/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClassBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="resourceclass", builderClass=ResourceClassBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class ResourceClass
extends PrimaryIdObject<String> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceClass.class);
    private final String imageUrl;
    private final String imageId;
    private final String hrn;
    private final ResourceClass parent;
    private final Boolean visibleInToolbox;
    private final Boolean draggableFromToolbox;
    private final ResourceClass instantiateAs;
    private final List<Resource> defaultResource;
    private final List<Resource> resources;
    private final List<String> configsetIds;
    private final Integer weight;

    @JsonCreator
    ResourceClass(@JsonProperty(value="id") String id, @JsonProperty(value="imageUrl") String imageUrl, @JsonProperty(value="imageId") String imageId, @JsonProperty(value="hrn") String hrn, @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResourceClassDeserializer.class) @JsonProperty(value="parent") ResourceClass parent, @JsonProperty(value="visibleInToolbox") Boolean visibleInToolbox, @JsonProperty(value="draggableFromToolbox") Boolean draggableFromToolbox, @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResourceClassDeserializer.class) @JsonProperty(value="instantiateAs") ResourceClass instantiateAs, @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResourceListDeserializer.class) @JsonProperty(value="defaultResource") List<Resource> defaultResource, @JsonProperty(value="resources") List<Resource> resources, @JsonProperty(value="configsetId") List<String> configsetIds, @JsonProperty(value="weight") Integer weight, @JsonProperty(value="@id") URI uri) {
        this(id, imageUrl, imageId, hrn, parent, visibleInToolbox, draggableFromToolbox, instantiateAs, defaultResource, resources, configsetIds, weight, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    ResourceClass(String id, String imageUrl, String imageId, String hrn, ResourceClass parent, Boolean visibleInToolbox, Boolean draggableFromToolbox, ResourceClass instantiateAs, List<Resource> defaultResource, List<Resource> resources, List<String> configsetIds, Integer weight, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super((Object)id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.imageUrl = imageUrl;
        this.imageId = imageId;
        this.hrn = hrn;
        this.parent = parent;
        this.visibleInToolbox = visibleInToolbox;
        this.draggableFromToolbox = draggableFromToolbox;
        this.instantiateAs = instantiateAs;
        this.configsetIds = configsetIds == null ? null : new ArrayList<String>(configsetIds);
        this.weight = weight;
        ArrayList<Resource> arrayList = this.resources = resources == null ? null : new ArrayList<Resource>(resources);
        if (defaultResource != null) {
            this.defaultResource = new ArrayList<Resource>(defaultResource.size());
            for (Resource dr : defaultResource) {
                Resource existingResource = null;
                if (this.resources != null) {
                    for (Resource r : this.resources) {
                        if (r.getId() == null || dr.getId() == null || !((Integer)r.getId()).equals(dr.getId())) continue;
                        existingResource = r;
                    }
                }
                if (existingResource != null) {
                    this.defaultResource.add(existingResource);
                    continue;
                }
                this.defaultResource.add(dr);
            }
            assert (this.defaultResource.size() == defaultResource.size());
        } else {
            this.defaultResource = null;
        }
    }

    ResourceClass(String id, String imageUrl, String imageId, String hrn, ResourceClass parent, Boolean visibleInToolbox, Boolean draggableFromToolbox, ResourceClass instantiateAs, List<String> configsetIds, Integer weight, URI uri, List<ResourceBuilder> defaultResourceBuilders, List<ResourceBuilder> resourceBuilders, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super((Object)id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.imageUrl = imageUrl;
        this.imageId = imageId;
        this.hrn = hrn;
        this.parent = parent;
        this.visibleInToolbox = visibleInToolbox;
        this.draggableFromToolbox = draggableFromToolbox;
        this.instantiateAs = instantiateAs;
        this.configsetIds = configsetIds == null ? null : new ArrayList<String>(configsetIds);
        this.weight = weight;
        HashMap<ResourceBuilder, Resource> createResourcesByResourceBuilder = new HashMap<ResourceBuilder, Resource>();
        if (resourceBuilders == null) {
            this.resources = null;
        } else {
            this.resources = new ArrayList<Resource>(resourceBuilders.size());
            for (ResourceBuilder rb : resourceBuilders) {
                rb.setResourceClassBuilder(null);
                rb.setResourceClass(this);
                Resource r = rb.create();
                this.resources.add(r);
                assert (r.getId() != null);
                if (r.getId() == null) continue;
                createResourcesByResourceBuilder.put(rb, r);
            }
            assert (this.resources.size() == resourceBuilders.size());
        }
        if (defaultResourceBuilders != null) {
            this.defaultResource = new ArrayList<Resource>(defaultResourceBuilders.size());
            for (ResourceBuilder resourceBuilder : defaultResourceBuilders) {
                Resource existingResource = (Resource)((Object)createResourcesByResourceBuilder.get((Object)resourceBuilder));
                if (existingResource != null) {
                    this.defaultResource.add(existingResource);
                    continue;
                }
                resourceBuilder.setResourceClassBuilder(null);
                resourceBuilder.setResourceClass(this);
                this.defaultResource.add(resourceBuilder.create());
            }
            assert (this.defaultResource.size() == defaultResourceBuilders.size());
        } else {
            this.defaultResource = null;
        }
    }

    @JsonProperty
    public String getImageUrl() {
        return this.imageUrl;
    }

    @JsonProperty
    public String getImageId() {
        return this.imageId;
    }

    @JsonProperty
    public String getHrn() {
        return this.hrn;
    }

    @JsonProperty(value="parent")
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResourceClassDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
    public ResourceClass getParent_ReferenceObjectOnly() {
        return this.parent;
    }

    @JsonIgnore
    public String getParentId() {
        return this.parent == null ? null : (String)this.parent.getId();
    }

    @JsonProperty
    public Boolean getVisibleInToolbox() {
        return this.visibleInToolbox;
    }

    @JsonProperty
    public Boolean getDraggableFromToolbox() {
        return this.draggableFromToolbox;
    }

    @JsonProperty(value="instantiateAs")
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResourceClassDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildLinkSerializer.class)
    public ResourceClass getInstantiateAs_ReferenceObjectOnly() {
        return this.instantiateAs;
    }

    @JsonIgnore
    public String getInstantiateAsId() {
        return this.instantiateAs == null ? null : (String)this.instantiateAs.getId();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResourceListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildrenLinkListSerializer.class)
    public List<Resource> getDefaultResource() {
        return this.defaultResource;
    }

    @JsonIgnore
    public String getDefaultResourceIdCsv() {
        return this.defaultResource == null ? null : this.defaultResource.stream().map(r -> "" + r.getId()).collect(Collectors.joining(","));
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResourceListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ChildrenLinkListSerializer.class)
    public List<Resource> getResources() {
        return this.resources;
    }

    @JsonProperty
    public List<String> getConfigsetIds() {
        return this.configsetIds;
    }

    @JsonIgnore
    public String getConfigsetIdsCsv() {
        return this.configsetIds == null ? null : this.configsetIds.stream().collect(Collectors.joining(","));
    }

    @JsonProperty
    public Integer getWeight() {
        return this.weight;
    }

    @JsonIgnore
    public int getWeightOrZero() {
        return this.weight == null ? 0 : this.weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ResourceClass that = (ResourceClass)((Object)o);
        if (this.draggableFromToolbox != null ? !this.draggableFromToolbox.equals(that.draggableFromToolbox) : that.draggableFromToolbox != null) {
            return false;
        }
        if (this.hrn != null ? !this.hrn.equals(that.hrn) : that.hrn != null) {
            return false;
        }
        if (this.id != null ? !((String)this.id).equals(that.id) : that.id != null) {
            return false;
        }
        if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) {
            return false;
        }
        if (this.imageUrl != null ? !this.imageUrl.equals(that.imageUrl) : that.imageUrl != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.weight != null ? !this.weight.equals(that.weight) : that.weight != null) {
            return false;
        }
        return !(this.visibleInToolbox != null ? !this.visibleInToolbox.equals(that.visibleInToolbox) : that.visibleInToolbox != null);
    }

    public int hashCode() {
        int result = this.id != null ? ((String)this.id).hashCode() : 0;
        result = 31 * result + (this.imageUrl != null ? this.imageUrl.hashCode() : 0);
        result = 31 * result + (this.imageId != null ? this.imageId.hashCode() : 0);
        result = 31 * result + (this.hrn != null ? this.hrn.hashCode() : 0);
        result = 31 * result + (this.visibleInToolbox != null ? this.visibleInToolbox.hashCode() : 0);
        result = 31 * result + (this.draggableFromToolbox != null ? this.draggableFromToolbox.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
        return result;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting ResourceClass " + (String)this.id + " to JSON", (Throwable)e);
            return "Exception converting ResourceClass " + (String)this.id + " to JSON: " + e.getMessage();
        }
    }
}

