/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TaskBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.BasicLdObjectBuilder;
import be.iminds.ilabt.util.jsonld.impl.ForeignIdObject;
import be.iminds.ilabt.util.jsonld.impl.ForeignIdObjectBuilder;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=TestInstanceStatistics.class)
public class TestInstanceStatisticsBuilder
extends ForeignIdObjectBuilder<TestInstanceStatistics, TestInstanceStatisticsBuilder> {
    private TestInstance testInstance;
    private Timestamp nextRun;
    private Timestamp lastRun;
    private Map<String, TestInstanceStatistics.LastResultInfo> lastResultInfoByFilter;
    private Task activeTask;
    private TestInstanceStatistics.RrdStatistics rrdStatistics;
    private TestInstanceStatistics.Summation summation;

    public TestInstanceStatisticsBuilder() {
    }

    public TestInstanceStatisticsBuilder(TestInstanceStatistics orig) {
        super((ForeignIdObject)orig);
        this.testInstance = orig.getTestInstance();
        this.nextRun = orig.getNextRun();
        this.lastRun = orig.getLastRun();
        this.lastResultInfoByFilter = orig.getLastResultInfoByFilter() == null ? null : new HashMap<String, TestInstanceStatistics.LastResultInfo>(orig.getLastResultInfoByFilter());
        this.activeTask = orig.getActiveTask();
        this.rrdStatistics = orig.getRrdStatistics();
        this.summation = orig.getSummation();
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=TestInstance.class)
    public TestInstanceStatisticsBuilder setTestInstance(TestInstance testInstance) {
        this.testInstance = testInstance;
        assert (this.testInstance == null || this.testInstance.getId() != null) : "testInstance == null -> " + (this.testInstance == null) + "   <->   testInstance.getId() ->" + this.testInstance.getId();
        return this;
    }

    public TestInstanceStatisticsBuilder setTestInstance(Integer testInstanceId, URI testInstanceUri) {
        if (testInstanceId == null) {
            assert (testInstanceUri == null);
            this.testInstance = null;
        } else {
            this.testInstance = ((TestInstanceBuilder)((TestInstanceBuilder)new TestInstanceBuilder().setId(testInstanceId)).setUri(testInstanceUri)).create();
        }
        assert (this.testInstance == null || this.testInstance.getId() != null) : "testInstance == null -> " + (this.testInstance == null) + "   <->   testInstance.getId() ->" + this.testInstance.getId();
        return this;
    }

    public TestInstanceStatisticsBuilder setTestInstanceId(Integer testInstanceId) {
        TestInstance testInstance = this.testInstance = testInstanceId == null ? null : ((TestInstanceBuilder)new TestInstanceBuilder().setId(testInstanceId)).create();
        assert (this.testInstance == null || this.testInstance.getId() != null) : "testInstance == null -> " + (this.testInstance == null) + "   <->   testInstance.getId() ->" + this.testInstance.getId();
        return this;
    }

    public TestInstanceStatisticsBuilder setNextRun(Timestamp nextRun) {
        this.nextRun = nextRun;
        return this;
    }

    public TestInstanceStatisticsBuilder setLastRun(Timestamp lastRun) {
        this.lastRun = lastRun;
        return this;
    }

    public TestInstanceStatisticsBuilder setLastResultInfos(Collection<TestInstanceStatistics.LastResultInfo> lastResultInfos) {
        HashMap hashMap = this.lastResultInfoByFilter = lastResultInfos == null ? null : new HashMap();
        if (lastResultInfos != null) {
            for (TestInstanceStatistics.LastResultInfo lastResultInfo : lastResultInfos) {
                this.lastResultInfoByFilter.put(lastResultInfo.getFilter(), lastResultInfo);
            }
        }
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListCallbackBasedAccessor(objectClass=Result.class, name="lastResults", builderReference=false)
    public TestInstanceStatisticsBuilder modifyLastResultInfoResults(UnaryOperator<Result> modifier) {
        if (this.lastResultInfoByFilter != null) {
            ArrayList<TestInstanceStatistics.LastResultInfo> orig = new ArrayList<TestInstanceStatistics.LastResultInfo>(this.lastResultInfoByFilter.values());
            for (TestInstanceStatistics.LastResultInfo lastResultInfo : orig) {
                assert (lastResultInfo.getFilter() != null);
                lastResultInfo = new TestInstanceStatistics.LastResultInfo(lastResultInfo.getFilter(), lastResultInfo.getDate(), lastResultInfo.getResult() == null ? null : (Result)((Object)modifier.apply(lastResultInfo.getResult())));
                this.lastResultInfoByFilter.put(lastResultInfo.getFilter(), lastResultInfo);
            }
        }
        return this;
    }

    public TestInstanceStatisticsBuilder setLastResultInfoByFilter(Map<String, TestInstanceStatistics.LastResultInfo> lastResultInfoByFilter) {
        this.lastResultInfoByFilter = lastResultInfoByFilter;
        return this;
    }

    public TestInstanceStatisticsBuilder setLastResultInfo(String filter, Long resultId, Timestamp date) {
        if (this.lastResultInfoByFilter == null) {
            this.lastResultInfoByFilter = new HashMap<String, TestInstanceStatistics.LastResultInfo>();
        }
        this.lastResultInfoByFilter.put(filter, new LastResultInfoBuilder().setFilter(filter).setResultId(resultId).setDate(date).create());
        return this;
    }

    public TestInstanceStatisticsBuilder setLastResultInfo(String filter, Long resultId, URI resultUri, Timestamp date) {
        if (this.lastResultInfoByFilter == null) {
            this.lastResultInfoByFilter = new HashMap<String, TestInstanceStatistics.LastResultInfo>();
        }
        assert (resultId != null || resultUri == null);
        this.lastResultInfoByFilter.put(filter, new LastResultInfoBuilder().setFilter(filter).setResult(resultId == null ? null : ((ResultBuilder)((ResultBuilder)new ResultBuilder().setId(resultId)).setUri(resultUri)).create()).setDate(date).create());
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Task.class, name="activeTask")
    public TestInstanceStatisticsBuilder setActiveTask(Task activeTask) {
        assert (activeTask == null || activeTask.getId() != null);
        this.activeTask = activeTask;
        return this;
    }

    public TestInstanceStatisticsBuilder setActiveTask(Long activeTaskId, URI activeTaskUri) {
        if (activeTaskId == null) {
            assert (activeTaskUri == null) : "Any Task MUST have an ID set";
            this.activeTask = null;
        } else {
            this.activeTask = ((TaskBuilder)((TaskBuilder)new TaskBuilder().setId(activeTaskId)).setUri(activeTaskUri)).create();
        }
        return this;
    }

    public TestInstanceStatisticsBuilder setActiveTask(Long activeTaskId) {
        this.activeTask = activeTaskId == null ? null : ((TaskBuilder)new TaskBuilder().setId(activeTaskId)).create();
        return this;
    }

    public TestInstanceStatisticsBuilder setRrdStatistics(TestInstanceStatistics.RrdStatistics rrdStatistics) {
        this.rrdStatistics = rrdStatistics;
        return this;
    }

    public TestInstanceStatisticsBuilder setSummation(TestInstanceStatistics.Summation summation) {
        this.summation = summation;
        return this;
    }

    public TestInstanceStatistics create() {
        return new TestInstanceStatistics(this.testInstance, this.nextRun, this.lastRun, this.lastResultInfoByFilter == null ? null : this.lastResultInfoByFilter.values(), this.activeTask, this.rrdStatistics, this.summation, this.uri);
    }

    public TestInstanceStatistics createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        return new TestInstanceStatistics(minimization.includeId() ? this.testInstance : null, minimization.includeOtherProperties() ? this.nextRun : null, minimization.includeOtherProperties() ? this.lastRun : null, minimization.includeOtherProperties() && this.lastResultInfoByFilter != null ? this.lastResultInfoByFilter.values() : null, minimization.includeOtherProperties() ? this.activeTask : null, minimization.includeOtherProperties() ? this.rrdStatistics : null, minimization.includeOtherProperties() ? this.summation : null, minimization.includeId() ? this.uri : null);
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=TestInstance.class)
    public TestInstance getTestInstance() {
        return this.testInstance;
    }

    public Integer getTestInstanceId() {
        return this.testInstance == null ? null : (Integer)this.testInstance.getId();
    }

    public Timestamp getNextRun() {
        return this.nextRun;
    }

    public Timestamp getLastRun() {
        return this.lastRun;
    }

    public Collection<TestInstanceStatistics.LastResultInfo> getLastResultInfos() {
        return this.lastResultInfoByFilter == null ? null : this.lastResultInfoByFilter.values();
    }

    public Map<String, TestInstanceStatistics.LastResultInfo> getLastResultInfoByFilter() {
        return this.lastResultInfoByFilter;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Task.class, name="activeTask")
    public Task getActiveTask() {
        return this.activeTask;
    }

    public TestInstanceStatistics.RrdStatistics getRrdStatistics() {
        return this.rrdStatistics;
    }

    public TestInstanceStatistics.Summation getSummation() {
        return this.summation;
    }

    @JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=TestInstanceStatistics.LastResultInfo.class)
    public static class LastResultInfoBuilder
    extends BasicLdObjectBuilder<TestInstanceStatistics.LastResultInfo> {
        private String filter;
        private Timestamp date;
        private Result result;

        public LastResultInfoBuilder() {
        }

        public LastResultInfoBuilder(TestInstanceStatistics.LastResultInfo orig) {
            this.filter = orig.getFilter();
            this.date = orig.getDate();
            this.result = orig.getResult();
        }

        public LastResultInfoBuilder setFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public LastResultInfoBuilder setDate(Timestamp date) {
            this.date = date;
            return this;
        }

        public LastResultInfoBuilder setDate(Date date) {
            this.date = new Timestamp(date.getTime());
            return this;
        }

        public LastResultInfoBuilder setResult(Result result) {
            assert (result == null || result.getId() != null);
            this.result = result;
            return this;
        }

        public LastResultInfoBuilder setResultId(Long resultId) {
            this.result = resultId == null ? null : ((ResultBuilder)new ResultBuilder().setId(resultId)).create();
            return this;
        }

        public TestInstanceStatistics.LastResultInfo create() {
            return new TestInstanceStatistics.LastResultInfo(this.filter, this.date, this.result);
        }

        public String getFilter() {
            return this.filter;
        }

        public Timestamp getDate() {
            return this.date;
        }

        public Result getResult() {
            return this.result;
        }
    }

    @JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=TestInstanceStatistics.Summation.class)
    public static class SummationBuilder
    extends BasicLdObjectBuilder<TestInstanceStatistics.Summation> {
        private String unit;
        private TestInstanceStatistics.SummationDetail year;
        private TestInstanceStatistics.SummationDetail month;
        private TestInstanceStatistics.SummationDetail week;
        private TestInstanceStatistics.SummationDetail day;
        private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

        public SummationBuilder() {
        }

        public SummationBuilder(TestInstanceStatistics.Summation orig) {
            this.unit = orig.getUnit();
            this.day = orig.getDay();
            this.week = orig.getWeek();
            this.month = orig.getMonth();
            this.year = orig.getYear();
        }

        public SummationBuilder(String aggJson) throws IOException {
            TestInstanceStatistics.Summation orig = (TestInstanceStatistics.Summation)((Object)MAPPER.readValue(aggJson, TestInstanceStatistics.Summation.class));
            this.unit = orig.getUnit();
            this.day = orig.getDay();
            this.week = orig.getWeek();
            this.month = orig.getMonth();
            this.year = orig.getYear();
        }

        public SummationBuilder setUnit(String unit) {
            this.unit = unit;
            return this;
        }

        public SummationBuilder setYear(TestInstanceStatistics.SummationDetail year) {
            this.year = year;
            return this;
        }

        public SummationBuilder setMonth(TestInstanceStatistics.SummationDetail month) {
            this.month = month;
            return this;
        }

        public SummationBuilder setWeek(TestInstanceStatistics.SummationDetail week) {
            this.week = week;
            return this;
        }

        public SummationBuilder setDay(TestInstanceStatistics.SummationDetail day) {
            this.day = day;
            return this;
        }

        public TestInstanceStatistics.Summation create() {
            return new TestInstanceStatistics.Summation(this.unit, this.year, this.month, this.week, this.day);
        }

        public String getUnit() {
            return this.unit;
        }

        public TestInstanceStatistics.SummationDetail getYear() {
            return this.year;
        }

        public TestInstanceStatistics.SummationDetail getMonth() {
            return this.month;
        }

        public TestInstanceStatistics.SummationDetail getWeek() {
            return this.week;
        }

        public TestInstanceStatistics.SummationDetail getDay() {
            return this.day;
        }

        static {
            MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        }
    }

    @JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=TestInstanceStatistics.RrdStatistics.class)
    public static class RrdStatisticsBuilder
    extends BasicLdObjectBuilder<TestInstanceStatistics.RrdStatistics> {
        private String metricName;
        private String unit;
        private double monthTotal;
        private double weekTotal;
        private double dayTotal;
        private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

        public RrdStatisticsBuilder() {
        }

        public RrdStatisticsBuilder(TestInstanceStatistics.RrdStatistics orig) {
            this.metricName = orig.getMetric();
            this.unit = orig.getUnit();
            this.monthTotal = orig.getMonthTotal();
            this.weekTotal = orig.getWeekTotal();
            this.dayTotal = orig.getDayTotal();
        }

        public RrdStatisticsBuilder(String testStatisticsJson) throws IOException {
            TestInstanceStatistics.RrdStatistics orig = (TestInstanceStatistics.RrdStatistics)((Object)MAPPER.readValue(testStatisticsJson, TestInstanceStatistics.RrdStatistics.class));
            this.metricName = orig.getMetric();
            this.unit = orig.getUnit();
            this.monthTotal = orig.getMonthTotal();
            this.weekTotal = orig.getWeekTotal();
            this.dayTotal = orig.getDayTotal();
        }

        public RrdStatisticsBuilder setMetricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public RrdStatisticsBuilder setUnit(String unit) {
            this.unit = unit;
            return this;
        }

        public RrdStatisticsBuilder setMonthTotal(double monthTotal) {
            this.monthTotal = monthTotal;
            return this;
        }

        public RrdStatisticsBuilder setWeekTotal(double weekTotal) {
            this.weekTotal = weekTotal;
            return this;
        }

        public RrdStatisticsBuilder setDayTotal(double dayTotal) {
            this.dayTotal = dayTotal;
            return this;
        }

        public TestInstanceStatistics.RrdStatistics create() {
            return new TestInstanceStatistics.RrdStatistics(this.metricName, this.unit, this.monthTotal, this.weekTotal, this.dayTotal);
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getUnit() {
            return this.unit;
        }

        public double getMonthTotal() {
            return this.monthTotal;
        }

        public double getWeekTotal() {
            return this.weekTotal;
        }

        public double getDayTotal() {
            return this.dayTotal;
        }

        static {
            MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        }
    }
}

