/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.F4FFederationStatus;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GDPRInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ProxyBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.json.util.JsonGeniUrnDeserializer;
import be.iminds.ilabt.jfed.json.util.JsonGeniUrnSerializer;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dropwizard.jackson.Jackson;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="testbed", builderClass=TestbedBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class Testbed
extends PrimaryIdObject<String>
implements Comparable {
    private static final Logger LOG = LoggerFactory.getLogger(Testbed.class);
    private final String longName;
    private final String interfaceUrl;
    private final String infoUrl;
    private final String helpUrl;
    private final String pingHost;
    private final String defaultComponentManagerUrn;
    private final String otrsName;
    private final String description;
    private final String geniId;
    private final URI geniHref;
    private final String color;
    private final String logo;
    private final String nodesLocationVisualisationImageUrl;
    private final String nodesLocationVisualisationCoordinatesUrl;
    @Deprecated
    private final Boolean allowLinks;
    private final List<TestbedCategory> categories;
    private final Organisation organisation;
    private final Server defaultServer;
    private final List<Server> servers;
    private final List<Proxy> proxies;
    private final List<String> primaryContactEmails;
    private final List<String> technicalContactEmails;
    private final List<String> gdprContactEmails;
    private final List<GeniUrn> testbedAdminUrns;
    private final List<String> software;
    private final String notes;
    private final F4FFederationStatus f4fFederationStatus;
    private final List<Federation> federations;
    private final GDPRInfo gdprInfo;
    private final URI resultsUri;
    private final URI testInstancesUri;
    private static final Comparator<String> ID_COMP = Comparator.naturalOrder();

    @JsonCreator
    Testbed(@JsonProperty(value="id") String id, @JsonProperty(value="longName") String longName, @JsonProperty(value="interfaceUrl") String interfaceUrl, @JsonProperty(value="pingHost") String pingHost, @JsonProperty(value="infoUrl") String infoUrl, @JsonProperty(value="helpUrl") String helpUrl, @JsonProperty(value="defaultComponentManagerUrn") String defaultComponentManagerUrn, @JsonProperty(value="otrsName") String otrsName, @JsonProperty(value="description") String description, @JsonProperty(value="geniId") String geniId, @JsonProperty(value="geniHref") URI geniHref, @JsonProperty(value="color") String color, @JsonProperty(value="logo") String logo, @JsonProperty(value="nodesLocationVisualisationImageUrl") String nodesLocationVisualisationImageUrl, @JsonProperty(value="nodesLocationVisualisationCoordinatesUrl") String nodesLocationVisualisationCoordinatesUrl, @JsonProperty(value="allowLinks") Boolean allowLinks, @JsonProperty(value="categories") Collection<TestbedCategory> categories, @JsonProperty(value="organisation") Organisation organisation, @JsonProperty(value="servers") List<Server> servers, @JsonProperty(value="defaultServer") Server defaultServer, @JsonProperty(value="proxies") List<Proxy> proxies, @JsonProperty(value="primaryContactEmails") List<String> primaryContactEmails, @JsonProperty(value="technicalContactEmails") List<String> technicalContactEmails, @JsonProperty(value="gdprContactEmails") List<String> gdprContactEmails, @JsonProperty(value="testbedAdminUrns") List<GeniUrn> testbedAdminUrns, @JsonProperty(value="software") List<String> software, @JsonProperty(value="notes") String notes, @JsonProperty(value="f4fFederationStatus") F4FFederationStatus f4fFederationStatus, @JsonProperty(value="federations") List<Federation> federations, @JsonProperty(value="gdprInfo") GDPRInfo gdprInfo, @JsonProperty(value="@id") URI uri, @JsonProperty(value="results") URI resultsUri, @JsonProperty(value="testInstances") URI testInstancesUri) {
        this(id, longName, interfaceUrl, pingHost, infoUrl, helpUrl, defaultComponentManagerUrn, otrsName, description, geniId, geniHref, color, logo, nodesLocationVisualisationImageUrl, nodesLocationVisualisationCoordinatesUrl, allowLinks, categories, organisation, servers, defaultServer, proxies, primaryContactEmails, technicalContactEmails, gdprContactEmails, testbedAdminUrns, software, notes, f4fFederationStatus, federations, gdprInfo, uri, resultsUri, testInstancesUri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    Testbed(String id, String longName, String interfaceUrl, String pingHost, String infoUrl, String helpUrl, String defaultComponentManagerUrn, String otrsName, String description, String geniId, URI geniHref, String color, String logo, String nodesLocationVisualisationImageUrl, String nodesLocationVisualisationCoordinatesUrl, Boolean allowLinks, Collection<TestbedCategory> categories, Organisation organisation, List<Server> servers, Server defaultServer, List<Proxy> proxies, List<String> primaryContactEmails, List<String> technicalContactEmails, List<String> gdprContactEmails, List<GeniUrn> testbedAdminUrns, List<String> software, String notes, F4FFederationStatus f4fFederationStatus, List<Federation> federations, GDPRInfo gdprInfo, URI uri, URI resultsUri, URI testInstancesUri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super((Object)id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.longName = longName;
        this.interfaceUrl = interfaceUrl;
        this.pingHost = pingHost;
        this.infoUrl = infoUrl;
        this.helpUrl = helpUrl;
        this.defaultComponentManagerUrn = defaultComponentManagerUrn;
        this.otrsName = otrsName;
        this.description = description;
        this.geniId = geniId;
        this.geniHref = geniHref;
        this.color = color;
        this.logo = logo;
        this.nodesLocationVisualisationImageUrl = nodesLocationVisualisationImageUrl;
        this.nodesLocationVisualisationCoordinatesUrl = nodesLocationVisualisationCoordinatesUrl;
        this.allowLinks = allowLinks;
        this.organisation = organisation;
        this.servers = servers;
        this.defaultServer = defaultServer;
        this.proxies = proxies;
        this.primaryContactEmails = primaryContactEmails == null ? null : Collections.unmodifiableList(new ArrayList<String>(primaryContactEmails));
        this.technicalContactEmails = technicalContactEmails == null ? null : Collections.unmodifiableList(new ArrayList<String>(technicalContactEmails));
        this.gdprContactEmails = gdprContactEmails == null ? null : Collections.unmodifiableList(new ArrayList<String>(gdprContactEmails));
        this.testbedAdminUrns = testbedAdminUrns == null ? null : Collections.unmodifiableList(new ArrayList<GeniUrn>(testbedAdminUrns));
        this.software = software == null ? null : Collections.unmodifiableList(new ArrayList<String>(software));
        this.federations = federations == null ? null : Collections.unmodifiableList(new ArrayList<Federation>(federations));
        this.f4fFederationStatus = f4fFederationStatus;
        this.gdprInfo = gdprInfo;
        this.notes = notes;
        this.resultsUri = resultsUri;
        this.testInstancesUri = testInstancesUri;
        if (categories != null) {
            TreeSet<TestbedCategory> tmp = new TreeSet<TestbedCategory>(categories);
            this.categories = Collections.unmodifiableList(new ArrayList<TestbedCategory>(tmp));
        } else {
            this.categories = null;
        }
    }

    Testbed(JsonLdObjectsMetaData.Minimization childrenMinimization, String id, String longName, String interfaceUrl, String pingHost, String infoUrl, String helpUrl, String defaultComponentManagerUrn, String otrsName, String description, String geniId, URI geniHref, String color, String logo, String nodesLocationVisualisationImageUrl, String nodesLocationVisualisationCoordinatesUrl, Boolean allowLinks, Collection<TestbedCategory> categories, Organisation organisation, List<ServerBuilder> serverBuilders, ServerBuilder defaultServerBuilder, List<ProxyBuilder> proxyBuilders, List<String> primaryContactEmails, List<String> technicalContactEmails, List<String> gdprContactEmails, List<GeniUrn> testbedAdminUrns, List<String> software, String notes, F4FFederationStatus f4fFederationStatus, List<Federation> federations, GDPRInfo gdprInfo, URI uri, URI resultsUri, URI testInstancesUri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super((Object)id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.longName = longName;
        this.interfaceUrl = interfaceUrl;
        this.pingHost = pingHost;
        this.infoUrl = infoUrl;
        this.helpUrl = helpUrl;
        this.defaultComponentManagerUrn = defaultComponentManagerUrn;
        this.otrsName = otrsName;
        this.description = description;
        this.geniId = geniId;
        this.geniHref = geniHref;
        this.color = color;
        this.logo = logo;
        this.nodesLocationVisualisationImageUrl = nodesLocationVisualisationImageUrl;
        this.nodesLocationVisualisationCoordinatesUrl = nodesLocationVisualisationCoordinatesUrl;
        this.allowLinks = allowLinks;
        this.organisation = organisation;
        Server newDefaultServer = null;
        if (serverBuilders != null) {
            ArrayList<Server> newServers = new ArrayList<Server>();
            for (ServerBuilder sb : serverBuilders) {
                Server server;
                sb.setTestbed(this);
                Server server2 = server = childrenMinimization == null ? sb.create() : sb.createMinimized(childrenMinimization);
                if (defaultServerBuilder != null && server.getId() != null && defaultServerBuilder.getId() != null && ((Integer)defaultServerBuilder.getId()).equals(server.getId())) {
                    assert (newDefaultServer == null) : "multiple servers are default";
                    newDefaultServer = server;
                }
                newServers.add(server);
            }
            this.servers = Collections.unmodifiableList(newServers);
        } else {
            this.servers = null;
        }
        if (newDefaultServer == null && defaultServerBuilder != null) {
            LOG.error("Testbed Creation error: Default server " + defaultServerBuilder.getId() + " is not in list of servers for testbed \"" + id + "\". Will IGNORE the default server.");
            assert (false) : "Testbed Creation error: Default server " + defaultServerBuilder.getId() + " is not in list of servers for testbed \"" + id + "\"";
        }
        this.defaultServer = newDefaultServer;
        if (proxyBuilders != null) {
            ArrayList<Proxy> newProxies = new ArrayList<Proxy>();
            for (ProxyBuilder pb : proxyBuilders) {
                newProxies.add(childrenMinimization == null ? pb.create() : pb.createMinimized(childrenMinimization));
            }
            this.proxies = Collections.unmodifiableList(newProxies);
        } else {
            this.proxies = null;
        }
        this.primaryContactEmails = primaryContactEmails == null ? null : Collections.unmodifiableList(new ArrayList<String>(primaryContactEmails));
        this.technicalContactEmails = technicalContactEmails == null ? null : Collections.unmodifiableList(new ArrayList<String>(technicalContactEmails));
        this.gdprContactEmails = gdprContactEmails == null ? null : Collections.unmodifiableList(new ArrayList<String>(gdprContactEmails));
        this.testbedAdminUrns = testbedAdminUrns == null ? null : Collections.unmodifiableList(new ArrayList<GeniUrn>(testbedAdminUrns));
        this.software = software == null ? null : Collections.unmodifiableList(new ArrayList<String>(software));
        this.federations = federations == null ? null : Collections.unmodifiableList(new ArrayList<Federation>(federations));
        this.f4fFederationStatus = f4fFederationStatus;
        this.gdprInfo = gdprInfo;
        this.notes = notes;
        this.resultsUri = resultsUri;
        this.testInstancesUri = testInstancesUri;
        if (categories != null) {
            TreeSet<TestbedCategory> tmp = new TreeSet<TestbedCategory>(categories);
            this.categories = Collections.unmodifiableList(new ArrayList<TestbedCategory>(tmp));
        } else {
            this.categories = null;
        }
    }

    @JsonProperty
    public String getLongName() {
        return this.longName;
    }

    @JsonProperty
    public String getInterfaceUrl() {
        return this.interfaceUrl;
    }

    @JsonProperty
    public String getPingHost() {
        return this.pingHost;
    }

    @JsonProperty
    public String getInfoUrl() {
        return this.infoUrl;
    }

    @JsonProperty
    public String getHelpUrl() {
        return this.helpUrl;
    }

    @JsonProperty
    public String getDefaultComponentManagerUrn() {
        return this.defaultComponentManagerUrn;
    }

    @JsonIgnore
    public GeniUrn getDefaultComponentManagerAsGeniUrn() {
        if (this.defaultComponentManagerUrn == null) {
            return null;
        }
        try {
            return new GeniUrn(this.defaultComponentManagerUrn);
        }
        catch (GeniUrn.GeniUrnParseException e) {
            throw new RuntimeException("Testbed has invalid defaultComponentManagerUrn\"" + this.defaultComponentManagerUrn + "\"");
        }
    }

    @JsonProperty
    public String getOtrsName() {
        return this.otrsName;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public String getGeniId() {
        return this.geniId;
    }

    @JsonProperty
    public URI getGeniHref() {
        return this.geniHref;
    }

    @JsonIgnore
    public String getGeniHrefAsString() {
        return this.geniHref == null ? null : this.geniHref.toASCIIString();
    }

    @JsonProperty
    public String getColor() {
        return this.color;
    }

    @JsonProperty
    public String getLogo() {
        return this.logo;
    }

    public String getNodesLocationVisualisationImageUrl() {
        return this.nodesLocationVisualisationImageUrl;
    }

    public String getNodesLocationVisualisationCoordinatesUrl() {
        return this.nodesLocationVisualisationCoordinatesUrl;
    }

    @Deprecated
    public Boolean getAllowLinks() {
        return this.allowLinks;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.OrganisationDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ParentLinkSerializer.class)
    public Organisation getOrganisation() {
        return this.organisation;
    }

    @JsonIgnore
    public String getOrganisationId() {
        return this.organisation == null ? null : (String)this.organisation.getId();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServerListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ChildrenLinkListSerializer.class)
    public List<Server> getServers() {
        return this.servers;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServerDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildLinkSerializer.class)
    public Server getDefaultServer() {
        return this.defaultServer;
    }

    @JsonIgnore
    public Integer getDefaultServerId() {
        return this.defaultServer == null ? null : (Integer)this.defaultServer.getId();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ProxyListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ChildrenLinkListSerializer.class)
    public List<Proxy> getProxies() {
        return this.proxies;
    }

    @JsonProperty
    public List<String> getPrimaryContactEmails() {
        return this.primaryContactEmails;
    }

    @JsonIgnore
    public String getPrimaryContactEmailsAsCsv() {
        return this.primaryContactEmails == null ? null : String.join((CharSequence)",", this.primaryContactEmails);
    }

    @JsonProperty
    public List<String> getTechnicalContactEmails() {
        return this.technicalContactEmails;
    }

    @JsonIgnore
    public String getTechnicalContactEmailsAsCsv() {
        return this.technicalContactEmails == null ? null : String.join((CharSequence)",", this.technicalContactEmails);
    }

    @JsonProperty
    public List<String> getGdprContactEmails() {
        return this.gdprContactEmails;
    }

    @JsonIgnore
    public String getGdprContactEmailsAsCsv() {
        return this.gdprContactEmails == null ? null : String.join((CharSequence)",", this.gdprContactEmails);
    }

    @JsonProperty
    @JsonSerialize(contentUsing=JsonGeniUrnSerializer.class)
    @JsonDeserialize(contentUsing=JsonGeniUrnDeserializer.class)
    public List<GeniUrn> getTestbedAdminUrns() {
        return this.testbedAdminUrns;
    }

    @JsonIgnore
    public String getTestbedAdminUrnsAsCsv() {
        if (this.testbedAdminUrns == null) {
            return null;
        }
        return this.testbedAdminUrns.stream().map(ResourceUrn::getValue).collect(Collectors.joining(","));
    }

    @JsonProperty
    public List<String> getSoftware() {
        return this.software;
    }

    @JsonIgnore
    public String getSoftwareAsCsv() {
        return this.software == null ? null : String.join((CharSequence)",", this.software);
    }

    @JsonProperty
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty
    public F4FFederationStatus getF4fFederationStatus() {
        return this.f4fFederationStatus;
    }

    @JsonProperty
    public GDPRInfo getGdprInfo() {
        return this.gdprInfo;
    }

    @JsonIgnore
    public String getF4fFederationStatusAsJsonString() {
        if (this.f4fFederationStatus == null) {
            return null;
        }
        ObjectMapper mapper = Jackson.newObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.f4fFederationStatus);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting f4fFederationStatus into JSON", (Throwable)e);
            throw new RuntimeException("Exception converting f4fFederationStatus into JSON");
        }
    }

    @JsonIgnore
    public String getGdprInfoAsJsonString() {
        if (this.gdprInfo == null) {
            return null;
        }
        ObjectMapper mapper = Jackson.newObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.gdprInfo);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting gdprInfo into JSON", (Throwable)e);
            throw new RuntimeException("Exception converting gdprInfo into JSON");
        }
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.FederationListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentsLinkListSerializer.class)
    public List<Federation> getFederations() {
        return this.federations;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TestbedCategoryListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ParentsLinkListSerializer.class)
    public List<TestbedCategory> getCategories() {
        return this.categories;
    }

    @JsonIgnore
    public SortedSet<Integer> getCategoryIds() {
        if (this.categories == null) {
            return Collections.emptySortedSet();
        }
        return this.categories.stream().map(PrimaryIdObject::getId).filter(Objects::nonNull).collect(Collectors.toCollection(TreeSet::new));
    }

    @JsonIgnore
    public SortedSet<String> getCategoryNames() {
        if (this.categories == null) {
            return Collections.emptySortedSet();
        }
        return this.categories.stream().map(TestbedCategory::getName).filter(Objects::nonNull).collect(Collectors.toCollection(TreeSet::new));
    }

    @JsonProperty(value="results")
    public URI getResultsUri() {
        return this.resultsUri;
    }

    @JsonProperty(value="testInstances")
    public URI getTestInstancesUri() {
        return this.testInstancesUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Testbed)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Testbed testbed = (Testbed)o;
        return Objects.equals(this.longName, testbed.longName) && Objects.equals(this.interfaceUrl, testbed.interfaceUrl) && Objects.equals(this.infoUrl, testbed.infoUrl) && Objects.equals(this.helpUrl, testbed.helpUrl) && Objects.equals(this.pingHost, testbed.pingHost) && Objects.equals(this.defaultComponentManagerUrn, testbed.defaultComponentManagerUrn) && Objects.equals(this.otrsName, testbed.otrsName) && Objects.equals(this.description, testbed.description) && Objects.equals(this.geniId, testbed.geniId) && Objects.equals(this.geniHref, testbed.geniHref) && Objects.equals(this.color, testbed.color) && Objects.equals(this.logo, testbed.logo) && Objects.equals(this.nodesLocationVisualisationImageUrl, testbed.nodesLocationVisualisationImageUrl) && Objects.equals(this.nodesLocationVisualisationCoordinatesUrl, testbed.nodesLocationVisualisationCoordinatesUrl) && Objects.equals(this.allowLinks, testbed.allowLinks) && Objects.equals(this.primaryContactEmails, testbed.primaryContactEmails) && Objects.equals(this.technicalContactEmails, testbed.technicalContactEmails) && Objects.equals(this.gdprContactEmails, testbed.gdprContactEmails) && Objects.equals(this.testbedAdminUrns, testbed.testbedAdminUrns) && Objects.equals(this.software, testbed.software) && Objects.equals(this.notes, testbed.notes) && Objects.equals(this.f4fFederationStatus, testbed.f4fFederationStatus) && Objects.equals(this.gdprInfo, testbed.gdprInfo) && Objects.equals(this.id, testbed.id) && Objects.equals(this.uri, testbed.uri) && Objects.equals(this.resultsUri, testbed.resultsUri) && Objects.equals(this.testInstancesUri, testbed.testInstancesUri);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.longName, this.interfaceUrl, this.infoUrl, this.helpUrl, this.pingHost, this.defaultComponentManagerUrn, this.otrsName, this.description, this.geniId, this.geniHref, this.color, this.logo, this.nodesLocationVisualisationImageUrl, this.nodesLocationVisualisationCoordinatesUrl, this.allowLinks, this.primaryContactEmails, this.technicalContactEmails, this.gdprContactEmails, this.testbedAdminUrns, this.software, this.notes, this.f4fFederationStatus, this.gdprInfo, this.resultsUri, this.testInstancesUri);
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)TestbedBuilder.minimize(JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN, this));
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting Testbed " + (String)this.getId() + " to JSON", (Throwable)e);
            return "Exception converting Testbed " + (String)this.getId() + " to JSON: " + e.getMessage();
        }
    }

    public int compareTo(@Nonnull Object o) {
        assert (o instanceof Testbed);
        return ID_COMP.compare((String)this.getId(), (String)((Testbed)o).getId());
    }
}

