/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.F4FFederationStatus;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FederationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GDPRInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ProxyBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategoryBuilder;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=Testbed.class)
public class TestbedBuilder
extends PrimaryIdObjectBuilder<String, Testbed, TestbedBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedBuilder.class);
    private String longName;
    private String interfaceUrl;
    private String pingHost;
    private String infoUrl;
    private String helpUrl;
    private String defaultComponentManagerUrn;
    private String otrsName;
    private String description;
    private String geniId;
    private URI geniHref;
    private List<TestbedCategory> categories;
    private URI resultsUri;
    private URI testInstancesUri;
    private String color;
    private String logo;
    private String nodesLocationVisualisationImageUrl;
    private String nodesLocationVisualisationCoordinatesUrl;
    @Deprecated
    private Boolean allowLinks;
    private Organisation organisation;
    private List<Server> servers;
    private Server defaultServer;
    private ServerBuilder defaultServerBuilder;
    private List<Proxy> proxies;
    private List<ServerBuilder> serverBuilders;
    private List<ProxyBuilder> proxyBuilders;
    private List<String> primaryContactEmails;
    private List<String> technicalContactEmails;
    private List<String> gdprContactEmails;
    private List<GeniUrn> testbedAdminUrns;
    private List<String> software;
    private String notes;
    private F4FFederationStatus f4fFederationStatus;
    private List<Federation> federations;
    private GDPRInfo gdprInfo;

    public TestbedBuilder() {
    }

    public TestbedBuilder(Map jsonMap) {
        Object type = jsonMap.get("@type");
        if (type == null || !type.equals("Testbed")) {
            throw new IllegalArgumentException("Illegal type, cannot build Testbed from this: " + type);
        }
        Object uri = jsonMap.get("@id");
        Object id = jsonMap.get("id");
        Object componentManager = jsonMap.get("defaultComponentManagerUrn");
        Object geniId = jsonMap.get("geniId");
        if (id != null && id instanceof String) {
            this.id = (String)id;
        }
        if (uri != null && uri instanceof String) {
            try {
                this.uri = new URI((String)uri);
            }
            catch (URISyntaxException e) {
                LOG.debug("invalid Testbed URI. will be ignored: \"" + uri + "\"");
            }
        }
        if (componentManager != null && componentManager instanceof String) {
            this.defaultComponentManagerUrn = (String)componentManager;
        }
        if (geniId != null && geniId instanceof String) {
            this.geniId = (String)geniId;
        }
    }

    public TestbedBuilder(Testbed orig) {
        this(orig, false);
    }

    @Nullable
    private static <T> List<T> newListOrNull(@Nullable List<T> in) {
        if (in == null) {
            return null;
        }
        return new ArrayList<T>(in);
    }

    public TestbedBuilder(Testbed orig, boolean recursiveChildBuilders) {
        super((PrimaryIdObject)orig);
        this.organisation = orig.getOrganisation();
        this.longName = orig.getLongName();
        this.interfaceUrl = orig.getInterfaceUrl();
        this.pingHost = orig.getPingHost();
        this.infoUrl = orig.getInfoUrl();
        this.helpUrl = orig.getHelpUrl();
        this.defaultComponentManagerUrn = orig.getDefaultComponentManagerUrn();
        this.otrsName = orig.getOtrsName();
        this.description = orig.getDescription();
        this.geniId = orig.getGeniId();
        this.geniHref = orig.getGeniHref();
        this.categories = TestbedCategoryBuilder.minimize(JsonLdObjectsMetaData.Minimization.ID_ONLY, orig.getCategories());
        this.allowLinks = orig.getAllowLinks();
        this.nodesLocationVisualisationCoordinatesUrl = orig.getNodesLocationVisualisationCoordinatesUrl();
        this.nodesLocationVisualisationImageUrl = orig.getNodesLocationVisualisationImageUrl();
        this.color = orig.getColor();
        this.logo = orig.getLogo();
        this.primaryContactEmails = TestbedBuilder.newListOrNull(orig.getPrimaryContactEmails());
        this.technicalContactEmails = TestbedBuilder.newListOrNull(orig.getTechnicalContactEmails());
        this.gdprContactEmails = TestbedBuilder.newListOrNull(orig.getGdprContactEmails());
        this.testbedAdminUrns = TestbedBuilder.newListOrNull(orig.getTestbedAdminUrns());
        this.software = TestbedBuilder.newListOrNull(orig.getSoftware());
        this.notes = orig.getNotes();
        this.f4fFederationStatus = orig.getF4fFederationStatus();
        this.gdprInfo = orig.getGdprInfo();
        this.federations = TestbedBuilder.newListOrNull(orig.getFederations());
        this.resultsUri = orig.getResultsUri();
        this.testInstancesUri = orig.getTestInstancesUri();
        if (!recursiveChildBuilders) {
            this.servers = TestbedBuilder.newListOrNull(orig.getServers());
            this.defaultServer = orig.getDefaultServer();
            this.proxies = TestbedBuilder.newListOrNull(orig.getProxies());
        } else {
            this.servers = null;
            this.defaultServer = null;
            this.proxies = null;
            if (orig.getServers() != null) {
                this.serverBuilders = new ArrayList<ServerBuilder>();
                for (Server server : orig.getServers()) {
                    ServerBuilder serverBuilder = new ServerBuilder(server, true);
                    if (orig.getDefaultServer() != null && ((Integer)server.getId()).equals(orig.getDefaultServer().getId())) {
                        this.defaultServerBuilder = serverBuilder;
                    }
                    this.serverBuilders.add(serverBuilder);
                }
            }
            if (orig.getProxies() != null) {
                this.proxyBuilders = new ArrayList<ProxyBuilder>();
                for (Proxy proxy : orig.getProxies()) {
                    ProxyBuilder proxyBuilder = new ProxyBuilder(proxy);
                    this.proxyBuilders.add(proxyBuilder);
                }
            } else {
                this.proxyBuilders = null;
            }
            if (orig.getDefaultServer() != null && this.defaultServerBuilder == null) {
                throw new RuntimeException("Testbed data conflict: default server is not one of the servers!");
            }
        }
    }

    public TestbedBuilder(TestbedBuilder orig) {
        this.id = orig.getId();
        this.uri = orig.getUri();
        this.organisation = orig.getOrganisation();
        this.longName = orig.getLongName();
        this.interfaceUrl = orig.getInterfaceUrl();
        this.pingHost = orig.getPingHost();
        this.infoUrl = orig.getInfoUrl();
        this.helpUrl = orig.getHelpUrl();
        this.defaultComponentManagerUrn = orig.getDefaultComponentManagerUrn();
        this.otrsName = orig.getOtrsName();
        this.description = orig.getDescription();
        this.geniId = orig.getGeniId();
        this.geniHref = orig.getGeniHref();
        this.categories = TestbedCategoryBuilder.minimize(JsonLdObjectsMetaData.Minimization.ID_ONLY, orig.getCategories());
        this.allowLinks = orig.getAllowLinks();
        this.nodesLocationVisualisationCoordinatesUrl = orig.getNodesLocationVisualisationCoordinatesUrl();
        this.nodesLocationVisualisationImageUrl = orig.getNodesLocationVisualisationImageUrl();
        this.color = orig.getColor();
        this.logo = orig.getLogo();
        this.primaryContactEmails = TestbedBuilder.newListOrNull(orig.getPrimaryContactEmails());
        this.technicalContactEmails = TestbedBuilder.newListOrNull(orig.getTechnicalContactEmails());
        this.gdprContactEmails = TestbedBuilder.newListOrNull(orig.getGdprContactEmails());
        this.testbedAdminUrns = TestbedBuilder.newListOrNull(orig.getTestbedAdminUrns());
        this.software = TestbedBuilder.newListOrNull(orig.getSoftware());
        this.notes = orig.getNotes();
        this.f4fFederationStatus = orig.getF4fFederationStatus();
        this.gdprInfo = orig.getGdprInfo();
        this.federations = TestbedBuilder.newListOrNull(orig.getFederations());
        this.resultsUri = orig.getResultsUri();
        this.testInstancesUri = orig.getTestInstancesUri();
        this.servers = TestbedBuilder.newListOrNull(orig.getServers());
        this.defaultServer = orig.getDefaultServer();
        this.proxies = TestbedBuilder.newListOrNull(orig.getProxies());
        this.serverBuilders = TestbedBuilder.newListOrNull(orig.getServerBuilders());
        this.defaultServerBuilder = orig.getDefaultServerBuilder();
        this.proxyBuilders = TestbedBuilder.newListOrNull(orig.getProxyBuilders());
    }

    public TestbedBuilder setLongName(String longName) {
        this.longName = longName;
        return this;
    }

    public TestbedBuilder setInterfaceUrl(String interfaceUrl) {
        this.interfaceUrl = interfaceUrl;
        return this;
    }

    public TestbedBuilder setPingHost(String pingHost) {
        this.pingHost = pingHost;
        return this;
    }

    public TestbedBuilder setInfoUrl(String infoUrl) {
        this.infoUrl = infoUrl;
        return this;
    }

    public TestbedBuilder setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
        return this;
    }

    public TestbedBuilder setDefaultComponentManagerUrn(String defaultComponentManagerUrn) {
        this.defaultComponentManagerUrn = defaultComponentManagerUrn;
        return this;
    }

    public TestbedBuilder setOtrsName(String otrsName) {
        this.otrsName = otrsName;
        return this;
    }

    public TestbedBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public TestbedBuilder setGeniId(String geniId) {
        this.geniId = geniId;
        return this;
    }

    public TestbedBuilder setGeniHref(URI geniHref) {
        this.geniHref = geniHref;
        return this;
    }

    public TestbedBuilder addCategory(Integer id, String name) {
        if (this.categories == null) {
            this.categories = new ArrayList<TestbedCategory>();
        }
        TestbedCategory testbedCategory = ((TestbedCategoryBuilder)new TestbedCategoryBuilder().setName(name).setId(id)).create();
        this.categories.add(testbedCategory);
        return this;
    }

    public TestbedBuilder addCategory(TestbedCategory testbedCategory) {
        if (this.categories == null) {
            this.categories = new ArrayList<TestbedCategory>();
        }
        this.categories.add(testbedCategory);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=TestbedCategory.class)
    public TestbedBuilder setCategories(Collection<TestbedCategory> categories) {
        this.categories = TestbedCategoryBuilder.minimize(JsonLdObjectsMetaData.Minimization.ID_ONLY, categories);
        return this;
    }

    public TestbedBuilder setColor(String color) {
        this.color = color;
        return this;
    }

    public TestbedBuilder setLogo(String logo) {
        this.logo = logo;
        return this;
    }

    public TestbedBuilder setPrimaryContactEmails(List<String> primaryContactEmails) {
        this.primaryContactEmails = primaryContactEmails;
        return this;
    }

    public TestbedBuilder setTechnicalContactEmails(List<String> technicalContactEmails) {
        this.technicalContactEmails = technicalContactEmails;
        return this;
    }

    public TestbedBuilder setGdprContactEmails(List<String> gdprContactEmails) {
        this.gdprContactEmails = gdprContactEmails;
        return this;
    }

    public TestbedBuilder setTestbedAdminUrns(List<GeniUrn> testbedAdminUrns) {
        this.testbedAdminUrns = testbedAdminUrns;
        return this;
    }

    public TestbedBuilder addSoftware(String software) {
        if (this.software == null) {
            this.software = new ArrayList<String>();
        }
        this.software.add(software);
        return this;
    }

    public TestbedBuilder setSoftware(List<String> software) {
        this.software = software;
        return this;
    }

    public TestbedBuilder setNotes(String notes) {
        this.notes = notes;
        return this;
    }

    public TestbedBuilder setF4fFederationStatus(F4FFederationStatus f4fFederationStatus) {
        this.f4fFederationStatus = f4fFederationStatus;
        return this;
    }

    public TestbedBuilder setGdprInfo(GDPRInfo gdprInfo) {
        this.gdprInfo = gdprInfo;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Federation.class)
    public TestbedBuilder setFederations(List<Federation> federations) {
        this.federations = federations;
        return this;
    }

    public TestbedBuilder setNodesLocationVisualisationImageUrl(String nodesLocationVisualisationImageUrl) {
        this.nodesLocationVisualisationImageUrl = nodesLocationVisualisationImageUrl;
        return this;
    }

    public TestbedBuilder setNodesLocationVisualisationCoordinatesUrl(String nodesLocationVisualisationCoordinatesUrl) {
        this.nodesLocationVisualisationCoordinatesUrl = nodesLocationVisualisationCoordinatesUrl;
        return this;
    }

    @Deprecated
    public TestbedBuilder setAllowLinks(Boolean allowLinks) {
        this.allowLinks = allowLinks;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Organisation.class)
    public TestbedBuilder setOrganisation(Organisation organisation) {
        this.organisation = organisation;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Server.class)
    public TestbedBuilder setServers(List<Server> servers) {
        this.servers = servers;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Server.class, builderReference=true)
    public TestbedBuilder setServerBuilders(List<ServerBuilder> serverBuilders) {
        this.serverBuilders = new ArrayList<ServerBuilder>(serverBuilders);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Server.class, name="defaultServer")
    public TestbedBuilder setDefaultServer(Server defaultServer) {
        this.defaultServer = defaultServer;
        return this;
    }

    public TestbedBuilder setDefaultServerId(Integer defaultServerId) {
        this.defaultServer = ((ServerBuilder)new ServerBuilder().setId(defaultServerId)).create();
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Server.class, builderReference=true, name="defaultServer")
    public TestbedBuilder setDefaultServerBuilder(ServerBuilder defaultServerBuilder) {
        this.defaultServerBuilder = defaultServerBuilder;
        return this;
    }

    public TestbedBuilder addServerBuilder(ServerBuilder curServerBuilder) {
        if (this.serverBuilders == null) {
            this.serverBuilders = new ArrayList<ServerBuilder>();
        }
        this.serverBuilders.add(curServerBuilder);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Proxy.class)
    public TestbedBuilder setProxies(List<Proxy> proxies) {
        this.proxies = proxies;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Proxy.class, builderReference=true)
    public TestbedBuilder setProxyBuilders(List<ProxyBuilder> proxyBuilders) {
        this.proxyBuilders = proxyBuilders == null ? null : new ArrayList<ProxyBuilder>(proxyBuilders);
        return this;
    }

    public TestbedBuilder addProxyBuilder(ProxyBuilder curProxyBuilder) {
        if (this.proxyBuilders == null) {
            this.proxyBuilders = new ArrayList<ProxyBuilder>();
        }
        this.proxyBuilders.add(curProxyBuilder);
        return this;
    }

    public TestbedBuilder setResultsUri(URI resultsUri) {
        this.resultsUri = resultsUri;
        return this;
    }

    public TestbedBuilder setTestInstancesUri(URI testInstancesUri) {
        this.testInstancesUri = testInstancesUri;
        return this;
    }

    public Testbed create() {
        boolean builders = this.usesBuilders();
        if (builders) {
            assert (this.proxies == null);
            assert (this.servers == null);
            return new Testbed(null, (String)this.id, this.longName, this.interfaceUrl, this.pingHost, this.infoUrl, this.helpUrl, this.defaultComponentManagerUrn, this.otrsName, this.description, this.geniId, this.geniHref, this.color, this.logo, this.nodesLocationVisualisationImageUrl, this.nodesLocationVisualisationCoordinatesUrl, this.allowLinks, this.categories, this.organisation, this.serverBuilders, this.defaultServerBuilder, this.proxyBuilders, this.primaryContactEmails, this.technicalContactEmails, this.gdprContactEmails, this.testbedAdminUrns, this.software, this.notes, this.f4fFederationStatus, this.federations, this.gdprInfo, this.uri, this.resultsUri, this.testInstancesUri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
        }
        assert (this.serverBuilders == null);
        assert (this.proxyBuilders == null);
        return new Testbed((String)this.id, this.longName, this.interfaceUrl, this.pingHost, this.infoUrl, this.helpUrl, this.defaultComponentManagerUrn, this.otrsName, this.description, this.geniId, this.geniHref, this.color, this.logo, this.nodesLocationVisualisationImageUrl, this.nodesLocationVisualisationCoordinatesUrl, this.allowLinks, this.categories, this.organisation, this.servers, this.defaultServer, this.proxies, this.primaryContactEmails, this.technicalContactEmails, this.gdprContactEmails, this.testbedAdminUrns, this.software, this.notes, this.f4fFederationStatus, this.federations, this.gdprInfo, this.uri, this.resultsUri, this.testInstancesUri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    public Testbed createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        boolean builders = this.usesBuilders();
        if (minimization == JsonLdObjectsMetaData.Minimization.FULL) {
            return this.create();
        }
        if (builders) {
            return new Testbed(minimization.getChildrenMinimization(), minimization.includeId() ? (String)this.id : null, minimization.includeOtherProperties() ? this.longName : null, minimization.includeOtherProperties() ? this.interfaceUrl : null, minimization.includeOtherProperties() ? this.pingHost : null, minimization.includeOtherProperties() ? this.infoUrl : null, minimization.includeOtherProperties() ? this.helpUrl : null, minimization.includeExtraIds() ? this.defaultComponentManagerUrn : null, minimization.includeOtherProperties() ? this.otrsName : null, minimization.includeOtherProperties() ? this.description : null, minimization.includeExtraIds() ? this.geniId : null, minimization.includeOtherProperties() ? this.geniHref : null, minimization.includeOtherProperties() ? this.color : null, minimization.includeOtherProperties() ? this.logo : null, minimization.includeOtherProperties() ? this.nodesLocationVisualisationImageUrl : null, minimization.includeOtherProperties() ? this.nodesLocationVisualisationCoordinatesUrl : null, minimization.includeOtherProperties() ? this.allowLinks : null, this.categories == null || !minimization.includeParent() ? null : TestbedCategoryBuilder.minimize(minimization.getParentMinimization(), this.categories), this.organisation == null || !minimization.includeParent() ? null : OrganisationBuilder.minimize(minimization.getParentMinimization(), this.organisation), !minimization.includeChildren() ? null : this.serverBuilders, !minimization.includeChildren() ? null : this.defaultServerBuilder, !minimization.includeParent() ? null : this.proxyBuilders, minimization.includeOtherProperties() ? this.primaryContactEmails : null, minimization.includeOtherProperties() ? this.technicalContactEmails : null, minimization.includeOtherProperties() ? this.gdprContactEmails : null, minimization.includeOtherProperties() ? this.testbedAdminUrns : null, minimization.includeOtherProperties() ? this.software : null, minimization.includeOtherProperties() ? this.notes : null, minimization.includeOtherProperties() ? this.f4fFederationStatus : null, this.federations == null || !minimization.includeParent() ? null : FederationBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.federations), minimization.includeOtherProperties() ? this.gdprInfo : null, minimization.includeId() ? this.uri : null, minimization.includeOtherProperties() ? this.resultsUri : null, minimization.includeOtherProperties() ? this.testInstancesUri : null, minimization.serializeAsEmbeddedObject());
        }
        return new Testbed(minimization.includeId() ? (String)this.id : null, minimization.includeOtherProperties() ? this.longName : null, minimization.includeOtherProperties() ? this.interfaceUrl : null, minimization.includeOtherProperties() ? this.pingHost : null, minimization.includeOtherProperties() ? this.infoUrl : null, minimization.includeOtherProperties() ? this.helpUrl : null, minimization.includeExtraIds() ? this.defaultComponentManagerUrn : null, minimization.includeOtherProperties() ? this.otrsName : null, minimization.includeOtherProperties() ? this.description : null, minimization.includeExtraIds() ? this.geniId : null, minimization.includeOtherProperties() ? this.geniHref : null, minimization.includeOtherProperties() ? this.color : null, minimization.includeOtherProperties() ? this.logo : null, minimization.includeOtherProperties() ? this.nodesLocationVisualisationImageUrl : null, minimization.includeOtherProperties() ? this.nodesLocationVisualisationCoordinatesUrl : null, minimization.includeOtherProperties() ? this.allowLinks : null, this.categories == null || !minimization.includeParent() ? null : TestbedCategoryBuilder.minimize(minimization.getParentMinimization(), this.categories), this.organisation == null || !minimization.includeParent() ? null : OrganisationBuilder.minimize(minimization.getParentMinimization(), this.organisation), this.servers == null || !minimization.includeChildren() ? null : ServerBuilder.minimize(minimization.getChildrenMinimization(), this.servers), this.defaultServer == null || !minimization.includeChildren() ? null : ServerBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.defaultServer), this.proxies == null || !minimization.includeParent() ? null : ProxyBuilder.minimize(minimization.getParentMinimization(), this.proxies), minimization.includeOtherProperties() ? this.primaryContactEmails : null, minimization.includeOtherProperties() ? this.technicalContactEmails : null, minimization.includeOtherProperties() ? this.gdprContactEmails : null, minimization.includeOtherProperties() ? this.testbedAdminUrns : null, minimization.includeOtherProperties() ? this.software : null, minimization.includeOtherProperties() ? this.notes : null, minimization.includeOtherProperties() ? this.f4fFederationStatus : null, this.federations == null || !minimization.includeParent() ? null : FederationBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.federations), minimization.includeOtherProperties() ? this.gdprInfo : null, minimization.includeId() ? this.uri : null, minimization.includeOtherProperties() ? this.resultsUri : null, minimization.includeOtherProperties() ? this.testInstancesUri : null, minimization.serializeAsEmbeddedObject());
    }

    private boolean usesBuilders() throws IllegalStateException {
        boolean usedDirect;
        if (this.serverBuilders != null && this.servers != null) {
            throw new IllegalStateException("Either none, only servers or only serverBuilders must be set, not both.");
        }
        if (this.defaultServerBuilder != null && this.defaultServer != null) {
            throw new IllegalStateException("Either none, only defaultServer or only defaultServerBuilder must be set, not both.");
        }
        if (this.proxyBuilders != null && this.proxies != null) {
            throw new IllegalStateException("Either none, only proxies or only proxyBuilders must be set, not both.");
        }
        boolean usedBuilder = this.defaultServerBuilder != null || this.serverBuilders != null || this.proxyBuilders != null;
        boolean bl = usedDirect = this.defaultServer != null || this.servers != null || this.proxies != null;
        if (usedBuilder && usedDirect) {
            throw new IllegalStateException("If you use ProxyBuilders, you must use ServerBuilders and defaultServerBuilder, and vice versa. (proxyBuilder used=" + (this.proxyBuilders != null) + " servers used=" + (this.servers != null) + " (defaultServerBuilder used=" + (this.defaultServerBuilder != null) + " defaultServer used=" + (this.defaultServer != null) + " ServerBuilders used=" + (this.serverBuilders != null) + " proxies used=" + (this.proxies != null) + " usedBuilder=" + usedBuilder + " usedDirect=" + usedDirect + ")");
        }
        return usedBuilder;
    }

    public static List<Testbed> minimize(JsonLdObjectsMetaData.Minimization minimization, Collection<Testbed> in) {
        if (in == null) {
            return null;
        }
        ArrayList<Testbed> res = new ArrayList<Testbed>();
        for (Testbed tb : in) {
            res.add(new TestbedBuilder(tb).createMinimized(minimization));
        }
        return res;
    }

    public static List<Testbed> minimizeBuilders(JsonLdObjectsMetaData.Minimization minimization, Collection<TestbedBuilder> in) {
        if (in == null) {
            return null;
        }
        ArrayList<Testbed> res = new ArrayList<Testbed>();
        for (TestbedBuilder tbb : in) {
            res.add(tbb.createMinimized(minimization));
        }
        return res;
    }

    public static Testbed minimize(JsonLdObjectsMetaData.Minimization minimization, Testbed in) {
        if (in == null) {
            return null;
        }
        return new TestbedBuilder(in).createMinimized(minimization);
    }

    public static Testbed minimize(JsonLdObjectsMetaData.Minimization minimization, TestbedBuilder in) {
        if (in == null) {
            return null;
        }
        return in.createMinimized(minimization);
    }

    public String getLongName() {
        return this.longName;
    }

    public String getInterfaceUrl() {
        return this.interfaceUrl;
    }

    public String getPingHost() {
        return this.pingHost;
    }

    public String getInfoUrl() {
        return this.infoUrl;
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    public String getDefaultComponentManagerUrn() {
        return this.defaultComponentManagerUrn;
    }

    public String getOtrsName() {
        return this.otrsName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGeniId() {
        return this.geniId;
    }

    public URI getGeniHref() {
        return this.geniHref;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=TestbedCategory.class)
    public List<TestbedCategory> getCategories() {
        return this.categories;
    }

    public URI getResultsUri() {
        return this.resultsUri;
    }

    public URI getTestInstancesUri() {
        return this.testInstancesUri;
    }

    public String getColor() {
        return this.color;
    }

    public String getLogo() {
        return this.logo;
    }

    public String getNodesLocationVisualisationImageUrl() {
        return this.nodesLocationVisualisationImageUrl;
    }

    public String getNodesLocationVisualisationCoordinatesUrl() {
        return this.nodesLocationVisualisationCoordinatesUrl;
    }

    @Deprecated
    public Boolean getAllowLinks() {
        return this.allowLinks;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Organisation.class)
    public Organisation getOrganisation() {
        return this.organisation;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Server.class)
    public List<Server> getServers() {
        return this.servers;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Server.class, name="defaultServer")
    public Server getDefaultServer() {
        return this.defaultServer;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Proxy.class)
    public List<Proxy> getProxies() {
        return this.proxies;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Server.class, builderReference=true)
    public List<ServerBuilder> getServerBuilders() {
        return this.serverBuilders;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Server.class, name="defaultServer", builderReference=true)
    public ServerBuilder getDefaultServerBuilder() {
        return this.defaultServerBuilder;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Proxy.class, builderReference=true)
    public List<ProxyBuilder> getProxyBuilders() {
        return this.proxyBuilders;
    }

    public List<String> getTechnicalContactEmails() {
        return this.technicalContactEmails;
    }

    public List<String> getPrimaryContactEmails() {
        return this.primaryContactEmails;
    }

    public List<String> getGdprContactEmails() {
        return this.gdprContactEmails;
    }

    public List<GeniUrn> getTestbedAdminUrns() {
        return this.testbedAdminUrns;
    }

    public List<String> getSoftware() {
        return this.software;
    }

    public String getNotes() {
        return this.notes;
    }

    public F4FFederationStatus getF4fFederationStatus() {
        return this.f4fFederationStatus;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Federation.class)
    public List<Federation> getFederations() {
        return this.federations;
    }

    public GDPRInfo getGdprInfo() {
        return this.gdprInfo;
    }
}

