/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategoryBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="testbedcategory", builderClass=TestbedCategoryBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class TestbedCategory
extends PrimaryIdObject<Integer>
implements Comparable<TestbedCategory> {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedCategory.class);
    private final String name;
    private final List<Testbed> testbeds;
    private final Boolean guiFilter;
    private static final Comparator<Integer> ID_COMP = Comparator.naturalOrder();
    private static final Comparator<String> NAME_COMP = Comparator.naturalOrder();

    TestbedCategory(@JsonProperty(value="id") Integer id, @JsonProperty(value="name") String name, @JsonProperty(value="guiFilter") Boolean guiFilter, @JsonProperty(value="testbedIds") Collection<Testbed> testbeds, @JsonProperty(value="@id") URI uri) {
        this(id, name, guiFilter, testbeds, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    TestbedCategory(Integer id, String name, Boolean guiFilter, Collection<Testbed> testbeds, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super((Object)id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.name = name;
        this.guiFilter = guiFilter;
        if (testbeds != null) {
            TreeSet<Testbed> tmp = new TreeSet<Testbed>(testbeds);
            this.testbeds = Collections.unmodifiableList(new ArrayList<Testbed>(tmp));
        } else {
            this.testbeds = null;
        }
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="guiFilter")
    public Boolean isGuiFilter() {
        return this.guiFilter;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TestbedListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ChildrenLinkListSerializer.class)
    public List<Testbed> getTestbeds() {
        return this.testbeds;
    }

    @JsonIgnore
    public SortedSet<String> getTestbedIds() {
        return this.testbeds == null ? Collections.emptySortedSet() : (SortedSet)this.testbeds.stream().map(PrimaryIdObject::getId).collect(Collectors.toCollection(TreeSet::new));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestbedCategory)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TestbedCategory that = (TestbedCategory)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.getTestbedIds(), that.getTestbedIds()) && Objects.equals(this.guiFilter, that.guiFilter);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.getTestbedIds(), this.guiFilter);
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting Testbed " + this.getId() + " to JSON", (Throwable)e);
            return "Exception converting Testbed " + this.getId() + " to JSON: " + e.getMessage();
        }
    }

    @Override
    public int compareTo(TestbedCategory o) {
        boolean hasNullName;
        assert (o != null);
        boolean hasNullId = this.getId() == null || o.getId() == null;
        boolean bl = hasNullName = this.getName() == null || o.getName() == null;
        if (hasNullId && hasNullName) {
            LOG.error("Cannot compare 2 TestbedCategory when they have no ID or names. Will compare object identity as fallback. This can have unintended consequences..");
            return Comparator.naturalOrder().compare(System.identityHashCode(this), System.identityHashCode(o));
        }
        if (!hasNullId) {
            return ID_COMP.compare((Integer)this.getId(), (Integer)o.getId());
        }
        return NAME_COMP.compare(this.getName(), o.getName());
    }
}

