/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.client;

import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.LoggerFactory;

public class FedmonWebApiClientPropertiesConfig
implements FedmonWebApiClientConfig {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(FedmonWebApiClientPropertiesConfig.class);
    private final Properties properties;
    private final JFedTrustStore jFedTrustStore;
    private final List<X509Certificate> userCertificate;
    private final PrivateKey userPrivateKey;
    private final Logger logger;

    public FedmonWebApiClientPropertiesConfig(@Nonnull Properties properties, @Nonnull JFedTrustStore jFedTrustStore, @Nullable List<X509Certificate> userCertificate, @Nullable PrivateKey userPrivateKey, @Nullable Logger logger) {
        this.properties = properties;
        this.jFedTrustStore = jFedTrustStore;
        this.userCertificate = userCertificate;
        this.userPrivateKey = userPrivateKey;
        this.logger = logger;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    private String getBaseUrl(boolean read) {
        String baseUrl;
        if (read) {
            baseUrl = this.properties.getProperty("webapi_client_url_read_base");
            if (baseUrl == null) {
                baseUrl = "https://localhost/";
                LOG.warn("webapi_client_url_read_base config option not set. Falling back to default: " + baseUrl);
            }
        } else {
            baseUrl = this.properties.getProperty("webapi_client_url_write_base");
            if (baseUrl == null) {
                baseUrl = "https://localhost/";
                LOG.warn("webapi_client_url_write_base config option not set. Falling back to default: " + baseUrl);
            }
        }
        return baseUrl;
    }

    @Override
    @Nonnull
    public URIBuilder getUriBuilder(Class<? extends JsonLdObject> objectClass, boolean read) {
        return this.getUriBuilder(objectClass, "", read);
    }

    @Override
    @Nonnull
    public URIBuilder getUriBuilder(Class<? extends JsonLdObject> objectClass, String pathEnd, boolean read) {
        if (pathEnd == null) {
            pathEnd = "";
        }
        String urlObjectName = JsonLdObjectsMetaData.getUrlObjectName(objectClass);
        assert (urlObjectName != null);
        String baseUrl = this.getBaseUrl(read);
        URIBuilder builder = null;
        try {
            builder = new URIBuilder(baseUrl);
            String basePath = ("/" + builder.getPath() + "/").replaceAll("//", "/");
            String fullPath = basePath + urlObjectName + "/" + pathEnd;
            builder.setPath(fullPath);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URL in configuration: \"" + baseUrl + "\"", e);
        }
        return builder;
    }

    @Override
    @Nonnull
    public JFedTrustStore getTrustStore() {
        return this.jFedTrustStore;
    }

    @Override
    @Nullable
    public List<X509Certificate> getUserCertificateChain() {
        return this.userCertificate;
    }

    @Override
    @Nullable
    public PrivateKey getUserPrivateKey() {
        return this.userPrivateKey;
    }

    @Override
    @Nullable
    public Logger getLogger() {
        return this.logger;
    }

    public String toString() {
        return "FedmonWebApiClientPropertiesConfig{user=" + (this.userCertificate == null || this.userPrivateKey == null ? "none" : "set") + " readUrl=\"" + this.getBaseUrl(true) + "\" writeUrl=\"" + this.getBaseUrl(false) + "\"}";
    }
}

