/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.client;

import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.http.client.utils.URIBuilder;

public class LastResultFilter
implements FedmonWebApiClient.FedmonFilter<Long, Result> {
    protected final TestInstanceFilter testInstanceFilter;
    protected final boolean excludeCancelled;
    protected final Optional<Boolean> expired;
    protected final List<String> summary;

    public LastResultFilter(TestInstanceFilter testInstanceFilter, boolean excludeCancelled, Optional<Boolean> expired, List<String> summary) {
        this.testInstanceFilter = testInstanceFilter;
        this.excludeCancelled = excludeCancelled;
        this.expired = expired;
        this.summary = summary;
    }

    public TestInstanceFilter getTestInstanceFilter() {
        return this.testInstanceFilter;
    }

    public boolean isExcludeCancelled() {
        return this.excludeCancelled;
    }

    public Optional<Boolean> getExpired() {
        return this.expired;
    }

    public List<String> getSummary() {
        return this.summary;
    }

    public boolean hasTestInstanceFilter() {
        return this.testInstanceFilter != null;
    }

    public boolean hasExpiredFilter() {
        return this.expired != null && this.expired.isPresent();
    }

    public boolean hasSummaryFilter() {
        return this.summary != null && !this.summary.isEmpty();
    }

    @Override
    @Nonnull
    public URIBuilder addToUriParameters(@Nonnull URIBuilder builder) {
        builder.addParameter("last", null);
        if (this.hasTestInstanceFilter()) {
            builder = this.testInstanceFilter.addToUriParameters(builder);
        }
        if (this.hasExpiredFilter()) {
            builder.addParameter("expired", "" + this.expired.get());
        }
        if (this.excludeCancelled) {
            builder.addParameter("cancelled_excluded", null);
        } else {
            builder.addParameter("cancelled_included", null);
        }
        if (this.hasSummaryFilter()) {
            builder.addParameter("summary", String.join((CharSequence)",", this.summary));
        }
        return builder;
    }

    @Override
    @Nonnull
    public Class<Long> getIdClass() {
        return Long.class;
    }

    @Override
    @Nonnull
    public Class<Result> getObjectClass() {
        return Result.class;
    }
}

