/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.git;

import be.iminds.ilabt.jfed.git.GitFetcher;
import be.iminds.ilabt.jfed.git.GitFetcherCommandBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GitFetcherTest {
    private static final Logger LOG = LoggerFactory.getLogger(GitFetcherTest.class);
    private static final String PRIVATE_REPO_SSH_URL = "git@github.com:twalcari/Hello-World.git";
    private static final String PRIVATE_REPO_HTTPS_URL = "https://github.com/twalcari/Hello-World.git";
    private File checkoutDirSimple;
    private File checkoutDirPrivateSsh;
    private File checkoutDirPrivateHttps;

    @BeforeMethod
    public void setUp() throws Exception {
        this.checkoutDirSimple = Files.createTempDirectory("gitfetcherSimpleTest", new FileAttribute[0]).toFile();
        this.checkoutDirSimple.deleteOnExit();
        this.checkoutDirPrivateSsh = Files.createTempDirectory("gitfetcherPrivateSshTest", new FileAttribute[0]).toFile();
        this.checkoutDirPrivateSsh.deleteOnExit();
        this.checkoutDirPrivateHttps = Files.createTempDirectory("gitfetcherPrivateHttpsTest", new FileAttribute[0]).toFile();
        this.checkoutDirPrivateHttps.deleteOnExit();
    }

    @Test
    public void testFetchSimple() throws Exception {
        GitFetcherCommandBuilder commandBuilder = new GitFetcherCommandBuilder();
        LOG.trace("Cloning to {}", (Object)this.checkoutDirSimple);
        commandBuilder.setTargetDir(this.checkoutDirSimple);
        commandBuilder.setGitUrl("https://github.com/octocat/Hello-World.git");
        GitFetcher gitFetcher = new GitFetcher(null);
        gitFetcher.fetch(commandBuilder.build());
        Assert.assertTrue((boolean)new File(this.checkoutDirSimple, "README").exists(), (String)"Could not find expected file");
    }

    @Test(enabled=false)
    public void testFetchPrivateSsh() throws Exception {
        GitFetcherCommandBuilder commandBuilder = new GitFetcherCommandBuilder();
        LOG.trace("Cloning to {}", (Object)this.checkoutDirPrivateSsh);
        commandBuilder.setTargetDir(this.checkoutDirPrivateSsh);
        commandBuilder.setGitUrl(PRIVATE_REPO_SSH_URL);
        commandBuilder.setPrivateKeyPemFile(this.getClass().getResource("gitfetcher-test.pem").getFile());
        GitFetcher gitFetcher = new GitFetcher(null);
        gitFetcher.fetch(commandBuilder.build());
        Assert.assertTrue((boolean)new File(this.checkoutDirPrivateSsh, "README").exists(), (String)"Could not find expected file");
    }

    @Test(enabled=false)
    public void testFetchPrivateHttps() throws Exception {
        GitFetcherCommandBuilder commandBuilder = new GitFetcherCommandBuilder();
        LOG.trace("Cloning to {}", (Object)this.checkoutDirPrivateHttps);
        commandBuilder.setTargetDir(this.checkoutDirPrivateHttps);
        commandBuilder.setGitUrl(PRIVATE_REPO_HTTPS_URL);
        commandBuilder.setUsername("twalcari");
        commandBuilder.setPassword("XXXXXX");
        GitFetcher gitFetcher = new GitFetcher(null);
        gitFetcher.fetch(commandBuilder.build());
        Assert.assertTrue((boolean)new File(this.checkoutDirPrivateHttps, "README").exists(), (String)"Could not find expected file");
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.checkoutDirSimple.delete();
        this.checkoutDirPrivateSsh.delete();
        this.checkoutDirPrivateHttps.delete();
    }
}

