/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lib;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.lib.TestSfaConnectionPool;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticAggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionBuilder;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionBuilderFactory;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.lowlevel.connection.HandleUntrustedCallback;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.lib.MockSfaConnection;
import be.iminds.ilabt.jfed.lowlevel.lib.TestCertHelper;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.LoginInfo;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Singleton;
import org.apache.xmlrpc.XmlRpcRequest;

public class MockHttpRepliesTestCoreModule
extends AbstractModule {
    protected final TestCertHelper testCertHelper;
    protected final List<MockSfaConnection.MockXmlRpcReply> mockReplies;
    protected final List<MockSfaConnection.MockXmlRpcHistoryItem> mockXmlRpcHistory = Collections.synchronizedList(new ArrayList());
    protected final List<XmlRpcRequest> noMockXmlRpcRequestInfo = Collections.synchronizedList(new ArrayList());
    protected final MockSfaConnection.MockXmlRpcHistoryListener mockXmlRpcHistoryListener = this.mockXmlRpcHistory::add;
    protected final MockSfaConnection.OnMockXmlRpcListener onNoMockXmlRpcListener = this.noMockXmlRpcRequestInfo::add;
    private Map<String, MockSfaConnection> conCache = Collections.synchronizedMap(new HashMap());

    public MockHttpRepliesTestCoreModule() {
        this(new TestCertHelper());
    }

    public MockHttpRepliesTestCoreModule(TestCertHelper testCertHelper) {
        this.testCertHelper = testCertHelper;
        this.mockReplies = new ArrayList<MockSfaConnection.MockXmlRpcReply>();
    }

    public void addMockReply(MockSfaConnection.MockXmlRpcReply mr) {
        this.mockReplies.add(mr);
    }

    protected void configure() {
        this.bind(JFedTrustStore.class).in(Singleton.class);
        this.bind(TestCertHelper.class).toInstance((Object)this.testCertHelper);
        this.bind(JFedConnectionProvider.class).to(TestSfaConnectionPool.class).in(Singleton.class);
        this.bind(AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory.class).to(AutomaticAggregateManagerWrapper.BasicAutomaticAggregateManagerWrapperFactory.class).in(Singleton.class);
        this.bind(AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory.class).to(AutomaticUserAndSliceApiWrapper.BasicAutomaticUserAndSliceApiWrapperFactory.class).in(Singleton.class);
    }

    public MockSfaConnection createCon(TestbedInfoSource testbedInfoSource, String urlStr) throws JFedException {
        MockSfaConnection con;
        URL url;
        if (this.conCache.containsKey(urlStr) && !this.conCache.get(urlStr).isError()) {
            return this.conCache.get(urlStr);
        }
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        Server server = testbedInfoSource.getServerByUrl(url);
        assert (server != null);
        Service service = testbedInfoSource.getServiceByUrl(url);
        assert (service != null);
        assert (Objects.equals(service.getServer().getId(), server.getId()));
        try {
            con = new MockSfaConnection(new URL(urlStr), service, null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL used in test: " + urlStr, e);
        }
        con.setMockReplies(this.mockReplies);
        con.setNoMockListeners(Collections.singletonList(this.onNoMockXmlRpcListener));
        con.setHistoryListeners(Collections.singletonList(this.mockXmlRpcHistoryListener));
        this.conCache.put(urlStr, con);
        return con;
    }

    @Provides
    public ConnectionBuilderFactory provideConnectionBuilderFactory(final TestbedInfoSource testbedInfoSource) throws JFedException {
        assert (testbedInfoSource != null);
        Server userAuth = testbedInfoSource.getFromAnyUrnExact("urn:publicid:IDN+authority.example.com+authority+sa");
        Server amAuth = testbedInfoSource.getFromAnyUrnExact("urn:publicid:IDN+authority.example.com+authority+cm");
        Server am2Auth = testbedInfoSource.getFromAnyUrnExact("urn:publicid:IDN+authority2.example.com+authority+cm");
        Server scsAuth = testbedInfoSource.getFromAnyUrnExact("urn:publicid:IDN+authority3.example.com+authority+cm");
        assert (userAuth != null);
        assert (amAuth != null);
        assert (am2Auth != null);
        assert (scsAuth != null);
        return new ConnectionBuilderFactory(){

            public ConnectionBuilder createConnectionBuilder() {
                return new ConnectionBuilder(){
                    private String serverUrlStr;

                    public void setUrl(String serverUrlString) {
                        this.serverUrlStr = serverUrlString;
                    }

                    public synchronized void setUrl(URL serverUrl) {
                        assert (this.serverUrlStr == null);
                        this.serverUrlStr = serverUrl.toExternalForm();
                    }

                    public void setSocketConnectTimeoutMs(int socketConnectTimeoutMs) {
                    }

                    public void setSocketReadTimeoutMs(int socketReadTimeoutMs) {
                    }

                    public synchronized SfaConnection buildSfaConnection() throws JFedException {
                        return MockHttpRepliesTestCoreModule.this.createCon(testbedInfoSource, this.serverUrlStr);
                    }

                    public HttpConnection buildHttpConnection() throws JFedException {
                        return null;
                    }

                    public ConnectionConfig getCurrentConnectionConfig(ConnectionConfig.Type type) {
                        return null;
                    }

                    public void set(ConnectionConfig connectionConfig) {
                    }

                    public void setHackAllowAllServerCertificates(boolean hackAllowAllServerCertificates) {
                    }

                    public void setHackOverrideAllowedServerCertificateAlias(List<String> hackOverrideAllowedServerCertificateAlias) {
                    }

                    public void setDebugInfo(JFedConnection.DebugInfo debugInfo) {
                    }

                    public void setProxy(JFedConnection.ProxyInfo proxyInfo, boolean forceSshProxyDns) {
                    }

                    public void useNoAuthentication() {
                    }

                    public void useHttpBasicAuthentication(LoginInfo login) {
                    }

                    public void useSslClientAuthentication(List<X509Certificate> clientCertChain, PrivateKey privateKey) {
                    }

                    public void useHttp() {
                    }

                    public void useHttps(JFedTrustStore conTrustStore, HandleUntrustedCallback handleUntrustedCallback) {
                    }
                };
            }
        };
    }

    public TestCertHelper getTestCertHelper() {
        return this.testCertHelper;
    }

    public List<MockSfaConnection.MockXmlRpcHistoryItem> getMockXmlRpcHistory() {
        return this.mockXmlRpcHistory;
    }

    public List<XmlRpcRequest> getNoMockXmlRpcRequestInfo() {
        return this.noMockXmlRpcRequestInfo;
    }
}

