/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lib;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.lib.TestCertHelper;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.BasicTestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ServerTrustInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.net.MalformedURLException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class TestAuthoritiesModule
extends AbstractModule {
    public static final String hrnA = "Example auth with user for testing";
    public static final String urlA_am2 = "https://am.authority.example.com/2.0";
    public static final String urlA_am3 = "https://am.authority.example.com/3.0";
    public static final String urlA_pgSa1 = "https://sa.authority.example.com/";
    public static final String hrnB = "Example 2nd auth for testing";
    public static final String urlB_am2 = "https://am.authority2.example.com/2.0";
    public static final String urlB_am3 = "https://am.authority2.example.com/3.0";
    public static final String urlB_pgSa1 = "https://sa.authority2.example.com/";
    public static final String hrnC = "Example SCS for testing";
    public static final String urlC_scs = "https://scs.authority3.example.com/scs";
    public static final String hrnFake = "Fake Authority for testing ... fake authorities";
    public static final String urlC_am2 = "https://am.authority3.example.com/am/2.0";
    public static final String urlC_am3 = "https://am.authority3.example.com/am/3.0";
    private final AMConfig am1conf;
    private final AMConfig am2conf;
    private final AMConfig am3conf;

    public TestAuthoritiesModule() {
        this(new AMConfig(), new AMConfig(true, false, false, false), new AMConfig());
    }

    public TestAuthoritiesModule(AMConfig am1conf, AMConfig am2conf, AMConfig am3conf) {
        this.am1conf = am1conf;
        this.am2conf = am2conf;
        this.am3conf = am3conf;
    }

    protected void configure() {
    }

    @Provides
    private TestbedInfoSource provideTestbedInfoSource(JFedTrustStore trustStore, TestCertHelper testCertHelper) throws MalformedURLException, JFedException {
        ServiceBuilder serviceBuilder;
        ArrayList<TestbedBuilder> testbedBuilders = new ArrayList<TestbedBuilder>();
        int serviceId = 100;
        TestbedBuilder testbedBuilder = new TestbedBuilder();
        ServerBuilder serverBuilder = new ServerBuilder();
        testbedBuilder.setId((Object)"test1");
        serverBuilder.setId((Object)1);
        testbedBuilder.addServerBuilder(serverBuilder);
        testbedBuilder.setLongName(hrnA);
        serverBuilder.setName(hrnA);
        testbedBuilder.setDefaultComponentManagerUrn("urn:publicid:IDN+authority.example.com+authority+cm");
        serverBuilder.setDefaultComponentManagerUrn("urn:publicid:IDN+authority.example.com+authority+cm");
        serverBuilder.setServerType("test");
        serverBuilder.setCertificateChain(KeyUtil.x509certificateToPem((X509Certificate)testCertHelper.authority1Cert));
        if (this.am1conf.hasAny) {
            serverBuilder.addFlag(Server.Flag.featureStitchingAny);
        }
        if (this.am1conf.hasUpToDateAdv) {
            serverBuilder.addFlag(Server.Flag.featureStitchingAdvertisementRspecUptodate);
        }
        serverBuilder.addFlag(Server.Flag.workaroundAddExpiresAttributeToRequestRspec);
        if (this.am1conf.hasV2) {
            serviceBuilder = new ServiceBuilder();
            serverBuilder.addServiceBuilder(serviceBuilder);
            serviceBuilder.setUrn("urn:publicid:IDN+authority.example.com+authority+cm");
            serviceBuilder.setUrl(urlA_am2);
            serviceBuilder.setApi(ApiInfo.ApiName.GENI_AM.getId());
            serviceBuilder.setApiVersion("2");
            serviceBuilder.setId((Object)serviceId++);
        }
        if (this.am1conf.hasV3) {
            serviceBuilder = new ServiceBuilder();
            serverBuilder.addServiceBuilder(serviceBuilder);
            serviceBuilder.setUrn("urn:publicid:IDN+authority.example.com+authority+cm");
            serviceBuilder.setUrl(urlA_am3);
            serviceBuilder.setApi(ApiInfo.ApiName.GENI_AM.getId());
            serviceBuilder.setApiVersion("3");
            serviceBuilder.setId((Object)serviceId++);
        }
        serviceBuilder = new ServiceBuilder();
        serverBuilder.addServiceBuilder(serviceBuilder);
        serviceBuilder.setUrn("urn:publicid:IDN+authority.example.com+authority+sa");
        serviceBuilder.setUrl(urlA_pgSa1);
        serviceBuilder.setApi(ApiInfo.ApiName.PROTOGENI_SA.getId());
        serviceBuilder.setApiVersion("1");
        serviceBuilder.setId((Object)serviceId++);
        serverBuilder.setUrnTld(GeniUrn.parse((String)serverBuilder.getDefaultComponentManagerUrn()).getEncodedTopLevelAuthority());
        serverBuilder.setBaseUrl(((ServiceBuilder)serverBuilder.getServiceBuilders().get(0)).getUrl());
        testbedBuilders.add(testbedBuilder);
        testbedBuilder = new TestbedBuilder();
        serverBuilder = new ServerBuilder();
        testbedBuilder.setId((Object)"test2");
        serverBuilder.setId((Object)2);
        testbedBuilder.addServerBuilder(serverBuilder);
        testbedBuilder.setLongName(hrnB);
        serverBuilder.setName(hrnB);
        testbedBuilder.setDefaultComponentManagerUrn("urn:publicid:IDN+authority2.example.com+authority+cm");
        serverBuilder.setDefaultComponentManagerUrn("urn:publicid:IDN+authority2.example.com+authority+cm");
        serverBuilder.setServerType("test");
        serverBuilder.setCertificateChain(KeyUtil.x509certificateToPem((X509Certificate)testCertHelper.authority2Cert));
        if (this.am2conf.hasAny) {
            serverBuilder.addFlag(Server.Flag.featureStitchingAny);
        }
        if (this.am2conf.hasUpToDateAdv) {
            serverBuilder.addFlag(Server.Flag.featureStitchingAdvertisementRspecUptodate);
        }
        if (this.am2conf.hasV2) {
            serviceBuilder = new ServiceBuilder();
            serverBuilder.addServiceBuilder(serviceBuilder);
            serviceBuilder.setUrn("urn:publicid:IDN+authority2.example.com+authority+cm");
            serviceBuilder.setUrl(urlB_am2);
            serviceBuilder.setApi(ApiInfo.ApiName.GENI_AM.getId());
            serviceBuilder.setApiVersion("2");
            serviceBuilder.setId((Object)serviceId++);
        }
        if (this.am2conf.hasV3) {
            serviceBuilder = new ServiceBuilder();
            serverBuilder.addServiceBuilder(serviceBuilder);
            serviceBuilder.setUrn("urn:publicid:IDN+authority2.example.com+authority+cm");
            serviceBuilder.setUrl(urlB_am3);
            serviceBuilder.setApi(ApiInfo.ApiName.GENI_AM.getId());
            serviceBuilder.setApiVersion("3");
            serviceBuilder.setId((Object)serviceId++);
        }
        serviceBuilder = new ServiceBuilder();
        serverBuilder.addServiceBuilder(serviceBuilder);
        serviceBuilder.setUrn("urn:publicid:IDN+authority2.example.com+authority+sa");
        serviceBuilder.setUrl(urlB_pgSa1);
        serviceBuilder.setApi(ApiInfo.ApiName.PROTOGENI_SA.getId());
        serviceBuilder.setApiVersion("1");
        serviceBuilder.setId((Object)serviceId++);
        serverBuilder.setUrnTld(GeniUrn.parse((String)serverBuilder.getDefaultComponentManagerUrn()).getEncodedTopLevelAuthority());
        serverBuilder.setBaseUrl(((ServiceBuilder)serverBuilder.getServiceBuilders().get(0)).getUrl());
        testbedBuilders.add(testbedBuilder);
        testbedBuilder = new TestbedBuilder();
        serverBuilder = new ServerBuilder();
        testbedBuilder.setId((Object)"test3");
        serverBuilder.setId((Object)3);
        testbedBuilder.addServerBuilder(serverBuilder);
        testbedBuilder.setLongName(hrnC);
        serverBuilder.setName(hrnC);
        testbedBuilder.setDefaultComponentManagerUrn("urn:publicid:IDN+authority3.example.com+authority+cm");
        serverBuilder.setDefaultComponentManagerUrn("urn:publicid:IDN+authority3.example.com+authority+cm");
        serverBuilder.setServerType("test");
        serverBuilder.setCertificateChain(KeyUtil.x509certificateToPem((X509Certificate)testCertHelper.authority3Cert));
        if (this.am3conf.hasAny) {
            serverBuilder.addFlag(Server.Flag.featureStitchingAny);
        }
        if (this.am3conf.hasUpToDateAdv) {
            serverBuilder.addFlag(Server.Flag.featureStitchingAdvertisementRspecUptodate);
        }
        serverBuilder.addFlag(Server.Flag.workaroundAddExpiresAttributeToRequestRspec);
        if (this.am3conf.hasV2) {
            serviceBuilder = new ServiceBuilder();
            serverBuilder.addServiceBuilder(serviceBuilder);
            serviceBuilder.setUrn("urn:publicid:IDN+authority3.example.com+authority+cm");
            serviceBuilder.setUrl(urlC_am2);
            serviceBuilder.setApi(ApiInfo.ApiName.GENI_AM.getId());
            serviceBuilder.setApiVersion("2");
            serviceBuilder.setId((Object)serviceId++);
        }
        if (this.am3conf.hasV3) {
            serviceBuilder = new ServiceBuilder();
            serverBuilder.addServiceBuilder(serviceBuilder);
            serviceBuilder.setUrn("urn:publicid:IDN+authority3.example.com+authority+cm");
            serviceBuilder.setUrl(urlC_am3);
            serviceBuilder.setApi(ApiInfo.ApiName.GENI_AM.getId());
            serviceBuilder.setApiVersion("3");
            serviceBuilder.setId((Object)serviceId++);
        }
        serviceBuilder = new ServiceBuilder();
        serverBuilder.addServiceBuilder(serviceBuilder);
        serviceBuilder.setUrn("urn:publicid:IDN+authority3.example.com+authority+cm");
        serviceBuilder.setUrl(urlC_scs);
        serviceBuilder.setApi(ApiInfo.ApiName.GENI_SCS.getId());
        serviceBuilder.setApiVersion("1");
        serviceBuilder.setId((Object)serviceId++);
        serverBuilder.setUrnTld(GeniUrn.parse((String)serverBuilder.getDefaultComponentManagerUrn()).getEncodedTopLevelAuthority());
        serverBuilder.setBaseUrl(((ServiceBuilder)serverBuilder.getServiceBuilders().get(0)).getUrl());
        testbedBuilders.add(testbedBuilder);
        testbedBuilder = new TestbedBuilder();
        serverBuilder = new ServerBuilder();
        testbedBuilder.setId((Object)"test4");
        serverBuilder.setId((Object)4);
        testbedBuilder.addServerBuilder(serverBuilder);
        testbedBuilder.setLongName(hrnFake);
        serverBuilder.setName(hrnFake);
        testbedBuilder.setDefaultComponentManagerUrn("urn:publicid:IDN+fake.example.com+authority+cm");
        serverBuilder.setDefaultComponentManagerUrn("urn:publicid:IDN+fake.example.com+authority+cm");
        serverBuilder.setServerType("fake");
        serverBuilder.setUrnTld(GeniUrn.parse((String)serverBuilder.getDefaultComponentManagerUrn()).getEncodedTopLevelAuthority());
        serverBuilder.setBaseUrl(null);
        testbedBuilders.add(testbedBuilder);
        assert (testbedBuilders.size() == 4);
        BasicTestbedInfoSource testbedInfoSource = BasicTestbedInfoSource.createFromTestbedBuilders(testbedBuilders);
        assert (testbedInfoSource.getTestbeds().size() == 4) : "testbedInfoSource.getTestbeds().size()=" + testbedInfoSource.getTestbeds().size();
        assert (testbedInfoSource.getServers().size() == 4) : "testbedInfoSource.getServers().size()=" + testbedInfoSource.getServers().size();
        assert (testbedInfoSource.getServiceCount() > 3) : "testbedInfoSource.getServiceCount()=" + testbedInfoSource.getServiceCount();
        trustStore.addAuthorityCerts(ServerTrustInfo.convert((TestbedInfoSource)testbedInfoSource));
        return testbedInfoSource;
    }

    public String getTestAuthorityUrnString() {
        return "urn:publicid:IDN+authority.example.com+authority+cm";
    }

    public String getTestAuthority2UrnString() {
        return "urn:publicid:IDN+authority2.example.com+authority+cm";
    }

    public String getTestAuthority3UrnString() {
        return "urn:publicid:IDN+authority3.example.com+authority+cm";
    }

    public GeniUrn getTestAuthorityUrn() {
        return GeniUrn.parse((String)this.getTestAuthorityUrnString());
    }

    public GeniUrn getTestAuthority2Urn() {
        return GeniUrn.parse((String)this.getTestAuthority2UrnString());
    }

    public GeniUrn getTestAuthority3Urn() {
        return GeniUrn.parse((String)this.getTestAuthority3UrnString());
    }

    public static class AMConfig {
        private final boolean hasV2;
        private final boolean hasV3;
        private final boolean hasUpToDateAdv;
        private final boolean hasAny;

        public AMConfig() {
            this(false, true, false, true);
        }

        public AMConfig(boolean hasV2, boolean hasV3, boolean hasUpToDateAdv, boolean hasAny) {
            this.hasV2 = hasV2;
            this.hasV3 = hasV3;
            this.hasUpToDateAdv = hasUpToDateAdv;
            this.hasAny = hasAny;
        }
    }
}

