/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lib;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lib.CorePreferencesModule;
import be.iminds.ilabt.jfed.lib.MockHttpRepliesTestCoreModule;
import be.iminds.ilabt.jfed.lib.TestAuthoritiesModule;
import be.iminds.ilabt.jfed.lib.TestUserModule;
import be.iminds.ilabt.jfed.lowlevel.lib.TestCertHelper;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.MalformedURLException;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAuthoritiesModuleTest {
    @Test
    public void testExampleAuth() throws GeniUrn.GeniUrnParseException, MalformedURLException {
        TestAuthoritiesModule testAuthoritiesModule = new TestAuthoritiesModule();
        Injector injector = Guice.createInjector((Module[])new Module[]{testAuthoritiesModule, new CorePreferencesModule(), new MockHttpRepliesTestCoreModule(), new TestUserModule()});
        TestbedInfoSource testbedInfoSource = (TestbedInfoSource)injector.getInstance(TestbedInfoSource.class);
        TestCertHelper testCertHelper = (TestCertHelper)injector.getInstance(TestCertHelper.class);
        GeniUrn exampleUrn = testAuthoritiesModule.getTestAuthorityUrn();
        GeniUrn exampleUrn2 = testAuthoritiesModule.getTestAuthority2Urn();
        GeniUrn exampleUrn3 = GeniUrn.parse((String)"urn:publicid:IDN+authority3.example.com+authority+cm");
        Assert.assertNotNull((Object)exampleUrn);
        Assert.assertNotNull((Object)exampleUrn2);
        Assert.assertNotNull((Object)exampleUrn3);
        MatcherAssert.assertThat((Object)testbedInfoSource.getServers(), (Matcher)Matchers.hasSize((int)4));
        Server exampleAuth = testbedInfoSource.getByUrnExact(exampleUrn);
        Assert.assertNotNull((Object)exampleAuth);
        Assert.assertNotNull((Object)exampleAuth.getDefaultComponentManagerUrn());
        MatcherAssert.assertThat((Object)exampleAuth.getDefaultComponentManagerUrn(), (Matcher)Matchers.equalTo((Object)exampleUrn.toString()));
        MatcherAssert.assertThat((Object)exampleAuth.getName(), (Matcher)Matchers.equalTo((Object)"Example auth with user for testing"));
        MatcherAssert.assertThat((Object)ApiInfo.findUrl((Server)exampleAuth, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_AM, (int)3), (Matcher)Matchers.equalTo((Object)new URL("https://am.authority.example.com/3.0")));
        Server exampleAuth1b = testbedInfoSource.getByUrnExact("urn:publicid:IDN+authority.example.com+authority+sa");
        Assert.assertNotNull((Object)exampleAuth1b);
        Assert.assertNotNull((Object)exampleAuth1b.getDefaultComponentManagerUrn());
        Server exampleAuth1c = testbedInfoSource.getByUrnExact("urn:publicid:IDN+authority2.example.com+authority+sa");
        Assert.assertNotNull((Object)exampleAuth1c);
        Assert.assertNotNull((Object)exampleAuth1c.getDefaultComponentManagerUrn());
        Server exampleAuth2 = testbedInfoSource.getByUrnExact(exampleUrn2);
        Assert.assertNotNull((Object)exampleAuth2);
        Assert.assertNotNull((Object)exampleAuth2.getDefaultComponentManagerUrn());
        MatcherAssert.assertThat((Object)exampleAuth2.getDefaultComponentManagerUrn(), (Matcher)Matchers.equalTo((Object)exampleUrn2.toString()));
        MatcherAssert.assertThat((Object)exampleAuth2.getName(), (Matcher)Matchers.equalTo((Object)"Example 2nd auth for testing"));
        MatcherAssert.assertThat((Object)ApiInfo.findUrl((Server)exampleAuth2, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_AM, (int)2), (Matcher)Matchers.equalTo((Object)new URL("https://am.authority2.example.com/2.0")));
        Server exampleAuth3 = testbedInfoSource.getByUrnExact(exampleUrn3);
        Assert.assertNotNull((Object)exampleAuth3);
        Assert.assertNotNull((Object)exampleAuth3.getDefaultComponentManagerUrn());
        MatcherAssert.assertThat((Object)exampleAuth3.getDefaultComponentManagerUrn(), (Matcher)Matchers.equalTo((Object)exampleUrn3.toString()));
        MatcherAssert.assertThat((Object)exampleAuth3.getName(), (Matcher)Matchers.equalTo((Object)"Example SCS for testing"));
        MatcherAssert.assertThat((Object)ApiInfo.findUrl((Server)exampleAuth3, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_SCS, (int)1), (Matcher)Matchers.equalTo((Object)new URL("https://scs.authority3.example.com/scs")));
    }
}

