/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lib;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.lib.TestCertHelper;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Singleton;

public class TestUserModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    public GeniUser provideGeniUser(final TestbedInfoSource testbedInfoSource, final TestCertHelper testCertHelper) {
        return new GeniUser(){

            @Nonnull
            public PrivateKey getPrivateKey() {
                assert (testCertHelper != null);
                return testCertHelper.userKeys.getSshPrivateKey();
            }

            @Nonnull
            public PublicKey getPublicKey() {
                return testCertHelper.userKeys.getSshPublicKey();
            }

            @Nonnull
            public List<X509Certificate> getClientCertificateChain() {
                return Collections.singletonList(testCertHelper.userCert);
            }

            public Server getUserAuthorityServer() {
                return testbedInfoSource.getFromAnyUrnExact("urn:publicid:IDN+authority.example.com+authority+root");
            }

            public Integer getUserAuthorityServerId() {
                return (Integer)testbedInfoSource.getFromAnyUrnExact("urn:publicid:IDN+authority.example.com+authority+root").getId();
            }

            @Nonnull
            public String getUserUrnString() {
                return "urn:publicid:IDN+authority.example.com+user+tester";
            }

            @Nonnull
            public GeniUrn getUserUrn() {
                try {
                    return new GeniUrn(this.getUserUrnString());
                }
                catch (GeniUrn.GeniUrnParseException ex) {
                    throw new RuntimeException(ex);
                }
            }

            public File getPrivateKeyFile() {
                return null;
            }

            public File getCertificateFile() {
                return null;
            }
        };
    }

    @Provides
    public GeniUserProvider provideGeniUserProvider(final GeniUser geniUser) {
        return new GeniUserProvider(){

            @Nonnull
            public GeniUser getLoggedInGeniUser() {
                return geniUser;
            }

            public boolean isUserLoggedIn() {
                return geniUser != null;
            }
        };
    }
}

