/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class AbstractGeniAggregateManagerTest {
    @Test
    public void testIsNotEnoughFreeResources() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getValue()).thenReturn((Object)"Could not map to resources: Precheck failure");
        Mockito.when((Object)reply.getRawValue()).thenReturn((Object)"Could not map to resources: Precheck failure");
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"  *** No available physical nodes of type SERVER5P found (1 requested)\n");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsNotEnoughFreeResources2() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getValue()).thenReturn(null);
        Mockito.when((Object)reply.getRawValue()).thenReturn((Object)"Could not map to resources: Precheck failure");
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"  *** No available physical nodes of type SERVER5P found (1 requested)\n");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsNotEnoughFreeResourcesPerformLte() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getValue()).thenReturn(null);
        Mockito.when((Object)reply.getRawValue()).thenReturn((Object)"");
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"Too Big: insufficient resources to fulfill request");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_TOOBIG);
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsNotEnoughFreeResourcesExogeni() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getValue()).thenReturn(null);
        Mockito.when((Object)reply.getRawValue()).thenReturn(null);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"Embedding workflow ERROR: 2:Not enough resources in domain: http://geni-orca.renci.org/owl/uvanlvmsite.rdf#uvanlvmsite/Domain/vm:vm; Requested:1;resource pool=0.\\n Please see https://geni-orca.renci.org/trac/wiki/orca-errors for possible solutions.");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.getByCode((int)2));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsNotEnoughFreeResourcesLogATec() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getValue()).thenReturn(null);
        Mockito.when((Object)reply.getRawValue()).thenReturn(null);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"insufficient resources available");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_REFUSED);
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsTermsAndConditionsNotAccepted1() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"[T&C-APPROVAL-MISSING] Approval of the Terms & Conditions is required in order to use this testbed. Please visit https://example.com/termsandconditions");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_REFUSED);
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIsReservationProblem() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"Refused cause mobile10 is pre-reserved.");
        Mockito.when((Object)reply.getValue()).thenReturn((Object)0);
        Mockito.when((Object)reply.getRawValue()).thenReturn((Object)0);
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_REFUSED);
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED), (Matcher)Matchers.is((Object)false));
    }
}

