/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.ReputationService;
import be.iminds.ilabt.jfed.lowlevel.api.RestApi;
import be.iminds.ilabt.jfed.lowlevel.api.RestApiTest;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReputationServiceTest
extends RestApiTest {
    private ReputationService reputationService;
    private static final GeniUrn USER_URN = GeniUrn.parse((String)"urn:publicid:IDN+fed4fire:global+user+arisleiv");
    private static final GeniUrn SLICE_URN = GeniUrn.parse((String)"urn:publicid:IDN+fed4fire:global:reputation+slice+other");
    private static final Date START_DATE = new Date(1436176077000L);
    private static final Date END_DATE = new Date(1436172077000L);

    @BeforeMethod
    public void setUp() throws Exception {
        Logger logger = (Logger)Mockito.mock(Logger.class);
        JFedPreferences preferences = (JFedPreferences)Mockito.mock(JFedPreferences.class);
        Mockito.when((Object)preferences.getRetrySettings()).thenReturn((Object)((RetrySettings)Mockito.mock(RetrySettings.class)));
        this.reputationService = new ReputationService(logger, preferences);
    }

    @Test
    public void testRegisterExperiment() throws Exception {
        String response = "[\n  {\n    \"user_urn\": \"urn:publicid:IDN+fed4fire:global+user+arisleiv\",\n    \"slice_urn\": \"urn:publicid:IDN+fed4fire:global:reputation+slice+other\",\n    \"start_time\": \"2015-07-06T09:47:57+00:00\",\n    \"end_time\": \"2015-07-06T08:41:17+00:00\"\n  }\n]\n";
        HttpConnection con = this.mockHttpConnection(response);
        RestApi.RestReply reply = this.reputationService.registerExperiment(con, USER_URN, SLICE_URN, START_DATE, END_DATE);
        Assert.assertEquals((int)((List)reply.getValue()).size(), (int)1);
        ReputationService.SliceReputation sliceReputation = (ReputationService.SliceReputation)((List)reply.getValue()).get(0);
        Assert.assertEquals((Object)sliceReputation.getUserUrn(), (Object)USER_URN);
        Assert.assertEquals((Object)sliceReputation.getSliceUrn(), (Object)SLICE_URN);
        Assert.assertEquals((Object)sliceReputation.getStartTime(), (Object)START_DATE);
        Assert.assertEquals((Object)sliceReputation.getEndTime(), (Object)END_DATE);
    }

    @Test
    public void testGetReputation() throws Exception {
        String response = "[{\"testbed\":\"omf:netmode\",\"services\":[{\"overall\":1.0},{\"availability\":1.0}]}]";
        HttpConnection con = this.mockHttpConnection(response);
        RestApi.RestReply reply = this.reputationService.getReputation(con, GeniUrn.createGeniUrnFromEncodedParts((String)"authority", (String)"omf:netmode", (String)"cm"));
        Assert.assertEquals((String)((ReputationService.TestbedReputation)reply.getValue()).getTestbed(), (String)"omf:netmode");
        Assert.assertEquals((int)((ReputationService.TestbedReputation)reply.getValue()).getServices().size(), (int)2);
        Assert.assertEquals(((ReputationService.TestbedReputation)reply.getValue()).getServices().get("overall"), (Object)1.0);
        Assert.assertEquals(((ReputationService.TestbedReputation)reply.getValue()).getServices().get("availability"), (Object)1.0);
    }

    @Test
    public void testGetReputations() throws Exception {
        String responseString = "[{\"testbed\":\"omf:netmode\",\"services\":[{\"overall\":1.0},{\"availability\":1.0}]},{\"testbed\":\"omf:nitos\",\"services\":[{\"overall\":1.0},{\"availability\":1.0}]}]";
        HttpConnection con = this.mockHttpConnection(responseString);
        RestApi.RestReply reply = this.reputationService.getReputations(con);
        Assert.assertEquals((int)((List)reply.getValue()).size(), (int)2);
        ((HttpConnection)Mockito.verify((Object)con)).getHttpClient();
    }

    @Test
    public void testRegisterUserQOE() throws Exception {
        String response = "DATA RECEIVED!";
        HttpConnection con = this.mockHttpConnection(response);
        RestApi.RestReply reply = this.reputationService.registerUserQOE(con, USER_URN, SLICE_URN, START_DATE, END_DATE, Collections.emptyList(), 5, 5, 5);
        Assert.assertEquals((String)((String)reply.getValue()), (String)response);
    }
}

