/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper;

import be.iminds.ilabt.jfed.lib.CorePreferencesModule;
import be.iminds.ilabt.jfed.lib.MockHttpRepliesTestCoreModule;
import be.iminds.ilabt.jfed.lib.TestAuthoritiesModule;
import be.iminds.ilabt.jfed.lib.TestUserModule;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.ProtoGeniSAUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.lib.MockReplyLibrary;
import be.iminds.ilabt.jfed.lowlevel.lib.MockSfaConnection;
import be.iminds.ilabt.jfed.lowlevel.lib.TestCertHelper;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.xmlrpc.XmlRpcRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

public class UserAndSliceApiWrapperTest {
    private static final Logger LOG = LoggerFactory.getLogger(UserAndSliceApiWrapperTest.class);

    public static String wrapSuccessXmlRpcSAReply(String internal) {
        return "<?xml version=\"1.0\"?>\n<methodResponse>\n<params>\n<param><value><struct>\n<member><name>value</name><value>" + StringEscapeUtils.escapeXml((String)internal) + "</value>\n</member>\n<member><name>output</name><value><string></string></value></member>\n<member><name>code</name><value><i4>0</i4></value></member>\n</struct></value>\n</param>\n</params>\n</methodResponse>\n";
    }

    @Test
    public void reconstructExpiresBug() throws JFedException {
        MockHttpRepliesTestCoreModule testCoreModule = new MockHttpRepliesTestCoreModule();
        Injector injector = Guice.createInjector((Module[])new Module[]{testCoreModule, new TestUserModule(), new CorePreferencesModule(), new TestAuthoritiesModule()});
        final TestCertHelper testCertHelper = (TestCertHelper)injector.getInstance(TestCertHelper.class);
        be.iminds.ilabt.jfed.log.Logger logger = (be.iminds.ilabt.jfed.log.Logger)injector.getInstance(be.iminds.ilabt.jfed.log.Logger.class);
        GeniUserProvider geniUserProvider = (GeniUserProvider)injector.getInstance(GeniUserProvider.class);
        JFedConnectionProvider connectionProvider = (JFedConnectionProvider)injector.getInstance(JFedConnectionProvider.class);
        JFedPreferences jFedPreferences = (JFedPreferences)injector.getInstance(JFedPreferences.class);
        long nowMs = System.currentTimeMillis();
        nowMs -= nowMs % 1000L;
        Date now = new Date(nowMs);
        final Date oneMin = new Date(nowMs + 60000L);
        Date twoMin = new Date(nowMs + 120000L);
        final Date fourMin = new Date(nowMs + 240000L);
        testCoreModule.addMockReply(new MockSfaConnection.AbstractMockXmlRpcReply(){
            int callCount = 0;

            @Override
            public MockSfaConnection.MockXmlRpcAnswer matches(XmlRpcRequest request) {
                if (!Objects.equals(MockReplyLibrary.getServerUrl(request), "https://sa.authority.example.com/")) {
                    return null;
                }
                if (Objects.equals(request.getMethodName(), "GetCredential") && request.getParameterCount() == 0) {
                    String targetUrn = "urn:publicid:IDN+authority.example.com+user+tester";
                    X509Certificate ownerCert = testCertHelper.saCert;
                    X509Certificate targetCert = testCertHelper.userCert;
                    X509Certificate signerCert = testCertHelper.authority1Cert;
                    RSAPrivateKey signerPrivateKey = testCertHelper.authority1Keys.getSshPrivateKey();
                    Date expireDate = this.callCount++ == 0 ? oneMin : fourMin;
                    String privilegeName = "*";
                    boolean canDelegate = true;
                    String credentialjFedName = "Test Credential for Test User";
                    SfaCredential cred = null;
                    try {
                        cred = SfaCredential.create((String)"privilege", (String)"urn:publicid:IDN+authority.example.com+authority+sa", (String)targetUrn, (X509Certificate)ownerCert, (X509Certificate)targetCert, (X509Certificate)signerCert, (PrivateKey)signerPrivateKey, (Date)expireDate, (String)privilegeName, (boolean)canDelegate, (String)credentialjFedName);
                    }
                    catch (CredentialException e) {
                        LOG.trace("Error creating test credential", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    String credentialXml = cred.getCredentialXml();
                    return new MockSfaConnection.MockXmlRpcAnswer(UserAndSliceApiWrapperTest.wrapSuccessXmlRpcSAReply(credentialXml));
                }
                return null;
            }
        });
        ProtoGeniSAUserAndSliceApiWrapper wrapper = new ProtoGeniSAUserAndSliceApiWrapper(logger, geniUserProvider, connectionProvider, jFedPreferences);
        List creds = wrapper.getUserCredentials(logger, GeniUrn.parse((String)"urn:publicid:IDN+authority.example.com+user+tester"));
        MatcherAssert.assertThat((Object)creds, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((AnyCredential)creds.get(0)).getExpiresDate(), (Matcher)Matchers.equalTo((Object)oneMin));
        MatcherAssert.assertThat((Object)wrapper.hasUserCredentials(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)creds, (Matcher)Matchers.hasSize((int)1));
        creds = wrapper.getCachedUserCredentialsForAM();
        MatcherAssert.assertThat((Object)creds, (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)wrapper.hasUserCredentials(), (Matcher)Matchers.is((Object)false));
        creds = wrapper.getUserCredentials(logger, GeniUrn.parse((String)"urn:publicid:IDN+authority.example.com+user+tester"));
        MatcherAssert.assertThat((Object)creds, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((AnyCredential)creds.get(0)).getExpiresDate(), (Matcher)Matchers.equalTo((Object)fourMin));
        MatcherAssert.assertThat((Object)wrapper.hasUserCredentials(), (Matcher)Matchers.is((Object)true));
        creds = wrapper.getCachedUserCredentialsForAM();
        MatcherAssert.assertThat((Object)creds, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)wrapper.hasUserCredentials(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Not all calls had a mock reply", testCoreModule.getNoMockXmlRpcRequestInfo(), (Matcher)Matchers.empty());
    }

    @Test
    public void reconstructExpiresBug2a() throws JFedException {
        UserAndSliceApiWrapper testWrapper = (UserAndSliceApiWrapper)Mockito.mock(UserAndSliceApiWrapper.class, (Answer)Mockito.CALLS_REAL_METHODS);
        long nowMs = System.currentTimeMillis();
        nowMs -= nowMs % 1000L;
        Date now = new Date(nowMs);
        Date oneMin = new Date(nowMs + 60000L);
        Date twoMin = new Date(nowMs + 120000L);
        Date fourMin = new Date(nowMs + 240000L);
        ArrayList<SfaCredential> credList = new ArrayList<SfaCredential>();
        SfaCredential cred = (SfaCredential)Mockito.mock(SfaCredential.class);
        Mockito.when((Object)cred.getExpiresDate()).thenReturn((Object)fourMin);
        credList.add(cred);
        MatcherAssert.assertThat((Object)testWrapper.hasUserCredentials(credList), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void reconstructExpiresBug2b() throws JFedException {
        UserAndSliceApiWrapper testWrapper = (UserAndSliceApiWrapper)Mockito.mock(UserAndSliceApiWrapper.class, (Answer)Mockito.CALLS_REAL_METHODS);
        long nowMs = System.currentTimeMillis();
        nowMs -= nowMs % 1000L;
        Date now = new Date(nowMs);
        Date oneMin = new Date(nowMs + 60000L);
        Date twoMin = new Date(nowMs + 120000L);
        Date fourMin = new Date(nowMs + 240000L);
        ArrayList<SfaCredential> credList = new ArrayList<SfaCredential>();
        SfaCredential cred = (SfaCredential)Mockito.mock(SfaCredential.class);
        Mockito.when((Object)cred.getExpiresDate()).thenReturn((Object)oneMin);
        credList.add(cred);
        MatcherAssert.assertThat((Object)testWrapper.hasUserCredentials(credList), (Matcher)Matchers.is((Object)false));
    }
}

