/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.connection;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpInfoXmlRpcTransportFactory;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.XmlRpcTypeNil;
import be.iminds.ilabt.jfed.util.debug_info.DebugInfoFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcLocalTransport;
import org.apache.xmlrpc.client.XmlRpcTransport;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactoryImpl;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcController;
import org.apache.xmlrpc.common.XmlRpcRequestProcessor;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.parser.XmlRpcResponseParser;
import org.apache.xmlrpc.serializer.XmlRpcWriter;
import org.apache.xmlrpc.server.XmlRpcServer;
import org.apache.xmlrpc.util.SAXParsers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MockSfaConnection
extends SfaConnection {
    private static final Logger LOG = LoggerFactory.getLogger(be.iminds.ilabt.jfed.lowlevel.lib.MockSfaConnection.class);
    private List<MockXmlRpcReply> mockReplies = new ArrayList<MockXmlRpcReply>();
    private List<OnMockXmlRpcListener> noMockListeners = new ArrayList<OnMockXmlRpcListener>();
    private List<MockXmlRpcHistoryListener> historyListeners = new ArrayList<MockXmlRpcHistoryListener>();

    public MockSfaConnection(URL serverUrl, Service service, JFedConnection.ProxyInfo proxyInfo) throws JFedException {
        this(serverUrl, proxyInfo, DebugInfoFactory.createFromService(null, (Service)service));
    }

    public MockSfaConnection(URL serverUrl, JFedConnection.ProxyInfo proxyInfo, JFedConnection.DebugInfo debugInfo) throws JFedException {
        super(new ConnectionConfig(serverUrl, debugInfo, proxyInfo, ConnectionConfig.Authentication.SSL_CLIENT_AUTH, null, null, null, ConnectionConfig.Protocol.HTTPS, null, null, ConnectionConfig.Type.SFA));
        try {
            this.xmlRpcClient = new XmlRpcClient();
            this.xmlRpcClient.setTypeFactory((TypeFactory)new XmlRpcTypeNil((XmlRpcController)this.xmlRpcClient));
            MockXmlRpcTransportFactory mockXmlRpcTransportFactory = new MockXmlRpcTransportFactory(this.xmlRpcClient);
            this.xmlRpcTransportFactory = mockXmlRpcTransportFactory;
            this.xmlRpcClient.setTransportFactory((XmlRpcTransportFactory)this.xmlRpcTransportFactory);
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(serverUrl);
            config.setEnabledForExtensions(true);
            config.setXmlRpcServer(mockXmlRpcTransportFactory.createServer(config));
            this.xmlRpcClient.setConfig((XmlRpcClientConfig)config);
            this.error = false;
        }
        catch (Exception e) {
            throw new JFedException("Error creating XmlRpcClient in MockSfaConnection constructor: " + e.getMessage(), (Throwable)e);
        }
    }

    public void close() {
        this.error = true;
        this.xmlRpcTransportFactory = null;
        this.xmlRpcClient = null;
    }

    public void setMockReplies(List<MockXmlRpcReply> mockReplies) {
        this.mockReplies = mockReplies;
    }

    public void setNoMockListeners(List<OnMockXmlRpcListener> noMockListeners) {
        this.noMockListeners = noMockListeners;
    }

    public void setHistoryListeners(List<MockXmlRpcHistoryListener> historyListeners) {
        this.historyListeners = historyListeners;
    }

    private class MockXmlRpcTransportFactory
    extends XmlRpcTransportFactoryImpl
    implements HttpInfoXmlRpcTransportFactory {
        private final XmlRpcTransport LOCAL_TRANSPORT;
        public String httpRecvHist;
        public String httpSentHist;
        public StatusLine httpStatusLine;
        public String httpRequestLine;
        public String httpRequestHeaders;
        public String httpResponseHeaders;

        public MockXmlRpcTransportFactory(XmlRpcClient pClient) {
            super(pClient);
            this.LOCAL_TRANSPORT = new MockXmlRpcLocalTransport(this.getClient());
            this.httpRecvHist = null;
            this.httpSentHist = null;
            this.httpStatusLine = null;
            this.httpRequestLine = null;
            this.httpRequestHeaders = null;
            this.httpResponseHeaders = null;
        }

        public XmlRpcTransport getTransport() {
            return this.LOCAL_TRANSPORT;
        }

        public String getHttpReceivedHistory() {
            return this.httpRecvHist;
        }

        public String getHttpSentHistory() {
            return this.httpSentHist;
        }

        public StatusLine getHttpStatusLine() {
            return this.httpStatusLine;
        }

        public String getHttpRequestLine() {
            return this.httpRequestLine;
        }

        public String getHttpRequestHeaders() {
            return this.httpRequestHeaders;
        }

        public String getHttpResponseHeaders() {
            return this.httpResponseHeaders;
        }

        public List<Header> getRawHttpResponseHeaders() {
            return Collections.emptyList();
        }

        public void clearLastCallData() {
            this.httpRecvHist = "";
            this.httpRequestHeaders = null;
            this.httpStatusLine = null;
            this.httpRequestLine = null;
            this.httpResponseHeaders = null;
            this.httpSentHist = "";
        }

        public void close() {
        }

        public void setProperty(String s, Object o) {
        }

        public XmlRpcRequestProcessor createServer(XmlRpcClientConfigImpl config) {
            return new MockXmlRpcServer(config);
        }

        private class MockXmlRpcLocalTransport
        extends XmlRpcLocalTransport {
            public MockXmlRpcLocalTransport(XmlRpcClient pClient) {
                super(pClient);
            }

            private void logRequest(XmlRpcRequest request) {
                ByteArrayOutputStream pStream = new ByteArrayOutputStream();
                XmlRpcStreamConfig config = (XmlRpcStreamConfig)request.getConfig();
                try {
                    ContentHandler h = this.getClient().getXmlWriterFactory().getXmlWriter(config, (OutputStream)pStream);
                    XmlRpcWriter xw = new XmlRpcWriter(config, h, this.getClient().getTypeFactory());
                    try {
                        xw.write(request);
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                    }
                }
                catch (XmlRpcException ex) {
                    LOG.error("Error while writing mock request", (Throwable)ex);
                }
                MockXmlRpcTransportFactory.this.httpSentHist = pStream.toString();
            }

            public Object sendRequest(XmlRpcRequest pRequest) throws XmlRpcException {
                this.logRequest(pRequest);
                return super.sendRequest(pRequest);
            }
        }

        private class MockXmlRpcServer
        extends XmlRpcServer {
            private final XmlRpcClientConfigImpl config;

            public MockXmlRpcServer(XmlRpcClientConfigImpl config) {
                this.config = config;
            }

            public Object execute(XmlRpcRequest pRequest) throws XmlRpcException {
                Object seenException = null;
                MockXmlRpcAnswer reply = null;
                for (MockXmlRpcReply mockXmlRpcReply : MockSfaConnection.this.mockReplies) {
                    try {
                        reply = mockXmlRpcReply.matches(pRequest);
                    }
                    catch (AssertionError e) {
                        LOG.error("AssertionError while matching for mock reply", (Throwable)((Object)e));
                        seenException = e;
                    }
                    catch (Exception e) {
                        LOG.error("Exception while matching for mock reply", (Throwable)e);
                        seenException = e;
                    }
                    if (reply == null) continue;
                    mockXmlRpcReply.registerUsage();
                    MockXmlRpcHistoryItem historyItem = new MockXmlRpcHistoryItem(pRequest, reply);
                    for (MockXmlRpcHistoryListener histListener : MockSfaConnection.this.historyListeners) {
                        histListener.onMockXmlRpcHistory(historyItem);
                    }
                }
                if (reply == null && seenException == null) {
                    for (OnMockXmlRpcListener l : MockSfaConnection.this.noMockListeners) {
                        l.onNoMockFor(pRequest);
                    }
                    throw new XmlRpcClientException("No mock answer for this request: " + String.valueOf(pRequest), null);
                }
                if (reply == null) {
                    throw new XmlRpcClientException("Got exception while looking for mock answer for " + String.valueOf(pRequest), seenException);
                }
                if (reply.isException()) {
                    LOG.trace("Mocked exception", reply.getEx());
                    throw new XmlRpcClientException("Mocked exception", reply.getEx());
                }
                MockXmlRpcTransportFactory.this.httpRecvHist = reply.getString();
                MockXmlRpcTransportFactory.this.httpStatusLine = new StatusLine(){

                    public ProtocolVersion getProtocolVersion() {
                        return new HttpVersion(1, 1);
                    }

                    public int getStatusCode() {
                        return 200;
                    }

                    public String getReasonPhrase() {
                        return "OK";
                    }
                };
                return this.readResponse(reply.getString());
            }

            protected XMLReader newXMLReader() throws XmlRpcException {
                return SAXParsers.newXMLReader();
            }

            private Object readResponse(String responseString) throws XmlRpcException {
                XmlRpcResponseParser xp;
                XMLReader xr = this.newXMLReader();
                try {
                    xp = new XmlRpcResponseParser((XmlRpcStreamRequestConfig)this.config, this.getTypeFactory());
                    xr.setContentHandler((ContentHandler)xp);
                    xr.parse(new InputSource(new StringReader(responseString)));
                }
                catch (SAXException e) {
                    throw new XmlRpcClientException("Failed to parse mock response: " + e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    throw new XmlRpcClientException("Failed to read mock response: " + e.getMessage(), (Throwable)e);
                }
                if (xp.isSuccess()) {
                    return xp.getResult();
                }
                Throwable t = xp.getErrorCause();
                if (t == null) {
                    throw new XmlRpcException(xp.getErrorCode(), xp.getErrorMessage());
                }
                if (t instanceof XmlRpcException) {
                    throw (XmlRpcException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new XmlRpcException(xp.getErrorCode(), xp.getErrorMessage(), t);
            }
        }
    }

    public static abstract class AbstractMockXmlRpcReply
    implements MockXmlRpcReply {
        private int usages = 0;

        @Override
        public void registerUsage() {
            ++this.usages;
        }

        @Override
        public int usageCount() {
            return this.usages;
        }
    }

    public static interface OnMockXmlRpcListener {
        public void onNoMockFor(XmlRpcRequest var1);
    }

    public static interface MockXmlRpcReply {
        public MockXmlRpcAnswer matches(XmlRpcRequest var1);

        public void registerUsage();

        public int usageCount();
    }

    public static class MockXmlRpcAnswer {
        private final String reply;
        private final Throwable ex;

        public MockXmlRpcAnswer(String reply) {
            this.reply = reply;
            this.ex = null;
        }

        public MockXmlRpcAnswer(Throwable ex) {
            this.reply = null;
            this.ex = ex;
        }

        public boolean isException() {
            return this.ex != null;
        }

        public String getString() {
            return this.reply;
        }

        public Throwable getEx() {
            return this.ex;
        }
    }

    public static interface MockXmlRpcHistoryListener {
        public void onMockXmlRpcHistory(MockXmlRpcHistoryItem var1);
    }

    public static class MockXmlRpcHistoryItem {
        public final XmlRpcRequest request;
        public final MockXmlRpcAnswer reply;

        public MockXmlRpcHistoryItem(XmlRpcRequest request, MockXmlRpcAnswer reply) {
            this.request = request;
            this.reply = reply;
        }
    }
}

