/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.lib;

import be.iminds.ilabt.jfed.lowlevel.credential.AbacCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

public class AbacCredentialTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbacCredentialTest.class);
    private static final String expectedCredentialXmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><signed-credential xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://www.protogeni.net/resources/credential/credential.xsd\" xsi:schemaLocation=\"http://www.protogeni.net/resources/credential/ext/policy/1 http://www.protogeni.net/resources/credential/ext/policy/1/policy.xsd\">\n  <credential xml:id=\"_0\">\n\n        <type>abac</type>\n        <serial/>\n        <owner_gid/>\n        <target_gid/>\n        <uuid/>\n        <expires>2100-12-31T00:00:00Z</expires>\n        <abac>\n            <rt0>\n                <version>1.1</version>\n                <head>\n   <ABACprincipal><keyid>8de9389a0f75149bd6910734bb7c008fffe05904</keyid></ABACprincipal>\n   <role>speaks_for_8de9389a0f75149bd6910734bb7c008fffe05904</role>\n</head>\n<tail>\n   <ABACprincipal><keyid>5d3aadc7a01ca922893a00142e49aa00d51c9b42</keyid></ABACprincipal>\n</tail>\n\n            </rt0>\n        </abac>\n\n</credential>\n  <signatures>\n  <Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\" xml:id=\"Sig__0\">\n<SignedInfo>\n<CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/>\n<SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#rsa-sha1\"/>\n<Reference URI=\"#_0\">\n<Transforms>\n<Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#enveloped-signature\"/>\n<Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/>\n</Transforms>\n<DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"/>\n<DigestValue>oK5N7PgvyQpRLpBp4mLGQkctw7g=</DigestValue>\n</Reference>\n</SignedInfo>\n<SignatureValue>d9lhBcX/15jfqw97cydwxEGxVoD4qbkfv95ZQEoDa/mXFg+j1+IKTa96cZE0Xhm7RJeIIxD2qz2r\n/pLx+m4gTBTpacj6nY9ciALgOYrn2n5J73cNzJi9Xm2eBCeM8AGAis4HJts3eacYHjjHV7Mmy7Rf\nCNwWquwqtlijIgZcD+Kh8HyDfI53ICFY1Wz3LQSyyoT/kgMj71xY+6sOBR3egyd6L8OsTxBY30sN\nDk30d6wv11bjS+3ZHKMO72l6Xdgd/UQeSljrzcgxTsgprIJgG4QHO2VDLfql3Th5kzAWhFUJvM/H\n1/nM1mv/XIG1eoiZ/IWg0h+g9NU+SGA9tfR4Eg==</SignatureValue>\n<KeyInfo>\n<X509Data>\n<X509Certificate>MIIEozCCA4ugAwIBAgIJAKdm6CkA/TLMMA0GCSqGSIb3DQEBBQUAMIGRMQswCQYDVQQGEwJCRTET\nMBEGA1UECBMKU29tZS1TdGF0ZTEOMAwGA1UEBxMFR2hlbnQxDzANBgNVBAoTBmlNaW5kczEPMA0G\nA1UECxMGaWxhYi50MRQwEgYDVQQDEwtqRmVkIFRlc3RlcjElMCMGCSqGSIb3DQEJARYWamZlZEBs\naXN0cy5mZWQ0ZmlyZS5ldTAgFw0xNDAzMjYwNzM1MThaGA8yMTUxMDIxNjA3MzUxOFowgZExCzAJ\nBgNVBAYTAkJFMRMwEQYDVQQIEwpTb21lLVN0YXRlMQ4wDAYDVQQHEwVHaGVudDEPMA0GA1UEChMG\naU1pbmRzMQ8wDQYDVQQLEwZpbGFiLnQxFDASBgNVBAMTC2pGZWQgVGVzdGVyMSUwIwYJKoZIhvcN\nAQkBFhZqZmVkQGxpc3RzLmZlZDRmaXJlLmV1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC\nAQEAt9DLTl6GDWg7RgCzepWyV9EpUfXUZUqQi1D8kJAWR5IcnyR1wCt5BqfUR5uBtvn2m2XSz3nD\n0jT6+sGsx0G1+50h31ukOA1JnRlvgENNiJztio76UP9eN0IrtFpuBK+g50kRrlrUhG/zfAV8snQp\nBO1Bue4YLJTf9mmnusTL2gWrzglGMalOfbIU2H3yjfPh5es5VOVutvNXpGGKVYoJrlOZ1SgkKwhl\nt+ANyrj6+cERaVqbgq1TeOOsFjdEq59HmP74eHTu0v9WrrWrlRbYElENbhDhGL2YXf0H9B+0eliT\nbkOly8ACIhGurjLKiPWIs6uKpaLLxcF0teQwsg0IFQIDAQABo4H5MIH2MB0GA1UdDgQWBBSN6Tia\nD3UUm9aRBzS7fACP/+BZBDCBxgYDVR0jBIG+MIG7gBSN6TiaD3UUm9aRBzS7fACP/+BZBKGBl6SB\nlDCBkTELMAkGA1UEBhMCQkUxEzARBgNVBAgTClNvbWUtU3RhdGUxDjAMBgNVBAcTBUdoZW50MQ8w\nDQYDVQQKEwZpTWluZHMxDzANBgNVBAsTBmlsYWIudDEUMBIGA1UEAxMLakZlZCBUZXN0ZXIxJTAj\nBgkqhkiG9w0BCQEWFmpmZWRAbGlzdHMuZmVkNGZpcmUuZXWCCQCnZugpAP0yzDAMBgNVHRMEBTAD\nAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQA/QKeMMXDvoWzPYmPhnQKro4Bk7YKd9HGkrwQKAx2Qs/LL\nXV3pp6vYJ9t66XisfPZlz5l5L5uDzTdU98ugvrfdxCCPkPixFztytS1hbQXSc4V4Zv1tMy6cyKJO\nhzGR3t8f2tgn4kiBd6z1PaYci92f00/HuI8JQEYbOzC63ZboIHyK14voKVomqXANqVlm+UdSjt8L\n+v5v1vxt/hIeDZQHwHcP9iTvuNT1HZ47S38JUdX1vHU+YAMHetuBpDGOsM54OJT7IlXD140WNbgz\nnydvhEDK9cZZhb7DHJ/pNDUIkpUrhxlovpFi9rdhShOYL6XJEq4MlhDRNTM19qGRZIo9</X509Certificate>\n</X509Data>\n<KeyValue>\n<RSAKeyValue>\n<Modulus>\nt9DLTl6GDWg7RgCzepWyV9EpUfXUZUqQi1D8kJAWR5IcnyR1wCt5BqfUR5uBtvn2m2XSz3nD0jT6\n+sGsx0G1+50h31ukOA1JnRlvgENNiJztio76UP9eN0IrtFpuBK+g50kRrlrUhG/zfAV8snQpBO1B\nue4YLJTf9mmnusTL2gWrzglGMalOfbIU2H3yjfPh5es5VOVutvNXpGGKVYoJrlOZ1SgkKwhlt+AN\nyrj6+cERaVqbgq1TeOOsFjdEq59HmP74eHTu0v9WrrWrlRbYElENbhDhGL2YXf0H9B+0eliTbkOl\ny8ACIhGurjLKiPWIs6uKpaLLxcF0teQwsg0IFQ==\n</Modulus>\n<Exponent>AQAB</Exponent>\n</RSAKeyValue>\n</KeyValue>\n</KeyInfo>\n</Signature></signatures>\n</signed-credential>";
    private static final String testPemPrivateKey = "-----BEGIN RSA PRIVATE KEY-----\nMIIEowIBAAKCAQEAt9DLTl6GDWg7RgCzepWyV9EpUfXUZUqQi1D8kJAWR5IcnyR1\nwCt5BqfUR5uBtvn2m2XSz3nD0jT6+sGsx0G1+50h31ukOA1JnRlvgENNiJztio76\nUP9eN0IrtFpuBK+g50kRrlrUhG/zfAV8snQpBO1Bue4YLJTf9mmnusTL2gWrzglG\nMalOfbIU2H3yjfPh5es5VOVutvNXpGGKVYoJrlOZ1SgkKwhlt+ANyrj6+cERaVqb\ngq1TeOOsFjdEq59HmP74eHTu0v9WrrWrlRbYElENbhDhGL2YXf0H9B+0eliTbkOl\ny8ACIhGurjLKiPWIs6uKpaLLxcF0teQwsg0IFQIDAQABAoIBABacqsXjPt5bWh9M\nasfDroK7Cjg4433qZEmfFtK5xuPbB4ZUN+AB+QtmjeiZKqXVrg6DwiEfu4UaW12J\ngbWpUbe4JriRT2xNxiZ7QIoovVr24wnOeOCJ6Y8mprWzAiG1cTfCd1hZeBcqpms1\nSZeyTnF6tkEnFvY1AjAP40BIgUM6hamTNPZgwRuob2ISHrLljm1AIOGRTY1hDISi\nKpfyY7yHTZJLwfUQVD6KBLg9YeiGy1NPzE9UmXrQlRooiipLw/kGA6SAoUblqvS3\nkFqTg/qUFxF4VxbCg4FjGXCQY4ws71OfGo4zgN/DmiO1vrHKnJvLIkjpTacMy2gr\nPrhWWUECgYEA8pX9euSto87peYxYkDYnQXYAK65X4mFIOV8CYW6hXMbltS5z/1hW\ndZKCNJr8ui6LpbcWTKmTYjDSxR15w+kuF1Trib682pQ2E3LCPYneBOJ0Hogv+D02\nKF5PsCOYcReVwHq8H1dEck9j2g5wGLaajDWw3Vu7o3trT6zbUQD72YkCgYEAwfrc\nRfKOk53HLSipM7Ipr+hPtYLrUExQTip8dh+3mAtXeMOe/Nm8P5ERSBAa8ETNx9fD                                                                                                                              \npzcQY/7GqgtLwAzgIM73yRSnUe0mDV4JwCeteJ8wpdB+xbPprPgp+4xj0oO0zfrh                                                                                                                              \n9Gi7Wl9lsFHGz03WLcLks2JNk9yEbWdStIUFsy0CgYEA1wkaLwvy2BgcYkCEaSF3                                                                                                                              \n3tEpCY98HBI8IY8U3yVgKIuvJ9JLxPebfJEollUk3i1QYM9RFxfiq9G3pD+ipoVW                                                                                                                              \n9Bu0xt+rLN7gqJC7mi1R/2Z1pHL4gsZP8azYWrzS7r0HZB3oEKgc5m91hd/yghWs                                                                                                                              \nHcmiRDaCuEI5N+F0b/O9THECgYAPqqARsiZbu7lzZz5LI4+EWoHdigZRROiTd5D3                                                                                                                              \nxVYBnKDi6wGzMC6o/6FirZJPZ28rPbzai3LycIhBAYqLpz6Ox8hxYA6najzRhY/K                                                                                                                              \nCipTfJ/kNHOYqhAsXRqe61bAkMyQeju3jqHbCatf0yr4YTP0HDJ2XnEfiQbVAyxF                                                                                                                              \n0hyEvQKBgDOyK9omGnMAFTZOMUu94y+atccMqHyxCDLZl6yh9ipB+gvGTDh9c6+G\nmMua/QVmH8yFT3NWM++2P54vuUFgrn3WmIpq4pkIoQ5qF9xi192oC7Kocwwy3OTn\nlmyfwPhutAcGcMFZcQoNPXPzrCj1Ku4duXtO6jkWy3kTqvr8ib8j\n-----END RSA PRIVATE KEY-----";
    private static final String testPemCert = "-----BEGIN CERTIFICATE-----\nMIIEozCCA4ugAwIBAgIJAKdm6CkA/TLMMA0GCSqGSIb3DQEBBQUAMIGRMQswCQYD\nVQQGEwJCRTETMBEGA1UECBMKU29tZS1TdGF0ZTEOMAwGA1UEBxMFR2hlbnQxDzAN\nBgNVBAoTBmlNaW5kczEPMA0GA1UECxMGaWxhYi50MRQwEgYDVQQDEwtqRmVkIFRl\nc3RlcjElMCMGCSqGSIb3DQEJARYWamZlZEBsaXN0cy5mZWQ0ZmlyZS5ldTAgFw0x\nNDAzMjYwNzM1MThaGA8yMTUxMDIxNjA3MzUxOFowgZExCzAJBgNVBAYTAkJFMRMw\nEQYDVQQIEwpTb21lLVN0YXRlMQ4wDAYDVQQHEwVHaGVudDEPMA0GA1UEChMGaU1p\nbmRzMQ8wDQYDVQQLEwZpbGFiLnQxFDASBgNVBAMTC2pGZWQgVGVzdGVyMSUwIwYJ\nKoZIhvcNAQkBFhZqZmVkQGxpc3RzLmZlZDRmaXJlLmV1MIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAt9DLTl6GDWg7RgCzepWyV9EpUfXUZUqQi1D8kJAW\nR5IcnyR1wCt5BqfUR5uBtvn2m2XSz3nD0jT6+sGsx0G1+50h31ukOA1JnRlvgENN\niJztio76UP9eN0IrtFpuBK+g50kRrlrUhG/zfAV8snQpBO1Bue4YLJTf9mmnusTL\n2gWrzglGMalOfbIU2H3yjfPh5es5VOVutvNXpGGKVYoJrlOZ1SgkKwhlt+ANyrj6\n+cERaVqbgq1TeOOsFjdEq59HmP74eHTu0v9WrrWrlRbYElENbhDhGL2YXf0H9B+0\neliTbkOly8ACIhGurjLKiPWIs6uKpaLLxcF0teQwsg0IFQIDAQABo4H5MIH2MB0G\nA1UdDgQWBBSN6TiaD3UUm9aRBzS7fACP/+BZBDCBxgYDVR0jBIG+MIG7gBSN6Tia\nD3UUm9aRBzS7fACP/+BZBKGBl6SBlDCBkTELMAkGA1UEBhMCQkUxEzARBgNVBAgT\nClNvbWUtU3RhdGUxDjAMBgNVBAcTBUdoZW50MQ8wDQYDVQQKEwZpTWluZHMxDzAN\nBgNVBAsTBmlsYWIudDEUMBIGA1UEAxMLakZlZCBUZXN0ZXIxJTAjBgkqhkiG9w0B\nCQEWFmpmZWRAbGlzdHMuZmVkNGZpcmUuZXWCCQCnZugpAP0yzDAMBgNVHRMEBTAD\nAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQA/QKeMMXDvoWzPYmPhnQKro4Bk7YKd9HGk\nrwQKAx2Qs/LLXV3pp6vYJ9t66XisfPZlz5l5L5uDzTdU98ugvrfdxCCPkPixFzty\ntS1hbQXSc4V4Zv1tMy6cyKJOhzGR3t8f2tgn4kiBd6z1PaYci92f00/HuI8JQEYb\nOzC63ZboIHyK14voKVomqXANqVlm+UdSjt8L+v5v1vxt/hIeDZQHwHcP9iTvuNT1\nHZ47S38JUdX1vHU+YAMHetuBpDGOsM54OJT7IlXD140WNbgznydvhEDK9cZZhb7D\nHJ/pNDUIkpUrhxlovpFi9rdhShOYL6XJEq4MlhDRNTM19qGRZIo9\n-----END CERTIFICATE-----";
    private static final String testPemCert2 = "-----BEGIN CERTIFICATE-----\nMIIDczCCAlugAwIBAgIJAL/+/v/MmM5BMA0GCSqGSIb3DQEBCwUAME8xCzAJBgNV\nBAYTAkJFMQwwCgYDVQQIDANPVkwxDTALBgNVBAcMBEdlbnQxDzANBgNVBAoMBmlN\naW5kczESMBAGA1UEAwwJVGVzdCBUb29sMCAXDTE1MTExODEyMDczM1oYDzIxNTIx\nMDEwMTIwNzMzWjBPMQswCQYDVQQGEwJCRTEMMAoGA1UECAwDT1ZMMQ0wCwYDVQQH\nDARHZW50MQ8wDQYDVQQKDAZpTWluZHMxEjAQBgNVBAMMCVRlc3QgVG9vbDCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKslQvr9oR7C7b2bcRUELhzbvcIA\nNumqsYt/QgBSQzEZjsahoZQl+BuwqhmELlD1m02bUW+IHz7Vc9d+W0l7TmAMUzq8\nsgSfnLpFKUvaZa5JuZoOwCvVUKo7xMbPm7w1ep2lh7Lblv/rgRW+33D4hXu8MVNU\n4ASTWM1re0S7xhC+o8w+SP8D/FhA/52O7bbtIN90ajOvYiLnq+gfvU6eIh74fP+g\nst1qqDZuht/Q8N6civU10t4jVcCl5u3JoXSjfxgoXicN3gG3VJCUA5bjI7o0SmU6\nswAD4H0WPSRA4iMd82MolXW5CAwaqBi0cZv9mD3q3djxSl6jZCJMNSIkpFcCAwEA\nAaNQME4wHQYDVR0OBBYEFF06rcegHKkiiToAFC5JqgDVHJtCMB8GA1UdIwQYMBaA\nFF06rcegHKkiiToAFC5JqgDVHJtCMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEL\nBQADggEBAGzgTdvukaMF6dgNS8ae5SLBq876BZFkX7KSE+9Lc/Gj4TClvP7S1ZpQ\nPlEj9uQgRYFgVz+AGgy3ehLjuMDxcimKi+23TMwlLqrerqm9McfsMa7Q00Q/9V9e\n2q28Jk2wknP8Fm7stL7aBJ+mK1dtMcYiHl1FDxdPilb8YguND1TJ+zfghSmBEMuy\nC15t92J5v3xm+3cmuEz3m6wZEnrqLkbzXd1SOUCoxF/f9K5pI8UjCkRjgWOkn/SZ\nqiheWk4+NOwQwlvNwFlMT+9o7ZM4j3JglG0Wbqd1yxVGaChc+Pt4ClC7uxslCdfI\nsMilLddgHu+BsfI2ClbRLm2J8AwYv14=\n-----END CERTIFICATE-----";
    private static final PrivateKey testPrivateKey;
    private static final PublicKey testPublicKey;
    private static final X509Certificate testCert;
    private static final X509Certificate testCert2;
    private static final String wvdemeerCertString = "-----BEGIN CERTIFICATE-----\nMIIEDDCCA3WgAwIBAgIDAgcaMA0GCSqGSIb3DQEBBAUAMIG1MQswCQYDVQQGEwJC\nRTELMAkGA1UECBMCT1YxDjAMBgNVBAcTBUdoZW50MRgwFgYDVQQKEw9pTWluZHMg\nLSBpbGFiLnQxHjAcBgNVBAsTFUNlcnRpZmljYXRlIEF1dGhvcml0eTEjMCEGA1UE\nAxMaYm9zcy53YWxsMi5pbGFidC5pbWluZHMuYmUxKjAoBgkqhkiG9w0BCQEWG3Z3\nYWxsLW9wc0BhdGxhbnRpcy51Z2VudC5iZTAeFw0xNTA5MjkwNjEwMjVaFw0xNjA5\nMjgwNjEwMjVaMIGyMQswCQYDVQQGEwJCRTELMAkGA1UECBMCT1YxGDAWBgNVBAoT\nD2lNaW5kcyAtIGlsYWIudDEeMBwGA1UECxMVaW1pbmRzLXdhbGwyLnd2ZGVtZWVy\nMS0wKwYDVQQDEyRiNzU2MTljYy0xNmI5LTExZTMtOTY2YS0wMDE1MTdiZWNkYzEx\nLTArBgkqhkiG9w0BCQEWHnd2ZGVtZWVyQHdhbGwyLmlsYWJ0LmltaW5kcy5iZTCB\nnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA37Y9en0GR8G3VZfclZJ6W2njdunq\neXdpDtFm8RsHMhOcjv9ZDEZozEwN5h8RZM1Enx3XyR16gHNL/+mClqJeXZ0UB37F\nIBXhNIJH99OQED+/ZeA14U3RutgfmmWK1Pq0rYWl+lSPY30u9WrKRzUtTdq2syY3\nj7cS6kWiBM/lrfECAwEAAaOCASkwggElMAwGA1UdEwEB/wQCMAAwHQYDVR0OBBYE\nFKcVS7s7d5gVtjUXbBmzUwsA66RNMIGQBgNVHREEgYgwgYWGNHVybjpwdWJsaWNp\nZDpJRE4rd2FsbDIuaWxhYnQuaW1pbmRzLmJlK3VzZXIrd3ZkZW1lZXKBHnd2ZGVt\nZWVyQHdhbGwyLmlsYWJ0LmltaW5kcy5iZYYtdXJuOnV1aWQ6Yjc1NjE5Y2MtMTZi\nOS0xMWUzLTk2NmEtMDAxNTE3YmVjZGMxMGMGCCsGAQUFBwEBBFcwVTBTBhRpg8yT\ngKiYzKjHvbGngICqrteKG4Y7aHR0cHM6Ly93d3cud2FsbDIuaWxhYnQuaW1pbmRz\nLmJlOjEyMzY5L3Byb3RvZ2VuaS94bWxycGMvc2EwDQYJKoZIhvcNAQEEBQADgYEA\nIJxpE7n6PLvF5+UAoLWJAmxyKoT+43Bx3lGNlE4MKlQkBz3UgqEcmJq3OSL9zvKQ\nLq/tnbzFi+UjjxG9GwSsTY48/kC8Jlf4V14MKJc+nNp1vMZKqPKgNdiYVIGuMIMD\nT1zbf+vmEohMTbajw2GlkCuZ2e3K8XX52h9UkPlOpvo=\n-----END CERTIFICATE-----\n";
    private static final X509Certificate wvdemeerCert;
    private static final String wvdemeerKeyId = "a7154bbb3b779815b635176c19b3530b00eba44d";

    @Test
    public void testCreateSpeaksFor() throws Exception {
        Date expire = RFC3339Util.rfc3339StringToDate((String)"2100-12-31T00:00:00Z");
        AbacCredential tst = AbacCredential.createSpeaksFor((Date)expire, (X509Certificate)testCert2, (X509Certificate)testCert, (Key)testPrivateKey);
        LOG.trace("Generated test ABAC SpeaksFor: " + tst.getCredentialXml());
        MatcherAssert.assertThat((Object)tst.isSpeaksFor(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)tst.getCredentialXml().replaceAll("\n", "").replaceAll("\r", ""), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedCredentialXmlString.replaceAll("\n", "").replaceAll("\r", ""))));
    }

    @Test
    public void testKeyId() throws Exception {
        String keyId = AbacCredential.generateKeyId((X509Certificate)wvdemeerCert);
        LOG.trace("generated keyId=" + keyId);
        LOG.trace(" expected keyId=a7154bbb3b779815b635176c19b3530b00eba44d");
        MatcherAssert.assertThat((Object)keyId, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)wvdemeerKeyId)));
    }

    @Test
    public void testParseAbac() throws Exception {
        AbacCredential cred = (AbacCredential)AnyCredential.createAutoDetect((String)"test cred", (String)expectedCredentialXmlString);
        MatcherAssert.assertThat((Object)cred.isSpeaksFor(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cred.getHeadKeyId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"8de9389a0f75149bd6910734bb7c008fffe05904")));
        MatcherAssert.assertThat((Object)cred.getTailKeyId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"5d3aadc7a01ca922893a00142e49aa00d51c9b42")));
        MatcherAssert.assertThat((Object)cred.getHeadRole(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"speaks_for_8de9389a0f75149bd6910734bb7c008fffe05904")));
        Date date = RFC3339Util.rfc3339StringToDate((String)"2100-12-31T00:00:00Z");
        MatcherAssert.assertThat((Object)cred.getExpires(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"2100-12-31T00:00:00Z")));
        MatcherAssert.assertThat((Object)cred.getExpiresDate(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)date)));
    }

    static {
        PrivateKey pk = null;
        X509Certificate c = null;
        X509Certificate c2 = null;
        try {
            pk = KeyUtil.pemToAnyPrivateKey((String)testPemPrivateKey, null);
            assert (pk != null);
            c = KeyUtil.pemToX509Certificate((String)testPemCert);
            assert (c != null);
            c2 = KeyUtil.pemToX509Certificate((String)testPemCert2);
            assert (c2 != null);
            wvdemeerCert = KeyUtil.pemToX509Certificate((String)wvdemeerCertString);
            assert (wvdemeerCert != null);
        }
        catch (Exception e) {
            throw new RuntimeException("Static initialize of XmlUtilTest failed: " + e.getMessage(), e);
        }
        testPrivateKey = pk;
        testCert = c;
        testCert2 = c2;
        testPublicKey = c.getPublicKey();
    }
}

