/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.lib;

import be.iminds.ilabt.jfed.lowlevel.credential.AbacCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.security.cert.X509Certificate;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AnyCredentialTest {
    private static final String ABAC_SPEAKSFOR_EXAMPLE_CREDENTIAL = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><signed-credential xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://www.protogeni.net/resources/credential/credential.xsd\" xsi:schemaLocation=\"http://www.protogeni.net/resources/credential/ext/policy/1 http://www.protogeni.net/resources/credential/ext/policy/1/policy.xsd\">\n  <credential xml:id=\"_0\">\n\n\t<type>abac</type>\n\t<serial/>\n\t<owner_gid/>\n\t<target_gid/>\n\t<uuid/>\n\t<expires>2015-10-09T12:04:32.309Z</expires>\n\t<abac>\n\t    <rt0>\n\t\t<version>1.1</version>\n\t\t<head>\n   <ABACprincipal><keyid>a681ca4082c1301703fee2d62d844664675bc5f0</keyid></ABACprincipal>\n   <role>speaks_for_a681ca4082c1301703fee2d62d844664675bc5f0</role>\n</head>\n<tail>\n   <ABACprincipal><keyid>193a45bb42745506c87ad182aee2f5017a56a1cf</keyid></ABACprincipal>\n</tail>\n\n\t    </rt0>\n\t</abac>\n\n</credential>\n  <signatures>\n  <Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\"><SignedInfo><CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/><SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#rsa-sha1\"/><Reference URI=\"#_0\"><Transforms><Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/></Transforms><DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"/><DigestValue>uzjP0RfmXdSXw+XbRZ8fkuYGdMM=</DigestValue></Reference></SignedInfo><SignatureValue>fPkr2TPp+AYHu4+mz0/9fmGg+dFwsXuA60TAtAamFoTENAG8XOtqESFgWZ8cASiQBCPnxfHkz6BypxnJ9y0DntKP4mOIjMzoy6Ng3JUtjC0dCuBBWlHt96BsqZOKwmr5oTaxmCGNrmcCEyhE5W4LFFtvu0XfDxgAp1i9TAGPt7g=</SignatureValue><KeyInfo>\n<KeyValue>\n<RSAKeyValue>\n<Modulus>ALY7An8l4nVLh+sCeQNT3V9xrW8QLSKnQlepD7deLUivUXnHNxSds07Ow/yPiiZq\nfYNFslEA5F51PILPWGmsG8gzTVeWpAdaYIuz9agKyXD7rZK4ZGHcR8V+MVX0GRyh\nSzD/OkX/eKW79YkejaLgZLrThkYi5pCom6HGKl9UVF0r\n</Modulus>\n<Exponent>AQAB</Exponent>\n</RSAKeyValue></KeyValue>\n<X509Data>\n<X509Certificate>MIIEDDCCA3WgAwIBAgIDAOUHMA0GCSqGSIb3DQEBBAUAMIG1MQswCQYDVQQGEwJC\nRTELMAkGA1UECBMCT1YxDjAMBgNVBAcTBUdoZW50MRgwFgYDVQQKEw9pTWluZHMg\nLSBpbGFiLnQxHjAcBgNVBAsTFUNlcnRpZmljYXRlIEF1dGhvcml0eTEjMCEGA1UE\nAxMaYm9zcy53YWxsMi5pbGFidC5pbWluZHMuYmUxKjAoBgkqhkiG9w0BCQEWG3Z3\nYWxsLW9wc0BhdGxhbnRpcy51Z2VudC5iZTAeFw0xNDA5MjUxMjI5MzRaFw0xNTA5\nMjUxMjI5MzRaMIGyMQswCQYDVQQGEwJCRTELMAkGA1UECBMCT1YxGDAWBgNVBAoT\nD2lNaW5kcyAtIGlsYWIudDEeMBwGA1UECxMVaW1pbmRzLXdhbGwyLnd2ZGVtZWVy\nMS0wKwYDVQQDEyRiNzU2MTljYy0xNmI5LTExZTMtOTY2YS0wMDE1MTdiZWNkYzEx\nLTArBgkqhkiG9w0BCQEWHnd2ZGVtZWVyQHdhbGwyLmlsYWJ0LmltaW5kcy5iZTCB\nnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtjsCfyXidUuH6wJ5A1PdX3GtbxAt\nIqdCV6kPt14tSK9Recc3FJ2zTs7D/I+KJmp9g0WyUQDkXnU8gs9YaawbyDNNV5ak\nB1pgi7P1qArJcPutkrhkYdxHxX4xVfQZHKFLMP86Rf94pbv1iR6NouBkutOGRiLm\nkKibocYqX1RUXSsCAwEAAaOCASkwggElMAwGA1UdEwEB/wQCMAAwHQYDVR0OBBYE\nFKaBykCCwTAXA/7i1i2ERmRnW8XwMIGQBgNVHREEgYgwgYWGNHVybjpwdWJsaWNp\nZDpJRE4rd2FsbDIuaWxhYnQuaW1pbmRzLmJlK3VzZXIrd3ZkZW1lZXKBHnd2ZGVt\nZWVyQHdhbGwyLmlsYWJ0LmltaW5kcy5iZYYtdXJuOnV1aWQ6Yjc1NjE5Y2MtMTZi\nOS0xMWUzLTk2NmEtMDAxNTE3YmVjZGMxMGMGCCsGAQUFBwEBBFcwVTBTBhRpg8yT\ngKiYzKjHvbGngICqrteKG4Y7aHR0cHM6Ly93d3cud2FsbDIuaWxhYnQuaW1pbmRz\nLmJlOjEyMzY5L3Byb3RvZ2VuaS94bWxycGMvc2EwDQYJKoZIhvcNAQEEBQADgYEA\nmJzek8GZc5YmBcmn1RLpEFhX0cLmsrmCnQXcpHJCzH4lhUiH5O1f1mN+2X7idKbS\nvmiQh8jKbn3jRalQOZ6kpn0XQsPnCJ4t5r7cP2p6fshHdMT11jwLkmlAR+wVlRjo\n8jDDT8yO5vJ9Db5D3mdeeg7DQm4fl9cHunvjGpNxhhc=\n</X509Certificate>\n</X509Data></KeyInfo></Signature></signatures>\n</signed-credential>";
    private final String SIGNER_CERT_PEM = "-----BEGIN CERTIFICATE-----MIIEDDCCA3WgAwIBAgIDAOUHMA0GCSqGSIb3DQEBBAUAMIG1MQswCQYDVQQGEwJC\nRTELMAkGA1UECBMCT1YxDjAMBgNVBAcTBUdoZW50MRgwFgYDVQQKEw9pTWluZHMg\nLSBpbGFiLnQxHjAcBgNVBAsTFUNlcnRpZmljYXRlIEF1dGhvcml0eTEjMCEGA1UE\nAxMaYm9zcy53YWxsMi5pbGFidC5pbWluZHMuYmUxKjAoBgkqhkiG9w0BCQEWG3Z3\nYWxsLW9wc0BhdGxhbnRpcy51Z2VudC5iZTAeFw0xNDA5MjUxMjI5MzRaFw0xNTA5\nMjUxMjI5MzRaMIGyMQswCQYDVQQGEwJCRTELMAkGA1UECBMCT1YxGDAWBgNVBAoT\nD2lNaW5kcyAtIGlsYWIudDEeMBwGA1UECxMVaW1pbmRzLXdhbGwyLnd2ZGVtZWVy\nMS0wKwYDVQQDEyRiNzU2MTljYy0xNmI5LTExZTMtOTY2YS0wMDE1MTdiZWNkYzEx\nLTArBgkqhkiG9w0BCQEWHnd2ZGVtZWVyQHdhbGwyLmlsYWJ0LmltaW5kcy5iZTCB\nnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtjsCfyXidUuH6wJ5A1PdX3GtbxAt\nIqdCV6kPt14tSK9Recc3FJ2zTs7D/I+KJmp9g0WyUQDkXnU8gs9YaawbyDNNV5ak\nB1pgi7P1qArJcPutkrhkYdxHxX4xVfQZHKFLMP86Rf94pbv1iR6NouBkutOGRiLm\nkKibocYqX1RUXSsCAwEAAaOCASkwggElMAwGA1UdEwEB/wQCMAAwHQYDVR0OBBYE\nFKaBykCCwTAXA/7i1i2ERmRnW8XwMIGQBgNVHREEgYgwgYWGNHVybjpwdWJsaWNp\nZDpJRE4rd2FsbDIuaWxhYnQuaW1pbmRzLmJlK3VzZXIrd3ZkZW1lZXKBHnd2ZGVt\nZWVyQHdhbGwyLmlsYWJ0LmltaW5kcy5iZYYtdXJuOnV1aWQ6Yjc1NjE5Y2MtMTZi\nOS0xMWUzLTk2NmEtMDAxNTE3YmVjZGMxMGMGCCsGAQUFBwEBBFcwVTBTBhRpg8yT\ngKiYzKjHvbGngICqrteKG4Y7aHR0cHM6Ly93d3cud2FsbDIuaWxhYnQuaW1pbmRz\nLmJlOjEyMzY5L3Byb3RvZ2VuaS94bWxycGMvc2EwDQYJKoZIhvcNAQEEBQADgYEA\nmJzek8GZc5YmBcmn1RLpEFhX0cLmsrmCnQXcpHJCzH4lhUiH5O1f1mN+2X7idKbS\nvmiQh8jKbn3jRalQOZ6kpn0XQsPnCJ4t5r7cP2p6fshHdMT11jwLkmlAR+wVlRjo\n8jDDT8yO5vJ9Db5D3mdeeg7DQm4fl9cHunvjGpNxhhc=\n-----END CERTIFICATE-----";

    @Test
    public void testCreateAutoDetect() throws CredentialException {
        AnyCredential cred = AnyCredential.createAutoDetect((String)"test", (String)ABAC_SPEAKSFOR_EXAMPLE_CREDENTIAL);
        Assert.assertNotNull((Object)cred);
        MatcherAssert.assertThat((Object)cred, (Matcher)Matchers.instanceOf(AbacCredential.class));
    }

    @Test
    public void testIsSpeaksFor() throws CredentialException {
        AnyCredential cred = AnyCredential.createAutoDetect((String)"test", (String)ABAC_SPEAKSFOR_EXAMPLE_CREDENTIAL);
        MatcherAssert.assertThat((Object)cred.isSpeaksFor(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testGetSignerCertificates() throws CredentialException {
        AnyCredential cred = AnyCredential.createAutoDetect((String)"test", (String)ABAC_SPEAKSFOR_EXAMPLE_CREDENTIAL);
        List x509CertificateList = cred.getSignerCertificates();
        MatcherAssert.assertThat((Object)x509CertificateList, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)x509CertificateList, (Matcher)Matchers.hasSize((int)1));
        X509Certificate expectedCert = KeyUtil.pemToX509Certificate((String)"-----BEGIN CERTIFICATE-----MIIEDDCCA3WgAwIBAgIDAOUHMA0GCSqGSIb3DQEBBAUAMIG1MQswCQYDVQQGEwJC\nRTELMAkGA1UECBMCT1YxDjAMBgNVBAcTBUdoZW50MRgwFgYDVQQKEw9pTWluZHMg\nLSBpbGFiLnQxHjAcBgNVBAsTFUNlcnRpZmljYXRlIEF1dGhvcml0eTEjMCEGA1UE\nAxMaYm9zcy53YWxsMi5pbGFidC5pbWluZHMuYmUxKjAoBgkqhkiG9w0BCQEWG3Z3\nYWxsLW9wc0BhdGxhbnRpcy51Z2VudC5iZTAeFw0xNDA5MjUxMjI5MzRaFw0xNTA5\nMjUxMjI5MzRaMIGyMQswCQYDVQQGEwJCRTELMAkGA1UECBMCT1YxGDAWBgNVBAoT\nD2lNaW5kcyAtIGlsYWIudDEeMBwGA1UECxMVaW1pbmRzLXdhbGwyLnd2ZGVtZWVy\nMS0wKwYDVQQDEyRiNzU2MTljYy0xNmI5LTExZTMtOTY2YS0wMDE1MTdiZWNkYzEx\nLTArBgkqhkiG9w0BCQEWHnd2ZGVtZWVyQHdhbGwyLmlsYWJ0LmltaW5kcy5iZTCB\nnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtjsCfyXidUuH6wJ5A1PdX3GtbxAt\nIqdCV6kPt14tSK9Recc3FJ2zTs7D/I+KJmp9g0WyUQDkXnU8gs9YaawbyDNNV5ak\nB1pgi7P1qArJcPutkrhkYdxHxX4xVfQZHKFLMP86Rf94pbv1iR6NouBkutOGRiLm\nkKibocYqX1RUXSsCAwEAAaOCASkwggElMAwGA1UdEwEB/wQCMAAwHQYDVR0OBBYE\nFKaBykCCwTAXA/7i1i2ERmRnW8XwMIGQBgNVHREEgYgwgYWGNHVybjpwdWJsaWNp\nZDpJRE4rd2FsbDIuaWxhYnQuaW1pbmRzLmJlK3VzZXIrd3ZkZW1lZXKBHnd2ZGVt\nZWVyQHdhbGwyLmlsYWJ0LmltaW5kcy5iZYYtdXJuOnV1aWQ6Yjc1NjE5Y2MtMTZi\nOS0xMWUzLTk2NmEtMDAxNTE3YmVjZGMxMGMGCCsGAQUFBwEBBFcwVTBTBhRpg8yT\ngKiYzKjHvbGngICqrteKG4Y7aHR0cHM6Ly93d3cud2FsbDIuaWxhYnQuaW1pbmRz\nLmJlOjEyMzY5L3Byb3RvZ2VuaS94bWxycGMvc2EwDQYJKoZIhvcNAQEEBQADgYEA\nmJzek8GZc5YmBcmn1RLpEFhX0cLmsrmCnQXcpHJCzH4lhUiH5O1f1mN+2X7idKbS\nvmiQh8jKbn3jRalQOZ6kpn0XQsPnCJ4t5r7cP2p6fshHdMT11jwLkmlAR+wVlRjo\n8jDDT8yO5vJ9Db5D3mdeeg7DQm4fl9cHunvjGpNxhhc=\n-----END CERTIFICATE-----");
        MatcherAssert.assertThat((Object)((X509Certificate)x509CertificateList.get(0)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedCert)));
    }
}

