/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.lib;

import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.lib.TestCertHelper;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.Init;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.ElementProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CredentialTests {
    private static Logger LOG = LoggerFactory.getLogger(CredentialTests.class);
    private SfaCredential userCredential;
    private SfaCredential toolCredential;
    private TestCertHelper testCertHelper;
    SfaCredential speaksForCred;
    SfaCredential delegatedCred;

    @Test
    public void generateCertificates() throws NoSuchAlgorithmException, IOException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException, CertPathBuilderException, KeyStoreException, InvalidAlgorithmParameterException {
        this.testCertHelper = new TestCertHelper();
        LOG.trace("Authority cert self-signed:\n" + KeyUtil.x509certificateToPem((X509Certificate)this.testCertHelper.authority1Cert));
        LOG.trace("\nUser cert signed by authority:\n" + KeyUtil.x509certificateToPem((X509Certificate)this.testCertHelper.userCert));
        LOG.trace("\nTool cert signed by authority:\n" + KeyUtil.x509certificateToPem((X509Certificate)this.testCertHelper.toolCert));
    }

    public static String signXml(Document doc, String elementToSignId, String elementToAddSignatureToName, X509Certificate cert, Key privateKey) throws Exception {
        doc.normalizeDocument();
        if (cert.getPublicKey() instanceof RSAPublicKey && privateKey instanceof RSAPrivateKey) {
            assert (Objects.equals(((RSAPublicKey)cert.getPublicKey()).getModulus(), ((RSAPrivateKey)privateKey).getModulus()));
            if (LOG.isDebugEnabled()) {
                boolean same = Objects.equals(((RSAPublicKey)cert.getPublicKey()).getModulus(), ((RSAPrivateKey)privateKey).getModulus());
                LOG.trace("signXml input cert and privateKey have same modulus");
            }
        } else {
            LOG.trace("not Rsa private and/or public key: no check done");
        }
        return CredentialTests.signXmlWithSanturio(doc, elementToSignId, elementToAddSignatureToName, cert, privateKey);
    }

    public static String signXmlWithoutSanturio(Document doc, String elementToSignId, String elementToAddSignatureToName, X509Certificate cert, Key privateKey) throws Exception {
        Element elementToAddSignatureTo = (Element)doc.getElementsByTagName(elementToAddSignatureToName).item(0);
        assert (elementToAddSignatureTo != null);
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        Reference ref = fac.newReference("#" + elementToSignId, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        KeyValue kv = kif.newKeyValue(cert.getPublicKey());
        ArrayList<X509Certificate> x509DataList = new ArrayList<X509Certificate>();
        x509DataList.add(cert);
        X509Data x509Data = kif.newX509Data(x509DataList);
        ArrayList<XMLStructure> kiList = new ArrayList<XMLStructure>();
        kiList.add(kv);
        kiList.add(x509Data);
        KeyInfo ki = kif.newKeyInfo(kiList);
        DOMSignContext dsc = new DOMSignContext(privateKey, (Node)elementToAddSignatureTo);
        XMLSignature signature = fac.newXMLSignature(si, ki);
        signature.sign(dsc);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "no");
        trans.setOutputProperty("encoding", "utf-8");
        trans.setOutputProperty("indent", "no");
        StringWriter stringWriter = new StringWriter();
        trans.transform(new DOMSource(doc), new StreamResult(stringWriter));
        return stringWriter.getBuffer().toString();
    }

    public static String signXmlWithSanturio(Document doc, String elementToSignId, String elementToAddSignatureToName, X509Certificate cert, Key privateKey) throws Exception {
        Init.init();
        ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)"");
        org.apache.xml.security.signature.XMLSignature sig = new org.apache.xml.security.signature.XMLSignature(doc, null, "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        Element elementToAddSignatureTo = (Element)doc.getElementsByTagName(elementToAddSignatureToName).item(0);
        elementToAddSignatureTo.appendChild(sig.getElement());
        Transforms transforms = new Transforms(doc);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        sig.addDocument("#" + elementToSignId, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        sig.addKeyInfo(cert);
        sig.addKeyInfo(cert.getPublicKey());
        sig.sign(privateKey);
        StringWriter stringWriter = new StringWriter();
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("indent", "no");
        transformer.transform(new DOMSource(doc), new StreamResult(stringWriter));
        return stringWriter.getBuffer().toString();
    }

    @Test(dependsOnMethods={"generateCertificates"})
    public void createUserCredential() throws Exception {
        Date expireDate = new Date(System.currentTimeMillis() + 172800000L);
        LOG.trace("Creating User Credential");
        this.userCredential = SfaCredential.create((String)"privilege", (String)"urn:publicid:IDN+authority.example.com+user+tester", (String)"urn:publicid:IDN+authority.example.com+authority+sa", (X509Certificate)this.testCertHelper.userCert, (X509Certificate)this.testCertHelper.saCert, (X509Certificate)this.testCertHelper.saCert, (PrivateKey)this.testCertHelper.saKeys.getSshPrivateKey(), (Date)expireDate, (String)"*", (boolean)false, (String)"Test User Credential");
        LOG.trace("User credential:\n" + this.userCredential.getCredentialXml() + "\n");
        LOG.trace("User credential:\n" + this.userCredential.getCredentialXml());
    }

    @Test(dependsOnMethods={"createUserCredential"})
    public void checkUserCredential() throws KeyStoreException, CredentialException {
        LOG.trace("Checking User Credential");
        KeyStore trustStore = this.testCertHelper.testTrustStore;
        trustStore.setCertificateEntry("test-authority", this.testCertHelper.authority1Cert);
        Assert.assertTrue((boolean)this.userCredential.check(trustStore));
        LOG.trace("User Credential check passed");
    }

    @Test(dependsOnMethods={"checkUserCredential"})
    public void createAndCheckToolCredential() throws Exception {
        Date expireDate = new Date(System.currentTimeMillis() + 172800000L);
        this.toolCredential = SfaCredential.create((String)"privilege", (String)"urn:publicid:IDN+authority.example.com+authority+root", (String)"urn:publicid:IDN+authority.example.com+tool+jfed_unit_test", (X509Certificate)this.testCertHelper.authority1Cert, (X509Certificate)this.testCertHelper.toolCert, (X509Certificate)this.testCertHelper.authority1Cert, (PrivateKey)this.testCertHelper.authority1Keys.getSshPrivateKey(), (Date)expireDate, (String)"*", (boolean)false, (String)"Test Tool Credential");
        KeyStore trustStore = this.testCertHelper.testTrustStore;
        trustStore.setCertificateEntry("test-authority", this.testCertHelper.authority1Cert);
        Assert.assertTrue((boolean)this.toolCredential.check(trustStore));
    }

    @Test(dependsOnMethods={"createAndCheckToolCredential"})
    public void createSpeaksForCredential() throws Exception {
        Date expireDate = new Date(System.currentTimeMillis() + 129600000L);
        this.speaksForCred = SfaCredential.createSpeaksFor((String)"urn:publicid:IDN+authority.example.com+user+tester", (String)"urn:publicid:IDN+authority.example.com+tool+jfed_unit_test", (X509Certificate)this.testCertHelper.userCert, (X509Certificate)this.testCertHelper.toolCert, (PrivateKey)this.testCertHelper.userKeys.getSshPrivateKey(), (Date)expireDate, (String)"*", (boolean)false);
    }

    @Test(dependsOnMethods={"createSpeaksForCredential"})
    public void checkSpeaksForCredential() throws Exception {
        assert (this.speaksForCred != null);
        LOG.trace("Checking Speaks For credential");
        Assert.assertTrue((boolean)this.speaksForCred.check(this.testCertHelper.testTrustStore));
    }

    @Test(dependsOnMethods={"checkSpeaksForCredential"})
    public void createDelegatedCredential() throws Exception {
        Date expireDate = new Date(System.currentTimeMillis() + 129600000L);
        this.delegatedCred = this.userCredential.delegate("urn:publicid:IDN+authority.example.com+tool+jfed_unit_test", this.testCertHelper.toolCert, (PrivateKey)this.testCertHelper.userKeys.getSshPrivateKey(), expireDate, "info", false);
    }

    @Test(dependsOnMethods={"createDelegatedCredential"})
    public void checkDelegatedCredential() throws CredentialException {
        assert (this.delegatedCred != null);
        LOG.trace("Checking Delegated credential");
        Assert.assertTrue((boolean)this.delegatedCred.check(this.testCertHelper.testTrustStore));
    }
}

