/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.stitching;

import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingDirector;
import be.iminds.ilabt.jfed.util.library.JSonHelper;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class StitchingDirectorTest {
    @Test
    public void testIsUnavailableVlan() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"Exception: requested VLAN unavailable: sdn-sw.newy32aoa.net.internet2.edu,eth7/2 VLAN=1717");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_VLAN_UNAVAILABLE);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Boolean.TRUE)));
        MatcherAssert.assertThat((Object)StitchingDirector.getUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)1717));
    }

    @Test
    public void testIsUnavailableVlanExo() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"Embedding workflow ERROR: 1:Error in building the dependency tree, probably not available vlan path OR trying to reuse a stitching tag:http://geni-orca.renci.org/owl/8d80a006-3e59-476c-abe2-c040454e7ded#/08c8ec53-b708-4f68-964f-09d4d179c6bb.\n Please see https://geni-orca.renci.org/trac/wiki/orca-errors for possible solutions.");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Boolean.TRUE)));
        MatcherAssert.assertThat((Object)StitchingDirector.getUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testIsUnavailableVlan2() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"vlan tag 304 for authority.example.com not available");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Boolean.TRUE)));
        MatcherAssert.assertThat((Object)StitchingDirector.getUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)304));
    }

    @Test
    public void testGetUnavailableVlan() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"Exception: requested VLAN unavailable: sdn-sw.newy32aoa.net.internet2.edu,eth7/2 VLAN=1717");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_VLAN_UNAVAILABLE);
        MatcherAssert.assertThat((Object)StitchingDirector.getUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)1717));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Boolean.TRUE)));
    }

    @Test
    public void testGetUnavailableVlan2() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"vlan tag 304 for authority.example.com not available");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)StitchingDirector.getUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Boolean.TRUE)));
    }

    @Test
    public void testIsAnyNotSupported() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"ERROR: vlan range any is invalid");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Boolean.TRUE)));
    }

    @Test
    public void testIsAnyNotSupported2() throws Exception {
        Object blabla = "blabla ";
        for (int i = 0; i < 50; ++i) {
            blabla = (String)blabla + "blabla ";
        }
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)((String)blabla + " blabla any blabla " + (String)blabla));
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Boolean.TRUE)));
    }

    @Test
    public void testReplyType1() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getValue()).thenReturn((Object)"Could not map to resources: Not enough bandwidth to connect some nodes");
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"Nodes:\\nnode0 interconnect-wall1\\nnode1 n096-06a\\nEnd Nodes\\nEdges:\\nlinksimple/link0/node0:0,node1:0 Mapping Failed\\nEnd Edges\\n");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType2() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getValue()).thenReturn((Object)"");
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"Nodes:\\nnode0 interconnect-wall1\\nnode1 n096-06a\\nEnd Nodes\\nEdges:\\nlinksimple/link0/node0:0,node1:0 Mapping Failed\\nEnd Edges\\n");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType3() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getValue()).thenReturn((Object)"Could not map to resources: Not enough bandwidth to connect some nodes");
        Mockito.when((Object)reply.getRawValue()).thenReturn((Object)"Could not map to resources: Not enough bandwidth to connect some nodes");
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        assert (reply.getValue() != null);
        assert (reply.getValue() instanceof String);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType3b() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getValue()).thenReturn((Object)"Could not map to resources: Not enough bandwidth to connect some nodes");
        Mockito.when((Object)reply.getOutput()).thenReturn(null);
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType4() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"Could not map to resources: Not enough bandwidth to connect some nodes");
        Mockito.when((Object)reply.getValue()).thenReturn((Object)"");
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType4b() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"Could not map to resources: Not enough bandwidth to connect some nodes");
        Mockito.when((Object)reply.getValue()).thenReturn(null);
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType5() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"");
        Map ht = (Map)JSonHelper.jsonStringToXmlRpcLikeObject((String)"{\n                  \"geni_urn\": \"urn:publicid:IDN+example.com+slice+a\",\n                  \"geni_resources\": [\n                         {\n                            \"geni_urn\": \"urn:publicid:IDN+example.com+slice+sliceinsteadofsliver\",\n                            \"geni_error\": \"Bandwidth PCE(PCE_CREATE_FAILED): 'Unable to find path because the maximum bandwidth of ion.internet2.edu:rtr.hous:ge-1/2/4 has been exceeded. 150.0 Mbps is available and 800 Mbps was requested  on reservation ion.internet2.edu-91961 in Bandwidth PCE'\",\n                            \"geni_status\": \"failed\"\n                            }\n                         ],\n                  \"geni_expires\": \"2014-05-25T12:28:25.000Z\",\n                  \"geni_status\": \"failed\"\n                  }");
        AggregateManager2.SliverStatus sliverStatus = new AggregateManager2.SliverStatus((Object)ht);
        Mockito.when((Object)reply.getValue()).thenReturn((Object)sliverStatus);
        Mockito.when((Object)reply.getRawValue()).thenReturn((Object)ht);
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_SUCCESS);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType6() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"");
        Map ht = (Map)JSonHelper.jsonStringToXmlRpcLikeObject((String)"{\n                  \"geni_urn\": \"urn:publicid:IDN+example.com+slice+a\",\n                  \"geni_resources\": [\n                         {\n                            \"geni_urn\": \"urn:publicid:IDN+example.com+sliver+a1\",\n                            \"geni_error\": \"vlan 15 is unavailable\",\n                            \"geni_status\": \"failed\"\n                            }\n                         ],\n                  \"geni_expires\": \"2014-05-25T12:28:25.000Z\",\n                  \"geni_status\": \"failed\"\n                  }");
        AggregateManager2.SliverStatus sliverStatus = new AggregateManager2.SliverStatus((Object)ht);
        Mockito.when((Object)reply.getValue()).thenReturn((Object)sliverStatus);
        Mockito.when((Object)reply.getRawValue()).thenReturn((Object)ht);
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_SUCCESS);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.FALSE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType6b() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"");
        Map ht = (Map)JSonHelper.jsonStringToXmlRpcLikeObject((String)"{\n                  \"geni_urn\": \"urn:publicid:IDN+example.com+slice+a\",\n                  \"geni_resources\": [\n                         {\n                            \"geni_urn\": \"urn:publicid:IDN+example.com+sliver+a1\",\n                            \"geni_error\": \"vlan 300 is unavailable\",\n                            \"geni_status\": \"fail\"\n                            }\n                         ],\n                  \"geni_expires\": \"2014-05-25T12:28:25.000Z\",\n                  \"geni_status\": \"fail\"\n                  }");
        AggregateManager2.SliverStatus sliverStatus = new AggregateManager2.SliverStatus((Object)ht);
        Mockito.when((Object)reply.getValue()).thenReturn((Object)sliverStatus);
        Mockito.when((Object)reply.getRawValue()).thenReturn((Object)ht);
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_SUCCESS);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.FALSE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType7() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"");
        Map ht = (Map)JSonHelper.jsonStringToXmlRpcLikeObject((String)"{ \"geni_slivers\": [ { \n                        \"geni_client_id\": \"PC\", \n                        \"geni_sliver_urn\": \"urn:publicid:IDN+example.com+sliver+53233\", \n                        \"geni_allocation_status\": \"geni_provisioned\", \n                        \"geni_error\": \"vlan 15 is unavailable\", \n                        \"geni_expires\": \"2015-03-12T23:06:05Z\", \n                        \"geni_operational_status\": \"geni_failed\" \n                    } ], \n  \"geni_urn\": \"urn:publicid:IDN+wall2.ilabt.iminds.be:fed4fire+slice+sAq4194362\"\n}");
        AggregateManager3.StatusInfo sliverStatus = new AggregateManager3.StatusInfo((Object)ht);
        Mockito.when((Object)reply.getValue()).thenReturn((Object)sliverStatus);
        Mockito.when((Object)reply.getRawValue()).thenReturn((Object)ht);
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_SUCCESS);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.FALSE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType8() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"");
        Map ht = (Map)JSonHelper.jsonStringToXmlRpcLikeObject((String)"{ \"geni_slivers\": [ { \n                        \"geni_client_id\": \"PC\", \n                        \"geni_sliver_urn\": \"urn:publicid:IDN+example.com+sliver+53233\", \n                        \"geni_allocation_status\": \"geni_provisioned\", \n                        \"geni_error\": \"Bandwidth PCE(PCE_CREATE_FAILED): 'Unable to find path because the maximum bandwidth of link has been exceeded.'\", \n                        \"geni_expires\": \"2015-03-12T23:06:05Z\", \n                        \"geni_operational_status\": \"geni_failed\" \n                    } ], \n  \"geni_urn\": \"urn:publicid:IDN+wall2.ilabt.iminds.be:fed4fire+slice+sAq4194362\"\n}");
        AggregateManager3.StatusInfo sliverStatus = new AggregateManager3.StatusInfo((Object)ht);
        Mockito.when((Object)reply.getValue()).thenReturn((Object)sliverStatus);
        Mockito.when((Object)reply.getRawValue()).thenReturn((Object)ht);
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_SUCCESS);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType9() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"");
        Map ht = (Map)JSonHelper.jsonStringToXmlRpcLikeObject((String)"{\n              \"geni_urn\": \"urn:publicid:IDN+example.com+slice+1\",\n              \"geni_resources\": [\n                     {\n                        \"geni_urn\": \"urn:publicid:IDN+example.com+sliver+a1\",\n                        \"geni_error\": \"\",\n                        \"geni_status\": \"changing\"\n                        }\n                     ],\n              \"geni_expires\": \"2014-08-13T06:50:11.000Z\",\n              \"geni_status\": \"changing\"\n              }\n");
        AggregateManager2.SliverStatus sliverStatus = new AggregateManager2.SliverStatus((Object)ht);
        Mockito.when((Object)reply.getValue()).thenReturn((Object)sliverStatus);
        Mockito.when((Object)reply.getRawValue()).thenReturn((Object)ht);
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_SUCCESS);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.FALSE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType11() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"");
        Map ht = (Map)JSonHelper.jsonStringToXmlRpcLikeObject((String)"{\n              \"geni_urn\": \"urn:publicid:IDN+example.com+slice+a\",\n              \"geni_resources\": [\n                     {\n                        \"geni_urn\": \"urn:publicid:IDN+example.com+sliver+s\",\n                        \"geni_error\": \"VLAN PCE(PCE_CREATE_FAILED): 'There are no VLANs available on link example.com  on reservation example.net in VLAN PCE'\",\n                        \"geni_status\": \"failed\"\n                        }\n                     ],\n              \"geni_expires\": \"2015-03-16T17:29:18.000Z\",\n              \"geni_status\": \"failed\"\n              }");
        AggregateManager2.SliverStatus sliverStatus = new AggregateManager2.SliverStatus((Object)ht);
        Mockito.when((Object)reply.getValue()).thenReturn((Object)sliverStatus);
        Mockito.when((Object)reply.getRawValue()).thenReturn((Object)ht);
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_SUCCESS);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.FALSE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType10() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"Could not verify topo");
        Mockito.when((Object)reply.getValue()).thenReturn(null);
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReplyType12() throws Exception {
        AbstractGeniAggregateManager.AggregateManagerReply reply = (AbstractGeniAggregateManager.AggregateManagerReply)Mockito.mock(AbstractGeniAggregateManager.AggregateManagerReply.class);
        Mockito.when((Object)reply.getOutput()).thenReturn((Object)"Error encountered converting RSpec to NDL via converter service: ERROR converting from RSpec3 request to RDF-XML:java.lang.Exception: ERROR: unable to convert RSpec2 document: java.lang.Exception: ERROR: vlan range any is invalid");
        Mockito.when((Object)reply.getValue()).thenReturn(null);
        Mockito.when((Object)reply.getGeniResponseCode()).thenReturn((Object)GeniAMResponseCode.GENIRESPONSE_ERROR);
        MatcherAssert.assertThat((Object)StitchingDirector.isUnavailableVlan((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)StitchingDirector.isUnrecoverableError((SfaApiCallReply)reply), (Matcher)Matchers.is((Object)Boolean.FALSE));
        MatcherAssert.assertThat((Object)StitchingDirector.isAnyNotSupported((AbstractGeniAggregateManager.AggregateManagerReply)reply), (Matcher)Matchers.is((Object)true));
    }
}

