/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.stitching;

import be.iminds.ilabt.jfed.lowlevel.stitching.VlanRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VlanRangeTest {
    @Test
    public void testRange() {
        String a = "5012";
        String b = "1";
        String c = "13-987";
        VlanRange.Range rA = new VlanRange.Range(a);
        VlanRange.Range rb = new VlanRange.Range(b);
        VlanRange.Range rc = new VlanRange.Range(c);
        Assert.assertEquals((int)rA.from, (int)5012);
        Assert.assertEquals((int)rA.to, (int)5012);
        Assert.assertEquals((int)rb.from, (int)1);
        Assert.assertEquals((int)rb.to, (int)1);
        Assert.assertEquals((int)rc.from, (int)13);
        Assert.assertEquals((int)rc.to, (int)987);
        Assert.assertEquals((Object)rA, (Object)new VlanRange.Range(5012, 5012));
        Assert.assertEquals((Object)rA, (Object)new VlanRange.Range(5012));
        Assert.assertEquals((Object)rc, (Object)new VlanRange.Range(13, 987));
        Assert.assertEquals((Object)rc, (Object)new VlanRange.Range(rc));
        Assert.assertEquals((Object)rb, (Object)new VlanRange.Range(rb));
        Assert.assertEquals((Object)rA, (Object)new VlanRange.Range(rA));
    }

    @Test
    public void testRangeSplit() {
        String a = "10";
        String b = "5-6";
        String c = "20-30";
        VlanRange.Range rA = new VlanRange.Range(a);
        VlanRange.Range rB = new VlanRange.Range(b);
        VlanRange.Range rC = new VlanRange.Range(c);
        VlanRange.Range.Pair splitA = rA.split(10);
        VlanRange.Range.Pair splitB1 = rB.split(5);
        VlanRange.Range.Pair splitB2 = rB.split(6);
        VlanRange.Range.Pair splitC1 = rC.split(20);
        VlanRange.Range.Pair splitC2 = rC.split(21);
        VlanRange.Range.Pair splitC3 = rC.split(25);
        VlanRange.Range.Pair splitC4 = rC.split(29);
        VlanRange.Range.Pair splitC5 = rC.split(30);
        Assert.assertNull((Object)splitA.getFirst());
        Assert.assertNull((Object)splitA.getSecond());
        Assert.assertNull((Object)splitB1.getFirst());
        Assert.assertEquals((Object)splitB1.getSecond(), (Object)new VlanRange.Range(6, 6));
        Assert.assertEquals((Object)splitB2.getFirst(), (Object)new VlanRange.Range(5, 5));
        Assert.assertNull((Object)splitB2.getSecond());
        Assert.assertNull((Object)splitC1.getFirst());
        Assert.assertEquals((Object)splitC1.getSecond(), (Object)new VlanRange.Range(21, 30));
        Assert.assertEquals((Object)splitC2.getFirst(), (Object)new VlanRange.Range(20, 20));
        Assert.assertEquals((Object)splitC2.getSecond(), (Object)new VlanRange.Range(22, 30));
        Assert.assertEquals((Object)splitC3.getFirst(), (Object)new VlanRange.Range(20, 24));
        Assert.assertEquals((Object)splitC3.getSecond(), (Object)new VlanRange.Range(26, 30));
        Assert.assertEquals((Object)splitC4.getFirst(), (Object)new VlanRange.Range(20, 28));
        Assert.assertEquals((Object)splitC4.getSecond(), (Object)new VlanRange.Range(30, 30));
        Assert.assertEquals((Object)splitC5.getFirst(), (Object)new VlanRange.Range(20, 29));
        Assert.assertNull((Object)splitC5.getSecond());
    }

    @Test
    public void testVlanRangeHelperRemoveAllSimple() {
        String exa = "5,15-16,20-22";
        VlanRange ha = new VlanRange(exa);
        TreeSet<Integer> unavailableVlans = new TreeSet<Integer>();
        unavailableVlans.add(5);
        unavailableVlans.add(15);
        unavailableVlans.add(21);
        String targetA = "16,20,22";
        VlanRange targetHa = new VlanRange(targetA);
        ha.removeAll(unavailableVlans);
        Assert.assertEquals((Collection)targetHa, (Collection)ha, (String)"VlanRangeHelper must be equal");
    }

    @Test
    public void testVlanRangeHelperRetainAllSimple() {
        String exa = "5,15-16,20-22";
        VlanRange ha = new VlanRange(exa);
        MatcherAssert.assertThat((Object)ha, (Matcher)Matchers.hasSize((int)6));
        TreeSet<Integer> unavailableVlans = new TreeSet<Integer>();
        unavailableVlans.add(5);
        unavailableVlans.add(15);
        unavailableVlans.add(21);
        MatcherAssert.assertThat((Object)ha, (Matcher)Matchers.hasSize((int)6));
        HashSet availableVlans = new HashSet(ha);
        MatcherAssert.assertThat((Object)ha, (Matcher)Matchers.hasSize((int)6));
        availableVlans.removeAll(unavailableVlans);
        MatcherAssert.assertThat((Object)ha, (Matcher)Matchers.hasSize((int)6));
        String targetA = "16,20,22";
        VlanRange targetHa = new VlanRange(targetA);
        MatcherAssert.assertThat((Object)targetHa, (Matcher)Matchers.hasSize((int)3));
        ha.retainAll(availableVlans);
        MatcherAssert.assertThat((Object)targetHa, (Matcher)Matchers.equalTo((Object)ha));
    }

    @Test
    public void testCollectionConstructor() {
        String exa = "5,10,15-16,20-22,28-35,50,100-101";
        VlanRange a = new VlanRange(exa);
        VlanRange b = new VlanRange(new ArrayList(a));
        List<Integer> l = Arrays.asList(5, 10, 15, 16, 20, 21, 22, 28, 29, 30, 31, 32, 33, 34, 35, 50, 100, 101);
        VlanRange c = new VlanRange(l);
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.equalTo((Object)b));
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.equalTo((Object)c));
    }

    @Test
    public void testCollectionConstructor2() {
        String exa = "5,10,15-16,20-22,28-35,50,100-101";
        VlanRange a = new VlanRange(exa);
        VlanRange aa = new VlanRange(exa);
        VlanRange b = new VlanRange(a);
        List<Integer> l = Arrays.asList(5, 10, 15, 16, 20, 21, 22, 28, 29, 30, 31, 32, 33, 34, 35, 50, 100, 101);
        VlanRange c = new VlanRange(b);
        ArrayList l2 = new ArrayList(a);
        MatcherAssert.assertThat(l, (Matcher)Matchers.equalTo(l2));
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.equalTo((Object)aa));
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.equalTo((Object)b));
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.equalTo((Object)c));
    }

    @Test
    public void testCollectionConstructor3() {
        String exa = "197,300-303,305,750-755";
        VlanRange a = new VlanRange(exa);
        VlanRange aa = new VlanRange(exa);
        VlanRange b = new VlanRange(a);
        List<Integer> l = Arrays.asList(197, 300, 301, 302, 303, 305, 750, 751, 752, 753, 754, 755);
        VlanRange c = new VlanRange(b);
        ArrayList l2 = new ArrayList(a);
        MatcherAssert.assertThat(l, (Matcher)Matchers.equalTo(l2));
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.equalTo((Object)aa));
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.equalTo((Object)b));
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.equalTo((Object)c));
    }

    @Test
    public void testVlanRangeHelperSplitComplex() {
        String exa = "5,7,10,15-16,20-21,25-26,28-29,30-32,40-42,50-52,130-132,140-142,150-152,160-162,1000-2000";
        VlanRange ha = new VlanRange(exa);
        TreeSet<Integer> unavailableVlans = new TreeSet<Integer>();
        unavailableVlans.add(5);
        unavailableVlans.add(10);
        unavailableVlans.add(15);
        unavailableVlans.add(21);
        unavailableVlans.add(28);
        unavailableVlans.add(29);
        unavailableVlans.add(30);
        unavailableVlans.add(41);
        unavailableVlans.add(52);
        unavailableVlans.add(130);
        unavailableVlans.add(131);
        unavailableVlans.add(141);
        unavailableVlans.add(142);
        unavailableVlans.add(150);
        unavailableVlans.add(152);
        unavailableVlans.add(160);
        unavailableVlans.add(161);
        unavailableVlans.add(162);
        unavailableVlans.add(1000);
        unavailableVlans.add(1500);
        unavailableVlans.add(1600);
        unavailableVlans.add(1700);
        unavailableVlans.add(2000);
        String targetA = "7,16,20,25-26,31-32,40,42,50-51,132,140,151,1001-1499,1501-1599,1601-1699,1701-1999";
        VlanRange targetHa = new VlanRange(targetA);
        ha.removeAll(unavailableVlans);
        Assert.assertEquals((Collection)targetHa, (Collection)ha, (String)"VlanRangeHelper must be equal");
    }

    @Test
    public void testVlanRangeHelper() {
        String exa = "3726-3732,3747-3749";
        String exb = "3726-3732,3747";
        String exc = "670,3726-3750";
        String exd = "2-4094";
        String exe = "300";
        String exf = "580,722";
        String exg = "580,722,1024,18-30";
        VlanRange ha = new VlanRange(exa);
        VlanRange hb = new VlanRange(exb);
        VlanRange hc = new VlanRange(exc);
        VlanRange hd = new VlanRange(exd);
        VlanRange he = new VlanRange(exe);
        VlanRange hf = new VlanRange(exf);
        VlanRange hg = new VlanRange(exg);
        Assert.assertEquals((int)ha.getRanges().size(), (int)ha.getRanges().size());
        Assert.assertEquals((int)hb.getRanges().size(), (int)hb.getRanges().size());
        Assert.assertEquals((int)hc.getRanges().size(), (int)hc.getRanges().size());
        Assert.assertEquals((int)hd.getRanges().size(), (int)hd.getRanges().size());
        Assert.assertEquals((int)he.getRanges().size(), (int)he.getRanges().size());
        Assert.assertEquals((int)hf.getRanges().size(), (int)hf.getRanges().size());
        Assert.assertEquals((int)hg.getRanges().size(), (int)hg.getRanges().size());
        Assert.assertEquals((Collection)ha.getRanges(), (Collection)ha.getRanges());
        Assert.assertEquals((Collection)hb.getRanges(), (Collection)hb.getRanges());
        Assert.assertEquals((Collection)hc.getRanges(), (Collection)hc.getRanges());
        Assert.assertEquals((Collection)hd.getRanges(), (Collection)hd.getRanges());
        Assert.assertEquals((Collection)he.getRanges(), (Collection)he.getRanges());
        Assert.assertEquals((Collection)hf.getRanges(), (Collection)hf.getRanges());
        Assert.assertEquals((Collection)hg.getRanges(), (Collection)hg.getRanges());
        Assert.assertEquals((int)ha.getRanges().size(), (int)2);
        Assert.assertEquals((int)hb.getRanges().size(), (int)2);
        Assert.assertEquals((int)hc.getRanges().size(), (int)2);
        Assert.assertEquals((int)hd.getRanges().size(), (int)1);
        Assert.assertEquals((int)he.getRanges().size(), (int)1);
        Assert.assertEquals((int)hf.getRanges().size(), (int)2);
        Assert.assertEquals((int)hg.getRanges().size(), (int)4);
        ArrayList<VlanRange.Range> rangesa = new ArrayList<VlanRange.Range>();
        ArrayList<VlanRange.Range> rangesb = new ArrayList<VlanRange.Range>();
        ArrayList<VlanRange.Range> rangesc = new ArrayList<VlanRange.Range>();
        ArrayList<VlanRange.Range> rangesd = new ArrayList<VlanRange.Range>();
        ArrayList<VlanRange.Range> rangese = new ArrayList<VlanRange.Range>();
        ArrayList<VlanRange.Range> rangesf = new ArrayList<VlanRange.Range>();
        ArrayList<VlanRange.Range> rangesg = new ArrayList<VlanRange.Range>();
        rangesa.add(new VlanRange.Range(3726, 3732));
        rangesa.add(new VlanRange.Range(3747, 3749));
        rangesb.add(new VlanRange.Range(3726, 3732));
        rangesb.add(new VlanRange.Range(3747));
        rangesc.add(new VlanRange.Range(670));
        rangesc.add(new VlanRange.Range(3726, 3750));
        rangesd.add(new VlanRange.Range(2, 4094));
        rangese.add(new VlanRange.Range(300));
        rangesf.add(new VlanRange.Range(580));
        rangesf.add(new VlanRange.Range(722));
        rangesg.add(new VlanRange.Range(580));
        rangesg.add(new VlanRange.Range(722));
        rangesg.add(new VlanRange.Range(1024));
        rangesg.add(new VlanRange.Range(18, 30));
        Assert.assertEquals((Collection)ha.getRanges(), rangesa);
        Assert.assertEquals((Collection)hb.getRanges(), rangesb);
        Assert.assertEquals((Collection)hc.getRanges(), rangesc);
        Assert.assertEquals((Collection)hd.getRanges(), rangesd);
        Assert.assertEquals((Collection)he.getRanges(), rangese);
        Assert.assertEquals((Collection)hf.getRanges(), rangesf);
        Assert.assertEquals((Collection)hg.getRanges(), rangesg);
        VlanRange.Iterator itA = ha.iterator();
        Assert.assertTrue((boolean)itA.hasNext());
        Assert.assertEquals(itA.next(), (Object)3726);
        Assert.assertTrue((boolean)itA.hasNext());
        Assert.assertEquals(itA.next(), (Object)3727);
        Assert.assertTrue((boolean)itA.hasNext());
        Assert.assertEquals(itA.next(), (Object)3728);
        VlanRange.Iterator itC = hc.iterator();
        Assert.assertTrue((boolean)itC.hasNext());
        Assert.assertEquals(itC.next(), (Object)670);
        Assert.assertTrue((boolean)itC.hasNext());
        Assert.assertEquals(itC.next(), (Object)3726);
        Assert.assertTrue((boolean)itC.hasNext());
        Assert.assertEquals(itC.next(), (Object)3727);
        VlanRange.Iterator itF = hf.iterator();
        Assert.assertTrue((boolean)itF.hasNext());
        Assert.assertEquals(itF.next(), (Object)580);
        Assert.assertTrue((boolean)itF.hasNext());
        Assert.assertEquals(itF.next(), (Object)722);
        Assert.assertFalse((boolean)itF.hasNext());
        VlanRange.Iterator itG = hg.iterator();
        Assert.assertTrue((boolean)itG.hasNext());
        Assert.assertEquals(itG.next(), (Object)580);
        Assert.assertTrue((boolean)itG.hasNext());
        Assert.assertEquals(itG.next(), (Object)722);
        Assert.assertTrue((boolean)itG.hasNext());
        Assert.assertEquals(itG.next(), (Object)1024);
        Assert.assertTrue((boolean)itG.hasNext());
        Assert.assertEquals(itG.next(), (Object)18);
        Integer i = 19;
        while (i <= 30) {
            Assert.assertTrue((boolean)itG.hasNext());
            Assert.assertEquals(itG.next(), (Object)i);
            Integer n = i;
            i = i + 1;
        }
        Assert.assertFalse((boolean)itG.hasNext());
    }
}

