/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.basic_model;

import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BasicStringRspecTest {
    private static final String wall2Manifest = "<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:client=\"http://www.protogeni.net/resources/rspec/ext/client/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"manifest\" xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/manifest.xsd \" expires=\"2014-09-01T06:15:12Z\">\n     <node client_id=\"PC\" component_manager_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+authority+cm\" exclusive=\"true\" component_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+node+n091-25\" sliver_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+sliver+28109\">\n      <sliver_type name=\"raw-pc\"/>\n      <rs:vnode xmlns:rs=\"http://www.protogeni.net/resources/rspec/ext/emulab/1\" name=\"n091-25\"/><host name=\"PC.sTKe1409551752.ch-geni-net.wall2.ilabt.iminds.be\"/>      <services><login authentication=\"ssh-keys\" hostname=\"n091-25.wall2.ilabt.iminds.be\" port=\"22\" username=\"wimvande\"/></services>   </node>\n</rspec>";
    private static final String wall2ManifestWithProxy = "<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:client=\"http://www.protogeni.net/resources/rspec/ext/client/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"manifest\"         xmlns:sshproxy=\"http://jfed.iminds.be/proxy/1.0\"         xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/manifest.xsd \" expires=\"2014-09-01T06:15:12Z\">\n     <node client_id=\"PC\" component_manager_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+authority+cm\" exclusive=\"true\" component_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+node+n091-25\" sliver_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+sliver+28109\">\n      <sliver_type name=\"raw-pc\"/>\n      <rs:vnode xmlns:rs=\"http://www.protogeni.net/resources/rspec/ext/emulab/1\" name=\"n091-25\"/><host name=\"PC.sTKe1409551752.ch-geni-net.wall2.ilabt.iminds.be\"/>      <services>\n         <sshproxy:proxy proxy=\"wvdemeer@bastion.test.iminds.be:22\" for=\"wimvande@n091-25.wall2.ilabt.iminds.be:22\"/>\n         <login authentication=\"ssh-keys\" hostname=\"n091-25.wall2.ilabt.iminds.be\" port=\"22\" username=\"wimvande\"/>\n      </services>   </node>\n</rspec>";
    public static final String helloGeniRspec = "<!--\nCopyright (c) 2010-2015 Raytheon BBN Technologies\n\nPermission is hereby granted, free of charge, to any person obtaining\na copy of this software and/or hardware specification (the \"Work\") to\ndeal in the Work without restriction, including without limitation the\nrights to use, copy, modify, merge, publish, distribute, sublicense,\nand/or sell copies of the Work, and to permit persons to whom the Work\nis furnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be\nincluded in all copies or substantial portions of the Work.\n\nTHE WORK IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS\nOR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\nMERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\nNONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT\nHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,\nWHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE WORK OR THE USE OR OTHER DEALINGS\nIN THE WORK.\n-->\n\n<rspec xmlns=\"http://www.geni.net/resources/rspec/3\"  \n       xmlns:emulab=\"http://www.protogeni.net/resources/rspec/ext/emulab/1\" \n       xmlns:tour=\"http://www.protogeni.net/resources/rspec/ext/apt-tour/1\" \n       xmlns:jacks=\"http://www.protogeni.net/resources/rspec/ext/jacks/1\"\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n       xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3    http://www.geni.net/resources/rspec/3/request.xsd\" \n       type=\"request\">\n\n <node xmlns:rs=\"http://www.protogeni.net/resources/rspec/ext/emulab/1\" client_id=\"server\" exclusive=\"false\">\n    <sliver_type name=\"default-vm\"/>\n    <emulab:routable_control_ip xmlns:emulab=\"http://www.protogeni.net/resources/rspec/ext/emulab/1\"/>\n    <services>\n      <install install_path=\"/local\" url=\"http://www.gpolab.bbn.com/experiment-support/HelloGENI//hellogeni-install.tar.gz\"/>\n      <execute command=\"sudo /local/install-script.sh\" shell=\"sh\"/>\n    </services>\n    <interface client_id=\"server:if0\">\n       <ip xmlns=\"http://www.geni.net/resources/rspec/3\" address=\"10.10.10.1\" type=\"ipv4\" netmask=\"255.255.255.0\"/>\n     </interface>\n    <site xmlns=\"http://www.protogeni.net/resources/rspec/ext/jacks/1\" id=\"28\"/>\n  </node>\n  \n  <node xmlns:rs=\"http://www.protogeni.net/resources/rspec/ext/emulab/1\" client_id=\"client\" exclusive=\"false\">\n    <sliver_type name=\"default-vm\"/>\n    <services>  \n      <install install_path=\"/local\" url=\"http://www.gpolab.bbn.com/experiment-support/HelloGENI//hellogeni-install.tar.gz\"/>\n      <execute command=\"sudo /local/install-script.sh\" shell=\"sh\"/>\n    </services>\n    <interface client_id=\"client:if0\">\n      <ip xmlns=\"http://www.geni.net/resources/rspec/3\" address=\"10.10.10.2\" type=\"ipv4\" netmask=\"255.255.255.0\"/>\n    </interface>\n    <site xmlns=\"http://www.protogeni.net/resources/rspec/ext/jacks/1\" id=\"28\"/>\n  </node>\n\n  <link client_id=\"lan0\">\n    <interface_ref client_id=\"server:if0\"/>\n    <interface_ref client_id=\"client:if0\"/>\n    <property source_id=\"server:if0\" dest_id=\"client:if0\"/>\n    <property source_id=\"client:if0\" dest_id=\"server:if0\"/>\n    <link_type name=\"lan\"/>\n  </link>\n\n</rspec>\n";

    @Test
    public void testWall2Manifest() {
        BasicStringRspec basicStringRspec = new BasicStringRspec(wall2Manifest);
        List basicNodeInfos = basicStringRspec.getBasicNodeInfo();
        Assert.assertEquals((int)basicNodeInfos.size(), (int)1);
        BasicStringRspec.BasicNodeInfo node0 = (BasicStringRspec.BasicNodeInfo)basicNodeInfos.get(0);
        Assert.assertNotNull((Object)node0.getClientId());
        Assert.assertNotNull((Object)node0.getComponentId());
        Assert.assertEquals((String)node0.getClientId(), (String)"PC");
        Assert.assertEquals((String)node0.getComponentId(), (String)"urn:publicid:IDN+wall2.ilabt.iminds.be+node+n091-25");
        Assert.assertEquals((String)node0.getComponentManagerId(), (String)"urn:publicid:IDN+wall2.ilabt.iminds.be+authority+cm");
        Assert.assertEquals((String)node0.getUniqueId(), (String)"PC@urn:publicid:IDN+wall2.ilabt.iminds.be+authority+cm");
        List loginServiceList = basicStringRspec.findNodeLoginInfoByUniqueId(node0.getUniqueId());
        Assert.assertEquals((int)loginServiceList.size(), (int)1);
        BasicStringRspec.LoginService login = (BasicStringRspec.LoginService)loginServiceList.get(0);
        Assert.assertEquals((String)login.getAuthentication(), (String)"ssh-keys");
        Assert.assertEquals((String)login.getHostname(), (String)"n091-25.wall2.ilabt.iminds.be");
        Assert.assertEquals((int)login.getPort(), (int)22);
        Assert.assertEquals((String)login.getUsername(), (String)"wimvande");
        Assert.assertNull((Object)login.getSshProxy());
    }

    @Test
    public void testWall2ManifestWithProxy() {
        BasicStringRspec basicStringRspec = new BasicStringRspec(wall2ManifestWithProxy);
        List basicNodeInfos = basicStringRspec.getBasicNodeInfo();
        Assert.assertEquals((int)basicNodeInfos.size(), (int)1);
        BasicStringRspec.BasicNodeInfo node0 = (BasicStringRspec.BasicNodeInfo)basicNodeInfos.get(0);
        Assert.assertNotNull((Object)node0.getClientId());
        Assert.assertNotNull((Object)node0.getComponentId());
        Assert.assertEquals((String)node0.getClientId(), (String)"PC");
        Assert.assertEquals((String)node0.getComponentId(), (String)"urn:publicid:IDN+wall2.ilabt.iminds.be+node+n091-25");
        Assert.assertEquals((String)node0.getComponentManagerId(), (String)"urn:publicid:IDN+wall2.ilabt.iminds.be+authority+cm");
        Assert.assertEquals((String)node0.getUniqueId(), (String)"PC@urn:publicid:IDN+wall2.ilabt.iminds.be+authority+cm");
        List loginServiceList = basicStringRspec.findNodeLoginInfoByUniqueId(node0.getUniqueId());
        Assert.assertEquals((int)loginServiceList.size(), (int)1);
        BasicStringRspec.LoginService login = (BasicStringRspec.LoginService)loginServiceList.get(0);
        Assert.assertEquals((String)login.getAuthentication(), (String)"ssh-keys");
        Assert.assertEquals((String)login.getHostname(), (String)"n091-25.wall2.ilabt.iminds.be");
        Assert.assertEquals((int)login.getPort(), (int)22);
        Assert.assertEquals((String)login.getUsername(), (String)"wimvande");
        Assert.assertNotNull((Object)login.getSshProxy());
        Assert.assertEquals((String)login.getSshProxy().getUsername(), (String)"wvdemeer");
        Assert.assertEquals((String)login.getSshProxy().getHostname(), (String)"bastion.test.iminds.be");
        Assert.assertEquals((int)login.getSshProxy().getPort(), (int)22);
        Assert.assertNull((Object)login.getSshProxy().getHostKey());
        Assert.assertNull((Object)login.getSshProxy().getSshKeyInfo());
    }

    @Test
    public void testHelloGeni() {
        BasicStringRspec basicStringRspec = new BasicStringRspec(helloGeniRspec);
        List basicNodeInfos = basicStringRspec.getBasicNodeInfo();
        Assert.assertEquals((int)basicNodeInfos.size(), (int)2);
        BasicStringRspec.BasicNodeInfo node0 = (BasicStringRspec.BasicNodeInfo)basicNodeInfos.get(0);
        Assert.assertNotNull((Object)node0.getClientId());
        Assert.assertNull((Object)node0.getComponentId());
        Assert.assertNull((Object)node0.getComponentManagerId());
        Assert.assertEquals((int)basicStringRspec.getAllComponentManagerUrns().size(), (int)0);
    }
}

