/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ssh_terminal_tool.known_hosts;

import be.iminds.ilabt.jfed.ssh_terminal_tool.known_hosts.OpenSshKnownHostsFile;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class OpenSshKnownHostsFileTest {
    @Test
    public void testAddKnownHost() throws Exception {
        File tmpFile = File.createTempFile("test_known_hosts", ".tmp");
        tmpFile.deleteOnExit();
        OpenSshKnownHostsFile openSshKnownHostsFile = new OpenSshKnownHostsFile(tmpFile);
        openSshKnownHostsFile.addKnownHost("example.com", "example.com ssh-rsa AAAAB3test/Ua0=");
        openSshKnownHostsFile.addKnownHost("example.net", "example.net ssh-rsa AAAAB3test2FFF= comment");
        String knowHostContent = IOUtils.fileToString((File)tmpFile);
        MatcherAssert.assertThat((Object)knowHostContent, (Matcher)Matchers.containsString((String)"example.com ssh-rsa AAAAB3test/Ua0="));
        MatcherAssert.assertThat((Object)knowHostContent, (Matcher)Matchers.containsString((String)"example.net ssh-rsa AAAAB3test2FFF="));
    }

    @Test
    public void testAddKnownHost2() throws Exception {
        File tmpFile = File.createTempFile("test_known_hosts", ".tmp");
        tmpFile.deleteOnExit();
        OpenSshKnownHostsFile openSshKnownHostsFile = new OpenSshKnownHostsFile(tmpFile);
        openSshKnownHostsFile.addKnownHost("example.com", "AAAAB3test/Ua0=");
        openSshKnownHostsFile.addKnownHost("example.net", "AAAAB3test2FFF=");
        String knowHostContent = IOUtils.fileToString((File)tmpFile);
        MatcherAssert.assertThat((Object)knowHostContent, (Matcher)Matchers.containsString((String)"example.com ssh-rsa AAAAB3test/Ua0="));
        MatcherAssert.assertThat((Object)knowHostContent, (Matcher)Matchers.containsString((String)"example.net ssh-rsa AAAAB3test2FFF="));
    }

    @Test
    public void testAddKnownHost3() throws Exception {
        File tmpFile = File.createTempFile("test_known_hosts", ".tmp");
        tmpFile.deleteOnExit();
        OpenSshKnownHostsFile openSshKnownHostsFile = new OpenSshKnownHostsFile(tmpFile);
        openSshKnownHostsFile.addKnownHost("example.com", "\n      example.com ssh-rsa\n      AAAAB3test/Ua0=\n");
        openSshKnownHostsFile.addKnownHost("example.net", "\n   \n  example.net  \n  ssh-rsa\n   \nAAAAB3test2FFF=\ncomment\n\n\n");
        String knowHostContent = IOUtils.fileToString((File)tmpFile);
        MatcherAssert.assertThat((Object)knowHostContent, (Matcher)Matchers.containsString((String)"example.com ssh-rsa AAAAB3test/Ua0="));
        MatcherAssert.assertThat((Object)knowHostContent, (Matcher)Matchers.containsString((String)"example.net ssh-rsa AAAAB3test2FFF="));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "AAAAB3test/Ua0="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "AAAAB3test2FFF="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "AAAAB3test3FFF="), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "AAAAB3test5/Ua0="), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testKnowsHost() throws Exception {
        File tmpFile = File.createTempFile("test_known_hosts", ".tmp");
        tmpFile.deleteOnExit();
        OpenSshKnownHostsFile openSshKnownHostsFile = new OpenSshKnownHostsFile(tmpFile);
        openSshKnownHostsFile.addKnownHost("example.com", "example.com ssh-rsa AAAAB3test/Ua0=");
        openSshKnownHostsFile.addKnownHost("example.net", "example.net ssh-rsa AAAAB3test2FFF= comment");
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "example.com ssh-rsa AAAAB3test/Ua0="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "example.net ssh-rsa AAAAB3test2FFF= comment"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "example.org ssh-rsa AAAAB3test2FFF="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "example.org ssh-rsa AAAAB3test3FFF="), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "example.com ssh-rsa AAAAB3test5/Ua0="), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "AAAAB3test/Ua0="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "AAAAB3test2FFF="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "AAAAB3test3FFF="), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "AAAAB3test5/Ua0="), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testKnowsHost2() throws Exception {
        File tmpFile = File.createTempFile("test_known_hosts", ".tmp");
        tmpFile.deleteOnExit();
        OpenSshKnownHostsFile openSshKnownHostsFile = new OpenSshKnownHostsFile(tmpFile);
        openSshKnownHostsFile.addKnownHost("example.com", "AAAAB3test/Ua0=");
        openSshKnownHostsFile.addKnownHost("example.net", "AAAAB3test2FFF=");
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "example.com ssh-rsa AAAAB3test/Ua0="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "example.net ssh-rsa AAAAB3test2FFF= comment"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "example.org ssh-rsa AAAAB3test2FFF="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "example.org ssh-rsa AAAAB3test3FFF="), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "example.com ssh-rsa AAAAB3test5/Ua0="), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "AAAAB3test/Ua0="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "AAAAB3test2FFF="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "AAAAB3test3FFF="), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "AAAAB3test5/Ua0="), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testKnowsHost3() throws Exception {
        File tmpFile = File.createTempFile("test_known_hosts", ".tmp");
        tmpFile.deleteOnExit();
        String content = "example.com,127.0.0.1 ssh-rsa AAAAB3test/Ua0= testkey\n127.0.0.2,example.net ssh-rsa AAAAB3test2FFF=";
        IOUtils.stringToFile((File)tmpFile, (String)content);
        OpenSshKnownHostsFile openSshKnownHostsFile = new OpenSshKnownHostsFile(tmpFile);
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "example.com ssh-rsa AAAAB3test/Ua0="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("127.0.0.1", "example.com ssh-rsa AAAAB3test/Ua0="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "example.net ssh-rsa AAAAB3test2FFF= comment"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("127.0.0.2", "example.net ssh-rsa AAAAB3test2FFF= comment"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "example.org ssh-rsa AAAAB3test2FFF="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "example.org ssh-rsa AAAAB3test3FFF="), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "example.com ssh-rsa AAAAB3test5/Ua0="), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("127.0.0.1", "example.com ssh-rsa AAAAB3test5/Ua0="), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "AAAAB3test/Ua0="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("127.0.0.1", "AAAAB3test/Ua0="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "AAAAB3test2FFF="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("127.0.0.2", "AAAAB3test2FFF="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.net", "AAAAB3test3FFF="), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("example.com", "AAAAB3test5/Ua0="), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)openSshKnownHostsFile.knowsHost("127.0.0.1", "AAAAB3test5/Ua0="), (Matcher)Matchers.is((Object)false));
    }
}

