/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.lib;

import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.lib.JFedPasswordManager;
import be.iminds.ilabt.jfed.util.lib.SSHKeyHelper;
import be.iminds.ilabt.jfed.util.library.LoginInfo;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JFedPasswordManagerTest {
    private static final Logger LOG = LoggerFactory.getLogger(JFedPasswordManagerTest.class);

    @Test
    public void testGetLogins() {
        JFedPasswordManager m = new JFedPasswordManager();
        m.addLogin(new LoginInfo("s1", "s1user1", "s1pass1"));
        m.addLogin(new LoginInfo("s1", "s1user2", "s1pass2"));
        m.addLogin(new LoginInfo("s2", "s2user3", "s2pass3"));
        m.addLogin(new LoginInfo("s2", "s2user4", "s2pass4"));
        m.addLogin(new LoginInfo("s3", "s3user5", "s3pass5"));
        List s1logins = m.getLogins("s1");
        List s2logins = m.getLogins("s2");
        List s3logins = m.getLogins("s3");
        List alllogins = m.getLogins();
        MatcherAssert.assertThat((Object)s1logins, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)s2logins, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)s3logins, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)m.getLogins("X"), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)m.getLogins("1"), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)m.getLogins("s"), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)alllogins, (Matcher)Matchers.hasSize((int)5));
        LoginInfo l1 = new LoginInfo("s1", "s1user1", "s1pass1");
        LoginInfo l2 = new LoginInfo("s1", "s1user2", "s1pass2");
        LoginInfo l3 = new LoginInfo("s2", "s2user3", "s2pass3");
        LoginInfo l4 = new LoginInfo("s2", "s2user4", "s2pass4");
        LoginInfo l5 = new LoginInfo("s3", "s3user5", "s3pass5");
        MatcherAssert.assertThat((Object)s1logins, (Matcher)Matchers.contains((Object[])new LoginInfo[]{l1, l2}));
        MatcherAssert.assertThat((Object)s2logins, (Matcher)Matchers.contains((Object[])new LoginInfo[]{l3, l4}));
        MatcherAssert.assertThat((Object)s3logins, (Matcher)Matchers.contains((Object[])new LoginInfo[]{l5}));
        MatcherAssert.assertThat((Object)alllogins, (Matcher)Matchers.contains((Object[])new LoginInfo[]{l1, l2, l3, l4, l5}));
    }

    @Test
    public void testOverwriteLogins() {
        JFedPasswordManager m = new JFedPasswordManager();
        m.addLogin(new LoginInfo("s1", "s1user1", "s1pass1"));
        m.addLogin(new LoginInfo("s1", "s1user2", "s1pass2"));
        m.addLogin(new LoginInfo("s2", "s2user3", "s2pass3"));
        m.addLogin(new LoginInfo("s1", "s1user1", "pass4"));
        m.addLogin(new LoginInfo("s1", "s2user3", "pass5"));
        List s1logins = m.getLogins("s1");
        List s2logins = m.getLogins("s2");
        List s3logins = m.getLogins("s3");
        List alllogins = m.getLogins();
        MatcherAssert.assertThat((Object)s1logins, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)s2logins, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)s3logins, (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)alllogins, (Matcher)Matchers.hasSize((int)4));
        LoginInfo l1 = new LoginInfo("s1", "s1user1", "s1pass1");
        LoginInfo l2 = new LoginInfo("s1", "s1user2", "s1pass2");
        LoginInfo l3 = new LoginInfo("s2", "s2user3", "s2pass3");
        LoginInfo l4 = new LoginInfo("s1", "s1user1", "pass4");
        LoginInfo l5 = new LoginInfo("s1", "s2user3", "pass5");
        MatcherAssert.assertThat((Object)s1logins, (Matcher)Matchers.contains((Object[])new LoginInfo[]{l2, l4, l5}));
        MatcherAssert.assertThat((Object)s2logins, (Matcher)Matchers.contains((Object[])new LoginInfo[]{l3}));
        MatcherAssert.assertThat((Object)alllogins, (Matcher)Matchers.contains((Object[])new LoginInfo[]{l2, l3, l4, l5}));
    }

    @Test
    public void testSaveLoadLogins() throws NoSuchAlgorithmException, IOException {
        JFedPasswordManager mo = new JFedPasswordManager();
        mo.addLogin(new LoginInfo("s1", "s1user1", "s1pass1"));
        mo.addLogin(new LoginInfo("s1", "s1user2", "s1pass2"));
        mo.addLogin(new LoginInfo("s2", "s2user3", "s2pass3"));
        mo.addLogin(new LoginInfo("s2", "s2user4", "s2pass4"));
        mo.addLogin(new LoginInfo("s3", "s3user5", "s3pass5"));
        SSHKeyHelper sshKeyHelper = new SSHKeyHelper();
        int r = new Random().nextInt();
        GeniUrn fakeUserUrn = GeniUrn.createGeniUrnFromDecodedParts((String)"example.com", (String)"user", (String)("fakeForTest" + r));
        GeniUser fakeUser = (GeniUser)Mockito.mock(GeniUser.class);
        Mockito.when((Object)fakeUser.getPrivateKey()).thenReturn((Object)sshKeyHelper.getSshPrivateKey());
        Mockito.when((Object)fakeUser.getPublicKey()).thenReturn((Object)sshKeyHelper.getSshPublicKey());
        Mockito.when((Object)fakeUser.getUserUrnString()).thenReturn((Object)String.valueOf(fakeUserUrn));
        Mockito.when((Object)fakeUser.getUserUrn()).thenReturn((Object)fakeUserUrn);
        JFedPreferences prefs = (JFedPreferences)Mockito.mock(JFedPreferences.class);
        mo.save(prefs, fakeUser);
        File saveFile = mo.getEncryptedSaveFile(prefs, fakeUser);
        Assert.assertTrue((boolean)saveFile.exists());
        JFedPasswordManager m = new JFedPasswordManager();
        m.load(prefs, fakeUser);
        LOG.trace("Loaded " + m.getLogins().size() + " logins from file.");
        saveFile.delete();
        List s1logins = m.getLogins("s1");
        List s2logins = m.getLogins("s2");
        List s3logins = m.getLogins("s3");
        List alllogins = m.getLogins();
        MatcherAssert.assertThat((Object)s1logins, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)s2logins, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)s3logins, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)m.getLogins("X"), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)m.getLogins("1"), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)m.getLogins("s"), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)alllogins, (Matcher)Matchers.hasSize((int)5));
        LoginInfo l1 = new LoginInfo("s1", "s1user1", "s1pass1");
        LoginInfo l2 = new LoginInfo("s1", "s1user2", "s1pass2");
        LoginInfo l3 = new LoginInfo("s2", "s2user3", "s2pass3");
        LoginInfo l4 = new LoginInfo("s2", "s2user4", "s2pass4");
        LoginInfo l5 = new LoginInfo("s3", "s3user5", "s3pass5");
        MatcherAssert.assertThat((Object)s1logins, (Matcher)Matchers.contains((Object[])new LoginInfo[]{l1, l2}));
        MatcherAssert.assertThat((Object)s2logins, (Matcher)Matchers.contains((Object[])new LoginInfo[]{l3, l4}));
        MatcherAssert.assertThat((Object)s3logins, (Matcher)Matchers.contains((Object[])new LoginInfo[]{l5}));
        MatcherAssert.assertThat((Object)alllogins, (Matcher)Matchers.contains((Object[])new LoginInfo[]{l1, l2, l3, l4, l5}));
    }
}

