/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.adv_based_generator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AdvertisementBasedRspecGeneratorConfig {
    @Nonnull
    public final List<NodeInfo> nodes;

    @JsonCreator
    public AdvertisementBasedRspecGeneratorConfig(@Nonnull @JsonProperty(value="nodes") List<NodeInfo> nodes) {
        this.nodes = nodes;
    }

    @Nonnull
    public List<NodeInfo> getNodes() {
        return this.nodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdvertisementBasedRspecGeneratorConfig)) {
            return false;
        }
        AdvertisementBasedRspecGeneratorConfig that = (AdvertisementBasedRspecGeneratorConfig)o;
        return this.nodes.equals(that.nodes);
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }

    public String toString() {
        return "AdvertisementBasedRspecGeneratorConfig{nodes=" + String.valueOf(this.nodes) + "}";
    }

    public static class NodeInfo {
        private final int count;
        @Nullable
        private final Integer serverId;
        @Nonnull
        private final String clientIdBase;
        @Nullable
        private final String ansibleGroup;
        @Nullable
        private final Boolean linkGroupNodes;
        @Nullable
        private final Boolean linkAllNodes;
        @Nullable
        private final String diskImage;
        @Nullable
        private final List<String> componentIdSelector;
        @Nullable
        private final List<String> componentIdFilter;
        @Nullable
        private final Boolean componentNameDenyThenAllow;
        @Nullable
        private final List<String> componentNameAllowRegex;
        @Nullable
        private final List<String> componentNameDenyRegex;
        @Nullable
        private final String sliverType;
        @Nullable
        private final List<String> hardwareTypeFilter;
        @Nullable
        private final Boolean availableFilter;
        @Nullable
        private final Boolean exclusive;

        public NodeInfo(int count, @Nullable Integer serverId, @Nullable String clientIdBase, @Nullable String ansibleGroup, @Nullable Boolean linkGroupNodes, @Nullable Boolean linkAllNodes, @Nullable String diskImage, @Nullable List<String> componentIdSelector, @Nullable List<String> componentIdFilter, @Nullable Boolean componentNameDenyThenAllow, @Nullable List<String> componentNameAllowRegex, @Nullable List<String> componentNameDenyRegex, @Nullable String sliverType, @Nullable List<String> hardwareTypeFilter, @Nullable Boolean availableFilter, @Nullable Boolean exclusive) {
            this.serverId = serverId;
            this.count = count;
            this.clientIdBase = clientIdBase == null ? "node" : clientIdBase;
            this.ansibleGroup = ansibleGroup;
            this.linkGroupNodes = linkGroupNodes;
            this.linkAllNodes = linkAllNodes;
            this.diskImage = diskImage;
            this.componentIdSelector = componentIdSelector;
            this.componentIdFilter = componentIdFilter;
            this.hardwareTypeFilter = hardwareTypeFilter;
            this.availableFilter = availableFilter;
            this.sliverType = sliverType;
            this.exclusive = exclusive;
            this.componentNameDenyThenAllow = componentNameDenyThenAllow;
            this.componentNameAllowRegex = componentNameAllowRegex;
            this.componentNameDenyRegex = componentNameDenyRegex;
        }

        @JsonCreator
        public static NodeInfo createNodeInfoFromJsonObject(@Nonnull Map<String, Object> props) {
            int count = (Integer)props.get("count");
            Integer serverId = props.containsKey("serverId") ? Integer.valueOf((Integer)props.get("serverId")) : null;
            ArrayList<String> componentIdSelector = null;
            Object componentIdSelectorObj = props.get("componentIdSelector");
            if (componentIdSelectorObj != null) {
                if (componentIdSelectorObj instanceof Collection) {
                    componentIdSelector = new ArrayList((Collection)componentIdSelectorObj);
                }
                if (componentIdSelectorObj instanceof String) {
                    componentIdSelector = Collections.singletonList((String)componentIdSelectorObj);
                }
                assert (componentIdSelector != null);
            }
            ArrayList<String> componentIdFilter = null;
            Object componentIdFilterObj = props.get("componentIdFilter");
            if (componentIdFilterObj != null) {
                if (componentIdFilterObj instanceof Collection) {
                    componentIdFilter = new ArrayList((Collection)componentIdFilterObj);
                }
                if (componentIdFilterObj instanceof String) {
                    componentIdFilter = Collections.singletonList((String)componentIdFilterObj);
                }
                assert (componentIdFilter != null);
            }
            ArrayList<String> componentNameDenyRegex = null;
            Object componentNameDenyRegexObj = props.get("componentNameDenyRegex");
            if (componentNameDenyRegexObj != null) {
                if (componentNameDenyRegexObj instanceof Collection) {
                    componentNameDenyRegex = new ArrayList((Collection)componentNameDenyRegexObj);
                }
                if (componentNameDenyRegexObj instanceof String) {
                    componentNameDenyRegex = Collections.singletonList((String)componentNameDenyRegexObj);
                }
                assert (componentNameDenyRegex != null);
            }
            ArrayList<String> componentNameAllowRegex = null;
            Object componentNameAllowRegexObj = props.get("componentNameAllowRegex");
            if (componentNameAllowRegexObj != null) {
                if (componentNameAllowRegexObj instanceof Collection) {
                    componentNameAllowRegex = new ArrayList((Collection)componentNameAllowRegexObj);
                }
                if (componentNameAllowRegexObj instanceof String) {
                    componentNameAllowRegex = Collections.singletonList((String)componentNameAllowRegexObj);
                }
                assert (componentNameAllowRegex != null);
            }
            ArrayList<String> hardwareTypeFilter = null;
            Object hardwareTypeFilterObj = props.get("hardwareTypeFilter");
            if (hardwareTypeFilterObj != null) {
                if (hardwareTypeFilterObj instanceof Collection) {
                    hardwareTypeFilter = new ArrayList((Collection)hardwareTypeFilterObj);
                }
                if (hardwareTypeFilterObj instanceof String) {
                    hardwareTypeFilter = Collections.singletonList((String)hardwareTypeFilterObj);
                }
                assert (hardwareTypeFilter != null);
            }
            return new NodeInfo(count, serverId, (String)props.get("clientIdBase"), (String)props.get("ansibleGroup"), (Boolean)props.get("linkGroupNodes"), (Boolean)props.get("linkAllNodes"), (String)props.get("diskImage"), componentIdSelector, componentIdFilter, (Boolean)props.get("componentNameDenyThenAllow"), componentNameAllowRegex, componentNameDenyRegex, (String)props.get("sliverType"), hardwareTypeFilter, (Boolean)props.get("availableFilter"), (Boolean)props.get("exclusive"));
        }

        @Nullable
        public Integer getServerId() {
            return this.serverId;
        }

        public int getCount() {
            return this.count;
        }

        @Nonnull
        public String getClientIdBase() {
            return this.clientIdBase;
        }

        @Nullable
        public String getAnsibleGroup() {
            return this.ansibleGroup;
        }

        @Nullable
        public Boolean getLinkGroupNodes() {
            return this.linkGroupNodes;
        }

        public boolean getLinkGroupNodesOrDefault() {
            return this.linkGroupNodes == null ? false : this.linkGroupNodes;
        }

        @Nullable
        public Boolean getLinkAllNodes() {
            return this.linkAllNodes;
        }

        public boolean getLinkAllNodesOrDefault() {
            return this.linkAllNodes == null ? false : this.linkAllNodes;
        }

        @Nullable
        public String getDiskImage() {
            return this.diskImage;
        }

        @Nullable
        public List<String> getComponentIdSelector() {
            return this.componentIdSelector;
        }

        @Nullable
        public List<String> getComponentIdFilter() {
            return this.componentIdFilter;
        }

        @Nullable
        public Boolean getComponentNameDenyThenAllow() {
            return this.componentNameDenyThenAllow;
        }

        public boolean getComponentNameDenyThenAllowOrDefault() {
            return this.componentNameDenyThenAllow == null ? true : this.componentNameDenyThenAllow;
        }

        @Nullable
        public List<String> getComponentNameAllowRegex() {
            return this.componentNameAllowRegex;
        }

        @Nullable
        public List<String> getComponentNameDenyRegex() {
            return this.componentNameDenyRegex;
        }

        @Nullable
        public String getSliverType() {
            return this.sliverType;
        }

        @Nullable
        public List<String> getHardwareTypeFilter() {
            return this.hardwareTypeFilter;
        }

        @Nullable
        public Boolean getAvailableFilter() {
            return this.availableFilter;
        }

        @Nullable
        public Boolean getExclusive() {
            return this.exclusive;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NodeInfo)) {
                return false;
            }
            NodeInfo nodeInfo = (NodeInfo)o;
            return this.count == nodeInfo.count && Objects.equals(this.clientIdBase, nodeInfo.clientIdBase) && Objects.equals(this.ansibleGroup, nodeInfo.ansibleGroup) && Objects.equals(this.linkGroupNodes, nodeInfo.linkGroupNodes) && Objects.equals(this.linkAllNodes, nodeInfo.linkAllNodes) && Objects.equals(this.diskImage, nodeInfo.diskImage) && Objects.equals(this.componentIdSelector, nodeInfo.componentIdSelector) && Objects.equals(this.componentIdFilter, nodeInfo.componentIdFilter) && Objects.equals(this.componentNameDenyThenAllow, nodeInfo.componentNameDenyThenAllow) && Objects.equals(this.componentNameAllowRegex, nodeInfo.componentNameAllowRegex) && Objects.equals(this.componentNameDenyRegex, nodeInfo.componentNameDenyRegex) && Objects.equals(this.sliverType, nodeInfo.sliverType) && Objects.equals(this.hardwareTypeFilter, nodeInfo.hardwareTypeFilter) && Objects.equals(this.availableFilter, nodeInfo.availableFilter) && Objects.equals(this.exclusive, nodeInfo.exclusive);
        }

        public int hashCode() {
            return Objects.hash(this.count, this.clientIdBase, this.linkGroupNodes, this.linkAllNodes, this.ansibleGroup, this.diskImage, this.componentIdSelector, this.componentIdFilter, this.componentNameDenyThenAllow, this.componentNameAllowRegex, this.componentNameDenyRegex, this.sliverType, this.hardwareTypeFilter, this.availableFilter, this.exclusive);
        }

        public String toString() {
            return "NodeInfo{count=" + this.count + ", serverId=" + this.serverId + ", clientIdBase='" + this.clientIdBase + "', ansibleGroup='" + this.ansibleGroup + "', linkAllNodes='" + this.linkAllNodes + "', linkGroupNodes='" + this.linkGroupNodes + "', diskImage='" + this.diskImage + "', componentIdSelector=" + String.valueOf(this.componentIdSelector) + ", componentIdFilter=" + String.valueOf(this.componentIdFilter) + ", componentNameDenyThenAllow=" + this.componentNameDenyThenAllow + ", componentNameAllowRegex=" + String.valueOf(this.componentNameAllowRegex) + ", componentNameDenyRegex=" + String.valueOf(this.componentNameDenyRegex) + ", sliverType='" + this.sliverType + "', hardwareTypeFilter=" + String.valueOf(this.hardwareTypeFilter) + ", availableFilter=" + this.availableFilter + ", exclusive=" + this.exclusive + "}";
        }
    }
}

