/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model;

import java.util.Objects;

public class HardwareType {
    private final String name;
    private final Integer typeSlotsInt;
    private final String typeSlotsString;

    public HardwareType(String name, Integer typeSlotsInt, String typeSlotsString) {
        this.name = name;
        this.typeSlotsInt = typeSlotsInt;
        this.typeSlotsString = typeSlotsString;
        if (typeSlotsString == null) assert (typeSlotsInt == null);
    }

    public HardwareType(String name) {
        this(name, null, null);
    }

    public String getName() {
        return this.name;
    }

    public Integer getTypeSlotsInt() {
        return this.typeSlotsInt;
    }

    public String getTypeSlotsString() {
        return this.typeSlotsString;
    }

    public boolean hasTypeSlots() {
        return this.typeSlotsString != null;
    }

    public boolean hasNumericTypeSlots() {
        return this.typeSlotsInt != null;
    }

    public boolean hasUnlimitedTypeSlots() {
        return this.typeSlotsString.trim().equalsIgnoreCase("unlimited");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HardwareType that = (HardwareType)o;
        if (this.name != null ? !Objects.equals(this.name, that.name) : that.name != null) {
            return false;
        }
        if (this.typeSlotsInt != null ? !Objects.equals(this.typeSlotsInt, that.typeSlotsInt) : that.typeSlotsInt != null) {
            return false;
        }
        return this.typeSlotsString != null ? Objects.equals(this.typeSlotsString, that.typeSlotsString) : that.typeSlotsString == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.typeSlotsInt != null ? this.typeSlotsInt.hashCode() : 0);
        result = 31 * result + (this.typeSlotsString != null ? this.typeSlotsString.hashCode() : 0);
        return result;
    }
}

