/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HardwareTypeInfo {
    @Nonnull
    public final List<Entry> overview;
    @Nonnull
    public final List<HardwareTypeInfoEntry> hardwareTypeInfoEntries;

    public HardwareTypeInfo(@Nullable List<Entry> overview, @Nullable List<HardwareTypeInfoEntry> hardwareTypeInfoEntries) {
        this.overview = overview == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Entry>(overview));
        this.hardwareTypeInfoEntries = hardwareTypeInfoEntries == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<HardwareTypeInfoEntry>(hardwareTypeInfoEntries));
    }

    @Nullable
    public String getTextOverview() {
        return this.overview.stream().filter(e -> Objects.equals(e.getMediaType(), "text/plain")).map(Entry::getDirectValue).findFirst().orElse(null);
    }

    @Nullable
    public String getHtmlOverview() {
        return this.overview.stream().filter(e -> Objects.equals(e.getMediaType(), "text/html")).map(Entry::getHref).findFirst().orElse(null);
    }

    @Nonnull
    public List<Entry> getOverviews() {
        return this.overview;
    }

    @Nonnull
    public List<HardwareTypeInfoEntry> getHardwareTypeInfoEntries() {
        return this.hardwareTypeInfoEntries;
    }

    @Nullable
    public HardwareTypeInfoEntry getHardwareTypeInfoByName(@Nonnull String name) {
        return this.hardwareTypeInfoEntries.stream().filter(e -> Objects.equals(e.getName(), name)).findFirst().orElse(null);
    }

    public static class HardwareTypeInfoEntry {
        @Nullable
        public final String name;
        @Nullable
        public final String hrn;
        @Nonnull
        public final List<Entry> infos;

        public HardwareTypeInfoEntry(@Nullable String name, @Nullable String hrn, @Nullable List<Entry> infos) {
            this.name = name;
            this.hrn = hrn;
            this.infos = infos == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Entry>(infos));
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getHrn() {
            return this.hrn;
        }

        @Nullable
        public String getTextDescription() {
            return this.infos.stream().filter(e -> Objects.equals(e.getMediaType(), "text/plain")).map(Entry::getDirectValue).findFirst().orElse(null);
        }

        @Nullable
        public String getHtmlDescription() {
            return this.infos.stream().filter(e -> Objects.equals(e.getMediaType(), "text/html")).map(Entry::getHref).findFirst().orElse(null);
        }

        @Nonnull
        public List<Entry> getInfos() {
            return this.infos;
        }
    }

    public static class Entry {
        @Nullable
        public final String mediaType;
        @Nullable
        public final String href;
        @Nullable
        public final String directValue;

        public Entry(@Nullable String mediaType, @Nullable String href, @Nullable String directValue) {
            this.mediaType = mediaType;
            this.href = href;
            this.directValue = directValue;
        }

        @Nullable
        public String getMediaType() {
            return this.mediaType;
        }

        @Nullable
        public String getHref() {
            return this.href;
        }

        @Nullable
        public String getDirectValue() {
            return this.directValue;
        }
    }
}

