/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.DiskImageList;
import be.iminds.ilabt.jfed.rspec.model.DistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.ExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.FlavorList;
import be.iminds.ilabt.jfed.rspec.model.HardwareTypeInfo;
import be.iminds.ilabt.jfed.rspec.model.Lease;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.OpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.model.OpenflowSliver;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ModelRspec {
    @Nonnull
    public ModelRspecType getModelRspecType();

    public void setParseData(@Nullable String var1, @Nullable String var2, @Nonnull Map<String, String> var3);

    @Nullable
    public String getSchemaLocation();

    @Nullable
    public String getOrigDefaultNamespace();

    @Nonnull
    public Map<String, String> getNameSpaceInfo();

    @Nonnull
    public List<GeniUrn> getAllComponentManagerUrns();

    public void addNode(@Nonnull RspecNode var1);

    public void deleteNode(@Nonnull RspecNode var1);

    @Nonnull
    public List<? extends RspecNode> getNodes();

    @Nonnull
    public List<? extends RspecNode> getNodesByAuthority(@Nonnull Server var1);

    @Nullable
    public RspecNode getNodeByUniqueId(@Nonnull String var1);

    @Nullable
    public RspecNode getNodeByClientId(@Nonnull String var1);

    @Nullable
    public RspecNode getNodeByComponentId(@Nonnull String var1);

    public void addLink(@Nonnull RspecLink var1);

    public void deleteLink(@Nonnull RspecLink var1);

    @Nonnull
    public List<? extends RspecLink> getLinks();

    @Nullable
    public RspecLink getLinkByClientId(@Nonnull String var1);

    @Nullable
    public RspecLink getLinkByUniqueId(@Nonnull String var1);

    @Nullable
    public RspecInterface getInterfaceByUniqueId(@Nonnull String var1);

    @Nullable
    public RspecInterface getInterfaceByClientId(@Nonnull String var1);

    public void addOpenflowDataPath(@Nonnull OpenflowDataPath var1);

    @Nonnull
    public List<? extends OpenflowDataPath> getOpenflowDataPaths();

    public void addOpenflowSliver(@Nonnull OpenflowSliver var1);

    @Nonnull
    public List<? extends OpenflowSliver> getOpenflowSlivers();

    public void addLease(@Nonnull Lease var1);

    @Nonnull
    public List<? extends Lease> getLeases();

    public void addChannel(@Nonnull Channel var1);

    public boolean deleteChannel(@Nonnull Channel var1);

    @Nonnull
    public List<? extends Channel> getChannels();

    @Nullable
    public Channel getChannelByComponentId(@Nonnull GeniUrn var1);

    public void addAddressPool(@Nonnull AddressPool var1);

    public boolean deleteAddressPool(@Nonnull AddressPool var1);

    @Nonnull
    public List<? extends AddressPool> getAddressPools();

    public AddressPool getAddressPoolByClientId(@Nonnull String var1);

    public void addExecuteAnsiblePlaybook(@Nonnull ExecuteAnsiblePlaybook var1);

    public boolean deleteExecuteAnsiblePlaybook(@Nonnull ExecuteAnsiblePlaybook var1);

    @Nonnull
    public List<? extends ExecuteAnsiblePlaybook> getExecuteAnsiblePlaybooks();

    public void addDistributeSshKeypair(@Nonnull DistributeSshKeypair var1);

    public boolean deleteDistributeSshKeypair(@Nonnull DistributeSshKeypair var1);

    @Nonnull
    public List<? extends DistributeSshKeypair> getDistributeSshKeypairs();

    @Nullable
    public HardwareTypeInfo getHardwareTypeInfo();

    public void setHardwareTypeInfo(@Nullable HardwareTypeInfo var1);

    @Nonnull
    public List<UserSpec> getSshKeys();

    public void setSshKeys(@Nonnull List<UserSpec> var1);

    @Nonnull
    public String nextLinkName();

    @Nonnull
    public String nextNodeName();

    @Nullable
    public String getType();

    @Nonnull
    public String nextIfaceName(@Nonnull RspecNode var1);

    @Nonnull
    public List<ExtraXml> getExtraXml();

    public void setExtraXml(@Nonnull List<ExtraXml> var1);

    @Nonnull
    public String toGeni3Rspec(@Nonnull RequestRspecSpecialCases var1);

    @Nonnull
    public String toGeni3Rspec();

    @Nullable
    public Date getExpires() throws ParseException;

    public void setExpires(@Nullable Date var1);

    @Nullable
    public String getExpiresString();

    public void setExpires(@Nullable String var1);

    @Nullable
    public Integer getRoutableAddressesAvailable();

    @Nullable
    public Integer getRoutableAddressesConfigured();

    public void setRoutableAddressesAvailable(@Nullable Integer var1);

    public void setRoutableAddressesConfigured(@Nullable Integer var1);

    @Nullable
    public Integer getMultiplexFactor();

    public void setMultiplexFactor(@Nullable Integer var1);

    @Nonnull
    public List<DiskImageList> getDiskImageLists();

    @Nonnull
    public List<FlavorList> getFlavorLists();

    public void addDiskImageList(@Nonnull DiskImageList var1);

    public void addFlavorList(@Nonnull FlavorList var1);

    @Nullable
    default public DiskImageList getDiskImageList(@Nonnull String id) {
        for (DiskImageList list : this.getDiskImageLists()) {
            if (!list.getId().equals(id)) continue;
            return list;
        }
        return null;
    }

    @Nullable
    default public FlavorList getFlavorList(@Nonnull String id) {
        for (FlavorList list : this.getFlavorLists()) {
            if (!list.getId().equals(id)) continue;
            return list;
        }
        return null;
    }

    @Nonnull
    public ModelRspec copy();

    public static enum RequestRspecSpecialCases {
        NONE,
        PLE,
        NITOS,
        NITOS_NO_E_NODE_B_HACK;

    }
}

