/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.imutable_impl;

import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.IPv4;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableIPv4;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ImmutableAddressPool
implements AddressPool {
    private final String clientId;
    private final GeniUrn componentManagerId;
    private final Integer count;
    private final String type;
    private final List<ImmutableIPv4> iPv4s;
    private final double editorX;
    private final double editorY;

    private static <OT, NT> List<NT> listInit(List<OT> orig, Function<OT, NT> convert) {
        if (orig == null) {
            return null;
        }
        return Collections.unmodifiableList(orig.stream().map(convert).collect(Collectors.toList()));
    }

    public ImmutableAddressPool(AddressPool orig) {
        this.clientId = orig.getClientId();
        this.componentManagerId = orig.getComponentManagerId();
        this.count = orig.getCount();
        this.type = orig.getType();
        this.iPv4s = ImmutableAddressPool.listInit(orig.getIPv4s(), ImmutableIPv4::new);
        this.editorX = orig.getEditorX();
        this.editorY = orig.getEditorY();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String clientId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GeniUrn getComponentManagerId() {
        return this.componentManagerId;
    }

    @Override
    public void setComponentManagerId(GeniUrn componentManagerId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public void setCount(Integer count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addIPv4(IPv4 iPv4) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deleteIPv4(IPv4 iPv4) {
        throw new UnsupportedOperationException();
    }

    public List<ImmutableIPv4> getIPv4s() {
        return this.iPv4s;
    }

    @Override
    public double getEditorX() {
        return this.editorX;
    }

    @Override
    public double getEditorY() {
        return this.editorY;
    }

    @Override
    public void setEditorX(double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEditorY(double y) {
        throw new UnsupportedOperationException();
    }
}

