/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.imutable_impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.DiskImageList;
import be.iminds.ilabt.jfed.rspec.model.DistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.ExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.FlavorList;
import be.iminds.ilabt.jfed.rspec.model.HardwareTypeInfo;
import be.iminds.ilabt.jfed.rspec.model.Lease;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.OpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.model.OpenflowSliver;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableAddressPool;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableChannel;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableDistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableLease;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableOpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecFactory;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecInterface;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecLink;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecNode;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.StaxRspecWriter;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableModelRspec
implements ModelRspec {
    private static final Logger LOG = LoggerFactory.getLogger(ImmutableModelRspec.class);
    private final List<ExtraXml> extraXml;
    private final Map<String, String> origNameSpaceInfo;
    private final List<ImmutableRspecNode> nodes;
    private final List<ImmutableRspecLink> links;
    private final List<ImmutableLease> leases;
    private final List<ImmutableChannel> channels;
    private final List<ImmutableOpenflowDataPath> openflowDataPaths;
    private final List<OpenflowSliver> openflowSlivers;
    private final List<ImmutableAddressPool> addressPools;
    private final List<ImmutableExecuteAnsiblePlaybook> executeAnsiblePlaybooks;
    private final List<ImmutableDistributeSshKeypair> distributeSshKeypairs;
    private final String origDefaultNamespace;
    private final String origSchemaLocation;
    private final String rspecType;
    private final List<UserSpec> sshKeys;
    private final List<DiskImageList> diskImageLists;
    private final List<FlavorList> flavorLists;
    private final String expiresString;
    private final HardwareTypeInfo hardwareTypeInfo;
    private final Integer routableAddressesAvailable;
    private final Integer routableAddressesConfigured;
    private final Integer multiplexFactor;
    private final RspecFactory factory;

    private static <T> List<T> listInit(List<T> orig) {
        if (orig == null) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList<T>(orig));
    }

    private static <OT, NT> List<NT> listInit(List<OT> orig, Function<OT, NT> convert) {
        if (orig == null) {
            return null;
        }
        return Collections.unmodifiableList(orig.stream().map(convert).collect(Collectors.toList()));
    }

    private static <T, Y> Map<T, Y> mapInit(Map<T, Y> orig) {
        if (orig == null) {
            return null;
        }
        return Collections.unmodifiableMap(new TreeMap<T, Y>(orig));
    }

    ImmutableModelRspec(ImmutableRspecFactory factory, ModelRspec orig) {
        this.factory = factory;
        this.rspecType = orig.getType();
        this.extraXml = ImmutableModelRspec.listInit(orig.getExtraXml());
        this.origNameSpaceInfo = ImmutableModelRspec.mapInit(orig.getNameSpaceInfo());
        this.leases = ImmutableModelRspec.listInit(orig.getLeases(), ImmutableLease::new);
        this.channels = ImmutableModelRspec.listInit(orig.getChannels(), ImmutableChannel::new);
        this.openflowDataPaths = ImmutableModelRspec.listInit(orig.getOpenflowDataPaths(), ImmutableOpenflowDataPath::new);
        this.openflowSlivers = ImmutableModelRspec.listInit(orig.getOpenflowSlivers(), OpenflowSliver::new);
        this.addressPools = ImmutableModelRspec.listInit(orig.getAddressPools(), ImmutableAddressPool::new);
        this.executeAnsiblePlaybooks = ImmutableModelRspec.listInit(orig.getExecuteAnsiblePlaybooks(), ImmutableExecuteAnsiblePlaybook::new);
        this.distributeSshKeypairs = ImmutableModelRspec.listInit(orig.getDistributeSshKeypairs(), ImmutableDistributeSshKeypair::new);
        this.sshKeys = ImmutableModelRspec.listInit(orig.getSshKeys());
        this.flavorLists = ImmutableModelRspec.listInit(orig.getFlavorLists());
        this.diskImageLists = ImmutableModelRspec.listInit(orig.getDiskImageLists());
        this.origDefaultNamespace = orig.getOrigDefaultNamespace();
        this.origSchemaLocation = orig.getSchemaLocation();
        this.expiresString = orig.getExpiresString();
        this.hardwareTypeInfo = orig.getHardwareTypeInfo();
        this.routableAddressesAvailable = orig.getRoutableAddressesAvailable();
        this.routableAddressesConfigured = orig.getRoutableAddressesConfigured();
        this.multiplexFactor = orig.getMultiplexFactor();
        this.nodes = ImmutableModelRspec.listInit(orig.getNodes(), origNode -> new ImmutableRspecNode(this, (RspecNode)origNode));
        this.links = ImmutableModelRspec.listInit(orig.getLinks(), origLink -> new ImmutableRspecLink(this, (RspecLink)origLink));
        this.nodes.stream().flatMap(node -> node.getInterfaces().stream()).forEach(iface -> iface.setForceFinal(true));
        this.links.stream().flatMap(node -> node.getInterfaces().stream()).forEach(iface -> iface.setForceFinal(true));
    }

    @Override
    @Nonnull
    public ModelRspecType getModelRspecType() {
        return ModelRspecType.IMMUTABLE;
    }

    @Override
    public void setParseData(@Nullable String schemaLocation, @Nullable String defaultNamespace, @Nonnull Map<String, String> namespaces) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public String getSchemaLocation() {
        return this.origSchemaLocation;
    }

    @Override
    @Nullable
    public String getOrigDefaultNamespace() {
        return this.origDefaultNamespace;
    }

    @Override
    @Nonnull
    public Map<String, String> getNameSpaceInfo() {
        return this.origNameSpaceInfo;
    }

    @Override
    public void addNode(@Nonnull RspecNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLink(@Nonnull RspecLink link) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public List<ImmutableRspecNode> getNodes() {
        return this.nodes;
    }

    @Nonnull
    public List<ImmutableRspecLink> getLinks() {
        return this.links;
    }

    @Override
    public void addOpenflowDataPath(@Nonnull OpenflowDataPath dp) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public List<ImmutableOpenflowDataPath> getOpenflowDataPaths() {
        return this.openflowDataPaths;
    }

    @Override
    public void addOpenflowSliver(@Nonnull OpenflowSliver sliver) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public List<? extends OpenflowSliver> getOpenflowSlivers() {
        return this.openflowSlivers;
    }

    @Override
    public void addLease(@Nonnull Lease lease) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public List<? extends Lease> getLeases() {
        return this.leases;
    }

    @Override
    public void addChannel(@Nonnull Channel channel) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public List<ImmutableChannel> getChannels() {
        return this.channels;
    }

    @Override
    public void addAddressPool(@Nonnull AddressPool addressPool) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deleteAddressPool(@Nonnull AddressPool addressPool) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public List<ImmutableAddressPool> getAddressPools() {
        return this.addressPools;
    }

    @Override
    @Nullable
    public AddressPool getAddressPoolByClientId(@Nonnull String clientId) {
        for (ImmutableAddressPool addressPool : this.addressPools) {
            if (!Objects.equals(clientId, addressPool.getClientId())) continue;
            return addressPool;
        }
        return null;
    }

    @Override
    public void addExecuteAnsiblePlaybook(@Nonnull ExecuteAnsiblePlaybook executeAnsiblePlaybook) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deleteExecuteAnsiblePlaybook(@Nonnull ExecuteAnsiblePlaybook executeAnsiblePlaybook) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public List<? extends ImmutableExecuteAnsiblePlaybook> getExecuteAnsiblePlaybooks() {
        return this.executeAnsiblePlaybooks;
    }

    @Override
    public void addDistributeSshKeypair(@Nonnull DistributeSshKeypair distributeSshKeypair) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deleteDistributeSshKeypair(@Nonnull DistributeSshKeypair distributeSshKeypair) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public List<? extends DistributeSshKeypair> getDistributeSshKeypairs() {
        return this.distributeSshKeypairs;
    }

    @Override
    @Nullable
    public HardwareTypeInfo getHardwareTypeInfo() {
        return this.hardwareTypeInfo;
    }

    @Override
    public void setHardwareTypeInfo(@Nullable HardwareTypeInfo hardwareTypeInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public ImmutableRspecNode getNodeByUniqueId(@Nonnull String id) {
        for (ImmutableRspecNode node : this.nodes) {
            if (!Objects.equals(node.getUniqueId(), id)) continue;
            return node;
        }
        return null;
    }

    @Override
    @Nullable
    public ImmutableRspecNode getNodeByClientId(@Nonnull String id) {
        for (ImmutableRspecNode node : this.nodes) {
            if (!Objects.equals(node.getClientId(), id)) continue;
            return node;
        }
        return null;
    }

    @Override
    @Nullable
    public ImmutableRspecNode getNodeByComponentId(@Nonnull String id) {
        for (ImmutableRspecNode node : this.nodes) {
            if (!Objects.equals(node.getComponentId().toString(), id)) continue;
            return node;
        }
        return null;
    }

    @Override
    @Nullable
    public ImmutableChannel getChannelByComponentId(@Nonnull GeniUrn urn) {
        for (ImmutableChannel channel : this.channels) {
            if (!Objects.equals(channel.getComponentId(), urn)) continue;
            return channel;
        }
        return null;
    }

    @Nonnull
    public List<ImmutableRspecNode> getNodesByAuthority(@Nonnull Server server) {
        return this.nodes.stream().filter(node -> node.getComponentManagerId().equalsIgnoringSubAuth((Object)server.getDefaultComponentManagerUrn())).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public ImmutableRspecLink getLinkByClientId(@Nonnull String id) {
        for (ImmutableRspecLink link : this.links) {
            if (!Objects.equals(link.getClientId(), id)) continue;
            return link;
        }
        return null;
    }

    @Override
    @Nullable
    public ImmutableRspecLink getLinkByUniqueId(@Nonnull String id) {
        for (ImmutableRspecLink link : this.links) {
            if (!Objects.equals(link.getUniqueId(), id)) continue;
            return link;
        }
        return null;
    }

    @Override
    public void deleteNode(@Nonnull RspecNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteLink(@Nonnull RspecLink link) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deleteChannel(@Nonnull Channel channel) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public String toGeni3Rspec(@Nonnull ModelRspec.RequestRspecSpecialCases specialCase) {
        StaxRspecWriter staxRspecWriter = new StaxRspecWriter(this);
        switch (specialCase) {
            case NONE: {
                break;
            }
            case PLE: {
                ArrayList<String> allowedComponentManagers = new ArrayList<String>();
                allowedComponentManagers.add("urn:publicid:IDN+ple:ibbtple+authority+cm");
                staxRspecWriter.setComponentManagerFilter(allowedComponentManagers);
                staxRspecWriter.setAddSchemaLocation(false);
                staxRspecWriter.setAddEmptySliverToNodeHack(true);
                break;
            }
            case NITOS_NO_E_NODE_B_HACK: {
                staxRspecWriter.setUseNitosENodeBHack(false);
                break;
            }
            default: {
                throw new RuntimeException("Special case " + String.valueOf((Object)specialCase) + " not supported");
            }
        }
        try {
            return staxRspecWriter.call();
        }
        catch (RspecParseException e) {
            LOG.error("Error converting to Rspec: ", (Throwable)e);
            throw new RuntimeException("Error converting to Rspec: " + String.valueOf(e), e);
        }
    }

    @Override
    @Nonnull
    public String toGeni3Rspec() {
        return this.toGeni3Rspec(ModelRspec.RequestRspecSpecialCases.NONE);
    }

    @Override
    @Nullable
    public Date getExpires() throws ParseException {
        if (this.expiresString == null) {
            return null;
        }
        return RFC3339Util.rfc3339StringToDate((String)this.expiresString);
    }

    @Override
    public void setExpires(@Nullable Date expires) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public String getExpiresString() {
        return this.expiresString;
    }

    @Override
    public void setExpires(@Nullable String expires) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Integer getRoutableAddressesAvailable() {
        return this.routableAddressesAvailable;
    }

    @Override
    @Nullable
    public Integer getRoutableAddressesConfigured() {
        return this.routableAddressesConfigured;
    }

    @Override
    public void setRoutableAddressesAvailable(@Nullable Integer routableAddressesAvailable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRoutableAddressesConfigured(@Nullable Integer routableAddressesConfigured) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public List<GeniUrn> getAllComponentManagerUrns() {
        HashSet urns = new HashSet();
        this.nodes.stream().map(RspecNode::getComponentManagerId).filter(Objects::nonNull).forEach(urns::add);
        this.links.stream().flatMap(link -> link.getComponentManagerUrns().stream()).forEach(urns::add);
        this.channels.stream().map(Channel::getComponentManagerId).forEach(urns::add);
        this.addressPools.stream().map(AddressPool::getComponentManagerId).forEach(urns::add);
        return new ArrayList<GeniUrn>(urns);
    }

    @Override
    @Nonnull
    public List<UserSpec> getSshKeys() {
        return this.sshKeys;
    }

    @Override
    public void setSshKeys(@Nonnull List<UserSpec> newKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public String nextLinkName() {
        int c = this.links.size();
        String res = "link" + c;
        while (this.getLinkByClientId(res) != null) {
            res = "link" + ++c;
        }
        return res;
    }

    @Override
    @Nonnull
    public String nextNodeName() {
        int c = this.nodes.size();
        String res = "node" + c;
        while (this.getNodeByClientId(res) != null) {
            res = "node" + ++c;
        }
        return res;
    }

    @Override
    @Nullable
    public String getType() {
        return this.rspecType;
    }

    @Override
    @Nonnull
    public String nextIfaceName(@Nonnull RspecNode node) {
        int c = node.getInterfaces().size();
        String res = node.getClientId() + ":if" + c;
        while (this.getInterfaceByClientId(res) != null) {
            res = node.getClientId() + ":if" + ++c;
        }
        return res;
    }

    @Override
    @Nullable
    public ImmutableRspecInterface getInterfaceByClientId(@Nonnull String clientId) {
        ImmutableRspecInterface iface;
        if (this.nodes != null) {
            for (ImmutableRspecNode node : this.nodes) {
                iface = node.getInterfaceByClientId(clientId);
                if (iface == null) continue;
                return iface;
            }
        }
        if (this.links != null) {
            for (ImmutableRspecLink link : this.links) {
                iface = link.getInterfaceByClientId(clientId);
                if (iface == null) continue;
                return iface;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public ImmutableRspecInterface getInterfaceByUniqueId(@Nonnull String uniqueId) {
        ImmutableRspecInterface iface;
        if (this.nodes != null) {
            for (ImmutableRspecNode node : this.nodes) {
                iface = node.getInterfaceByUniqueId(uniqueId);
                if (iface == null) continue;
                return iface;
            }
        }
        if (this.links != null) {
            for (ImmutableRspecLink link : this.links) {
                iface = link.getInterfaceByUniqueId(uniqueId);
                if (iface == null) continue;
                return iface;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Integer getMultiplexFactor() {
        return this.multiplexFactor;
    }

    @Override
    public void setMultiplexFactor(@Nullable Integer multiplexFactor) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public List<DiskImageList> getDiskImageLists() {
        return this.diskImageLists;
    }

    @Override
    @Nonnull
    public List<FlavorList> getFlavorLists() {
        return this.flavorLists;
    }

    @Override
    public void addDiskImageList(@Nonnull DiskImageList list) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFlavorList(@Nonnull FlavorList list) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public List<ExtraXml> getExtraXml() {
        return this.extraXml;
    }

    @Override
    public void setExtraXml(@Nonnull List<ExtraXml> extraXml) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public ModelRspec copy() {
        return this.factory.copyModelRspec(this, null);
    }
}

