/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.imutable_impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.LinkSetting;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableLinkSetting;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecInterface;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecNode;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableRspecLink
implements RspecLink {
    private static final Logger LOG = LoggerFactory.getLogger(ImmutableRspecLink.class);
    protected final List<ExtraXml> extraXml;
    private final List<GeniUrn> componentManagerUrns;
    private final List<String> linkTypes;
    private final List<ImmutableRspecInterface> interfaces;
    private final List<ImmutableLinkSetting> linkSettings;
    private final String clientId;
    private final GeniUrn sliverId;
    private final String sharedLanName;
    @Nonnull
    private final ImmutableModelRspec modelRspec;
    private final List<String> autoSharedLanNames;
    private final Boolean vlanTagging;
    private final Integer vlanTag;
    private final Boolean noMacLearning;
    private final Boolean linkMultiplexing;
    private final Boolean bestEffort;
    private final Boolean interswitchDisallow;
    private final String noMacLearningValueString;

    private static <T> List<T> listInit(List<T> orig) {
        if (orig == null) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList<T>(orig));
    }

    /*
     * WARNING - void declaration
     */
    public ImmutableRspecLink(@Nonnull ImmutableModelRspec newModelRspec, @Nonnull RspecLink orig) {
        this.modelRspec = newModelRspec;
        this.clientId = orig.getClientId();
        this.extraXml = ImmutableRspecLink.listInit(orig.getExtraXml());
        this.sliverId = orig.getSliverId();
        this.componentManagerUrns = ImmutableRspecLink.listInit(orig.getComponentManagerUrns());
        this.linkTypes = ImmutableRspecLink.listInit(orig.getLinkTypes());
        this.sharedLanName = orig.getSharedLan();
        this.autoSharedLanNames = ImmutableRspecLink.listInit(orig.getAutoShareLanNames());
        this.vlanTagging = orig.hasVlanTaggingTag() ? Boolean.valueOf(orig.isVlanTaggingEnabled()) : null;
        this.vlanTag = orig.getVlanTag();
        this.noMacLearning = orig.hasNoMacLearningTag() ? Boolean.valueOf(orig.isNoMacLearning()) : null;
        this.noMacLearningValueString = orig.hasNoMacLearningTag() ? orig.getNoMacLeaningValueString() : null;
        this.bestEffort = orig.hasBestEffortTag() ? Boolean.valueOf(orig.isBestEffortEnabled()) : null;
        this.linkMultiplexing = orig.hasLinkMultiplexingTag() ? Boolean.valueOf(orig.isLinkMultiplexingEnabled()) : null;
        this.interswitchDisallow = orig.hasInterswitchDisallowTag() ? Boolean.valueOf(orig.isInterswitchDisallowed()) : null;
        ArrayList<void> copiedInterfaces = new ArrayList<void>();
        for (RspecInterface rspecInterface : orig.getInterfaces()) {
            void var6_7;
            ImmutableRspecInterface immutableRspecInterface = newModelRspec.getInterfaceByClientId(rspecInterface.getClientId());
            if (immutableRspecInterface != null) {
                if (immutableRspecInterface.isLinkBound()) {
                    if (immutableRspecInterface.getLink() != null) {
                        throw new IllegalStateException("The interface " + immutableRspecInterface.getUniqueId() + " was already bound to link " + immutableRspecInterface.getLink().getUniqueId() + " but it also needed to be bound to link " + this.getUniqueId());
                    }
                    LOG.warn("The interface " + immutableRspecInterface.getUniqueId() + " was already bound to link " + immutableRspecInterface.getLink().getUniqueId() + " and that binding occurred again. (will ignore, as that is safe.)");
                }
                immutableRspecInterface.bindLink(this);
            } else {
                ImmutableRspecInterface immutableRspecInterface2 = new ImmutableRspecInterface(this.getRspec(), null, this, rspecInterface);
            }
            copiedInterfaces.add(var6_7);
        }
        this.interfaces = Collections.unmodifiableList(copiedInterfaces);
        ArrayList<ImmutableLinkSetting> copiedLinkSetting = new ArrayList<ImmutableLinkSetting>();
        for (LinkSetting linkSetting : orig.getLinkSettings()) {
            ImmutableRspecInterface fromIface = this.getInterfaceByClientId(linkSetting.getFromIface().getClientId());
            ImmutableRspecInterface toIface = this.getInterfaceByClientId(linkSetting.getToIface().getClientId());
            assert (fromIface != null);
            assert (toIface != null);
            copiedLinkSetting.add(new ImmutableLinkSetting(fromIface, toIface, linkSetting));
        }
        this.linkSettings = Collections.unmodifiableList(copiedLinkSetting);
    }

    @Override
    public void overwritePropertiesWith(@Nonnull RspecLink otherLink, boolean overwriteWithNulloverwriteNonAuthoratativeComponentManagers) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public ImmutableModelRspec getRspec() {
        return this.modelRspec;
    }

    @Override
    @Nonnull
    public String getUniqueId() {
        return BasicStringRspec.makeUniqueLinkId((String)this.clientId, null, this.getComponentManagerUrnStrings());
    }

    @Nonnull
    public List<String> getComponentManagerUrnStrings() {
        return this.componentManagerUrns.stream().map(ResourceUrn::getValue).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(@Nullable String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public List<GeniUrn> getComponentManagerUrns() {
        return this.componentManagerUrns;
    }

    @Override
    @Nonnull
    public List<String> getLinkTypes() {
        return this.linkTypes;
    }

    @Override
    @Nonnull
    public List<? extends LinkSetting> getLinkSettings() {
        return this.linkSettings;
    }

    @Override
    @Nullable
    public ImmutableLinkSetting getLinkSetting(@Nonnull RspecInterface fromIface, @Nonnull RspecInterface toIface) {
        assert (fromIface != null);
        assert (fromIface instanceof ImmutableRspecInterface);
        assert (toIface != null);
        assert (toIface instanceof ImmutableRspecInterface);
        assert (fromIface.getRspec() == this.getRspec());
        assert (toIface.getRspec() == this.getRspec());
        for (ImmutableLinkSetting ls : this.linkSettings) {
            if (ls.getFromIface() != fromIface || ls.getToIface() != toIface) continue;
            return ls;
        }
        return null;
    }

    @Override
    @Nullable
    public ImmutableLinkSetting getLinkSettingByClientIds(@Nonnull String fromIfaceName, @Nonnull String toIfaceName) {
        for (ImmutableLinkSetting ls : this.linkSettings) {
            if (!Objects.equals(ls.getFromIface().getClientId(), fromIfaceName) || !Objects.equals(ls.getToIface().getClientId(), toIfaceName)) continue;
            return ls;
        }
        return null;
    }

    @Override
    @Nullable
    public ImmutableLinkSetting getLinkSettingByUniqueIds(@Nonnull String fromIfaceName, @Nonnull String toIfaceName) {
        for (ImmutableLinkSetting ls : this.linkSettings) {
            if (!Objects.equals(ls.getFromIface().getUniqueId(), fromIfaceName) || !Objects.equals(ls.getToIface().getUniqueId(), toIfaceName)) continue;
            return ls;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isImpaired() {
        List<ImmutableLinkSetting> list = this.linkSettings;
        synchronized (list) {
            for (ImmutableLinkSetting ls : this.linkSettings) {
                if (!ls.isActive()) continue;
                return true;
            }
            return false;
        }
    }

    protected boolean addInterface(@Nonnull RspecInterface iface) {
        throw new UnsupportedOperationException();
    }

    protected boolean removeInterface(@Nonnull RspecInterface iface) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public List<ImmutableRspecInterface> getInterfaces() {
        return this.interfaces;
    }

    @Override
    @Nullable
    public ImmutableRspecInterface getInterfaceForNode(@Nonnull RspecNode node) {
        assert (node instanceof ImmutableRspecNode);
        for (ImmutableRspecInterface iface : this.interfaces) {
            if (iface.getNode() != node) continue;
            return iface;
        }
        return null;
    }

    @Override
    @Nullable
    public ImmutableRspecInterface getInterfaceByClientId(@Nonnull String clientId) {
        for (ImmutableRspecInterface iface : this.interfaces) {
            if (!Objects.equals(iface.getClientId(), clientId)) continue;
            return iface;
        }
        return null;
    }

    @Override
    @Nullable
    public ImmutableRspecInterface getInterfaceByUniqueId(@Nonnull String uniqueId) {
        for (ImmutableRspecInterface iface : this.interfaces) {
            if (!Objects.equals(iface.getUniqueId(), uniqueId)) continue;
            return iface;
        }
        return null;
    }

    @Override
    @Nullable
    public GeniUrn getSliverId() {
        return this.sliverId;
    }

    @Override
    public void setSliverId(@Nullable GeniUrn sliverId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSliverId(@Nullable String sliverId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStitched(@Nullable TestbedInfoSource testbedInfoSource) {
        if (this.getComponentManagerUrns().size() < 2) {
            return false;
        }
        if (this.getLinkTypes().size() > 1 || this.getLinkTypes().size() == 1 && !this.getLinkTypes().get(0).equalsIgnoreCase("lan") && !this.getLinkTypes().get(0).equalsIgnoreCase("vlan")) {
            return false;
        }
        if (testbedInfoSource == null) {
            return true;
        }
        Server firstServer = null;
        for (GeniUrn urn : this.getComponentManagerUrns()) {
            Server server = testbedInfoSource.getByUrn(urn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_TOPLEVEL);
            if (server == null) {
                LOG.warn("Authority not found for " + String.valueOf(urn) + " during stitch check -> falling back to assuming link is stitched");
                return true;
            }
            if (firstServer == null) {
                firstServer = server;
                continue;
            }
            if (Objects.equals(firstServer.getDefaultComponentManagerUrn(), server.getDefaultComponentManagerUrn())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public List<ExtraXml> getExtraXml() {
        return this.extraXml;
    }

    @Override
    @Nullable
    public String getSharedLan() {
        return this.sharedLanName;
    }

    @Override
    public void setSharedLan(@Nullable String sharedLanName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isVlanTaggingEnabled() {
        return this.vlanTagging != null && this.vlanTagging != false;
    }

    @Override
    public boolean hasVlanTaggingTag() {
        return this.vlanTagging != null;
    }

    @Override
    public void setVlanTagging(@Nullable Boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Integer getVlanTag() {
        return this.vlanTag;
    }

    @Override
    public void setVlanTag(@Nullable Integer vlanTag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNoMacLearning() {
        return this.noMacLearning != null && this.noMacLearning != false;
    }

    @Override
    public boolean hasNoMacLearningTag() {
        return this.noMacLearning != null;
    }

    @Override
    public void setNoMacLearning(@Nullable Boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public String getNoMacLeaningValueString() {
        if (this.noMacLearning == null) {
            return null;
        }
        return this.noMacLearningValueString;
    }

    @Override
    public void setNoMacLearning(@Nullable String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBestEffortEnabled() {
        return this.bestEffort != null && this.bestEffort != false;
    }

    @Override
    public boolean hasBestEffortTag() {
        return this.bestEffort != null;
    }

    @Override
    public void setBestEffort(@Nullable Boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLinkMultiplexingEnabled() {
        return this.linkMultiplexing != null && this.linkMultiplexing != false;
    }

    @Override
    public boolean hasLinkMultiplexingTag() {
        return this.linkMultiplexing != null;
    }

    @Override
    public void setLinkMultiplexing(@Nullable Boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasAutoShareLan() {
        return !this.autoSharedLanNames.isEmpty();
    }

    @Override
    @Nonnull
    public List<String> getAutoShareLanNames() {
        return this.autoSharedLanNames;
    }

    @Override
    public boolean isInterswitchDisallowed() {
        return this.interswitchDisallow != null && this.interswitchDisallow != false;
    }

    @Override
    public boolean hasInterswitchDisallowTag() {
        return this.interswitchDisallow != null;
    }

    @Override
    public void setInterswitchDisallow(@Nullable Boolean value) {
        throw new UnsupportedOperationException();
    }
}

