/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class StaxHelper {
    public static XMLEventReader makeXmlEventReader(final List<XMLEvent> inputEvents) {
        return new XMLEventReader(){
            List<XMLEvent> events;
            int i;
            int lastremoved;
            {
                this.events = new ArrayList<XMLEvent>(inputEvents);
                this.i = -1;
                this.lastremoved = -1;
            }

            @Override
            public XMLEvent nextEvent() throws XMLStreamException {
                return this.next();
            }

            @Override
            public boolean hasNext() {
                return this.events != null && this.i < this.events.size() - 1;
            }

            @Override
            public XMLEvent next() {
                ++this.i;
                if (this.i >= this.events.size()) {
                    throw new NoSuchElementException();
                }
                return this.events.get(this.i);
            }

            @Override
            public void remove() {
                if (this.i == this.lastremoved) {
                    throw new IllegalStateException("next() already called for this position");
                }
                if (this.i == 0) {
                    throw new IllegalStateException("next() not yet called");
                }
                this.events.remove(this.i);
                this.lastremoved = this.i - 1;
                --this.i;
            }

            @Override
            public XMLEvent peek() throws XMLStreamException {
                if (!this.hasNext()) {
                    return null;
                }
                return this.events.get(this.i + 1);
            }

            @Override
            public String getElementText() throws XMLStreamException {
                XMLEvent startE = this.events.get(this.i);
                if (!startE.isStartElement()) {
                    throw new XMLStreamException("not a start element");
                }
                Object res = "";
                while (this.hasNext()) {
                    XMLEvent e = this.next();
                    if (e.isCharacters()) {
                        res = (String)res + e.asCharacters().getData();
                        continue;
                    }
                    if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), startE.asStartElement().getName())) {
                        return res;
                    }
                    if (e.isEndElement()) {
                        throw new XMLStreamException("encountered end event that is not corresponding end event: end=" + String.valueOf(e.asEndElement().getName()) + "  start=" + String.valueOf(startE.asStartElement().getName()));
                    }
                    if (e.isStartElement()) {
                        throw new XMLStreamException("encountered start event that is not corresponding end event: " + String.valueOf(e.asStartElement().getName()) + "  start=" + String.valueOf(startE.asStartElement().getName()));
                    }
                    throw new XMLStreamException("encountered non text event that is not corresponding end event: " + String.valueOf(e));
                }
                throw new XMLStreamException("encountered end of stream before end element");
            }

            @Override
            public XMLEvent nextTag() throws XMLStreamException {
                while (this.hasNext()) {
                    XMLEvent e = this.next();
                    if (e.isCharacters()) {
                        if (e.asCharacters().isIgnorableWhiteSpace()) continue;
                        throw new XMLStreamException("encountered characters are not ignorable white space: " + String.valueOf(e));
                    }
                    if (e.isEndElement() || e.isStartElement()) {
                        return e;
                    }
                    throw new XMLStreamException("unexpected element: " + String.valueOf(e));
                }
                throw new XMLStreamException("encountered end of stream before start or end element");
            }

            @Override
            public Object getProperty(String name) throws IllegalArgumentException {
                throw new RuntimeException("unsupported. this is a fake XMLEventReader");
            }

            @Override
            public void close() throws XMLStreamException {
                this.events.clear();
                this.events = null;
            }
        };
    }

    public static XMLEventReader getEventsUntilEndTag(XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException {
        ArrayList<XMLEvent> res = new ArrayList<XMLEvent>();
        res.add(startNodeEvent);
        String name = startNodeEvent.asStartElement().getName().getLocalPart();
        int depth = 0;
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            res.add(e);
            if (e.isStartElement() && Objects.equals(e.asStartElement().getName().getLocalPart(), name)) {
                ++depth;
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName().getLocalPart(), name)) continue;
            if (depth == 0) break;
            --depth;
        }
        return StaxHelper.makeXmlEventReader(res);
    }

    public static Pair<String, Boolean> getTextExpectingNoNestedElements(XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException {
        boolean hasUnexpectedNestedElements = false;
        StringBuilder text = new StringBuilder();
        String name = startNodeEvent.asStartElement().getName().getLocalPart();
        int depth = 0;
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName().getLocalPart(), name)) {
                    ++depth;
                }
                hasUnexpectedNestedElements = true;
            }
            if (e.isEndElement()) {
                if (Objects.equals(e.asEndElement().getName().getLocalPart(), name)) {
                    if (depth == 0) {
                        return new Pair<String, Boolean>(text.toString(), hasUnexpectedNestedElements);
                    }
                    hasUnexpectedNestedElements = true;
                    --depth;
                } else {
                    hasUnexpectedNestedElements = true;
                }
            }
            if (!e.isCharacters() || e.asCharacters().isIgnorableWhiteSpace()) continue;
            text.append(e.asCharacters().getData());
        }
        return new Pair<String, Boolean>(text.toString(), hasUnexpectedNestedElements);
    }

    public static boolean readAllExpectingNothingMore(XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException {
        boolean detectedLosingData = false;
        String name = startNodeEvent.asStartElement().getName().getLocalPart();
        int depth = 0;
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName().getLocalPart(), name)) {
                    ++depth;
                } else {
                    detectedLosingData = true;
                }
            }
            if (!e.isEndElement()) continue;
            if (Objects.equals(e.asEndElement().getName().getLocalPart(), name)) {
                if (depth == 0) {
                    return detectedLosingData;
                }
                detectedLosingData = true;
                --depth;
                continue;
            }
            detectedLosingData = true;
        }
        return detectedLosingData;
    }

    public static String xmlEventToString(XMLEvent e) {
        if (e.isStartDocument()) {
            return "StartDocument";
        }
        if (e.isEndDocument()) {
            return "EndDocument";
        }
        if (e.isStartElement()) {
            return "StartElement(name=" + String.valueOf(e.asStartElement().getName()) + ")";
        }
        if (e.isEndElement()) {
            return "EndElement(name=" + String.valueOf(e.asEndElement().getName()) + ")";
        }
        if (e.isCharacters()) {
            return "Charachters(data=" + e.asCharacters().getData() + ")";
        }
        if (e.isAttribute()) {
            return "Attribute";
        }
        return "unknown";
    }

    public static String xmlEventToStringWithAttributes(XMLEvent e) {
        if (e.isStartElement()) {
            StringBuilder sb = new StringBuilder();
            Iterator<Attribute> it = e.asStartElement().getAttributes();
            while (it.hasNext()) {
                Attribute att = it.next();
                sb.append(att.getName()).append("=\"").append(att.getValue()).append("\"");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            return "StartElement(" + String.valueOf(e.asStartElement().getName()) + " " + sb.toString() + ")";
        }
        return StaxHelper.xmlEventToString(e);
    }

    public static class Pair<A, B> {
        private final A a;
        private final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public A getKey() {
            return this.a;
        }

        public B getValue() {
            return this.b;
        }
    }
}

