/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.parser.extensions;

import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.rspec.parser.RspecXmlConstants;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.Callable;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;

public class UserSpecWriter
implements Callable<String> {
    private final List<UserSpec> userSpecs;

    public UserSpecWriter(List<UserSpec> userSpecs) {
        this.userSpecs = userSpecs;
    }

    @Override
    public String call() throws Exception {
        try {
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
            StringWriter sw = new StringWriter();
            for (UserSpec userSpec : this.userSpecs) {
                XMLEventWriter innerEventWriter = outputFactory.createXMLEventWriter(sw);
                IndentingXMLEventWriter eventWriter = new IndentingXMLEventWriter(innerEventWriter);
                eventWriter.setDefaultNamespace("http://jfed.iminds.be/rspec/ext/jfed-ssh-keys/1");
                UserSpecWriter.writeUserSpec(eventFactory, (XMLEventWriter)eventWriter, userSpec);
                eventWriter.add(eventFactory.createEndDocument());
                eventWriter.close();
                sw.append('\n');
            }
            return sw.toString();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Problem writing RSpec", e);
        }
    }

    public static void writeUserSpec(XMLEventFactory eventFactory, XMLEventWriter eventWriter, UserSpec userSpec) throws XMLStreamException {
        eventWriter.add(eventFactory.createStartElement(RspecXmlConstants.Q_JFEDSSH_USER_SSH_KEYS, null, null));
        if (userSpec.getUrn() != null) {
            eventWriter.add(eventFactory.createAttribute(RspecXmlConstants.Q_JFEDSSH_USER, userSpec.getUrn()));
        }
        for (String userKey : userSpec.getSshKey()) {
            eventWriter.add(eventFactory.createStartElement(RspecXmlConstants.Q_JFEDSSH_KEY, null, null));
            eventWriter.add(eventFactory.createCharacters(UserSpecWriter.trimSshKey(userKey)));
            eventWriter.add(eventFactory.createEndElement(RspecXmlConstants.Q_JFEDSSH_KEY, null));
        }
        eventWriter.add(eventFactory.createEndElement(RspecXmlConstants.Q_JFEDSSH_USER_SSH_KEYS, null));
    }

    public static String trimSshKey(String input) {
        return input.replace("\n", "").replace("\r", "").trim();
    }
}

