/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import java.lang.reflect.Type;
import java.util.Date;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DateSerializerAdapter
implements JsonSerializer<Date> {
    @NotNull
    private final ILogger logger;

    public DateSerializerAdapter(@NotNull ILogger logger) {
        this.logger = logger;
    }

    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        try {
            return src == null ? null : new JsonPrimitive(DateUtils.getTimestamp(src));
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error when serializing Date", e);
            return null;
        }
    }
}

