/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake;

import org.rendersnake.HtmlCanvas;
import org.rendersnake.internal.ContextMap;

public class RequestUtils {
    public static ContextMap getParameters(HtmlCanvas html) {
        return html.getPageContext().getContextMap("http.request.parameters");
    }

    public static String getParameter(HtmlCanvas html, String key) {
        ContextMap map = RequestUtils.getParameters(html);
        if (null == map) {
            return null;
        }
        return map.getString(key, new String[0]);
    }

    public static Integer getIntegerParameter(HtmlCanvas html, String key) {
        String valueOrNull = RequestUtils.getParameter(html, key);
        return valueOrNull == null || valueOrNull.length() == 0 ? null : Integer.valueOf(Integer.parseInt(valueOrNull));
    }

    public static Boolean getBooleanParameter(HtmlCanvas html, String key) {
        String valueOrNull = RequestUtils.getParameter(html, key);
        return valueOrNull == null || valueOrNull.length() == 0 ? null : Boolean.valueOf(Boolean.parseBoolean(valueOrNull));
    }

    public static ContextMap getSession(HtmlCanvas html) {
        return html.getPageContext().getContextMap("http.session");
    }

    public static String getHeaderValue(HtmlCanvas html, String name) {
        ContextMap map = html.getPageContext().getContextMap("http.request.headers");
        if (null == map) {
            return null;
        }
        return map.getString(name, new String[0]);
    }

    public static ContextMap getCookies(HtmlCanvas html) {
        return html.getPageContext().getContextMap("http.request.cookies");
    }

    public static String getPath(HtmlCanvas html) {
        return html.getPageContext().getString("http.request.path", new String[0]);
    }

    public static String getRequestURLAndQuery(HtmlCanvas html) {
        return html.getPageContext().getString("http.request.uri.query", new String[0]);
    }
}

