/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class ConnectivityTestAggregateManager2
extends BaseApiTest<LegacyApiTestConfig> {
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "One simple \"Geni Aggregate Manager API v2\" Test (XmlRpc and GetVersion). This is mainly useful to test connectivity to the tested AM.";
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            return Collections.emptyList();
        }
    };
    private AggregateManager2 am2;
    private Map versionRawResult = null;
    private AggregateManager2.VersionInfo versionInfo = null;

    @Inject
    public ConnectivityTestAggregateManager2(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    public SfaConnection getAM2Connection() throws JFedException {
        return (SfaConnection)this.getConnectionProvider().getConnectionByAuthority(this.getUser(), this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2));
    }

    public void testAM2CorrectnessXmlRpcResult(Map res) {
        Object code = res.get("code");
        Object value = res.get("value");
        Object output = res.get("output");
        this.assertNotNull(code, "testAM2CorrectnessXmlRpcResult code == null in " + String.valueOf(res));
        this.assertNotNull(value, "testAM2CorrectnessXmlRpcResult value == null in " + String.valueOf(res));
        this.assertInstanceOf(code, Map.class, "testAM2CorrectnessXmlRpcResult code is not Map in " + String.valueOf(res) + " (it is " + code.getClass().getName() + " with value \"" + code.toString() + "\")");
        Map codeHt = (Map)code;
        Object genicode = codeHt.get("geni_code");
        this.assertNotNull(genicode, "testAM2CorrectnessXmlRpcResult code does not contain \"geni_code\" in " + String.valueOf(res));
        this.assertEquals(genicode.getClass(), Integer.class, "testAM2CorrectnessXmlRpcResult code.geni_code is not int in " + String.valueOf(res));
        int genicodevalue = (Integer)genicode;
        if (genicodevalue != 0) {
            this.assertNotNull(output, "testAM2CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output == null in " + String.valueOf(res));
            this.assertEquals(output.getClass(), String.class, "testAM2CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\") in \"+res+\"");
        } else if (output == null) {
            this.note("testAM2CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is ommited. This is allowed by the API.");
        } else if (output != null && !(output instanceof String)) {
            this.note("testAM2CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\"). This is allowed but not recommended by jFed.");
        }
    }

    @Override
    public void setUp() {
        this.note("Starting setUp");
        this.am2 = new AggregateManager2(this.logger, this.getJFedPreferences());
        this.note("setUp complete");
    }

    @ApiTest.Test
    public void testGetVersionXmlRpcCorrectness() throws JFedException {
        this.note("Starting testGetVersionXmlRpcCorrectness");
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.getVersion(this.getAM2Connection());
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.versionRawResult = reply.getRawResult();
        this.assertNotNull(this.versionRawResult);
        Object ver = this.versionRawResult.get("geni_api");
        assert (ver != null);
        assert (ver instanceof Integer);
        int v = (Integer)ver;
        assert (v == 2);
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "GeniResponse code is not SUCCESS (0)");
        this.versionInfo = (AggregateManager2.VersionInfo)reply.getValue();
        this.assertNotNull(this.versionInfo);
        this.note("testGetVersionXmlRpcCorrectness complete");
    }
}

