/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.ProtogeniSliceAuthority;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class ConnectivityTestSliceAuthority
extends BaseApiTest<LegacyApiTestConfig> {
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "One simple \"ProtoGeni Slice Authority API v1\" Test (XmlRpc and GetVersion). This is mainly useful to test connectivity to the tested SA.";
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            return Collections.emptyList();
        }
    };
    private ProtogeniSliceAuthority sa;

    @Inject
    public ConnectivityTestSliceAuthority(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    public SfaConnection getConnection() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.user.getUserAuthorityServer(), new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1));
    }

    @Override
    public void setUp() {
        this.sa = new ProtogeniSliceAuthority(this.logger, this.getJFedPreferences());
    }

    @ApiTest.Test
    public void testGetVersion() throws JFedException {
        System.out.println("GetVersion test starting");
        ProtogeniSliceAuthority.SliceAuthorityReply reply = this.sa.getVersion(this.getConnection());
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
        System.out.println("GetVersion test finished");
    }
}

