/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import be.iminds.ilabt.jfed.testing.shared.CommonAMTest;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.lib.SSHKeyHelper;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class TestBestEffortAMv3
extends BaseApiTest<LegacyApiTestConfig> {
    private CommonAMTest commonAMTest;
    private AggregateManager3 am3;
    private Boolean createSliceIfNotExists = true;
    private Boolean reuseSliceIfExists = false;
    private Boolean disableCleanup = false;
    private Map versionRawResult = null;
    private AggregateManager3.VersionInfo versionInfo = null;
    private CommonAMTest.SliceInfo sliceP;
    private CommonAMTest.SliceInfo sliceOA;
    private CommonAMTest.SliceInfo sliceR;
    private ResourceUrn urnSliverP1;
    private List<ResourceUrn> urnSliverP2;
    private ResourceUrn urnSliverR1;
    private ResourceUrn urnSliverR2;
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "Many Aggregate Manager (Geni AM API v3) Tests. 2 slices and a sliver will be created during the tests. The sliver will be deleted. This will not test ListResources.";
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("create_slice_if_not_exists");
            res.add("reuse_slice_if_exists");
            res.add("disable_slice_cleanup");
            res.add("fixed_slice_name");
            res.add("fixed_project_name");
            res.add("try_to_use_project_for_slices");
            CommonAMTest.addOptionsForNodeLoginSshProxy(res);
            CommonAMTest.addOptionsForConnectionSshProxy(res);
            CommonAMTest.addOptionsForRspecTypeVersion(res);
            return res;
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }
    };

    @Inject
    public TestBestEffortAMv3(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    private static List<String> toStringList(String s) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(s);
        return res;
    }

    private static List<String> toStringList(String s1, String s2) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(s1);
        res.add(s2);
        return res;
    }

    private static List<String> toStringList(String s1, String s2, String s3) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(s1);
        res.add(s2);
        res.add(s3);
        return res;
    }

    public SfaConnection getAM3Connection() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3));
    }

    public void testAM3CorrectnessXmlRpcResult(Map res) {
        Object code = res.get("code");
        Object value = res.get("value");
        Object output = res.get("output");
        this.assertNotNull(code, "testAM3CorrectnessXmlRpcResult code == null in " + String.valueOf(res));
        this.assertNotNull(value, "testAM3CorrectnessXmlRpcResult value == null in " + String.valueOf(res));
        this.assertInstanceOf(code, Map.class, "testAM3CorrectnessXmlRpcResult code is not Map in " + String.valueOf(res));
        Map codeHt = (Map)code;
        Object genicode = codeHt.get("geni_code");
        this.assertNotNull(genicode, "testAM3CorrectnessXmlRpcResult code does not contain \"geni_code\" in " + String.valueOf(res));
        this.assertEquals(genicode.getClass(), Integer.class, "testAM3CorrectnessXmlRpcResult code.geni_code is not int in " + String.valueOf(res));
        int genicodevalue = (Integer)genicode;
        if (genicodevalue != 0) {
            this.assertNotNull(output, "testAM3CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output == null in " + String.valueOf(res));
            this.assertEquals(output.getClass(), String.class, "testAM3CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\") in \"+res+\"");
        } else {
            if (output == null) {
                this.note("testAM3CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is ommited. This is allowed by the API.");
            }
            if (output != null && !(output instanceof String)) {
                this.warn("testAM3CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\"). This is allowed but not recommended by jFed.");
            }
        }
    }

    @Override
    public void setUp() {
        this.assertNotNull(this.user);
        this.assertNotNull(this.user.getUserAuthorityServerId());
        this.commonAMTest = new CommonAMTest(this, this.user.getUserAuthorityServerId(), this.getTestbedInfoSource());
        this.am3 = new AggregateManager3(this.logger, this.getJFedPreferences());
        this.createSliceIfNotExists = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("create_slice_if_not_exists"));
        this.reuseSliceIfExists = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("reuse_slice_if_exists"));
        this.disableCleanup = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("disable_slice_cleanup"));
        if (this.createSliceIfNotExists == null) {
            this.createSliceIfNotExists = true;
        }
        if (this.reuseSliceIfExists == null) {
            this.reuseSliceIfExists = false;
        }
        if (this.disableCleanup == null) {
            this.disableCleanup = false;
        }
        this.commonAMTest.selectRegularTestCredentialType(this);
        this.commonAMTest.setupProxyForConnectionPool((LegacyApiTestConfig)this.getTestConfig());
    }

    @ApiTest.Test(groups={"getversion"})
    public void testGetVersionXmlRpcCorrectness() throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.getVersion(this.getAM3Connection());
        this.testAM3CorrectnessXmlRpcResult(reply.getRawResult());
        this.versionRawResult = reply.getRawResult();
        this.assertNotNull(this.versionRawResult);
        Object ver = this.versionRawResult.get("geni_api");
        this.assertNotNull(ver);
        this.assertTrue(ver instanceof Integer);
        int v = (Integer)ver;
        this.assertEquals(v, 3, "AM (backward compatibility \"geni_api\" field) is not version 3");
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "GeniResponse code is not SUCCESS (0)");
        this.versionInfo = (AggregateManager3.VersionInfo)reply.getValue();
        this.assertNotNull(this.versionInfo);
        this.assertEquals(this.versionInfo.getApi(), 3, "AM is not version 3");
    }

    public CommonAMTest.SliceInfo createTestSlice(String suffix) throws JFedException, IOException {
        boolean tryToUseProject;
        CommonAMTest.SliceInfo slice = null;
        String fixedSliceName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_slice_name");
        String fixedProjectName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_project_name");
        boolean bl = tryToUseProject = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("try_to_use_project_for_slices")) != Boolean.FALSE;
        if (this.reuseSliceIfExists.booleanValue() && fixedSliceName != null && (slice = this.commonAMTest.reuseSlice(fixedSliceName + suffix)) == null && !this.createSliceIfNotExists.booleanValue()) {
            throw new RuntimeException("create_slice_if_not_exists is false, and slice does not exist.");
        }
        if (slice == null) {
            slice = fixedSliceName == null ? this.commonAMTest.createSlice(suffix, fixedProjectName, tryToUseProject, false) : this.commonAMTest.createSlice(fixedSliceName + suffix, false, fixedProjectName, tryToUseProject, false);
        }
        this.assertNotNull(slice.urnString, "slice" + suffix + ".urnString may not be null");
        this.assertTrue(slice.urnString.startsWith("urn:publicid:IDN+"));
        this.assertNotNull(slice.credentials, "sliceS.credential may not be null");
        this.assertNotEmpty(slice.credentials, "sliceS.credential may not be empty");
        this.assertValidUrn(slice.urnString, "slice");
        return slice;
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, description="Create the slice used in the next tests")
    public void createTestSliceP() throws JFedException, IOException {
        this.sliceP = this.createTestSlice("P");
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, description="Create the slice used in the next tests", groups={"testRenew"})
    public void createTestSliceR() throws JFedException, IOException {
        this.skip("test not yet implemented");
        this.sliceR = this.createTestSlice("R");
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, description="Create the slice used in the next tests", groups={"testPerformOperationAction"})
    public void createTestSliceOA() throws JFedException, IOException {
        this.skip("test not yet implemented");
        this.sliceOA = this.createTestSlice("OA");
    }

    @ApiTest.Test(hardDepends={"createTestSliceP"}, groups={"testProvision"})
    public void testAllocateP() throws JFedException, NoSuchAlgorithmException, ParseException {
        this.assertNotNull(this.sliceP);
        String requestRspecP1 = this.commonAMTest.getOneNodeRequestRSpec(this.testedAuthority.getServerForRspecComponentManager(), this.sliceP.urn);
        if (requestRspecP1 == null) {
            this.skip("testCreateSliver skipped, because no RSpec example known for type=\"" + this.testedAuthority.getServerForRspecComponentManager().getServerType() + "\"");
        }
        String requestRspecP2 = "<rspec type=\"request\"        xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/request.xsd\"        xmlns=\"http://www.geni.net/resources/rspec/3\"        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n    <node client_id=\"node0\"           component_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+node+n091-01\"           component_manager_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+authority+cm\"           exclusive=\"true\">\n        <sliver_type name=\"raw-pc\"/>\n    </node>\n    <node client_id=\"node1\"           component_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+node+n091-01\"           component_manager_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+authority+cm\"          exclusive=\"true\">\n        <sliver_type name=\"raw-pc\"/>\n    </node>\n</rspec>\n";
        Date expireDate = new Date(System.currentTimeMillis() + 3600000L);
        String endTime = RFC3339Util.dateToRFC3339String((Date)expireDate);
        AbstractGeniAggregateManager.AggregateManagerReply replyP2 = this.am3.allocate(this.getAM3Connection(), this.sliceP.urnString, this.commonAMTest.getSliceCredentialListForAM(this.sliceP), "<rspec type=\"request\"        xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/request.xsd\"        xmlns=\"http://www.geni.net/resources/rspec/3\"        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n    <node client_id=\"node0\"           component_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+node+n091-01\"           component_manager_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+authority+cm\"           exclusive=\"true\">\n        <sliver_type name=\"raw-pc\"/>\n    </node>\n    <node client_id=\"node1\"           component_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+node+n091-01\"           component_manager_id=\"urn:publicid:IDN+wall2.ilabt.iminds.be+authority+cm\"          exclusive=\"true\">\n        <sliver_type name=\"raw-pc\"/>\n    </node>\n</rspec>\n", endTime, this.commonAMTest.addCredentialExtraOptions(null));
        this.assertEquals(replyP2.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "Allocate P2 did not succeed");
        AggregateManager3.AllocateAndProvisionInfo allocateAndProvisionInfoP2 = (AggregateManager3.AllocateAndProvisionInfo)replyP2.getValue();
        String replyRequestRspecP2 = allocateAndProvisionInfoP2.getRspec();
        this.assertNotNull(replyRequestRspecP2, "Allocate should return an RSpec" + replyRequestRspecP2);
        List sliverInfosP2 = allocateAndProvisionInfoP2.getSliverInfo();
        this.assertTrue(sliverInfosP2.size() >= 1, "should be at least 1 sliver allocated");
        this.urnSliverP2 = new ArrayList<ResourceUrn>();
        for (AggregateManager3.SliverInfo sliverInfoP2 : sliverInfosP2) {
            this.assertEquals(sliverInfoP2.getAllocationStatus(), "geni_allocated", "Allocated sliver should be in geni_allocated state");
            String sliverP2UrnStr = sliverInfoP2.getSliverUrn();
            this.assertNotNull(sliverP2UrnStr);
            this.assertValidUrn(sliverP2UrnStr, "sliver");
            this.urnSliverP2.add(new ResourceUrn(sliverP2UrnStr));
        }
        this.note("Allocated slivers P2 for slice=\"" + this.sliceP.urnString + "\" sliver_urns=" + String.valueOf(this.urnSliverP2));
        AbstractGeniAggregateManager.AggregateManagerReply replyP1 = this.am3.allocate(this.getAM3Connection(), this.sliceP.urnString, this.commonAMTest.getSliceCredentialListForAM(this.sliceP), requestRspecP1, endTime, this.commonAMTest.addCredentialExtraOptions(null));
        this.assertEquals(replyP1.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "Allocate P1 did not succeed");
        AggregateManager3.AllocateAndProvisionInfo allocateAndProvisionInfoP1 = (AggregateManager3.AllocateAndProvisionInfo)replyP1.getValue();
        String replyRequestRspecP1 = allocateAndProvisionInfoP1.getRspec();
        this.assertNotNull(replyRequestRspecP1, "Allocate should return an RSpec" + replyRequestRspecP1);
        List sliverInfosP1 = allocateAndProvisionInfoP1.getSliverInfo();
        this.assertEquals(sliverInfosP1.size(), 1, "should be exactly 1 sliver allocated");
        AggregateManager3.SliverInfo sliverInfoP1 = (AggregateManager3.SliverInfo)sliverInfosP1.get(0);
        this.assertEquals(sliverInfoP1.getAllocationStatus(), "geni_allocated", "Allocated sliver should be in geni_allocated state");
        String sliverP1UrnStr = sliverInfoP1.getSliverUrn();
        this.assertNotNull(sliverP1UrnStr);
        this.assertValidUrn(sliverP1UrnStr, "sliver");
        this.urnSliverP1 = new ResourceUrn(sliverP1UrnStr);
        this.note("Allocated sliver  P1 for slice=\"" + this.sliceP.urnString + "\" sliver_urn=\"" + String.valueOf(this.urnSliverP1) + "\"");
    }

    @ApiTest.Test(hardDepends={"createTestSliceR"}, softDepends={"testProvisionP"}, groups={"testRenew"})
    public void testAllocateR() throws JFedException, NoSuchAlgorithmException, ParseException {
        this.assertNotNull(this.sliceR);
        String requestRspecR1 = this.commonAMTest.getOneNodeRequestRSpec(this.testedAuthority.getServerForRspecComponentManager(), this.sliceR.urn);
        String requestRspecR2 = this.commonAMTest.getOneNodeRequestRSpec(this.testedAuthority.getServerForRspecComponentManager(), this.sliceR.urn);
        if (requestRspecR1 == null) {
            this.skip("testCreateSliver skipped, because no RSpec example known for type=\"" + this.testedAuthority.getServerForRspecComponentManager().getServerType() + "\"");
        }
        if (requestRspecR2 == null) {
            this.skip("testCreateSliver skipped, because no RSpec example known for type=\"" + this.testedAuthority.getServerForRspecComponentManager().getServerType() + "\"");
        }
        Date expireDate = new Date(System.currentTimeMillis() + 3600000L);
        String endTime = RFC3339Util.dateToRFC3339String((Date)expireDate);
        AbstractGeniAggregateManager.AggregateManagerReply replyR1 = this.am3.allocate(this.getAM3Connection(), this.sliceR.urnString, this.commonAMTest.getSliceCredentialListForAM(this.sliceR), requestRspecR1, endTime, this.commonAMTest.addCredentialExtraOptions(null));
        this.assertEquals(replyR1.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "Allocate R1 did not succeed");
        AggregateManager3.AllocateAndProvisionInfo allocateAndProvisionInfoR1 = (AggregateManager3.AllocateAndProvisionInfo)replyR1.getValue();
        String replyRequestRspecR1 = allocateAndProvisionInfoR1.getRspec();
        this.assertNotNull(replyRequestRspecR1, "Allocate should return an RSpec" + replyRequestRspecR1);
        List sliverInfosR1 = allocateAndProvisionInfoR1.getSliverInfo();
        this.assertEquals(sliverInfosR1.size(), 1, "should be exactly 1 sliver allocated");
        AggregateManager3.SliverInfo sliverInfoR1 = (AggregateManager3.SliverInfo)sliverInfosR1.get(0);
        this.assertEquals(sliverInfoR1.getAllocationStatus(), "geni_allocated", "Allocated sliver should be in geni_allocated state");
        String sliverR1UrnStr = sliverInfoR1.getSliverUrn();
        this.assertNotNull(sliverR1UrnStr);
        this.assertValidUrn(sliverR1UrnStr, "sliver");
        this.urnSliverR1 = new ResourceUrn(sliverR1UrnStr);
        this.note("Allocated sliver  R1 for slice=\"" + this.sliceR.urnString + "\" sliver_urn=\"" + String.valueOf(this.urnSliverR1) + "\"");
        AbstractGeniAggregateManager.AggregateManagerReply replyR2 = this.am3.allocate(this.getAM3Connection(), this.sliceR.urnString, this.commonAMTest.getSliceCredentialListForAM(this.sliceR), requestRspecR2, endTime, this.commonAMTest.addCredentialExtraOptions(null));
        this.assertEquals(replyR2.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "Allocate R2 did not succeed");
        AggregateManager3.AllocateAndProvisionInfo allocateAndProvisionInfoR2 = (AggregateManager3.AllocateAndProvisionInfo)replyR2.getValue();
        String replyRequestRspecR2 = allocateAndProvisionInfoR2.getRspec();
        this.assertNotNull(replyRequestRspecR2, "Allocate should return an RSpec" + replyRequestRspecR2);
        List sliverInfosR2 = allocateAndProvisionInfoR2.getSliverInfo();
        this.assertEquals(sliverInfosR2.size(), 1, "should be exactly 1 sliver allocated");
        AggregateManager3.SliverInfo sliverInfoR2 = (AggregateManager3.SliverInfo)sliverInfosR2.get(0);
        this.assertEquals(sliverInfoR2.getAllocationStatus(), "geni_allocated", "Allocated sliver should be in geni_allocated state");
        String sliverR2UrnStr = sliverInfoR2.getSliverUrn();
        this.assertNotNull(sliverR2UrnStr);
        this.assertValidUrn(sliverR2UrnStr, "sliver");
        this.urnSliverR2 = new ResourceUrn(sliverR2UrnStr);
        this.note("Allocated sliver  R2 for slice=\"" + this.sliceR.urnString + "\" sliver_urn=\"" + String.valueOf(this.urnSliverR2) + "\"");
    }

    @ApiTest.Test(hardDepends={"testAllocateP"}, groups={"testProvision"})
    public void testProvisionP() throws JFedException, NoSuchAlgorithmException, ParseException {
        this.assertNotNull(this.sliceP);
        this.assertNotNull(this.urnSliverP1);
        this.assertNotNull(this.urnSliverP2);
        this.assertNotEmpty(this.urnSliverP2);
        SSHKeyHelper dummyKeys = new SSHKeyHelper();
        ArrayList<String> sshKeys = new ArrayList<String>();
        sshKeys.add(dummyKeys.getSshPublicKeyString());
        UserSpec userSpec = new UserSpec(this.user.getUserUrnString(), sshKeys);
        ArrayList<UserSpec> users = new ArrayList<UserSpec>();
        users.add(userSpec);
        Date expireDate = new Date(System.currentTimeMillis() + 5400000L);
        String endTime = RFC3339Util.dateToRFC3339String((Date)expireDate);
        ArrayList<String> urns = new ArrayList<String>();
        urns.add(this.urnSliverP1.getValue());
        for (ResourceUrn urn : this.urnSliverP2) {
            urns.add(urn.getValue());
        }
        AbstractGeniAggregateManager.AggregateManagerReply replyProvision = this.am3.provision(this.getAM3Connection(), urns, this.commonAMTest.getSliceCredentialListForAM(this.sliceP), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), null, endTime, users, this.commonAMTest.addCredentialExtraOptions(null));
        this.assertNotEquals(replyProvision.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "Provision succeeded, but should have failed");
        AbstractGeniAggregateManager.AggregateManagerReply replyStatus = this.am3.status(this.getAM3Connection(), TestBestEffortAMv3.toStringList(this.sliceP.urnString), this.commonAMTest.getSliceCredentialListForAM(this.sliceP), Boolean.valueOf(true), this.commonAMTest.addCredentialExtraOptions(null));
        this.assertEquals(replyProvision.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED, "Provision failed, but Status should have failed as well");
    }

    @ApiTest.Test(softDepends={"testProvisionP", "testAllocateR", "testAllocateP"}, groups={"testProvision", "testRenew", "testPerformOperationAction"})
    public void testDeleteSliver() throws JFedException {
        if (this.disableCleanup.booleanValue()) {
            this.skip("No cleanup needed.");
        }
        ArrayList<CommonAMTest.SliceInfo> slicesToDelete = new ArrayList<CommonAMTest.SliceInfo>();
        slicesToDelete.add(this.sliceR);
        slicesToDelete.add(this.sliceP);
        slicesToDelete.add(this.sliceOA);
        for (CommonAMTest.SliceInfo slice : slicesToDelete) {
            if (slice == null || slice.urnString == null) {
                this.note("Skipped a Delete because other test created nothing to delete");
                continue;
            }
            this.note("Delete for slice " + slice.urnString);
            try {
                AbstractGeniAggregateManager.AggregateManagerReply reply2 = this.am3.delete(this.getAM3Connection(), TestBestEffortAMv3.toStringList(slice.urnString), this.commonAMTest.getSliceCredentialListForAM(slice), null, this.commonAMTest.addCredentialExtraOptions(null));
                this.testAM3CorrectnessXmlRpcResult(reply2.getRawResult());
                this.assertEquals(reply2.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "DeleteSliver reply GeniResponse code is not SUCCESS (0) when given a slice \"" + slice.urnString + "\" that has a sliver.");
                List sliverInfos = (List)reply2.getValue();
                for (AggregateManager3.SliverInfo sliverInfo : sliverInfos) {
                    String resSliverSUrnStr = sliverInfo.getSliverUrn();
                    this.assertNotNull(resSliverSUrnStr);
                    this.assertValidUrn(resSliverSUrnStr, "sliver");
                    this.assertNotNull(sliverInfo.getAllocationStatus());
                    this.assertEquals(sliverInfo.getAllocationStatus(), "geni_unallocated");
                }
            }
            catch (Exception e) {
                this.errorNonFatal("Something went wrong while deleting: " + e.getMessage());
            }
        }
    }
}

