/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import be.iminds.ilabt.jfed.testing.shared.CommonAMTest;
import be.iminds.ilabt.jfed.ui.commandline.ContextFile;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class TestDelegationOnAggregateManager
extends BaseApiTest<LegacyApiTestConfig> {
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "Delegation or speaksfor credential generation and usage test. This test generates a delegated or speaksfor credentials, and uses it to call ListResources on an AM.";
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("useSpeaksFor");
            res.add("speaksForOptionNames");
            res.add("passwordFilename2");
            res.add("amVersion");
            return res;
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("userUrn2");
            res.add("pemKeyAndCertFilename2");
            res.add("userAuthorityUrn2");
            return res;
        }
    };
    private AggregateManager2 am2;
    private AggregateManager3 am3;
    private CommonAMTest commonAMTestUser1;
    private CommonAMTest commonAMTestUser2;
    private GeniUser secondUser;
    private SfaCredential userCredential1;
    private SfaCredential userCredential2;
    private SfaCredential userCredential2DelegatedToUser1;
    private boolean delegation;
    private List<String> speakForOptionNames;
    private int amVersion = 2;
    private Map versionRawResult = null;
    private AggregateManager2.VersionInfo versionInfo = null;

    @Inject
    public TestDelegationOnAggregateManager(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    public SfaConnection getAMConnectionUser1() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, this.amVersion));
    }

    public SfaConnection getAMConnectionUser2() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.secondUser, this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, this.amVersion));
    }

    private List<AnyCredential> getUser1CredentialList() {
        ArrayList<AnyCredential> res = new ArrayList<AnyCredential>();
        res.add((AnyCredential)this.userCredential1);
        return res;
    }

    private List<AnyCredential> getUser2CredentialList() {
        ArrayList<AnyCredential> res = new ArrayList<AnyCredential>();
        res.add((AnyCredential)this.userCredential2);
        return res;
    }

    private List<AnyCredential> getUser2DelegatedToUser1CredentialList() {
        ArrayList<AnyCredential> res = new ArrayList<AnyCredential>();
        res.add((AnyCredential)this.userCredential2DelegatedToUser1);
        return res;
    }

    @Override
    public void setUp() throws CredentialException {
        Boolean delegationConfigParameter = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).get("useSpeaksFor"));
        if (delegationConfigParameter != null) {
            boolean bl = this.delegation = delegationConfigParameter == false;
            if (this.delegation) {
                this.note("This test will test delegation");
            } else {
                this.note("This test will test speaks-for");
            }
        } else {
            this.delegation = true;
            this.note("This test will test delegation");
        }
        if (((LegacyApiTestConfig)this.getTestConfig()).get("amVersion") != null) {
            this.amVersion = Integer.parseInt(String.valueOf(((LegacyApiTestConfig)this.getTestConfig()).get("amVersion")));
            this.assertTrue(this.amVersion >= 2 && this.amVersion <= 3, "Unsupported AM version: " + this.amVersion);
        }
        this.note("Getting info for 2nd user");
        this.secondUser = null;
        try {
            this.secondUser = new ContextFile(((LegacyApiTestConfig)this.getTestConfig()).getProperties(), this.testbedInfoSource, this.authorityFinder).getUser("2");
        }
        catch (ContextFile.ContextFileException e) {
            throw new RuntimeException("Exception extracting user 2 details from context file", e);
        }
        this.assertNotNull(this.secondUser);
        this.assertNotNull(this.secondUser.getUserAuthorityServerId());
        this.assertNotNull(this.user);
        this.assertNotNull(this.user.getUserAuthorityServerId());
        this.am2 = new AggregateManager2(this.logger, this.getJFedPreferences());
        this.am3 = new AggregateManager3(this.logger, this.getJFedPreferences());
        this.commonAMTestUser1 = new CommonAMTest(this, this.user.getUserAuthorityServerId(), this.getTestbedInfoSource());
        this.commonAMTestUser2 = new CommonAMTest(this, this.secondUser.getUserAuthorityServerId(), this.getTestbedInfoSource());
        if (((LegacyApiTestConfig)this.getTestConfig()).containsKey("speaksForOptionNames")) {
            String speaksForOptionNames = (String)((LegacyApiTestConfig)this.getTestConfig()).get("speaksForOptionNames");
            String[] speaksForOptionNamesArray = speaksForOptionNames.split(",");
            this.speakForOptionNames = new ArrayList<String>();
            for (String speaksForOptionName : speaksForOptionNamesArray) {
                speaksForOptionName = speaksForOptionName.trim();
                this.speakForOptionNames.add(speaksForOptionName);
            }
            this.note("Setting speaksFor option names to use: " + String.valueOf(this.speakForOptionNames));
        } else {
            this.speakForOptionNames = new ArrayList<String>();
            this.speakForOptionNames.add("speaking_for");
            this.speakForOptionNames.add("geni_speaking_for");
            this.note("Using default speaksFor option names to use: " + String.valueOf(this.speakForOptionNames));
        }
    }

    @ApiTest.Test(description="Fetching User 1 Credential.")
    public void getUser1Credential() throws JFedException, CredentialException {
        GeniUser user1 = this.user;
        this.userCredential1 = (SfaCredential)this.commonAMTestUser1.getUserCredentialListForAM();
        this.assertNotNull(this.userCredential1);
        this.note("Credential owner urn:  \"" + this.userCredential1.getOwnerUrn() + "\"");
        this.note("Credential target urn: \"" + this.userCredential1.getTargetUrn() + "\"");
        this.note("Credential type:       \"" + this.userCredential1.getType() + "\"");
        this.note("Credential expires:    \"" + this.userCredential1.getExpires() + "\"");
        this.note("Credential expires (parsed):    \"" + String.valueOf(this.userCredential1.getExpiresDate()) + "\"");
        this.assertTrue(this.userCredential1.check(this.testbedInfoSource));
        this.note("Credential for " + user1.getUserUrnString() + " passed check");
    }

    @ApiTest.Test(description="Fetching User 2 Credential.")
    public void getUser2Credential() throws JFedException, CredentialException {
        this.userCredential2 = (SfaCredential)this.commonAMTestUser2.getUserCredentialListForAM();
        this.assertNotNull(this.userCredential2);
        this.note("Credential owner urn:  \"" + this.userCredential2.getOwnerUrn() + "\"");
        this.note("Credential target urn: \"" + this.userCredential2.getTargetUrn() + "\"");
        this.note("Credential type:       \"" + this.userCredential2.getType() + "\"");
        this.note("Credential expires:    \"" + this.userCredential2.getExpires() + "\"");
        this.note("Credential expires (parsed):    \"" + String.valueOf(this.userCredential2.getExpiresDate()) + "\"");
        this.assertTrue(this.userCredential2.check(this.testbedInfoSource));
        this.note("Credential for " + this.secondUser.getUserUrnString() + " passed check");
    }

    @ApiTest.Test(description="Create delegated or speaksfor credential", hardDepends={"getUser2Credential"})
    public void createDelegatedOrSpeaksForCredential() throws JFedException, CredentialException {
        this.createDelegatedOrSpeaksForCredentialInternal();
    }

    public void createDelegatedOrSpeaksForCredentialInternal() throws JFedException, CredentialException {
        GeniUser user1 = this.user;
        GeniUser user2 = this.secondUser;
        this.assertNotNull(this.userCredential2);
        Date expires = new Date(System.currentTimeMillis() + 86400000L);
        if (this.userCredential2.getExpiresDate() != null && expires.after(this.userCredential2.getExpiresDate())) {
            this.note("original credential expires in less than 24 hours (at " + this.userCredential2.getExpires() + " == " + String.valueOf(this.userCredential2.getExpiresDate()) + "), so using that expire time for the " + (this.delegation ? "delegated" : "speaksfor") + " credential");
            expires = this.userCredential2.getExpiresDate();
        }
        if (this.userCredential2.getExpiresDate() == null) {
            this.note("original credential expires is invalid date. Will create credential that expires in 1 hour");
            expires = new Date(System.currentTimeMillis() + 3600000L);
        }
        if (this.delegation) {
            this.note("Configured to create delegated credential");
            this.userCredential2DelegatedToUser1 = this.userCredential2.delegate(user1.getUserUrnString(), (X509Certificate)user1.getClientCertificateChain().get(0), user2.getPrivateKey(), expires, "*", false);
        } else {
            this.note("Configured to create speaks-for credential");
            this.userCredential2DelegatedToUser1 = SfaCredential.createSpeaksFor((String)user2.getUserUrnString(), (String)user1.getUserUrnString(), (X509Certificate)((X509Certificate)user2.getClientCertificateChain().get(0)), (X509Certificate)((X509Certificate)user1.getClientCertificateChain().get(0)), (PrivateKey)user2.getPrivateKey(), (Date)expires, (String)"*", (boolean)false);
        }
        this.assertNotNull(this.userCredential2DelegatedToUser1);
        this.note("Credential owner urn:  \"" + this.userCredential2DelegatedToUser1.getOwnerUrn() + "\"");
        this.note("Credential target urn: \"" + this.userCredential2DelegatedToUser1.getTargetUrn() + "\"");
        this.note("Credential type:       \"" + this.userCredential2DelegatedToUser1.getType() + "\"");
        this.note("Credential expires:    \"" + this.userCredential2DelegatedToUser1.getExpires() + "\"");
        this.assertTrue(this.userCredential2DelegatedToUser1.check(this.testbedInfoSource));
        this.note("Generated " + (this.delegation ? "delegated" : "speaksfor") + " credential passed check");
    }

    @ApiTest.Test(description="Testing GetVersion as user 1. This call requires no credential.", hardDepends={"createDelegatedOrSpeaksForCredential"})
    public void getVersionUser1() throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.getVersion(this.getAMConnectionUser1());
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "GeniResponse code is not SUCCESS (0)");
        this.versionInfo = (AggregateManager2.VersionInfo)reply.getValue();
        this.assertNotNull(this.versionInfo);
    }

    @ApiTest.Test(description="Testing ListResources as user 2. The (non-delegated and non-speaks-for) user 2 credential is used.", hardDepends={"getVersionUser1"})
    public void listResourcesUser2() throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply reply = null;
        if (this.amVersion == 2) {
            AbstractGeniAggregateManager.AggregateManagerReply am2reply;
            reply = am2reply = this.am2.listResources(this.getAMConnectionUser2(), this.getUser2CredentialList(), "geni", "3", Boolean.valueOf(true), Boolean.valueOf(true), null, null);
        }
        if (this.amVersion == 3) {
            AbstractGeniAggregateManager.AggregateManagerReply am3reply;
            reply = am3reply = this.am3.listResources(this.getAMConnectionUser2(), this.getUser2CredentialList(), "geni", "3", Boolean.valueOf(true), Boolean.valueOf(true), null);
        }
        this.assertNotNull(reply);
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "GeniResponse code is not SUCCESS (0)");
        String rspec = (String)reply.getValue();
        this.assertNotNull(rspec);
    }

    @ApiTest.Test(description="Testing ListResources as user 1 with user 2 delegated or speaksfor credential.", hardDepends={"listResourcesUser2"})
    public void listResourcesDelegatedOrSpeaksFor() throws JFedException {
        this.listResourcesDelegatedOrSpeaksForInternal();
    }

    public void listResourcesDelegatedOrSpeaksForInternal() throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply reply = null;
        if (this.delegation) {
            this.note("Calling ListResource with delegated credential");
            if (this.amVersion == 2) {
                AbstractGeniAggregateManager.AggregateManagerReply am2reply;
                reply = am2reply = this.am2.listResources(this.getAMConnectionUser1(), this.getUser2DelegatedToUser1CredentialList(), "geni", "3", Boolean.valueOf(true), Boolean.valueOf(true), null, null);
            }
            if (this.amVersion == 3) {
                AbstractGeniAggregateManager.AggregateManagerReply am3reply;
                reply = am3reply = this.am3.listResources(this.getAMConnectionUser1(), this.getUser2DelegatedToUser1CredentialList(), "geni", "3", Boolean.valueOf(true), Boolean.valueOf(true), null);
            }
        } else {
            this.note("Calling ListResource with speaks-for credential");
            GeniUser user2 = this.secondUser;
            HashMap<String, String> extraOptions = new HashMap<String, String>();
            for (String speakForOptionName : this.speakForOptionNames) {
                extraOptions.put(speakForOptionName, user2.getUserUrnString());
            }
            List<AnyCredential> credList = this.getUser2DelegatedToUser1CredentialList();
            this.assertNotNull(this.userCredential2);
            credList.add((AnyCredential)this.userCredential2);
            if (this.amVersion == 2) {
                AbstractGeniAggregateManager.AggregateManagerReply am2reply;
                reply = am2reply = this.am2.listResources(this.getAMConnectionUser1(), credList, "geni", "3", Boolean.valueOf(true), Boolean.valueOf(true), null, extraOptions);
            }
            if (this.amVersion == 3) {
                AbstractGeniAggregateManager.AggregateManagerReply am3reply;
                reply = am3reply = this.am3.listResources(this.getAMConnectionUser1(), credList, "geni", "3", Boolean.valueOf(true), Boolean.valueOf(true), extraOptions);
            }
        }
        this.assertNotNull(reply);
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "GeniResponse code is not SUCCESS (0)");
        String rspec = (String)reply.getValue();
        this.assertNotNull(rspec);
    }

    @ApiTest.Test(description="Testing ListResources as user 1 with user 2 delegated or speaksfor credential. Test with different valid expire date formats", hardDepends={"listResourcesUser2"}, softDepends={"listResourcesDelegatedOrSpeaksFor"})
    public void listResourcesDelegatedOrSpeaksForVariousExpireDatesDormats() throws JFedException, CredentialException {
        this.note("All dates used in the credential expires field of this test are normally valid RFC3339");
        SfaCredential.debug_expiredate_forceZinsteadOfZero = false;
        SfaCredential.debug_expiredate_forcezulu = true;
        SfaCredential.debug_expiredate_discardsubsecond = true;
        SfaCredential.debug_expiredate_smalltz = false;
        this.note("Testing with +00:00 instead of Z and SfaCredential.forceZuluTimezone=" + SfaCredential.debug_expiredate_forcezulu + " discardMilliSeconds=" + SfaCredential.debug_expiredate_discardsubsecond + " lowerCase=" + SfaCredential.debug_expiredate_smalltz);
        this.createDelegatedOrSpeaksForCredentialInternal();
        this.listResourcesDelegatedOrSpeaksForInternal();
        SfaCredential.debug_expiredate_forcezulu = false;
        SfaCredential.debug_expiredate_discardsubsecond = false;
        SfaCredential.debug_expiredate_smalltz = true;
        this.note("Testing with SfaCredential.forceZuluTimezone=" + SfaCredential.debug_expiredate_forcezulu + " discardMilliSeconds=" + SfaCredential.debug_expiredate_discardsubsecond + " lowerCase=" + SfaCredential.debug_expiredate_smalltz);
        this.createDelegatedOrSpeaksForCredentialInternal();
        this.listResourcesDelegatedOrSpeaksForInternal();
        SfaCredential.debug_expiredate_forcezulu = false;
        SfaCredential.debug_expiredate_discardsubsecond = true;
        SfaCredential.debug_expiredate_smalltz = false;
        this.note("Testing with SfaCredential.forceZuluTimezone=" + SfaCredential.debug_expiredate_forcezulu + " discardMilliSeconds=" + SfaCredential.debug_expiredate_discardsubsecond + " lowerCase=" + SfaCredential.debug_expiredate_smalltz);
        this.createDelegatedOrSpeaksForCredentialInternal();
        this.listResourcesDelegatedOrSpeaksForInternal();
        SfaCredential.debug_expiredate_forcezulu = true;
        SfaCredential.debug_expiredate_discardsubsecond = false;
        SfaCredential.debug_expiredate_smalltz = false;
        this.note("Testing with SfaCredential.forceZuluTimezone=" + SfaCredential.debug_expiredate_forcezulu + " discardMilliSeconds=" + SfaCredential.debug_expiredate_discardsubsecond + " lowerCase=" + SfaCredential.debug_expiredate_smalltz);
        this.createDelegatedOrSpeaksForCredentialInternal();
        this.listResourcesDelegatedOrSpeaksForInternal();
        SfaCredential.debug_expiredate_forcezulu = true;
        SfaCredential.debug_expiredate_discardsubsecond = true;
        SfaCredential.debug_expiredate_smalltz = true;
        this.note("Testing with SfaCredential.forceZuluTimezone=" + SfaCredential.debug_expiredate_forcezulu + " discardMilliSeconds=" + SfaCredential.debug_expiredate_discardsubsecond + " lowerCase=" + SfaCredential.debug_expiredate_smalltz);
        this.createDelegatedOrSpeaksForCredentialInternal();
        this.listResourcesDelegatedOrSpeaksForInternal();
        SfaCredential.debug_expiredate_forcezulu = true;
        SfaCredential.debug_expiredate_discardsubsecond = false;
        SfaCredential.debug_expiredate_smalltz = true;
        this.note("Testing with SfaCredential.forceZuluTimezone=" + SfaCredential.debug_expiredate_forcezulu + " discardMilliSeconds=" + SfaCredential.debug_expiredate_discardsubsecond + " lowerCase=" + SfaCredential.debug_expiredate_smalltz);
        this.createDelegatedOrSpeaksForCredentialInternal();
        this.listResourcesDelegatedOrSpeaksForInternal();
        SfaCredential.debug_expiredate_forcezulu = false;
        SfaCredential.debug_expiredate_discardsubsecond = true;
        SfaCredential.debug_expiredate_smalltz = true;
        this.note("Testing with SfaCredential.forceZuluTimezone=" + SfaCredential.debug_expiredate_forcezulu + " discardMilliSeconds=" + SfaCredential.debug_expiredate_discardsubsecond + " lowerCase=" + SfaCredential.debug_expiredate_smalltz);
        this.createDelegatedOrSpeaksForCredentialInternal();
        this.listResourcesDelegatedOrSpeaksForInternal();
        SfaCredential.debug_expiredate_forcezulu = false;
        SfaCredential.debug_expiredate_discardsubsecond = false;
        SfaCredential.debug_expiredate_smalltz = false;
        this.note("Testing with SfaCredential.forceZuluTimezone=" + SfaCredential.debug_expiredate_forcezulu + " discardMilliSeconds=" + SfaCredential.debug_expiredate_discardsubsecond + " lowerCase=" + SfaCredential.debug_expiredate_smalltz);
        this.createDelegatedOrSpeaksForCredentialInternal();
        this.listResourcesDelegatedOrSpeaksForInternal();
        SfaCredential.debug_expiredate_forceZinsteadOfZero = true;
        SfaCredential.debug_expiredate_forcezulu = true;
        SfaCredential.debug_expiredate_discardsubsecond = true;
        SfaCredential.debug_expiredate_smalltz = false;
    }
}

