/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi1;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi1;
import be.iminds.ilabt.jfed.lowlevel.api.ProtogeniSliceAuthority;
import be.iminds.ilabt.jfed.lowlevel.api.test.AbstractFederationApi1Test;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import be.iminds.ilabt.jfed.testing.shared.CommonAMTest;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class TestFederationSliceAuthority1
extends AbstractFederationApi1Test {
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "Test Uniform Federation API Slice Authority";
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            ArrayList<String> res = new ArrayList<String>();
            return res;
        }
    };
    private FederationSliceAuthorityApi1 sa;
    private FederationMemberAuthorityApi1 ma;
    final List<String> sliceDefaultFieldNames = new ArrayList<String>();
    List<AbstractFederationApi.GetVersionResult.FieldInfo> sliceDefaultFields = new ArrayList<AbstractFederationApi.GetVersionResult.FieldInfo>();
    final List<String> projectDefaultFieldNames = new ArrayList<String>();
    List<AbstractFederationApi.GetVersionResult.FieldInfo> projectDefaultFields = new ArrayList<AbstractFederationApi.GetVersionResult.FieldInfo>();
    private boolean hasSliceMemberService = false;
    private boolean hasSliverInfoService = false;
    private boolean hasProjectService = false;
    private boolean hasProjectMemberService = false;
    private List<String> allRoles;
    AnyCredential maTestUserCredential;
    List<AnyCredential> maTestUserCredentialList;
    HashMap<String, Object> aggregatedUserInfo;
    AnyCredential testUserCredential;
    List<AnyCredential> testUserCredentialList;
    private String sliceName;
    private GeniUrn sliceUrn;
    private Map<String, Object> sliceCreationDetails;
    private static final String initialSliceDescription = "test slice used in automated testing";
    private static final Date initialRequestedSliceExpiration = new Date(System.currentTimeMillis() + 0x6DDD00L);
    private List<AnyCredential> sliceCredentials;
    private static final String updatedSliceDescription = "test slice used in automated testing with updated description";
    private static final Date requestedRenewedSliceExpiration = new Date(initialRequestedSliceExpiration.getTime() + 14400000L);
    private String lookupSliceMembersRole;
    private String projectName;
    private GeniUrn projectUrn;
    private Map<String, Object> projectCreationDetails;
    private static final String initialProjectDescription = "test project used in automated testing";
    private static final String updatedProjectDescription = "test project used in automated testing with updated description";
    private String lookupProjectMembersRole;

    @Inject
    public TestFederationSliceAuthority1(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    public SfaConnection getSAConnection() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_SA, 1));
    }

    public SfaConnection getMAConnection() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 1));
    }

    @Override
    public void setUp() {
        this.sa = new FederationSliceAuthorityApi1(this.logger, this.getJFedPreferences());
        this.ma = new FederationMemberAuthorityApi1(this.logger, this.getJFedPreferences());
        this.sa.setHandleMalformedReplies(false);
        this.ma.setHandleMalformedReplies(false);
        this.sliceDefaultFields = this.sa.getMinimumFields("SLICE");
        this.projectDefaultFields = this.sa.getMinimumFields("PROJECT");
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.sliceDefaultFields) {
            this.sliceDefaultFieldNames.add(fi.getName());
        }
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.projectDefaultFields) {
            this.projectDefaultFieldNames.add(fi.getName());
        }
    }

    @ApiTest.Test
    public void getVersion() throws JFedException {
        AbstractFederationApi.FederationApiReply reply = this.sa.getVersion(this.getSAConnection());
        this.checkGetVersion((AbstractFederationApi.FederationApiReply<? extends AbstractFederationApi.GetVersionResult>)reply, (AbstractFederationApi)this.sa, true);
        Map<String, Object> htRes = this.assertStringObjectMap(reply.getRawValue());
        List services = this.assertMapContainsList(htRes, "SERVICES");
        if (services != null) {
            this.hasSliceMemberService = services.contains("SLICE_MEMBER");
            this.hasSliverInfoService = services.contains("SLIVER_INFO");
            this.hasProjectService = services.contains("PROJECT");
            this.hasProjectMemberService = services.contains("PROJECT_MEMBER");
        }
        this.allRoles = ((FederationSliceAuthorityApi1.GetVersionSAResult)reply.getValue()).getRoles();
        this.warnIfNot(this.allRoles.size() > 0, "No roles are defined in get_version");
    }

    @ApiTest.Test(softDepends={"getVersion"})
    public void getTestUserCredential() throws JFedException {
        GeniUrn testUserUrn = GeniUrn.parse((String)this.user.getUserUrnString());
        this.assertNotNull(testUserUrn, "Error in test user urn: " + this.user.getUserUrnString());
        AbstractFederationApi.FederationApiReply reply = this.ma.getCredentials(this.getMAConnection(), new ArrayList(), testUserUrn, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        List testUserCreds = (List)reply.getValue();
        this.assertNotNull(testUserCreds, "no credential returned");
        this.assertNotEmpty(testUserCreds, "empty list of credentials returned. Expecting a list with credentials, but got  " + (String)(reply.getRawValue() == null ? "null" : (reply.getRawValue() instanceof Object[] ? "a list: " + String.valueOf(reply.getRawValue()) : "something of class:" + reply.getRawValue().getClass().getName())));
        this.maTestUserCredentialList = new ArrayList<AnyCredential>(testUserCreds);
        this.maTestUserCredential = (AnyCredential)testUserCreds.get(0);
    }

    @ApiTest.Test(softDepends={"getTestUserCredential"}, description="Some methods might require user info, so we try to fetch all user info here. Any failure here is not a failure of the SA, but a failure in the MA.")
    public void getTestUserInfo() throws JFedException {
        Map<String, Object> partialUserInfo;
        GeniUrn testUserUrn = GeniUrn.parse((String)this.user.getUserUrnString());
        this.assertNotNull(testUserUrn, "Error in test user urn: " + this.user.getUserUrnString());
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("MEMBER_URN", testUserUrn.getValue());
        this.aggregatedUserInfo = new HashMap();
        this.setErrorsNotFatal();
        AbstractFederationApi.FederationApiReply reply = this.ma.lookupPublicMemberInfo(this.getMAConnection(), this.maTestUserCredentialList, match, null, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        Map<String, Object> rawHt = this.assertStringObjectMap(reply.getRawValue());
        if (rawHt != null && (partialUserInfo = this.assertStringObjectMap(rawHt.get(testUserUrn.getValue()))) != null) {
            this.aggregatedUserInfo.putAll(partialUserInfo);
        }
        reply = this.ma.lookupIdentifyingMemberInfo(this.getMAConnection(), this.maTestUserCredentialList, match, null, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        rawHt = this.assertStringObjectMap(reply.getRawValue());
        if (rawHt != null && (partialUserInfo = this.assertStringObjectMap(rawHt.get(testUserUrn.getValue()))) != null) {
            this.aggregatedUserInfo.putAll(partialUserInfo);
        }
        reply = this.ma.lookupPrivateMemberInfo(this.getMAConnection(), this.maTestUserCredentialList, match, null, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        rawHt = this.assertStringObjectMap(reply.getRawValue());
        if (rawHt != null && (partialUserInfo = this.assertStringObjectMap(rawHt.get(testUserUrn.getValue()))) != null) {
            this.aggregatedUserInfo.putAll(partialUserInfo);
        }
        this.note("All retrieved user info fields: " + String.valueOf(this.aggregatedUserInfo.keySet()));
        this.setErrorsFatal();
    }

    @ApiTest.Test(softDepends={"getTestUserCredential"}, description="Get A Credential for the test user. If the MA get_credential call did not work, this will try to fall back to the old PROTOGENI_SA API.")
    public void retrieveCredentialSomehow() throws JFedException {
        if (this.maTestUserCredentialList != null && this.maTestUserCredential != null) {
            this.testUserCredential = this.maTestUserCredential;
            this.testUserCredentialList = this.maTestUserCredentialList;
        } else if (!ApiInfo.hasService((Server)this.user.getUserAuthorityServer(), (ApiInfo.Api)new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1))) {
            this.errorFatal("The Uniform Federation API Member Authority get_credential call failed to provide a credential. additionally, the test user authority does not have a PROTOGENI_SA available as fallback. => Cannot retrieve a credential for the test user.");
        } else {
            this.note("The Uniform Federation API Member Authority get_credential call failed to provide a credential: Falling back to the PROTOGENI_SA API to retrieve a credential for the remaining tests.");
            SfaConnection protogeniSaCon = (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.user.getUserAuthorityServer(), new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1));
            ProtogeniSliceAuthority protogeniSa = new ProtogeniSliceAuthority(this.logger, this.getJFedPreferences());
            ProtogeniSliceAuthority.SliceAuthorityReply pgSaReply = protogeniSa.getCredential(protogeniSaCon);
            this.assertTrue(pgSaReply.getGeniResponseCode().isSuccess());
            AnyCredential pgCred = (AnyCredential)pgSaReply.getValue();
            this.assertNotNull(pgCred, "no credential returned by protogeni SA");
            this.testUserCredentialList = new ArrayList<AnyCredential>();
            this.testUserCredentialList.add(pgCred);
            this.testUserCredential = pgCred;
        }
    }

    @ApiTest.Test(hardDepends={"retrieveCredentialSomehow"}, softDepends={"getVersion", "createProject", "getTestUserInfo"})
    public void createSlice() throws JFedException, ParseException {
        this.sliceName = CommonAMTest.createSliceName(this, this.user.getUserAuthorityServer(), ApiInfo.getDefaultComponentManagerForEach((Server)this.testedAuthority.getServerForRspecComponentManager()), "S", 3, null);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("SLICE_EXPIRATION", RFC3339Util.dateToRFC3339String((Date)initialRequestedSliceExpiration, (boolean)true, (boolean)true, (boolean)true));
        fields.put("SLICE_DESCRIPTION", initialSliceDescription);
        if (this.hasProjectService) {
            fields.put("SLICE_PROJECT_URN", this.projectUrn.getValue());
        }
        if (this.getVersionResult != null && this.getVersionResult.getFieldsForObject("PROJECT").containsKey("_GENI_SLICE_EMAIL")) {
            if (this.aggregatedUserInfo != null && this.aggregatedUserInfo.containsKey("MEMBER_EMAIL")) {
                fields.put("_GENI_SLICE_EMAIL", String.valueOf(this.aggregatedUserInfo.get("MEMBER_EMAIL")));
            } else {
                this.warn("create_slice requires the field _GENI_SLICE_EMAIL, but the current user's EMAIL is unknown. (the value 'dummy@example.com' will be used, but will likely cause problems)");
                fields.put("_GENI_SLICE_EMAIL", "dummy@example.com");
            }
        }
        this.addRequiredSupplementaryFieldsToCreate(fields, "SLICE");
        AbstractFederationApi.FederationApiReply reply = this.sa.createSlice(this.getSAConnection(), this.testUserCredentialList, this.sliceName, fields, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        this.sliceCreationDetails = this.assertStringObjectMap(reply.getRawValue());
        this.assertNotNull(this.sliceCreationDetails);
        this.note("slice details contains the following fields: " + String.valueOf(this.sliceCreationDetails.keySet()));
        this.setErrorsNotFatal();
        this.assertMapContainsString(this.sliceCreationDetails, "SLICE_URN");
        String replySliceUrn = (String)this.sliceCreationDetails.get("SLICE_URN");
        this.note("SLICE_URN of created slice: \"" + replySliceUrn + "\"");
        this.sliceUrn = GeniUrn.parse((String)replySliceUrn);
        this.assertNotNull(this.sliceUrn, "SLICE_URN value \"" + replySliceUrn + "\" is not a valid urn");
        this.assertEquals(this.sliceUrn.getEncodedResourceType(), "slice", "SLICE_URN is not a slice urn, but is of type " + this.sliceUrn.getEncodedResourceType());
        this.assertEquals(this.sliceUrn.getEncodedResourceName(), this.sliceName, "SLICE_URN does not have the requested name \"" + this.sliceName + "\", but has name " + this.sliceUrn.getEncodedResourceName());
        this.warnIfNot(this.sliceUrn.getEncodedTopLevelAuthority().startsWith(this.testedAuthority.getServerToConnect().getUrnTld()), "SLICE_URN top level authority is unexpected (expected \"" + this.testedAuthority.getServerToConnect().getUrnTld() + "\" or subauthority): " + this.sliceUrn.getEncodedTopLevelAuthority());
        Object expirationObject = this.sliceCreationDetails.get("SLICE_EXPIRATION");
        this.assertNotNull(expirationObject, "slice creation result Map does not contain key \"SLICE_EXPIRATION\"");
        if (!(expirationObject instanceof Date) && !(expirationObject instanceof String)) {
            this.errorNonFatal("slice creation result Map value for \"SLICE_EXPIRATION\" is not a Date or String but a " + expirationObject.getClass().getName());
        }
        this.setErrorsFatal();
        String receivedSliceExpirationString = (String)expirationObject;
        Date receivedSliceExpirationDate = null;
        try {
            receivedSliceExpirationDate = RFC3339Util.rfc3339StringToDate((String)receivedSliceExpirationString);
            this.setErrorsNotFatal();
            this.assertTrue(receivedSliceExpirationDate.equals(initialRequestedSliceExpiration) || receivedSliceExpirationDate.after(initialRequestedSliceExpiration), "received SLICE_EXPIRATION (" + receivedSliceExpirationString + ") is unexpected given requested SLICE_EXPIRATION (" + RFC3339Util.dateToRFC3339String((Date)initialRequestedSliceExpiration, (boolean)true, (boolean)true, (boolean)true) + ")");
            this.setErrorsFatal();
        }
        catch (ParseException e) {
            this.warn("The returned SLICE_EXPIRATION is NOT a valid RFC3339 date: \"" + receivedSliceExpirationString + "\"");
        }
        Object creationSliceCredentialString = this.sliceCreationDetails.get("SLICE_CREDENTIAL");
        if (creationSliceCredentialString != null) {
            this.warn("Creating the slice returned a SLICE_CREDENTIAL. This field name is not prefixed with an underscore and is not in the API yet. If it is added, it should probably be of type CREDENTIAL (a list of dictionaries) and not a STRING. Otherwise, the type of credential is not known.");
        }
    }

    @ApiTest.Test(hardDepends={"createSlice"})
    public void getSliceCredentials() throws JFedException {
        AbstractFederationApi.FederationApiReply reply = this.sa.getSliceCredentials(this.getSAConnection(), this.testUserCredentialList, this.sliceUrn, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        this.sliceCredentials = (List)reply.getValue();
        this.assertNotNull(this.sliceCredentials);
        this.assertNotEmpty(this.sliceCredentials);
    }

    private void checkSliceLookupResult(AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceInfoList> reply, List<String> expectedFieldNames, List<String> excludedFieldNames) {
        Map<String, Object> lookupRes = this.assertStringObjectMap(reply.getRawValue());
        this.checkCorrectnessXmlRpcResult(reply);
        this.checkLookupCorrectness(reply);
        this.assertNotNull(lookupRes);
        this.assertTrue(lookupRes.size() > 0, "Lookup result is empty for slice urn: " + this.sliceUrn.getValue());
        this.errorNonFatalIfNot(lookupRes.size() == 1, "lookup must return one slice, but it returned " + lookupRes.size());
        Map<String, Object> rawUser = this.assertStringObjectMap(lookupRes.get(this.sliceUrn.getValue()));
        this.errorNonFatalIfNot(rawUser != null, "lookup must return requested slice (" + this.sliceUrn.getValue() + ") but returned null.");
        String rawUrn = (String)rawUser.get("SLICE_URN");
        if (rawUrn != null && !Objects.equals(this.sliceUrn.getValue(), rawUrn)) {
            this.errorNonFatal("lookup must return requested slice (" + this.sliceUrn.getValue() + "), and it did, however its returned SLICE_URN entry is not matching: " + rawUrn);
        }
        for (Object sliceInfo : lookupRes.values()) {
            Map<String, Object> rawSliceInfo = this.assertStringObjectMap(sliceInfo);
            for (String fieldName : expectedFieldNames) {
                if (rawSliceInfo.containsKey(fieldName)) continue;
                this.errorNonFatal("returned result does not contain field: \"" + fieldName + "\"");
            }
            for (String fieldName : excludedFieldNames) {
                if (!rawSliceInfo.containsKey(fieldName)) continue;
                this.errorNonFatal("returned result contains unexpected field: \"" + fieldName + "\"");
            }
        }
    }

    @ApiTest.Test(hardDepends={"getSliceCredentials"})
    public void lookupSlicesNoFilter() throws JFedException {
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("SLICE_URN", this.sliceUrn.getValue());
        this.note("looking up slice by SLICE_URN: " + this.sliceUrn.getValue());
        AbstractFederationApi.FederationApiReply reply = this.sa.lookupSlices(this.getSAConnection(), this.sliceCredentials, match, null, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.sliceDefaultFields) {
            if (!this.hasProjectService && Objects.equals(fi.getName(), "SLICE_PROJECT_URN")) continue;
            expectedFieldNames.add(fi.getName());
        }
        this.note("No filter provided, so expecting all fields to be returned: " + String.valueOf(expectedFieldNames));
        this.checkSliceLookupResult((AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceInfoList>)reply, expectedFieldNames, excludedFieldNames);
        Map<String, Object> rawHt = this.assertStringObjectMap(reply.getRawValue());
        if (rawHt != null) {
            Map<String, Object> sliceHt = this.assertStringObjectMap(rawHt.get(this.sliceUrn.getValue()));
            String desc = this.assertMapContainsNonemptyString(sliceHt, "SLICE_DESCRIPTION");
            this.assertEquals(desc, initialSliceDescription);
        }
    }

    @ApiTest.Test(hardDepends={"getSliceCredentials"}, softDepends={"lookupSlicesNoFilter"})
    public void updateSlice() throws JFedException {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("SLICE_DESCRIPTION", updatedSliceDescription);
        AbstractFederationApi.FederationApiReply reply = this.sa.updateSlice(this.getSAConnection(), this.sliceCredentials, this.sliceUrn, fields, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
    }

    @ApiTest.Test(hardDepends={"updateSlice"})
    public void lookupSlicesNoFilterAfterUpdate() throws JFedException {
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("SLICE_URN", this.sliceUrn.getValue());
        this.note("looking up slice by SLICE_URN: " + this.sliceUrn.getValue());
        AbstractFederationApi.FederationApiReply reply = this.sa.lookupSlices(this.getSAConnection(), this.sliceCredentials, match, null, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.sliceDefaultFields) {
            if (!this.hasProjectService && Objects.equals(fi.getName(), "SLICE_PROJECT_URN")) continue;
            expectedFieldNames.add(fi.getName());
        }
        this.note("No filter provided, so expecting all fields to be returned: " + String.valueOf(expectedFieldNames));
        this.checkSliceLookupResult((AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceInfoList>)reply, expectedFieldNames, excludedFieldNames);
        Map<String, Object> rawHt = this.assertStringObjectMap(reply.getRawValue());
        if (rawHt != null) {
            Map<String, Object> sliceHt = this.assertStringObjectMap(rawHt.get(this.sliceUrn.getValue()));
            String desc = this.assertMapContainsNonemptyString(sliceHt, "SLICE_DESCRIPTION");
            this.assertEquals(desc, updatedSliceDescription);
        }
    }

    @ApiTest.Test(hardDepends={"getSliceCredentials"}, softDepends={"lookupSlicesNoFilter"})
    public void renewSlice() throws JFedException {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("SLICE_EXPIRATION", RFC3339Util.dateToRFC3339String((Date)requestedRenewedSliceExpiration, (boolean)true, (boolean)true, (boolean)true));
        AbstractFederationApi.FederationApiReply reply = this.sa.updateSlice(this.getSAConnection(), this.sliceCredentials, this.sliceUrn, fields, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
    }

    @ApiTest.Test(hardDepends={"renewSlice"})
    public void lookupSlicesNoFilterAfterRenew() throws JFedException, ParseException {
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("SLICE_URN", this.sliceUrn.getValue());
        this.note("looking up slice by SLICE_URN: " + this.sliceUrn.getValue());
        AbstractFederationApi.FederationApiReply reply = this.sa.lookupSlices(this.getSAConnection(), this.sliceCredentials, match, null, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.sliceDefaultFields) {
            if (!this.hasProjectService && Objects.equals(fi.getName(), "SLICE_PROJECT_URN")) continue;
            expectedFieldNames.add(fi.getName());
        }
        this.note("No filter provided, so expecting all fields to be returned: " + String.valueOf(expectedFieldNames));
        this.checkSliceLookupResult((AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceInfoList>)reply, expectedFieldNames, excludedFieldNames);
        Map<String, Object> rawHt = this.assertStringObjectMap(reply.getRawValue());
        Map<String, Object> stringHt = this.assertStringObjectMap(rawHt.get(this.sliceUrn.getValue()));
        String expirationString = this.assertMapContainsNonemptyString(stringHt, "SLICE_EXPIRATION");
        try {
            Date receivedSliceExpiration = RFC3339Util.rfc3339StringToDate((String)expirationString);
            this.assertTrue(receivedSliceExpiration.equals(requestedRenewedSliceExpiration) || receivedSliceExpiration.after(requestedRenewedSliceExpiration), "received SLICE_EXPIRATION (" + String.valueOf(requestedRenewedSliceExpiration) + ") is unexpected given requested renew SLICE_EXPIRATION (" + RFC3339Util.dateToRFC3339String((Date)requestedRenewedSliceExpiration, (boolean)true, (boolean)true, (boolean)true) + ")");
        }
        catch (ParseException e) {
            this.errorNonFatal("The returned SLICE_EXPIRATION is NOT a valid RFC3339 date: \"" + expirationString + "\"");
        }
    }

    @ApiTest.Test(hardDepends={"createSlice", "getSliceCredentials"}, softDepends={"lookupSlicesNoFilterAfterUpdate"})
    public void lookupSliceMembers() throws JFedException {
        if (!this.hasSliceMemberService) {
            this.skip("No SLICE_MEMBER service advertised in get_version");
        }
        AbstractFederationApi.FederationApiReply reply = this.sa.lookupSliceMembers(this.getSAConnection(), this.sliceUrn, this.sliceCredentials, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        List memberTuples = (List)reply.getValue();
        this.assertNotNull(memberTuples);
        this.assertNotEmpty(memberTuples);
        this.assertTrue(memberTuples.size() == 1, "More than 1 member in slice: " + String.valueOf(memberTuples));
        FederationSliceAuthorityApi1.UrnRoleTuple memberTuple = (FederationSliceAuthorityApi1.UrnRoleTuple)memberTuples.get(0);
        this.assertEquals(memberTuple.urn.getValue(), this.user.getUserUrnString(), "Expected slice member to be " + this.user.getUserUrnString() + " but it was " + memberTuple.urn.getValue());
        this.note("test user role in slice is: " + memberTuple.role);
        this.assertNotNull(memberTuple.role, "member role is null in slice");
        this.lookupSliceMembersRole = memberTuple.role;
    }

    @ApiTest.Test(hardDepends={"createSlice"}, softDepends={"lookupSliceMembers"})
    public void lookupSlicesForMember() throws JFedException {
        if (!this.hasSliceMemberService) {
            this.skip("No SLICE_MEMBER service advertised in get_version");
        }
        GeniUrn memberUrn = GeniUrn.parse((String)this.user.getUserUrnString());
        this.assertNotNull(memberUrn);
        AbstractFederationApi.FederationApiReply reply = this.sa.lookupSlicesForMember(this.getSAConnection(), memberUrn, this.testUserCredentialList, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        List value = (List)reply.getValue();
        this.assertNotNull(value);
        this.assertNotEmpty(value);
        this.assertTrue(value.size() >= 1, "should have been at least 1 slice for " + String.valueOf(memberUrn));
        this.note("Slice urns for member " + String.valueOf(memberUrn) + ": " + String.valueOf(value));
        String role = null;
        for (FederationSliceAuthorityApi1.UrnRoleTuple tuple : value) {
            if (tuple.getUrn().getEncodedTopLevelAuthority().startsWith(this.sliceUrn.getEncodedTopLevelAuthority()) && Objects.equals(tuple.getUrn().getEncodedResourceName(), this.sliceUrn.getEncodedResourceName()) && Objects.equals(tuple.getUrn().getEncodedResourceType(), "slice")) {
                role = tuple.getRole();
            }
            this.assertEquals(tuple.getUrn().getEncodedResourceType(), "slice", "The returned URN is not a slice urn but is of type: \"" + tuple.getUrn().getEncodedResourceType() + "\"");
        }
        this.assertNotNull(role, "slice \"" + String.valueOf(this.sliceUrn) + "\" was not listed as slice for member \"" + String.valueOf(memberUrn) + "\". Full result: " + String.valueOf(value));
        if (this.lookupSliceMembersRole != null) {
            this.assertEquals(role, this.lookupSliceMembersRole, "A different role was returned for \"" + String.valueOf(memberUrn) + "\" in " + String.valueOf(this.sliceUrn) + " for the lookup_slices_for_members and lookup_slice_members calls");
        }
    }

    @ApiTest.Test(hardDepends={"getVersion", "createSlice", "lookupSliceMembers"}, softDepends={"lookupSlicesForMember"})
    public void modifySliceMembership() throws JFedException {
        this.assertNotNull(this.allRoles, "get_version test did not set allRoles");
        this.assertNotNull(this.lookupSliceMembersRole, "lookupSliceMembersRole not set in lookupSliceMembers");
        if (!this.hasSliceMemberService) {
            this.skip("No SLICE_MEMBER service advertised in get_version");
        }
        ArrayList membersToAdd = new ArrayList();
        ArrayList membersToRemove = new ArrayList();
        ArrayList<FederationSliceAuthorityApi1.UrnRoleTuple> membersToChange = new ArrayList<FederationSliceAuthorityApi1.UrnRoleTuple>();
        if (this.allRoles.size() <= 1) {
            this.skip("server does not have multiple roles: cannot test modify_slice_membership");
        }
        String newRole = this.allRoles.get(0);
        String oldRole = this.lookupSliceMembersRole;
        if (this.allRoles.contains("USER") && !Objects.equals(oldRole, "USER")) {
            newRole = "USER";
        }
        if (this.allRoles.contains("MEMBER") && !Objects.equals(oldRole, "MEMBER")) {
            newRole = "MEMBER";
        }
        for (int i = 1; Objects.equals(newRole, oldRole) && i < this.allRoles.size(); ++i) {
            newRole = this.allRoles.get(i);
        }
        this.assertNotEquals(newRole, oldRole, "roles defined in get_version do not differ: oldRole=" + oldRole + " allRoles=" + String.valueOf(this.allRoles));
        membersToChange.add(new FederationSliceAuthorityApi1.UrnRoleTuple(this.user.getUserUrn(), newRole));
        this.note("Wil ltry to change role of member \"" + this.user.getUserUrnString() + "\" in slice \"" + String.valueOf(this.sliceUrn) + "\" from \"" + oldRole + "\" to \"" + newRole + "\"");
        AbstractFederationApi.FederationApiReply reply1 = this.sa.modifySliceMembership(this.getSAConnection(), this.sliceUrn, membersToAdd, membersToRemove, membersToChange, this.testUserCredentialList, null);
        this.checkCorrectnessXmlRpcResult(reply1);
        this.assertTrue(reply1.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply1.getGeniResponseCode()));
        AbstractFederationApi.FederationApiReply reply2 = this.sa.lookupSliceMembers(this.getSAConnection(), this.sliceUrn, this.testUserCredentialList, null);
        this.assertTrue(reply2.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply2.getGeniResponseCode()));
        List memberTuples = (List)reply2.getValue();
        this.assertNotNull(memberTuples);
        this.assertNotEmpty(memberTuples);
        this.assertTrue(memberTuples.size() == 1, "Expected exactly 1 member in slice: " + String.valueOf(memberTuples));
        FederationSliceAuthorityApi1.UrnRoleTuple memberTuple = (FederationSliceAuthorityApi1.UrnRoleTuple)memberTuples.get(0);
        this.assertEquals(memberTuple.urn.getValue(), this.user.getUserUrnString(), "Expected slice member to be " + this.user.getUserUrnString() + " but it was " + memberTuple.urn.getValue());
        this.note("test user role in slice is: " + memberTuple.role);
        this.assertNotNull(memberTuple.role, "member role is null in slice");
        this.assertEquals(memberTuple.role, newRole, "member role differs from newly assigned role");
        this.lookupSliceMembersRole = memberTuple.role;
    }

    @ApiTest.Test(hardDepends={"retrieveCredentialSomehow", "createSlice"}, softDepends={"lookupSlicesNoFilterAfterUpdate", "lookupSlicesForMember", "lookupSliceMembers", "modifySliceMembership"})
    public void lookupSliverInfoNoFilter() throws JFedException {
        if (!this.hasSliverInfoService) {
            this.skip("No SLIVER_INFO service advertised in get_version");
        }
        HashMap match = new HashMap();
        AbstractFederationApi.FederationApiReply reply = this.sa.lookupSliverInfo(this.getSAConnection(), this.testUserCredentialList, this.sliceUrn, match, null, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        this.checkLookupCorrectness(reply);
        AbstractFederationApi.SliverInfoList lookupRes = (AbstractFederationApi.SliverInfoList)reply.getValue();
        this.assertNotNull(lookupRes);
        this.assertTrue(lookupRes.size() == 0);
        this.note("This test just checks that there are no slivers in the created slice. Nothing else is currently tested for SLIVER_INFO");
    }

    @ApiTest.Test(hardDepends={"retrieveCredentialSomehow"}, softDepends={"getVersion", "getTestUserInfo"})
    public void createProject() throws JFedException {
        if (!this.hasProjectService) {
            this.skip("No PROJECT service advertised in get_version");
        }
        this.projectName = "P" + System.currentTimeMillis();
        this.projectUrn = GeniUrn.createGeniUrnFromEncodedParts((String)this.testedAuthority.getServerToConnect().getUrnTld(), (String)"project", (String)this.projectName);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("PROJECT_DESCRIPTION", initialProjectDescription);
        fields.put("PROJECT_EXPIRATION", RFC3339Util.dateToRFC3339String((Date)new Date(System.currentTimeMillis() + 10800000L), (boolean)true, (boolean)true, (boolean)true));
        if (this.getVersionResult == null) {
            this.warn("get_version result is unknown to this test method. Cannot add any required supplemental fields.");
        } else {
            if (this.getVersionResult.getFields() == null) {
                this.warn("getVersionResult fieldInfos map is null. Bug in jFed?");
            } else {
                this.note("All Required supplemental fields: " + String.valueOf(this.getVersionResult.getFields().keySet()));
            }
            if (this.getVersionResult.getFieldsForObject("PROJECT") == null) {
                this.warn("getVersionResult fieldInfos map is null when called with getFieldsForObject(\"PROJECT\"). Bug in jFed?");
            } else {
                this.note("Required supplemental fields for PROJECT are: " + String.valueOf(this.getVersionResult.getFieldsForObject("PROJECT").keySet()));
            }
        }
        if (this.getVersionResult != null && this.getVersionResult.getFieldsForObject("PROJECT") != null) {
            if (this.getVersionResult.getFieldsForObject("PROJECT").containsKey("_GENI_PROJECT_EMAIL")) {
                this.note("get_version contains supplementary field _GENI_PROJECT_EMAIL. Will fill in user email.");
                if (this.aggregatedUserInfo != null && this.aggregatedUserInfo.containsKey("MEMBER_EMAIL")) {
                    fields.put("_GENI_PROJECT_EMAIL", String.valueOf(this.aggregatedUserInfo.get("MEMBER_EMAIL")));
                } else {
                    this.warn("create_project requires the field _GENI_PROJECT_EMAIL, but the current users EMAIL is unknown. (the value 'dummy@example.com' will be used, but will likely cause problems)");
                    fields.put("_GENI_PROJECT_EMAIL", "dummy@example.com");
                }
            }
            if (this.getVersionResult.getFieldsForObject("PROJECT").containsKey("_GENI_PROJECT_OWNER")) {
                this.note("get_version contains supplementary field _GENI_PROJECT_OWNER. Will fill in user UID");
                if (this.aggregatedUserInfo != null && this.aggregatedUserInfo.containsKey("MEMBER_UID")) {
                    fields.put("_GENI_PROJECT_OWNER", String.valueOf(this.aggregatedUserInfo.get("MEMBER_UID")));
                } else {
                    this.warn("create_project requires the field _GENI_PROJECT_OWNER, but the current users UID is unknown. (the value 'unknown' will be used, but will likely cause problems)");
                    fields.put("_GENI_PROJECT_OWNER", "unknown");
                }
            }
        }
        this.addRequiredSupplementaryFieldsToCreate(fields, "PROJECT");
        AbstractFederationApi.FederationApiReply reply = this.sa.createProject(this.getSAConnection(), this.testUserCredentialList, this.projectName, fields, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        this.projectCreationDetails = this.assertStringObjectMap(reply.getRawValue());
        this.assertNotNull(this.projectCreationDetails);
        this.note("project details contains the following fields: " + String.valueOf(this.projectCreationDetails.keySet()));
        this.setErrorsNotFatal();
        this.assertMapContainsString(this.projectCreationDetails, "PROJECT_URN");
        this.setErrorsFatal();
    }

    private void checkProjectLookupResult(AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfoMap> reply, List<String> expectedFieldNames, List<String> excludedFieldNames) {
        String rawName;
        Map<String, Object> lookupRes = this.assertStringObjectMap(reply.getRawValue());
        this.checkCorrectnessXmlRpcResult(reply);
        this.checkLookupCorrectness(reply);
        this.assertNotNull(lookupRes);
        this.assertTrue(lookupRes.size() > 0, "Lookup result is empty for project urn: " + this.projectUrn.getValue());
        this.errorNonFatalIfNot(lookupRes.size() == 1, "lookup must return one project, but it returned " + lookupRes.size());
        Map<String, Object> rawUser = this.assertStringObjectMap(lookupRes.get(this.projectUrn.getValue()));
        this.errorNonFatalIfNot(rawUser != null, "lookup must return requested project (" + this.projectUrn.getValue() + ") but returned null.");
        String rawUrn = (String)rawUser.get("PROJECT_URN");
        if (rawUrn != null && !Objects.equals(this.projectUrn.getValue(), rawUrn)) {
            this.errorNonFatal("lookup must return requested project (" + this.projectUrn.getValue() + "), and it did, however its returned PROJECT_URN entry is not matching: " + rawUrn);
        }
        if ((rawName = (String)rawUser.get("PROJECT_NAME")) != null && !Objects.equals(this.projectName, rawName)) {
            this.errorNonFatal("lookup must return requested project (urn=" + this.projectUrn.getValue() + " name=" + this.projectName + "), and it did, however its returned PROJECT_Name entry is not matching: " + rawName);
        }
        for (Object projectInfo : lookupRes.values()) {
            Map<String, Object> rawProjectInfo = this.assertStringObjectMap(projectInfo);
            for (String fieldName : expectedFieldNames) {
                if (rawProjectInfo.containsKey(fieldName)) continue;
                this.errorNonFatal("returned result does not contain field: \"" + fieldName + "\"");
            }
            for (String fieldName : excludedFieldNames) {
                if (!rawProjectInfo.containsKey(fieldName)) continue;
                this.errorNonFatal("returned result contains unexpected field: \"" + fieldName + "\"");
            }
        }
    }

    @ApiTest.Test(hardDepends={"createProject"})
    public void lookupProjectsByUrnNoFilter() throws JFedException {
        if (!this.hasProjectService) {
            this.skip("No PROJECT service advertised in get_version");
        }
        HashMap<String, String> match = new HashMap<String, String>();
        Object filter = null;
        match.put("PROJECT_URN", this.projectUrn.getValue());
        this.note("looking up project by PROJECT_URN: " + this.projectUrn.getValue());
        AbstractFederationApi.FederationApiReply reply = this.sa.lookupProjects(this.getSAConnection(), this.testUserCredentialList, match, null, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.projectDefaultFields) {
            expectedFieldNames.add(fi.getName());
        }
        this.note("No filter provided, so expecting all fields to be returned: " + String.valueOf(expectedFieldNames));
        this.checkProjectLookupResult((AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfoMap>)reply, expectedFieldNames, excludedFieldNames);
        Map<String, Object> rawHt = this.assertStringObjectMap(reply.getRawValue());
        if (rawHt != null) {
            Map<String, Object> projectHt = this.assertStringObjectMap(rawHt.get(this.projectUrn.getValue()));
            String desc = this.assertMapContainsNonemptyString(projectHt, "PROJECT_DESCRIPTION");
            this.assertEquals(desc, initialProjectDescription);
        }
    }

    @ApiTest.Test(hardDepends={"createProject"})
    public void lookupProjectsByNameNoFilter() throws JFedException {
        if (!this.hasProjectService) {
            this.skip("No PROJECT service advertised in get_version");
        }
        HashMap<String, String> match = new HashMap<String, String>();
        Object filter = null;
        match.put("PROJECT_NAME", this.projectName);
        this.note("looking up project by PROJECT_URN: " + this.projectUrn.getValue());
        AbstractFederationApi.FederationApiReply reply = this.sa.lookupProjects(this.getSAConnection(), this.testUserCredentialList, match, null, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.projectDefaultFields) {
            expectedFieldNames.add(fi.getName());
        }
        this.note("No filter provided, so expecting all fields to be returned: " + String.valueOf(expectedFieldNames));
        this.checkProjectLookupResult((AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfoMap>)reply, expectedFieldNames, excludedFieldNames);
        Map<String, Object> rawHt = this.assertStringObjectMap(reply.getRawValue());
        if (rawHt != null) {
            Map<String, Object> projectHt = this.assertStringObjectMap(rawHt.get(this.projectUrn.getValue()));
            String desc = this.assertMapContainsNonemptyString(projectHt, "PROJECT_DESCRIPTION");
            this.assertEquals(desc, initialProjectDescription);
        }
    }

    @ApiTest.Test(hardDepends={"createProject"}, softDepends={"lookupProjectsByUrnNoFilter", "lookupProjectsByNameNoFilter"})
    public void updateProject() throws JFedException {
        if (!this.hasProjectService) {
            this.skip("No PROJECT service advertised in get_version");
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("PROJECT_DESCRIPTION", updatedProjectDescription);
        AbstractFederationApi.FederationApiReply reply = this.sa.updateProject(this.getSAConnection(), this.testUserCredentialList, this.projectUrn, fields, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
    }

    @ApiTest.Test(hardDepends={"updateProject"})
    public void lookupProjectsNoFilterAfterUpdate() throws JFedException {
        if (!this.hasProjectService) {
            this.skip("No PROJECT service advertised in get_version");
        }
        HashMap<String, String> match = new HashMap<String, String>();
        Object filter = null;
        match.put("PROJECT_URN", this.projectUrn.getValue());
        this.note("looking up project by PROJECT_URN: " + this.projectUrn.getValue());
        AbstractFederationApi.FederationApiReply reply = this.sa.lookupProjects(this.getSAConnection(), this.testUserCredentialList, match, null, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.projectDefaultFields) {
            expectedFieldNames.add(fi.getName());
        }
        this.note("No filter provided, so expecting all fields to be returned: " + String.valueOf(expectedFieldNames));
        this.checkProjectLookupResult((AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfoMap>)reply, expectedFieldNames, excludedFieldNames);
        Map<String, Object> rawHt = this.assertStringObjectMap(reply.getRawValue());
        if (rawHt != null) {
            Map<String, Object> projectHt = this.assertStringObjectMap(rawHt.get(this.projectUrn.getValue()));
            String desc = this.assertMapContainsNonemptyString(projectHt, "PROJECT_DESCRIPTION");
            this.assertEquals(desc, updatedProjectDescription);
        }
    }

    @ApiTest.Test(hardDepends={"retrieveCredentialSomehow", "createProject"}, softDepends={"lookupProjectsNoFilterAfterUpdate"})
    public void lookupProjectMembers() throws JFedException {
        if (!this.hasProjectMemberService) {
            this.skip("No PROJECT_MEMBER service advertised in get_version");
        }
        AbstractFederationApi.FederationApiReply reply = this.sa.lookupProjectMembers(this.getSAConnection(), this.projectUrn, this.testUserCredentialList, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        List memberTuples = (List)reply.getValue();
        this.assertNotNull(memberTuples);
        this.assertNotEmpty(memberTuples);
        this.assertTrue(memberTuples.size() == 1, "Expected exactly 1 member in project: " + String.valueOf(memberTuples));
        FederationSliceAuthorityApi1.UrnRoleTuple memberTuple = (FederationSliceAuthorityApi1.UrnRoleTuple)memberTuples.get(0);
        this.assertEquals(memberTuple.urn.getValue(), this.user.getUserUrnString(), "Expected project member to be " + this.user.getUserUrnString() + " but it was " + memberTuple.urn.getValue());
        this.note("test user role in project is: " + memberTuple.role);
        this.assertNotNull(memberTuple.role, "member role is null in project");
        this.lookupProjectMembersRole = memberTuple.role;
    }

    @ApiTest.Test(hardDepends={"createProject"}, softDepends={"lookupProjectMembers"})
    public void lookupProjectsForMember() throws JFedException {
        if (!this.hasProjectMemberService) {
            this.skip("No PROJECT_MEMBER service advertised in get_version");
        }
        GeniUrn memberUrn = GeniUrn.parse((String)this.user.getUserUrnString());
        this.assertNotNull(memberUrn);
        AbstractFederationApi.FederationApiReply reply = this.sa.lookupProjectsForMember(this.getSAConnection(), memberUrn, this.testUserCredentialList, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        List value = (List)reply.getValue();
        this.assertNotNull(value);
        this.assertNotEmpty(value);
        this.assertTrue(value.size() >= 1, "should have been at least 1 project for " + String.valueOf(memberUrn));
        this.note("Project urns for member " + String.valueOf(memberUrn) + ": " + String.valueOf(value));
        String role = null;
        for (FederationSliceAuthorityApi1.UrnRoleTuple tuple : value) {
            if (Objects.equals(tuple.getUrn(), this.projectUrn)) {
                role = tuple.getRole();
            }
            this.assertEquals(tuple.getUrn().getEncodedResourceType(), "project", "The returned URN is not a project urn but is of type: \"" + tuple.getUrn().getEncodedResourceType() + "\"");
        }
        this.assertNotNull(role, "project " + String.valueOf(this.projectUrn) + " was not listed as project for member " + String.valueOf(memberUrn) + ". All: " + String.valueOf(value));
        if (this.lookupProjectMembersRole != null) {
            this.assertEquals(role, this.lookupProjectMembersRole, "A different role was returned for " + String.valueOf(memberUrn) + " in " + String.valueOf(this.projectUrn) + " for the lookup_projects_for_members and lookup_project_members calls");
        }
    }

    @ApiTest.Test(hardDepends={"getVersion", "createProject", "lookupProjectMembers"}, softDepends={"lookupProjectsForMember"})
    public void modifyProjectMembership() throws JFedException {
        this.assertNotNull(this.allRoles, "get_version test did not set allRoles");
        this.assertNotNull(this.lookupProjectMembersRole, "lookupProjectMembersRole not set in lookupProjectMembers");
        if (!this.hasProjectMemberService) {
            this.skip("No PROJECT_MEMBER service advertised in get_version");
        }
        ArrayList membersToAdd = new ArrayList();
        ArrayList membersToRemove = new ArrayList();
        ArrayList<FederationSliceAuthorityApi1.UrnRoleTuple> membersToChange = new ArrayList<FederationSliceAuthorityApi1.UrnRoleTuple>();
        if (this.allRoles.size() <= 1) {
            this.skip("server does not have multiple roles: cannot test modify_project_membership");
        }
        String newRole = this.allRoles.get(0);
        String oldRole = this.lookupProjectMembersRole;
        if (this.allRoles.contains("USER") && !Objects.equals(oldRole, "USER")) {
            newRole = "USER";
        }
        if (this.allRoles.contains("MEMBER") && !Objects.equals(oldRole, "MEMBER")) {
            newRole = "MEMBER";
        }
        for (int i = 1; Objects.equals(newRole, oldRole) && i < this.allRoles.size(); ++i) {
            newRole = this.allRoles.get(i);
        }
        this.assertNotEquals(newRole, oldRole, "roles defined in get_version do not differ: oldRole=" + oldRole + " allRoles=" + String.valueOf(this.allRoles));
        membersToChange.add(new FederationSliceAuthorityApi1.UrnRoleTuple(this.user.getUserUrn(), newRole));
        this.note("Wil ltry to change role of member \"" + this.user.getUserUrnString() + "\" in project \"" + String.valueOf(this.projectUrn) + "\" from \"" + oldRole + "\" to \"" + newRole + "\"");
        AbstractFederationApi.FederationApiReply reply1 = this.sa.modifyProjectMembership(this.getSAConnection(), this.projectUrn, membersToAdd, membersToRemove, membersToChange, this.testUserCredentialList, null);
        this.checkCorrectnessXmlRpcResult(reply1);
        this.assertTrue(reply1.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply1.getGeniResponseCode()));
        AbstractFederationApi.FederationApiReply reply2 = this.sa.lookupProjectMembers(this.getSAConnection(), this.projectUrn, this.testUserCredentialList, null);
        this.assertTrue(reply2.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply2.getGeniResponseCode()));
        List memberTuples = (List)reply2.getValue();
        this.assertNotNull(memberTuples);
        this.assertNotEmpty(memberTuples);
        this.assertTrue(memberTuples.size() == 1, "Expected exactly 1 member in project: " + String.valueOf(memberTuples));
        FederationSliceAuthorityApi1.UrnRoleTuple memberTuple = (FederationSliceAuthorityApi1.UrnRoleTuple)memberTuples.get(0);
        this.assertEquals(memberTuple.urn.getValue(), this.user.getUserUrnString(), "Expected project member to be " + this.user.getUserUrnString() + " but it was " + memberTuple.urn.getValue());
        this.note("test user role in project is: " + memberTuple.role);
        this.assertNotNull(memberTuple.role, "member role is null in project");
        this.assertEquals(memberTuple.role, newRole, "member role differs from newly assigned role");
        this.lookupProjectMembersRole = memberTuple.role;
    }
}

