/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.ProtogeniSliceAuthority;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestMetaData;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.NoConfigApiTestMetaData;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class TestSliceAuthority
extends BaseApiTest<LegacyApiTestConfig> {
    private static final ApiTestMetaData metadata = new NoConfigApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "Slice Authority Tests. Currently only GetVersion is tested, this needs to be extended.";
        }
    };
    private ProtogeniSliceAuthority sa;

    @Inject
    public TestSliceAuthority(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static ApiTestMetaData getMetaData() {
        return metadata;
    }

    public SfaConnection getConnection() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.user.getUserAuthorityServer(), new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1));
    }

    @Override
    public void setUp() {
        this.sa = new ProtogeniSliceAuthority(this.logger, this.getJFedPreferences());
    }

    public static void testSACorrectnessXmlRpcResult(Map res) {
        Object code = res.get("code");
        Object value = res.get("value");
        Object output = res.get("output");
        assert (code != null);
        assert (value != null);
        assert (output != null);
        assert (code instanceof Integer);
        assert (output instanceof String);
    }

    @ApiTest.Test
    public void testGetVersion() throws JFedException {
        System.out.println("GetVersion test starting");
        ProtogeniSliceAuthority.SliceAuthorityReply reply = this.sa.getVersion(this.getConnection());
        assert (reply.getGeniResponseCode().isSuccess());
        System.out.println("GetVersion test finished");
    }
}

