/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.base;

import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.ApiTestMetaData;
import be.iminds.ilabt.jfed.testing.shared.AutomatedTestExternalExecutableLocations;
import be.iminds.ilabt.jfed.testing.shared.AutomatedTestExternalExecutableLocationsImpl;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTestFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ApiTestFactory.class);
    @Nonnull
    protected final Injector injector;

    @Inject
    public ApiTestFactory(@Nonnull Injector injector) {
        this.injector = injector;
    }

    public ApiTestFactory(@Nonnull Injector injector, @Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUserProvider geniUserProvider) {
        this.injector = injector;
        be.iminds.ilabt.jfed.log.Logger injectorLogger = (be.iminds.ilabt.jfed.log.Logger)injector.getInstance(be.iminds.ilabt.jfed.log.Logger.class);
        GeniUserProvider injectorGeniUserProvider = (GeniUserProvider)injector.getInstance(GeniUserProvider.class);
        if (logger != injectorLogger) {
            throw new IllegalArgumentException("Injector must provided same logger");
        }
        if (geniUserProvider != injectorGeniUserProvider) {
            throw new IllegalArgumentException("Injector must provided same geniUserProvider");
        }
    }

    @Nonnull
    public ApiTest createApiTest(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nullable TargetAuthority testedAuthority, @Nonnull String testClassName, @Nonnull String testConfigString) throws InvalidApiTestException {
        try {
            Class<?> foundClass = Class.forName(testClassName);
            if (!ApiTest.class.isAssignableFrom(foundClass)) {
                throw new InvalidApiTestException("The test class \"" + testClassName + "\" is not an ApiTest");
            }
            Class<?> testClass = foundClass;
            return this.createApiTest(logger, testedAuthority, testClass, testConfigString);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidApiTestException("The test class \"" + testClassName + "\" cannot be found", e);
        }
    }

    @Nonnull
    public ApiTest createApiTest(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, final @Nullable TargetAuthority testedAuthority, @Nonnull Class<? extends ApiTest> testClass, @Nonnull String testConfigString) throws InvalidApiTestException {
        Injector usedInjector;
        ApiTestMetaData apiTestMetaData = ApiTest.getMetaData(testClass);
        assert (apiTestMetaData != null);
        final Class testConfigClass = apiTestMetaData.getConfigClass();
        Object testConfigInstance = apiTestMetaData.parseApiTestConfig(testConfigString);
        assert (testConfigClass != null);
        assert (apiTestMetaData != null);
        boolean hasJFedTrustStore = this.hasBinding(JFedTrustStore.class);
        boolean hasTargetBinding = this.hasBinding(TargetAuthority.class);
        boolean hasTargetBindingOrNull = this.hasBindingOrNull(TargetAuthority.class);
        boolean hasTestConfig = this.hasBinding(ApiTestConfig.class);
        boolean hasRspecFactory = this.hasBinding(RspecFactory.class);
        boolean hasAutomatedTestExternalExecutableLocations = this.hasBinding(AutomatedTestExternalExecutableLocations.class);
        if (!hasJFedTrustStore) {
            throw new NullPointerException("injector has no binding for JFedTrustStore: cannot create test.");
        }
        if (hasTargetBinding) {
            TargetAuthority target = (TargetAuthority)this.injector.getInstance(TargetAuthority.class);
            assert (target != null);
            assert (testedAuthority != null);
            if (!Objects.equals(target.getOrigUrn(), testedAuthority.getOrigUrn())) {
                throw new RuntimeException("Internal error: the injector was already bound for another authority! already bound to: " + String.valueOf(testedAuthority.getOrigUrn()) + " new target: " + String.valueOf(target.getOrigUrn()));
            }
        }
        ArrayList<AbstractModule> extraModules = new ArrayList<AbstractModule>();
        if (!hasTargetBindingOrNull) {
            if (testedAuthority != null) {
                extraModules.add(new AbstractModule(){

                    protected void configure() {
                        this.bind(TargetAuthority.class).toInstance((Object)testedAuthority);
                    }
                });
            } else {
                extraModules.add(new AbstractModule(){

                    protected void configure() {
                        this.bind(TargetAuthority.class).toInstance(null);
                    }
                });
            }
        }
        if (!hasTestConfig) {
            extraModules.add(new AbstractModule((ApiTestConfig)testConfigInstance){
                final /* synthetic */ ApiTestConfig val$testConfigInstance;
                {
                    this.val$testConfigInstance = apiTestConfig;
                }

                protected void configure() {
                    this.bind(testConfigClass).toInstance((Object)this.val$testConfigInstance);
                }
            });
        }
        if (!hasRspecFactory) {
            extraModules.add(new AbstractModule(){

                protected void configure() {
                    this.bind(RspecFactory.class).toInstance((Object)RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)ModelRspecType.BASIC));
                }
            });
        }
        if (!hasAutomatedTestExternalExecutableLocations) {
            LOG.debug("Binding a new AutomatedTestExternalExecutableLocations to the injector");
            final AutomatedTestExternalExecutableLocationsImpl automatedTestExternalExecutableLocations = new AutomatedTestExternalExecutableLocationsImpl();
            try {
                automatedTestExternalExecutableLocations.requireExe("ansible-playbook");
            }
            catch (AutomatedTestExternalExecutableLocations.ExecutableNotFoundException e) {
                LOG.error("Required exe not found: test might fail later i fit is needed!", (Throwable)e);
            }
            extraModules.add(new AbstractModule(){

                protected void configure() {
                    this.bind(AutomatedTestExternalExecutableLocations.class).toInstance((Object)automatedTestExternalExecutableLocations);
                }
            });
        }
        if (!extraModules.isEmpty()) {
            LOG.info("Constructing " + testClass.getName() + " using Guice child injector (was missing " + extraModules.size() + " things)");
            usedInjector = this.injector.createChildInjector(extraModules);
        } else {
            LOG.info("Constructing " + testClass.getName() + " using Guice injector (already has everything needed)");
            usedInjector = this.injector;
        }
        be.iminds.ilabt.jfed.log.Logger injectorLogger = (be.iminds.ilabt.jfed.log.Logger)usedInjector.getInstance(be.iminds.ilabt.jfed.log.Logger.class);
        if (logger != injectorLogger) {
            throw new IllegalArgumentException("Injector must provided same logger");
        }
        return (ApiTest)usedInjector.getInstance(testClass);
    }

    private boolean hasBinding(Class clazz) {
        try {
            Object tst = this.injector.getInstance(clazz);
            return tst != null;
        }
        catch (ConfigurationException e) {
            return false;
        }
        catch (Exception e) {
            LOG.warn("Injector did not already have target binding, and returned unexpected exception class.", (Throwable)e);
            return false;
        }
    }

    private boolean hasBindingOrNull(Class clazz) {
        try {
            Object tst = this.injector.getInstance(clazz);
            return true;
        }
        catch (ConfigurationException e) {
            return false;
        }
        catch (Exception e) {
            LOG.warn("Injector did not already have target binding, and returned unexpected exception class.", (Throwable)e);
            return false;
        }
    }

    public class InvalidApiTestException
    extends Exception {
        public InvalidApiTestException() {
        }

        public InvalidApiTestException(String message) {
            super(message);
        }

        public InvalidApiTestException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidApiTestException(Throwable cause) {
            super(cause);
        }

        public InvalidApiTestException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

