/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.base;

import be.iminds.ilabt.jfed.testing.base.ApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LegacyApiTestConfig
implements ApiTestConfig {
    @Nonnull
    private final Properties properties;
    @Nonnull
    private final LegacyApiTestMetaData legacyApiTestMetaData;

    public LegacyApiTestConfig(@Nonnull String propertiesString, @Nonnull LegacyApiTestMetaData legacyApiTestMetaData) {
        this.legacyApiTestMetaData = legacyApiTestMetaData;
        this.properties = new Properties();
        StringReader stringReader = new StringReader(propertiesString);
        try {
            this.properties.load(stringReader);
            stringReader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException", e);
        }
    }

    public LegacyApiTestConfig(@Nonnull Properties properties, @Nonnull LegacyApiTestMetaData legacyApiTestMetaData) {
        this.legacyApiTestMetaData = legacyApiTestMetaData;
        this.properties = properties;
    }

    @Override
    public boolean isValid() {
        for (String reqKey : this.legacyApiTestMetaData.getReqConfKeys()) {
            if (this.properties.containsKey(reqKey)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public String stringValue() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.properties.store(stringWriter, "");
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert properties to string", e);
        }
    }

    @Nullable
    public String getProperty(@Nonnull String key) {
        return this.properties.getProperty(key);
    }

    @Nonnull
    public String getProperty(@Nonnull String key, @Nonnull String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    @Nullable
    public Object get(@Nonnull String key) {
        return this.properties.get(key);
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    @Nonnull
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }
}

