/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.shared;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.SfaConnectionPool;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.lib.Gid;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.GeniUserSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.stitching.VlanRange;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicModelRspec;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecNode;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec.util.RspecBinder;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.shared.TestConfig;
import be.iminds.ilabt.jfed.ui.commandline.ContextFile;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.schmizz.sshj.connection.channel.direct.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonAMTest {
    private static final Logger LOG = LoggerFactory.getLogger(CommonAMTest.class);
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final int MAX_CREATE_SLICE_TRIES = 3;
    private final BaseApiTest<LegacyApiTestConfig> test;
    private final Server userAuthority;
    private final List<Server> testedAuthoritiesForRspec;
    private final TestbedInfoSource testbedInfoSource;
    private List<AnyCredential> userCredentials;
    private UserAndSliceApiWrapper userAndSliceApiWrapperUser1;
    private UserAndSliceApiWrapper userAndSliceApiWrapperUser2;
    private List<AnyCredential> user2Credentials;
    private TestCredentialType testCredentialType = TestCredentialType.REGULAR;
    private SfaCredential delegatedUserCredential;
    private AnyCredential speaksForUserCredential;
    private final List<SliceInfo> allSliceInfo = new ArrayList<SliceInfo>();
    private SpeaksForConfig speaksForConfig;
    protected User2LoginConfig secondUserConfig;
    private static final Map<Long, FedmonTestInfo> fedmonTestByThreadId = new ConcurrentHashMap<Long, FedmonTestInfo>();
    private boolean hasCachedFixedRspec = false;
    private String cachedFixedRspec = null;
    private boolean cachedIsGeniFixedRspec = true;

    public CommonAMTest(@Nonnull BaseApiTest<LegacyApiTestConfig> test, TestbedInfoSource testbedInfoSource) {
        this(test, test.getUser().getUserAuthorityServerId(), test.getTestedAuthority() == null ? null : test.getTestedAuthority().getServerForRspecComponentManager(), testbedInfoSource);
    }

    public CommonAMTest(@Nonnull BaseApiTest<LegacyApiTestConfig> test, @Nullable Integer userAuthorityId, TestbedInfoSource testbedInfoSource) {
        this(test, userAuthorityId, test.getTestedAuthority() == null ? Collections.emptyList() : Collections.singletonList(test.getTestedAuthority().getServerForRspecComponentManager()), testbedInfoSource);
    }

    public CommonAMTest(@Nonnull BaseApiTest<LegacyApiTestConfig> test, @Nonnull Integer userAuthorityId, @Nullable Server testedAuthorityForRspec, TestbedInfoSource testbedInfoSource) {
        this(test, userAuthorityId, testedAuthorityForRspec == null ? Collections.emptyList() : Collections.singletonList(testedAuthorityForRspec), testbedInfoSource);
    }

    public CommonAMTest(@Nonnull BaseApiTest<LegacyApiTestConfig> test, @Nonnull Integer userAuthorityId, @Nonnull List<Server> testedAuthoritiesForRspec, TestbedInfoSource testbedInfoSource) {
        this.test = test;
        this.userAuthority = testbedInfoSource.getServerById(userAuthorityId);
        this.testedAuthoritiesForRspec = testedAuthoritiesForRspec;
        this.testbedInfoSource = testbedInfoSource;
        assert (this.test != null);
        assert (this.userAuthority != null);
        this.userAndSliceApiWrapperUser1 = test.getAutomaticUserAndSliceApiWrapperFactory().create();
    }

    public static void registerFedmonTest(Long threadId, Integer testInstanceId, Long taskId) {
        fedmonTestByThreadId.put(threadId, new FedmonTestInfo(testInstanceId, taskId));
    }

    public static void registerFedmonTest(Integer testInstanceId, Long taskId) {
        CommonAMTest.registerFedmonTest(Thread.currentThread().getId(), testInstanceId, taskId);
    }

    public static String getComponentManagerIdForSite(Server auth) {
        if (auth.isServerType("emulab")) {
            return auth.getDefaultComponentManagerUrn();
        }
        if (auth.isServerType("instageni")) {
            return auth.getDefaultComponentManagerUrn();
        }
        if (auth.isServerType("planetlab")) {
            return auth.getDefaultComponentManagerUrn();
        }
        if (auth.isServerType("orca") || auth.isServerType("exogeni")) {
            String sitename = null;
            if (Objects.equals(auth.getDefaultComponentManagerUrn(), "urn:publicid:IDN+geni.renci.org+authority+cm")) {
                sitename = "exogeni.net";
            }
            if (Objects.equals(auth.getDefaultComponentManagerUrn(), "urn:publicid:IDN+bbn-hn.exogeni.net+authority+cm")) {
                sitename = "exogeni.net:bbnvmsite";
            }
            if (Objects.equals(auth.getDefaultComponentManagerUrn(), "urn:publicid:IDN+dbc1-16.nicl.cs.duke.edu+authority+cm")) {
                sitename = "exogeni.net:dukevmsite";
            }
            if (Objects.equals(auth.getDefaultComponentManagerUrn(), "urn:publicid:IDN+fiu-hn.exogeni.net+authority+cm")) {
                sitename = "exogeni.net:fiuvmsite";
            }
            if (Objects.equals(auth.getDefaultComponentManagerUrn(), "urn:publicid:IDN+nicta-hn.exogeni.net+authority+cm")) {
                sitename = "exogeni.net:nictavmsite";
            }
            if (Objects.equals(auth.getDefaultComponentManagerUrn(), "urn:publicid:IDN+rci-hn.exogeni.net+authority+cm")) {
                sitename = "exogeni.net:rcivmsite";
            }
            if (Objects.equals(auth.getDefaultComponentManagerUrn(), "urn:publicid:IDN+uh-hn.exogeni.net+authority+cm")) {
                sitename = "exogeni.net:uhvmsite";
            }
            if (Objects.equals(auth.getDefaultComponentManagerUrn(), "urn:publicid:IDN+uva-nl-hn.exogeni.net+authority+cm")) {
                sitename = "exogeni.net:uvanlvmsite";
            }
            if (Objects.equals(auth.getDefaultComponentManagerUrn(), "urn:publicid:IDN+ufl-hn.exogeni.net+authority+cm")) {
                sitename = "exogeni.net:uflvmsite";
            }
            if (Objects.equals(auth.getDefaultComponentManagerUrn(), "urn:publicid:IDN+osf-hn.exogeni.net+authority+cm")) {
                sitename = "exogeni.net:osfvmsite";
            }
            if (sitename != null) {
                return "urn:publicid:IDN+" + sitename + "+authority+cm";
            }
        }
        return auth.getDefaultComponentManagerUrn();
    }

    public static boolean getExclusiveForSite(Server auth) {
        String sliverType = CommonAMTest.getSliverTypeForSite(auth);
        return Objects.equals(sliverType, "raw-pc");
    }

    public static String getSliverTypeForSite(Server auth) {
        if (auth.isServerType("emulab")) {
            return "raw-pc";
        }
        if (auth.isServerType("instageni")) {
            return "emulab-xen";
        }
        if (auth.isServerType("planetlab")) {
            return "plab-vserver";
        }
        if (auth.getServerType() != null && (auth.getServerType().equals("orca") || auth.getServerType().equals("exogeni"))) {
            return "xo.small";
        }
        if (auth.getUrnTld().contains("exogeni") || auth.getUrnTld().contains("vmsite") || auth.getUrnTld().contains("orca")) {
            return "xo.small";
        }
        return null;
    }

    public String getOneNodeRequestRSpec(Server auth, GeniUrn sliceUrn) {
        return this.getOneNodeRequestRSpec(auth, sliceUrn, null, null, null);
    }

    public String getOneNodeRequestRSpec(Server auth, GeniUrn sliceUrn, @Nullable GeniUrn fixedNodeUrn, Boolean exclusive, String sliverType) {
        Object componentId = "";
        if (fixedNodeUrn != null) {
            componentId = " component_id=\"" + String.valueOf(fixedNodeUrn) + "\" ";
        }
        if (Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), GeniUrn.parse((String)"urn:publicid:IDN+fiteagle+authority+am"))) {
            Random rand = new Random(System.currentTimeMillis());
            return "<rspec type=\"request\" xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/ad.xsd http://fiteagle.org/rspec/ext/1 http://fiteagle.org/rspec/ext/1\" xmlns:ns2=\"http://fiteagle.org/rspec/ext/1\" xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:ns3=\"http://fiteagle.org/rspec/ext/1/openstackVMResource\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n<ns3:openstackResource resourceId=\"42ad1e74-c9cd-4fe0-9d18-522b7f8bede1\">\n<ns3:vmToInstantiate imageId=\"d6521c1b-4407-454a-981f-b5d4d4d5fcae\" flavorId=\"3\" vmName=\"randomName" + rand.nextInt() + "\" keyPairName=\"randomKeyPair" + rand.nextInt() + "\"/>\n</ns3:openstackResource>\n</rspec>";
        }
        if (Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), GeniUrn.parse((String)"urn:publicid:IDN+clab+authority+cm"))) {
            return "<rspec type=\"request\" xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/request.xsd \" xmlns:client=\"http://www.protogeni.net/resources/rspec/ext/client/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.geni.net/resources/rspec/3\">\n     <node client_id=\"myNodeId\" component_manager_id=\"urn:publicid:IDN+clab+authority+cm\" " + (String)componentId + " exclusive=\"false\">\n         <sliver_type name=\"RD_sliver\"/>\n     </node>\n</rspec>";
        }
        if (auth.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority().startsWith("omf:nitos") || Objects.equals(TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.test.getTestConfig()).getProperty("use_nitos_lease", "false")), Boolean.TRUE)) {
            Random rand = new Random(System.currentTimeMillis());
            long leaseId = Math.abs(rand.nextInt());
            Date lease_start_date = new Date();
            Date lease_end_date = new Date(lease_start_date.getTime() + 0x6DDD00L);
            String usedNodeCompman = "omf:nitos.outdoor";
            String usedNodeName = "node001";
            if (fixedNodeUrn != null) {
                usedNodeCompman = fixedNodeUrn.getEncodedTopLevelAuthority();
                usedNodeName = fixedNodeUrn.getEncodedResourceName();
            }
            componentId = " component_id=\"urn:publicid:IDN+" + usedNodeCompman + "+node+" + usedNodeName + "\" ";
            return "<?xml version=\"1.0\"?>\n<rspec type=\"request\"        xmlns=\"http://www.geni.net/resources/rspec/3\"        xmlns:ol=\"http://nitlab.inf.uth.gr/schema/sfa/rspec/1\"        xmlns:omf=\"http://schema.mytestbed.net/sfa/rspec/1\"        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"        xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/request.xsd http://nitlab.inf.uth.gr/schema/sfa/rspec/1 http://nitlab.inf.uth.gr/schema/sfa/rspec/1/request-reservation.xsd\">\n  <ol:lease client_id=\"l" + leaseId + "\"             valid_from=\"" + RFC3339Util.dateToRFC3339String((Date)lease_start_date) + "\"             valid_until=\"" + RFC3339Util.dateToRFC3339String((Date)lease_end_date) + "\"/>\n  <node " + (String)componentId + "         component_manager_id=\"" + String.valueOf(auth.getDefaultComponentManagerAsGeniUrn()) + "\"         component_name=\"" + usedNodeName + "\"         exclusive=\"true\"         client_id=\"my_node\">\n    <ol:lease_ref id_ref=\"l" + leaseId + "\"/>\n  </node>\n</rspec>";
        }
        if (Objects.equals(auth.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority(), "omf:netmode")) {
            String componentName;
            Random rand = new Random(System.currentTimeMillis());
            long leaseId = Math.abs(rand.nextInt());
            Date lease_start_date = new Date();
            Date lease_end_date = new Date(lease_start_date.getTime() + 0x6DDD00L);
            if (fixedNodeUrn == null) {
                componentId = " component_id=\"urn:publicid:IDN+" + auth.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority() + "+node+omf.netmode.node1\" ";
                componentName = "omf.netmode.node1";
            } else {
                componentName = fixedNodeUrn.getEncodedResourceName();
            }
            return "<?xml version=\"1.0\"?>\n<rspec type=\"request\"        xmlns=\"http://www.geni.net/resources/rspec/3\"        xmlns:ol=\"http://nitlab.inf.uth.gr/schema/sfa/rspec/1\"        xmlns:omf=\"http://schema.mytestbed.net/sfa/rspec/1\"        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"        xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/request.xsd http://nitlab.inf.uth.gr/schema/sfa/rspec/1 http://nitlab.inf.uth.gr/schema/sfa/rspec/1/request-reservation.xsd\">\n  <ol:lease client_id=\"l" + leaseId + "\"             valid_from=\"" + RFC3339Util.dateToRFC3339String((Date)lease_start_date) + "\"             valid_until=\"" + RFC3339Util.dateToRFC3339String((Date)lease_end_date) + "\"/>\n  <node " + (String)componentId + "         component_manager_id=\"" + String.valueOf(auth.getDefaultComponentManagerAsGeniUrn()) + "\"         component_name=\"" + componentName + "\"         exclusive=\"true\"         client_id=\"my_node\">\n    <ol:lease_ref id_ref=\"l" + leaseId + "\"/>\n  </node>\n</rspec>";
        }
        if (Objects.equals(auth.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority(), "omf")) {
            Random rand = new Random(System.currentTimeMillis());
            Date lease_start_date = new Date();
            long duration_unknownunit = 6L;
            Date lease_end_date = new Date(lease_start_date.getTime() + duration_unknownunit * 60L * 60L * 1000L);
            return "<?xml version=\"1.0\"?>\n<RSpec type=\"NITOS\" expires=\"2013-10-31T19:30:08Z\" generated=\"2013-10-31T18:30:08Z\">\n  <network name=\"omf\">\n    <node component_manager_id=\"urn:publicid:IDN+omf+authority+cm\"           component_id=\"urn:publicid:IDN+" + auth.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority() + "+node+node001\"          component_name=\"node001\"           site_id=\"urn:publicid:IDN+" + auth.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority() + "+authority+sa\">\n      <hostname>node001</hostname>\n      <location country=\"unknown\" longitude=\"39.360839\" latitude=\"22.949989\"/>\n      <position_3d x=\"1\" y=\"1\" z=\"5\"/>\n      <exclusive>TRUE</exclusive>\n      <gateway>nitlab.inf.uth.gr</gateway>\n      <granularity>1800</granularity>\n      <hardware_type>orbit</hardware_type>\n      <sliver/>\n    </node>\n    <lease slice_id=\"" + String.valueOf(sliceUrn) + "\" start_time=\"" + lease_start_date.getTime() + "\" duration=\"" + duration_unknownunit + "\">\n      <node component_id=\"urn:publicid:IDN+" + auth.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority() + "+node+node001\"/>\n      </lease>\n  </network>\n</RSpec>";
        }
        if (auth.isServerType("emulab")) {
            if (exclusive == null) {
                exclusive = true;
            }
            if (sliverType == null) {
                sliverType = "raw-pc";
            }
            return "<rspec type=\"request\" xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/request.xsd \" xmlns:client=\"http://www.protogeni.net/resources/rspec/ext/client/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.geni.net/resources/rspec/3\">\n  <node client_id=\"PC\" component_manager_id=\"" + auth.getDefaultComponentManagerUrn() + "\" " + (String)componentId + " exclusive=\"" + exclusive + "\">\n    <sliver_type name=\"" + sliverType + "\"/>\n  </node>\n</rspec>\n";
        }
        if (auth.isServerType("instageni")) {
            if (exclusive == null) {
                exclusive = false;
            }
            if (sliverType == null) {
                sliverType = "emulab-xen";
            }
            return "<rspec type=\"request\" xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/request.xsd \" xmlns:client=\"http://www.protogeni.net/resources/rspec/ext/client/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.geni.net/resources/rspec/3\">\n  <node client_id=\"PC\" component_manager_id=\"" + auth.getDefaultComponentManagerUrn() + "\" " + (String)componentId + " exclusive=\"" + exclusive + "\">\n    <sliver_type name=\"" + sliverType + "\"/>\n  </node>\n</rspec>\n";
        }
        if (auth.isServerType("planetlab")) {
            if (fixedNodeUrn == null) {
                componentId = " component_id=\"urn:publicid:IDN+ple:unistra+node+planetlab1.u-strasbg.fr\" ";
            }
            return "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n   <rspec type=\"request\"  xmlns=\"http://www.geni.net/resources/rspec/3\" >\n       <node client_id=\"node0\" " + (String)componentId + " component_manager_id=\"urn:publicid:IDN+ple:ibbtple+authority+cm\"  exclusive=\"false\">\n           <sliver/>\n           <sliver_type name=\"plab-vserver\"/>\n           <hardware_type name=\"plab-pc\"/>\n           <hardware_type name=\"pc\"/>\n       </node>\n   </rspec>";
        }
        if (auth.getServerType() != null && (auth.getServerType().equals("orca") || auth.getServerType().equals("exogeni"))) {
            String componentManagerId = CommonAMTest.getComponentManagerIdForSite(auth);
            if (exclusive == null) {
                exclusive = false;
            }
            if (sliverType == null) {
                sliverType = "xo.small";
            }
            return "<rspec type=\"request\" xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/request.xsd \" xmlns:client=\"http://www.protogeni.net/resources/rspec/ext/client/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.geni.net/resources/rspec/3\">\n  <node client_id=\"PC\" component_manager_id=\"" + componentManagerId + "\" " + (String)componentId + " exclusive=\"" + exclusive + "\">\n    <sliver_type name=\"" + sliverType + "\"/>\n  </node>\n</rspec>\n";
        }
        if (exclusive == null) {
            exclusive = false;
        }
        return "<rspec type=\"request\" xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/request.xsd \" xmlns:client=\"http://www.protogeni.net/resources/rspec/ext/client/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.geni.net/resources/rspec/3\">\n  <node client_id=\"PC\" component_manager_id=\"" + auth.getDefaultComponentManagerUrn() + "\" " + (String)componentId + " exclusive=\"" + exclusive + "\">\n" + (String)(sliverType == null ? "" : "<sliver_type name=\"" + sliverType + "\"/>\n") + "  </node>\n</rspec>\n";
    }

    public static boolean isEmptyRspec(ApiTest test, String rspec) {
        if (rspec == null || rspec.trim().isEmpty()) {
            return true;
        }
        BasicStringRspec basicStringRspec = new BasicStringRspec(rspec);
        if (!basicStringRspec.isWellFormed()) {
            throw new RuntimeException("Not an rspec (not even well formed XML): " + rspec);
        }
        if (!basicStringRspec.isValidRspec()) {
            throw new RuntimeException("Not an rspec (it is well formed XML, but not an RSpec): " + rspec);
        }
        List basicNodeInfo = basicStringRspec.getBasicNodeInfo();
        if (basicNodeInfo == null) {
            throw new RuntimeException("Not an valid rspec (probably not well formed XML): " + rspec);
        }
        return basicNodeInfo.isEmpty();
    }

    public static int testValidGeni3ManifestRspec(ApiTest test, String rspec) {
        if (rspec == null) {
            return -1;
        }
        test.assertNotNull(rspec, "Rspec is null");
        if (rspec.contains("<RSpec")) {
            test.note("We received an SFA RSpec instead of a GENI RSpec v3, but we'll try to work around.");
            rspec = rspec.replace("<RSpec type=\"SFA\"", "<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"manifest\"");
            rspec = rspec.replace("<RSpec ", "<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"manifest\"");
            rspec = rspec.replace("</RSpec>", "</rspec>");
            rspec = rspec.replace("<network name=\"ple\">", "");
            rspec = rspec.replace("</network>", "");
        }
        BasicStringRspec basicStringRspec = new BasicStringRspec(rspec);
        test.assertTrue(basicStringRspec.isWellFormed(), "Not an rspec (not even well formed XML): " + rspec);
        test.assertTrue(basicStringRspec.isValidRspec(), "Not an rspec (it is well formed XML, but not an RSpec): " + rspec);
        String type = basicStringRspec.getRspecType();
        test.assertNotNull(type, "Received manifest RSpec does not specify a type: " + rspec);
        test.assertEquals(type, "manifest", "Received manifest RSpec is not a manifest: " + rspec);
        return basicStringRspec.getBasicNodeInfo().size();
    }

    public static int testValidGeni3AdvertisementRspec(ApiTest test, String rspec) {
        if (rspec == null) {
            return -1;
        }
        test.assertNotNull(rspec, "Rspec is null");
        BasicStringRspec basicStringRspec = new BasicStringRspec(rspec);
        test.assertTrue(basicStringRspec.isWellFormed(), "Not an rspec (not even well formed XML): " + rspec);
        test.assertTrue(basicStringRspec.isValidRspec(), "Not an rspec (it is well formed XML, but not an RSpec): " + rspec);
        String type = basicStringRspec.getRspecType();
        test.assertNotNull(type, "Received advertisement RSpec does not specify a type: " + rspec);
        test.assertEquals(type, "advertisement", "Received advertisement RSpec is not a manifest: " + rspec);
        return basicStringRspec.getBasicNodeInfo().size();
    }

    public static String createSliceName(@Nonnull ApiTest test, @Nonnull Server userAuthority, @Nonnull List<GeniUrn> testedAuthorityCms, @Nonnull String prefix, int maxNodeNameLength, @Nullable SpeaksForConfig speaksForConfig) {
        long uniqueishID;
        int maxSliceNameLength = 19;
        int maxTestedAuthorityCmLen = testedAuthorityCms.isEmpty() ? (test.getTestedAuthority() == null ? 5 : test.getTestedAuthority().getRspecUrn().getEncodedTopLevelAuthority().length()) : testedAuthorityCms.get(0).getEncodedTopLevelAuthority().length();
        String longestCmUrn = null;
        for (GeniUrn u : testedAuthorityCms) {
            if (u.getEncodedTopLevelAuthority().length() < maxTestedAuthorityCmLen) continue;
            maxTestedAuthorityCmLen = u.getEncodedTopLevelAuthority().length();
            longestCmUrn = u.getEncodedTopLevelAuthority();
        }
        String maxUserAuthName = userAuthority.getUrnTld();
        int maxUserAuthLen = userAuthority.getUrnTld().length();
        if (speaksForConfig != null && speaksForConfig.getUser2Urn() != null && speaksForConfig.getUser2Urn().getEncodedTopLevelAuthority().length() > maxUserAuthLen) {
            maxUserAuthLen = speaksForConfig.getUser2Urn().getEncodedTopLevelAuthority().length();
            maxUserAuthName = speaksForConfig.getUser2Urn().getEncodedTopLevelAuthority();
        }
        test.note("The longest CM urn top level authority is: \"" + longestCmUrn + "\" (" + maxTestedAuthorityCmLen + " chars)");
        test.note("The user authority of max length is: \"" + maxUserAuthName + "\" (" + maxUserAuthLen + " chars)");
        test.note("The maximum node name length is: " + maxNodeNameLength);
        int authLen = userAuthority.getUrnTld().replaceAll("\\.", "").length();
        int planetlab_l = 32 - authLen;
        int dotcount = 3;
        int nodeNameLen = maxNodeNameLength;
        int protogeni_l = 63 - maxTestedAuthorityCmLen - maxUserAuthLen - nodeNameLen - 3;
        int l = 0;
        l = protogeni_l < planetlab_l ? protogeni_l : planetlab_l;
        if (l < maxSliceNameLength) {
            maxSliceNameLength = l;
            test.note("For " + userAuthority.getUrnTld() + " (" + authLen + " non-dot chars), the maximum slice name length (taking into account planetlab and protogeni limits) is " + maxSliceNameLength);
        } else {
            test.note("Slice name length is " + maxSliceNameLength);
        }
        int uniqueTextLen = maxSliceNameLength - prefix.length();
        if (uniqueTextLen < 2) {
            uniqueTextLen = 2;
            test.note("The calculated slice name length is " + maxSliceNameLength + " which is too short. It will be increased to " + (prefix.length() + uniqueTextLen) + " create a usable slice name for this test.\nThis slicename consists of a prefix (\"" + prefix + "\" = " + prefix.length() + " chars) and a unique suffix (" + uniqueTextLen + " RANDOM chars)");
        }
        FedmonTestInfo fedmonTestInfo = fedmonTestByThreadId.get(Thread.currentThread().getId());
        String uniqueTextHelper = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        if (fedmonTestInfo == null || fedmonTestInfo.testInstanceId == null || maxSliceNameLength < 5) {
            StringBuilder uniqueText = new StringBuilder();
            for (int i = 0; i < uniqueTextLen; ++i) {
                int pos = RANDOM.nextInt(uniqueTextHelper.length());
                uniqueText.append(uniqueTextHelper.charAt(pos));
            }
            return prefix + String.valueOf(uniqueText);
        }
        StringBuilder uniqueishText = new StringBuilder();
        assert (uniqueishID > 0L);
        int nrChars = 0;
        for (uniqueishID = (long)fedmonTestInfo.testInstanceId.intValue(); uniqueishID != 0L && nrChars++ < 8; uniqueishID >>= 5) {
            int part = (int)(uniqueishID & 0x1FL);
            uniqueishText.append(uniqueTextHelper.charAt(part));
        }
        int rand = RANDOM.nextInt(8);
        uniqueishText.append("6789ABCD".charAt(rand));
        if (maxSliceNameLength < 2 + uniqueishText.length()) {
            test.note("maxSliceNameLength=" + maxSliceNameLength + " -> the calculated slice name (len=2+" + uniqueishText.length() + ") would not fit. Falling back to shorter name.");
            return prefix.charAt(0) + uniqueishText.substring(0, maxSliceNameLength - 1);
        }
        int maxPrefixLen = maxSliceNameLength - uniqueishText.length() - 1;
        if (maxPrefixLen < 0) {
            maxPrefixLen = 1;
        }
        String fedmonPrefix = maxPrefixLen >= 6 ? "fedmon" : "fedmon".substring(0, maxPrefixLen);
        return fedmonPrefix + prefix.charAt(0) + String.valueOf(uniqueishText);
    }

    public static void addOptionsForNodeLoginSshProxy(List<String> res) {
        res.add("loginSshProxyMode");
        res.add("loginSshProxyHostName");
        res.add("loginSshProxyHostKey");
        res.add("loginSshProxyHostPort");
        res.add("loginSshProxyUsername");
        res.add("loginSshProxyKeySource");
    }

    public static void addOptionsForConnectionSshProxy(List<String> res) {
        res.add("sfaSshProxyMode");
        res.add("sfaSshProxyHostName");
        res.add("sfaSshProxyHostKey");
        res.add("sfaSshProxyHostPort");
        res.add("sfaSshProxyUsername");
        res.add("sfaSshProxyKeySource");
    }

    public static void addOptionsForRspecTypeVersion(List<String> res) {
        res.add("rspecTypeName");
        res.add("rspecTypeVersion");
    }

    public String getRspecTypeName(LegacyApiTestConfig testConfig) {
        String res = TextUtil.objectToStringOrNull((Object)testConfig.get("rspecTypeName"), (boolean)true);
        if (res == null) {
            return "geni";
        }
        return res;
    }

    public String getRspecTypeVersion(LegacyApiTestConfig testConfig) {
        String res = TextUtil.objectToStringOrNull((Object)testConfig.get("rspecTypeVersion"), (boolean)true);
        if (res == null) {
            return "3";
        }
        return res;
    }

    public boolean isRspecTypeGeni3(LegacyApiTestConfig testConfig) {
        String name = TextUtil.objectToStringOrNull((Object)testConfig.get("rspecTypeName"), (boolean)true);
        String ver = TextUtil.objectToStringOrNull((Object)testConfig.get("rspecTypeVersion"), (boolean)true);
        return !(name != null && !name.equalsIgnoreCase("geni") || ver != null && !ver.equals("3"));
    }

    public static boolean preferSliverType(String sliverTypeNameA, String sliverTypeNameB) {
        int scoreB;
        if (sliverTypeNameB == null) {
            return true;
        }
        int scoreA = CommonAMTest.getSliverTypeNameScore(sliverTypeNameA);
        return scoreA > (scoreB = CommonAMTest.getSliverTypeNameScore(sliverTypeNameB));
    }

    public static int getSliverTypeNameScore(String sliverTypeName) {
        if (sliverTypeName == null) {
            return 0;
        }
        if (sliverTypeName.equalsIgnoreCase("emulab-openvz")) {
            return 100;
        }
        if (sliverTypeName.equalsIgnoreCase("emulab-xen")) {
            return 98;
        }
        if (sliverTypeName.equalsIgnoreCase("plab-vserver")) {
            return 99;
        }
        if (sliverTypeName.equalsIgnoreCase("raw-pc")) {
            return 90;
        }
        if (sliverTypeName.equalsIgnoreCase("xo.small")) {
            return 80;
        }
        if (sliverTypeName.equalsIgnoreCase("xo.tiny")) {
            return 81;
        }
        if (sliverTypeName.startsWith("xo.")) {
            return 79;
        }
        if (sliverTypeName.contains("xen")) {
            return 63;
        }
        if (sliverTypeName.contains("openvz")) {
            return 62;
        }
        if (sliverTypeName.contains("virt")) {
            return 61;
        }
        if (sliverTypeName.contains("vz")) {
            return 60;
        }
        if (sliverTypeName.contains("raw")) {
            return 11;
        }
        if (sliverTypeName.contains("pc")) {
            return 10;
        }
        return 1;
    }

    public List<AnyCredential> getUser2Credentials() {
        assert (this.test != null);
        assert (this.secondUserConfig.getUser() != null);
        if (this.user2Credentials != null) {
            return this.user2Credentials;
        }
        try {
            this.user2Credentials = this.userAndSliceApiWrapperUser2.getUserCredentials(this.test.getLogger(), GeniUrn.parse((String)this.secondUserConfig.getUser().getUserUrnString()));
        }
        catch (JFedException e) {
            throw new RuntimeException(e);
        }
        assert (this.user2Credentials != null);
        assert (!this.user2Credentials.isEmpty());
        return this.user2Credentials;
    }

    private List<AnyCredential> getUserCredentialsList() {
        assert (this.test != null);
        assert (this.userAuthority != null);
        if (this.userCredentials != null && !this.userCredentials.isEmpty()) {
            return this.userCredentials;
        }
        try {
            if (this.testCredentialType == TestCredentialType.SPEAKSFOR && this.speaksForConfig.isSARequestMethodSpeaksFor()) {
                this.userAndSliceApiWrapperUser1.setSpeaksFor(this.speaksForConfig.getSpeaksForCredentials(), this.speaksForConfig.getUser2Urn());
                if (!this.speaksForConfig.isAutomaticSpeaksForOptionNames()) {
                    this.userAndSliceApiWrapperUser1.setExtraOptionsForCallsWithCredential(this.addCredentialExtraOptions(null));
                }
            }
            if (this.testCredentialType == TestCredentialType.REGULAR || this.testCredentialType == TestCredentialType.SPEAKSFOR && this.speaksForConfig.isSARequestMethodSpeaksFor()) {
                GeniUrn userUrn;
                if (this.testCredentialType == TestCredentialType.SPEAKSFOR) {
                    assert (this.speaksForConfig.isSARequestMethodSpeaksFor());
                    userUrn = this.speaksForConfig.getUser2Urn();
                } else {
                    userUrn = this.test.getUser().getUserUrn();
                }
                this.userCredentials = this.userAndSliceApiWrapperUser1.getUserCredentials(this.test.getLogger(), userUrn);
            } else {
                this.userCredentials = this.userAndSliceApiWrapperUser2.getUserCredentials(this.test.getLogger(), this.secondUserConfig.getUser().getUserUrn());
            }
        }
        catch (JFedException e) {
            throw new RuntimeException(e);
        }
        assert (this.userCredentials != null);
        assert (!this.userCredentials.isEmpty());
        return this.userCredentials;
    }

    public List<AnyCredential> getUserCredentialListForAM() {
        if (this.testCredentialType == TestCredentialType.REGULAR) {
            return this.getUserCredentialsList();
        }
        if (this.testCredentialType == TestCredentialType.SPEAKSFOR) {
            ArrayList<AnyCredential> res = new ArrayList<AnyCredential>();
            assert (this.speaksForConfig.getSpeaksForCredentials() != null);
            this.speaksForConfig.getSpeaksForCredentials().stream().filter(s4cred -> !res.contains(s4cred)).forEach(s4cred -> {
                this.test.note("Implementation bug (has been auto-fixed): speaksfor credential was not added automatically to user credential list");
                res.add((AnyCredential)s4cred);
            });
            res.addAll(this.getUserCredentialsList());
            return res;
        }
        if (this.testCredentialType == TestCredentialType.DELEGATION) {
            return Collections.singletonList(this.getDelegatedUserCredential());
        }
        throw new RuntimeException("unsupported credential type: " + String.valueOf((Object)this.testCredentialType));
    }

    public List<AnyCredential> getSliceCredentialListForAM(SliceInfo sliceInfo) {
        if (this.testCredentialType == TestCredentialType.REGULAR) {
            return sliceInfo.credentials;
        }
        if (this.testCredentialType == TestCredentialType.SPEAKSFOR) {
            ArrayList<AnyCredential> res = new ArrayList<AnyCredential>();
            List<AnyCredential> speaksForCredentials = this.speaksForConfig.getSpeaksForCredentials();
            if (!sliceInfo.credentials.containsAll(speaksForCredentials)) {
                assert (speaksForCredentials != null && !speaksForCredentials.isEmpty());
                res.addAll(speaksForCredentials);
                this.test.note("Implementation bug (has been auto-fixed): The wrapper is not automatically adding the speaksFor credential to the list of slice credentials");
            }
            res.addAll(sliceInfo.credentials);
            return res;
        }
        if (this.testCredentialType == TestCredentialType.DELEGATION) {
            return Collections.singletonList(sliceInfo.getDelegatedCredential(this.test.getUser(), this.secondUserConfig.getUser()));
        }
        throw new RuntimeException("unsupported credential type: " + String.valueOf((Object)this.testCredentialType));
    }

    public Map<String, Object> addCredentialExtraOptions(Map<String, Object> extraOptions) {
        if (this.testCredentialType != TestCredentialType.SPEAKSFOR) {
            return extraOptions;
        }
        assert (!this.speaksForConfig.isAutomaticSpeaksForOptionNames() && this.speaksForConfig.getSpeaksForOptionNames().isEmpty() || this.speaksForConfig.getUser2Urn() != null);
        if (this.speaksForConfig.isAutomaticSpeaksForOptionNames() || this.speaksForConfig.getSpeaksForOptionNames().isEmpty()) {
            return extraOptions;
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (extraOptions != null) {
            res.putAll(extraOptions);
        }
        for (String speaksForOptionName : this.speaksForConfig.getSpeaksForOptionNames()) {
            res.put(speaksForOptionName, this.speaksForConfig.getUser2Urn().getValue());
        }
        return res;
    }

    public void setupProxyForConnectionPool(LegacyApiTestConfig testConfig) {
        String mode;
        if (testConfig.get("sfaSshProxyMode") != null) {
            mode = testConfig.getProperty("sfaSshProxyMode");
            if (!Objects.equals(mode, "manual") && !Objects.equals(mode, "user")) {
                return;
            }
        } else {
            return;
        }
        if (Objects.equals(mode, "manual") && testConfig.get("sfaSshProxyHostName") != null) {
            String username;
            String sfaSshProxyHostName = (String)testConfig.get("sfaSshProxyHostName");
            int sfaSshProxyHostPort = Integer.parseInt(String.valueOf(testConfig.get("sfaSshProxyHostPort")));
            String sfaSshProxyHostKey = (String)testConfig.get("sfaSshProxyHostKey");
            if (testConfig.get("sfaSshProxyUsername") != null) {
                String sfaSshProxyUsername = (String)testConfig.get("sfaSshProxyUsername");
                String loggedInUserName = this.test.getUser().getUserUrn().getEncodedResourceName();
                username = sfaSshProxyUsername;
                boolean limitName = username.contains("$USER");
                username = username.replace("$USER", loggedInUserName);
                if (limitName) {
                    username = Proxy.limitUsername((String)username);
                }
            } else {
                username = Proxy.limitUsername((String)this.test.getUser().getUserUrn().getEncodedResourceName());
            }
            String sfaSshProxyKeySource = (String)testConfig.get("sfaSshProxyKeySource");
            GeniUserSshKeyInfo sshKeyInfo = null;
            if (sfaSshProxyKeySource.equalsIgnoreCase("user")) {
                this.test.note("Using user private key as proxy private key.");
                sshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)this.test.getUser());
            }
            if (sfaSshProxyKeySource.equalsIgnoreCase("file")) {
                this.test.warn("Configuration warning: Test option sfaSshProxyKeySource=\"" + sfaSshProxyKeySource + "\" is not implemented yet. Cannot continue, will do test WITHOUT proxy.");
            }
            if (sshKeyInfo == null) {
                this.test.warn("Configuration error: Test option sfaSshProxyKeySource=\"" + sfaSshProxyKeySource + "\" is not known. Cannot continue, will do test WITHOUT proxy.");
            } else {
                JFedConnection.SshProxyInfo sfaSshProxyInfo = new JFedConnection.SshProxyInfo(sfaSshProxyHostName, sfaSshProxyHostPort, username, (SshKeyInfo)sshKeyInfo, sfaSshProxyHostKey);
                this.test.note("Using SSH proxy for SSH login test: " + String.valueOf(sfaSshProxyInfo));
                ((SfaConnectionPool)this.test.getConnectionProvider()).setDefaultProxy((JFedConnection.ProxyInfo)sfaSshProxyInfo);
            }
            return;
        }
        if (Objects.equals(mode, "user")) {
            GeniUser user = this.test.getUser();
            Integer userServerId = user.getUserAuthorityServerId();
            Server userServer = this.testbedInfoSource.getServerById(userServerId);
            if (userServer.getTestbed().getProxies().isEmpty()) {
                this.test.warn("This logged in user's authority does not have a proxy that jFed can use.");
                return;
            }
            Proxy authProxyInfo = (Proxy)userServer.getTestbed().getProxies().get(0);
            VlanRange portRange = new VlanRange(authProxyInfo.getPortRange());
            Integer port = portRange.getFirst();
            GeniUserSshKeyInfo userSshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)this.test.getUser());
            JFedConnection.SshProxyInfo proxyInfo = new JFedConnection.SshProxyInfo(authProxyInfo.getHostname(), port.intValue(), authProxyInfo.transformUsername(user.getUserUrn().getEncodedResourceName()), (SshKeyInfo)userSshKeyInfo, authProxyInfo.getHostKey());
            this.test.note("Using proxy for AM connections: " + String.valueOf(proxyInfo));
            ((SfaConnectionPool)this.test.getConnectionProvider()).setDefaultProxy((JFedConnection.ProxyInfo)proxyInfo);
            return;
        }
    }

    public void selectRegularTestCredentialType(ApiTest test) {
        this.testCredentialType = TestCredentialType.REGULAR;
        this.speaksForConfig = null;
        this.secondUserConfig = null;
        this.delegatedUserCredential = null;
        this.speaksForUserCredential = null;
        this.user2Credentials = null;
        for (SliceInfo sliceInfo : this.allSliceInfo) {
            sliceInfo.delegatedCredential = null;
        }
        this.userAndSliceApiWrapperUser2 = null;
    }

    public SfaCredential getDelegatedUserCredential() {
        if (this.delegatedUserCredential != null) {
            return this.delegatedUserCredential;
        }
        if (this.user2Credentials == null || this.user2Credentials.isEmpty()) {
            this.getUser2Credentials();
        }
        if (this.user2Credentials == null || this.user2Credentials.isEmpty()) {
            throw new RuntimeException("User credential is null");
        }
        GeniUser user1 = this.test.getUser();
        GeniUser user2 = this.secondUserConfig.getUser();
        SfaCredential sfaUser2Credential = null;
        for (AnyCredential user2Credential : this.user2Credentials) {
            if (!(user2Credential instanceof SfaCredential)) continue;
            sfaUser2Credential = (SfaCredential)user2Credential;
        }
        if (sfaUser2Credential == null) {
            throw new RuntimeException("No SFA user 2 credential available: " + String.valueOf(this.user2Credentials));
        }
        try {
            this.delegatedUserCredential = sfaUser2Credential.delegate(user1.getUserUrnString(), (X509Certificate)user1.getClientCertificateChain().get(0), user2.getPrivateKey(), new Date(System.currentTimeMillis() + 86400000L), "*", false);
        }
        catch (CredentialException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        assert (this.delegatedUserCredential != null);
        return this.delegatedUserCredential;
    }

    public SliceInfo createSlice(String prefix, String project, boolean preferUsingProject, boolean supportsFixedRspecOption) throws JFedException, IOException {
        return this.createSlice(prefix, project, preferUsingProject, supportsFixedRspecOption, 60);
    }

    public SliceInfo createSlice(String prefix, String project, boolean preferUsingProject, boolean supportsFixedRspecOption, int sliceExpireTimeInMinutes) throws JFedException, IOException {
        return this.createSlice(prefix, true, project, preferUsingProject, supportsFixedRspecOption, sliceExpireTimeInMinutes);
    }

    public static void addOptionsForFixedRspec(List<String> res) {
        res.add("fixed_rspec");
        res.add("fixed_rspec_file");
        res.add("fixed_rspec_url");
        res.add("fixed_rspec_bind_unbound_to");
        res.add("fixed_rspec_set_component_urn");
    }

    public String bindUnboundTo(String rspec, String target) {
        return CommonAMTest.bindUnboundTo(this.test, rspec, target);
    }

    public static String bindUnboundTo(ApiTest test, String rspec, String target) {
        String targetComponentManagerId;
        if (target.trim().equalsIgnoreCase("auto") || target.trim().equalsIgnoreCase("target")) {
            if (test.getTestedAuthority() == null) {
                throw new IllegalStateException("Cannot bind unbound nodes to target of this test if there is not target set.");
            }
            targetComponentManagerId = test.getTestedAuthority().getRspecUrn().toString();
            test.note("Will bind unbound nodes to target of this test: \"" + targetComponentManagerId + "\"");
        } else {
            targetComponentManagerId = target;
        }
        return RspecBinder.bindUnboundTo(test::warn, s -> test.warn((String)s, true), test::note, (String)rspec, (String)targetComponentManagerId);
    }

    public String forceComponentUrn(String rspec, String componentUrn) {
        if (componentUrn == null || componentUrn.trim().isEmpty() || rspec == null) {
            return rspec;
        }
        ImmutableRequestRspecSource requestRspecSource = new ImmutableRequestRspecSource(rspec, ModelRspecType.BASIC);
        BasicModelRspec model = (BasicModelRspec)requestRspecSource.getModelRspec(ModelRspecType.BASIC, new ProgressHandler[0]);
        if (model == null) {
            this.test.warn("Could not parse provided RSpec. Will not try to force component_urn.");
            return rspec;
        }
        if (requestRspecSource.isLosingData(ModelRspecType.BASIC)) {
            this.test.warn("Something is wrong in RSpec. Because of this, the component_urn cannot be set without losing data. Will not force component_urn.");
            return rspec;
        }
        if (GeniUrn.parse((String)componentUrn) == null) {
            this.test.warn("The configured target to force component_urn (\"force fixed_rspec_set_component_urn\" option) is not a valid URN: \"" + componentUrn + "\". Will not force component_urn.");
            return rspec;
        }
        this.test.note("Will force component_urn of first node to: \"" + componentUrn + "\"");
        GeniUrn targetComponentIdUrn = GeniUrn.parse((String)componentUrn);
        assert (targetComponentIdUrn != null);
        BasicRspecNode node0 = (BasicRspecNode)model.getNodes().get(0);
        node0.setComponentId(targetComponentIdUrn);
        return model.toGeni3Rspec();
    }

    public String getFixedRspecOption() throws IOException {
        if (!this.hasCachedFixedRspec) {
            this.cachedFixedRspec = this.getFixedRspecOptionInternal();
            this.hasCachedFixedRspec = true;
        }
        return this.cachedFixedRspec;
    }

    public boolean isFixedRspec() throws IOException {
        if (!this.hasCachedFixedRspec) {
            this.cachedFixedRspec = this.getFixedRspecOptionInternal();
            this.hasCachedFixedRspec = true;
        }
        return this.cachedFixedRspec != null;
    }

    public boolean isGeniFixedRspec() throws IOException {
        if (!this.hasCachedFixedRspec) {
            this.cachedFixedRspec = this.getFixedRspecOptionInternal();
            this.hasCachedFixedRspec = true;
        }
        return this.cachedIsGeniFixedRspec;
    }

    public String getFixedRspecOptionInternal() throws IOException {
        String rspecArg = ((LegacyApiTestConfig)this.test.getTestConfig()).getProperty("fixed_rspec");
        String rspecFileArg = ((LegacyApiTestConfig)this.test.getTestConfig()).getProperty("fixed_rspec_file");
        String rspecUrlArg = ((LegacyApiTestConfig)this.test.getTestConfig()).getProperty("fixed_rspec_url");
        String rspecBindUnboundArg = ((LegacyApiTestConfig)this.test.getTestConfig()).getProperty("fixed_rspec_bind_unbound_to");
        String forceComponentUrn = ((LegacyApiTestConfig)this.test.getTestConfig()).getProperty("fixed_rspec_set_component_urn");
        int countRspecArgs = 0;
        if (rspecArg != null) {
            ++countRspecArgs;
        }
        if (rspecFileArg != null) {
            ++countRspecArgs;
        }
        if (rspecUrlArg != null) {
            ++countRspecArgs;
        }
        if (countRspecArgs > 1) {
            throw new RuntimeException("There are three options that control the use of a fixed_rspec: fixed_rspec, fixed_rspec_file and fixed_rspec_url. You provided more than 1, which is not allowed.");
        }
        String res = null;
        if (rspecArg != null) {
            if (rspecArg.trim().isEmpty()) {
                this.test.warn("Empty Rspec specified in config");
                return null;
            }
            res = rspecArg;
        }
        if (rspecFileArg != null) {
            String rspec = IOUtils.fileToString((String)rspecFileArg);
            if (rspec == null || rspec.trim().isEmpty()) {
                this.test.warn("Empty Rspec read from file \"" + rspecFileArg + "\"");
                return null;
            }
            res = rspec;
        }
        if (rspecUrlArg != null) {
            URL url = new URL(rspecUrlArg);
            try (InputStream is = url.openStream();){
                String rspec = IOUtils.streamToString((InputStream)is, (String)"UTF-8");
                if (rspec == null || rspec.trim().isEmpty()) {
                    this.test.warn("Empty Rspec read from URL \"" + rspecUrlArg + "\"");
                    String string = null;
                    return string;
                }
                String head = TextUtil.abbreviate((String)rspec, (int)200);
                this.test.note("Downloaded Rspec from \"" + rspecUrlArg + "\". Rspec size: " + rspec.length() + " characters.\nHead: " + head, true);
                res = rspec;
            }
        }
        if (res != null) {
            try {
                BasicStringRspec basicStringRspec = new BasicStringRspec(res);
                this.cachedIsGeniFixedRspec = basicStringRspec.isValidRspec();
            }
            catch (Exception e) {
                this.cachedIsGeniFixedRspec = false;
            }
        }
        if (res != null && rspecBindUnboundArg != null && !rspecBindUnboundArg.trim().isEmpty()) {
            if (!this.cachedIsGeniFixedRspec) {
                this.test.warn("Test options specify an authority to bind unbound nodes to (" + rspecBindUnboundArg + "), but the provided fixed RSpec is NOT a geni 3 RSpec: cannot bind!");
            } else {
                res = this.bindUnboundTo(res, rspecBindUnboundArg);
            }
        }
        if (res != null && forceComponentUrn != null && !forceComponentUrn.trim().isEmpty()) {
            if (!this.cachedIsGeniFixedRspec) {
                this.test.warn("Test options specify an component_urn to set the first node to (" + forceComponentUrn + "), but the provided fixed RSpec is NOT a geni 3 RSpec: cannot set!");
            } else {
                res = this.forceComponentUrn(res, forceComponentUrn);
            }
        }
        return res;
    }

    public void registerSlivers(SliceInfo slice, Server authority, Collection<GeniUrn> sliverUrns, Date expirationDate) throws JFedException {
        if (this.testCredentialType == TestCredentialType.REGULAR || this.testCredentialType == TestCredentialType.SPEAKSFOR && this.speaksForConfig.isSARequestMethodSpeaksFor()) {
            this.userAndSliceApiWrapperUser1.registerAggregatesForSlice(this.test.getLogger(), slice.credentials, slice.urn, authority.getDefaultComponentManagerAsGeniUrn(), sliverUrns, expirationDate, null);
        } else {
            this.userAndSliceApiWrapperUser2.registerAggregatesForSlice(this.test.getLogger(), slice.credentials, slice.urn, authority.getDefaultComponentManagerAsGeniUrn(), sliverUrns, expirationDate, null);
        }
    }

    public void unregisterSlivers(SliceInfo slice, Server authority, Collection<GeniUrn> sliverUrns) throws JFedException {
        if (this.testCredentialType == TestCredentialType.REGULAR || this.testCredentialType == TestCredentialType.SPEAKSFOR && this.speaksForConfig.isSARequestMethodSpeaksFor()) {
            this.userAndSliceApiWrapperUser1.unregisterAggregatesForSlice(this.test.getLogger(), slice.credentials, slice.urn, authority.getDefaultComponentManagerAsGeniUrn(), sliverUrns);
        } else {
            this.userAndSliceApiWrapperUser2.unregisterAggregatesForSlice(this.test.getLogger(), slice.credentials, slice.urn, authority.getDefaultComponentManagerAsGeniUrn(), sliverUrns);
        }
    }

    public SliceInfo createSlice(String prefixOrName, boolean createName, String project, boolean preferUsingProject, boolean supportsFixedRspecOption) throws JFedException, IOException {
        return this.createSlice(prefixOrName, createName, project, preferUsingProject, supportsFixedRspecOption, 60);
    }

    public SliceInfo createSlice(String prefixOrName, boolean createName, String project, boolean preferUsingProject, boolean supportsFixedRspecOption, int sliceExpireTimeInMinutes) throws JFedException, IOException {
        String fixedRspec;
        this.test.note("testCredentialType = " + String.valueOf((Object)this.testCredentialType));
        if (this.testCredentialType == TestCredentialType.SPEAKSFOR && this.speaksForConfig.isSARequestMethodSpeaksFor()) {
            List<AnyCredential> speaksForCreds = this.speaksForConfig.getSpeaksForCredentials();
            assert (speaksForCreds != null && !speaksForCreds.isEmpty());
            this.test.note("Activating speaksFor Credential");
            if (speaksForCreds == null || speaksForCreds.isEmpty()) {
                this.test.warn("Error activating speaksFor credential");
            } else {
                this.userAndSliceApiWrapperUser1.setSpeaksFor(speaksForCreds, this.speaksForConfig.getUser2Urn());
                if (!this.speaksForConfig.isAutomaticSpeaksForOptionNames()) {
                    this.userAndSliceApiWrapperUser1.setExtraOptionsForCallsWithCredential(this.addCredentialExtraOptions(null));
                }
            }
        }
        Date expirationDate = new Date(System.currentTimeMillis() + (long)(sliceExpireTimeInMinutes * 60) * 1000L);
        int maxNodeNameLength = 3;
        if (supportsFixedRspecOption && (fixedRspec = this.getFixedRspecOption()) != null && this.isGeniFixedRspec()) {
            ImmutableRequestRspecSource source = new ImmutableRequestRspecSource(fixedRspec, ModelRspecType.BASIC);
            this.test.assertNotNull(source.getBasicNodeInfo(), "Problem parsing RSpec. RSpec head=" + TextUtil.abbreviate((String)fixedRspec, (int)200));
            for (BasicStringRspec.BasicNodeInfo basicNodeInfo : source.getBasicNodeInfo()) {
                String nodeName = basicNodeInfo.getClientId() != null ? basicNodeInfo.getClientId().trim() : null;
                if (nodeName == null || nodeName.length() <= maxNodeNameLength) continue;
                maxNodeNameLength = nodeName.length();
            }
        }
        SliceInfo res = new SliceInfo();
        int tries = 0;
        boolean success = false;
        while (!success) {
            res.name = createName ? CommonAMTest.createSliceName(this.test, this.userAuthority, ApiInfo.getDefaultComponentManagerForEach(this.testedAuthoritiesForRspec), prefixOrName, maxNodeNameLength, this.speaksForConfig) : prefixOrName;
            res.urn = GeniUrn.createGeniUrnFromEncodedParts((String)this.userAuthority.getUrnTld(), (String)"slice", (String)res.name);
            res.urnString = res.urn.toString();
            try {
                UserAndSliceApiWrapper.SliceInfo sliceInfo;
                if (this.testCredentialType == TestCredentialType.REGULAR || this.testCredentialType == TestCredentialType.SPEAKSFOR && this.speaksForConfig.isSARequestMethodSpeaksFor()) {
                    GeniUrn userUrn;
                    GeniUser user1 = this.test.getUser();
                    if (this.testCredentialType == TestCredentialType.SPEAKSFOR) {
                        assert (this.speaksForConfig.isSARequestMethodSpeaksFor());
                        userUrn = this.speaksForConfig.getUser2Urn();
                    } else {
                        userUrn = this.test.getUser().getUserUrn();
                    }
                    String subAuthorityName = CommonAMTest.findProject(this.test, this.test.getLogger(), project, user1, userUrn, this.userAndSliceApiWrapperUser1, preferUsingProject);
                    sliceInfo = this.userAndSliceApiWrapperUser1.createSlice(this.test.getLogger(), res.name, expirationDate, subAuthorityName);
                } else {
                    GeniUser user2 = this.secondUserConfig.getUser();
                    String subAuthorityName = CommonAMTest.findProject(this.test, this.test.getLogger(), project, user2, user2.getUserUrn(), this.userAndSliceApiWrapperUser2, preferUsingProject);
                    sliceInfo = this.userAndSliceApiWrapperUser2.createSlice(this.test.getLogger(), res.name, expirationDate, subAuthorityName);
                }
                res.credentials = sliceInfo.getCredentials();
                res.urn = sliceInfo.getUrn();
                res.urnString = res.urn.toString();
                success = true;
            }
            catch (Exception e) {
                LOG.warn("Exception creating slice, will ignore for now", (Throwable)e);
                success = false;
            }
            if (success) continue;
            this.test.assertTrue(++tries <= 3, "tried " + tries + " times. Maximum tries is 3. -> Giving up!");
            if (tries > 3) {
                res.credentials = null;
                break;
            }
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException e) {}
        }
        this.test.assertNotNull(res.credentials);
        this.test.assertNotEmpty(res.credentials);
        this.test.assertNotNull(res.credentials);
        this.test.assertNotEmpty(res.credentials);
        this.allSliceInfo.add(res);
        this.logParsableInfo(res.name, "slice", "name");
        this.logParsableInfo(res.urnString, "slice", "urn");
        if (res.credentials != null && res.credentials.size() > 0) {
            try {
                for (AnyCredential c : res.credentials) {
                    Gid gid;
                    if (!(c instanceof SfaCredential)) continue;
                    SfaCredential sc = (SfaCredential)c;
                    if (sc.getTargetGid() != null && !sc.getTargetGid().trim().isEmpty() && (gid = new Gid(sc.getTargetGid())).getSubjectUuid() != null) {
                        this.logParsableInfo(gid.getSubjectUuid(), "slice", "uuid");
                    }
                    GeniUrn targetUrn = GeniUrn.parse((String)sc.getTargetUrn());
                    this.test.assertNotNull(targetUrn, "The slice credential does not have a valid target URN: " + sc.getTargetUrn());
                    if (targetUrn.getEncodedResourceType().equalsIgnoreCase("auth") || targetUrn.getEncodedResourceType().equalsIgnoreCase("auth") || targetUrn.getEncodedResourceType().equalsIgnoreCase("user")) {
                        this.test.fatalError("The slice credential is not a slice URN: " + sc.getTargetUrn());
                    }
                    if (targetUrn.getEncodedResourceType().equalsIgnoreCase("slice")) continue;
                    this.test.warn("The slice credential is probably not a slice URN: " + sc.getTargetUrn());
                }
            }
            catch (Exception t) {
                LOG.error("Error retrieving slice UUID info", (Throwable)t);
                this.test.note("Debug info: Error retrieving slice UUID info: " + t.getMessage());
            }
        }
        return res;
    }

    @Nullable
    public static String findProject(@Nonnull ApiTest test, @Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nullable String specifiedProject, @Nonnull GeniUser user, @Nonnull GeniUrn userUrn, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, boolean preferUsingProject) {
        List subAuthorityNames;
        if (specifiedProject != null) {
            return specifiedProject;
        }
        if (!preferUsingProject) {
            return null;
        }
        try {
            if (!userAndSliceApiWrapper.hasUserCredentials()) {
                userAndSliceApiWrapper.getUserCredentials(logger, userUrn);
            }
            subAuthorityNames = userAndSliceApiWrapper.getSubAuthorityNames(logger, userUrn);
        }
        catch (Exception t) {
            LOG.warn("Exception while getting sub authority names. will try to ignore.", (Throwable)t);
            test.note("Exception while getting sub authority names. will try to ignore. Exception: " + t.getMessage());
            subAuthorityNames = Collections.emptyList();
        }
        if (!subAuthorityNames.isEmpty()) {
            return (String)subAuthorityNames.get(0);
        }
        UserAndSliceApiWrapper.SubAuthoritySupport subAuthoritySupport = null;
        try {
            subAuthoritySupport = userAndSliceApiWrapper.getSubAuthoritySupport(logger);
        }
        catch (JFedException e) {
            throw new RuntimeException("Failed to check if slice authority requires a mandatory authority/project for creating a slice");
        }
        if (Objects.equals(subAuthoritySupport, UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_MANDATORY)) {
            throw new RuntimeException("There are no sub authorities for user " + String.valueOf(user.getUserUrn()));
        }
        return null;
    }

    public SliceInfo reuseSlice(String sliceName) throws JFedException {
        boolean callAsUser1;
        boolean bl = callAsUser1 = this.testCredentialType == TestCredentialType.REGULAR;
        assert (callAsUser1 != (this.testCredentialType == TestCredentialType.SPEAKSFOR || this.testCredentialType == TestCredentialType.DELEGATION));
        if (this.testCredentialType == TestCredentialType.SPEAKSFOR && this.speaksForConfig.isSARequestMethodSpeaksFor()) {
            callAsUser1 = true;
        }
        SliceInfo res = new SliceInfo();
        boolean tries = false;
        res.name = sliceName;
        res.urn = null;
        res.urnString = null;
        try {
            if (callAsUser1) {
                GeniUrn userUrn;
                if (this.testCredentialType == TestCredentialType.SPEAKSFOR) {
                    assert (this.speaksForConfig.isSARequestMethodSpeaksFor());
                    userUrn = this.speaksForConfig.getUser2Urn();
                } else {
                    userUrn = this.test.getUser().getUserUrn();
                }
                if (!this.userAndSliceApiWrapperUser1.hasUserCredentials()) {
                    this.userAndSliceApiWrapperUser1.getUserCredentials(this.test.getLogger(), userUrn);
                }
                List sliceUrns = this.userAndSliceApiWrapperUser1.getSlicesForUser(this.test.getLogger(), userUrn);
                for (GeniUrn sliceUrn : sliceUrns) {
                    if (!Objects.equals(sliceUrn.getEncodedResourceName(), sliceName)) continue;
                    res.urn = sliceUrn;
                    break;
                }
                if (res.urn == null) {
                    return null;
                }
                res.credentials = this.userAndSliceApiWrapperUser1.getSliceCredentials(this.test.getLogger(), res.urn);
            } else {
                List sliceUrns = this.userAndSliceApiWrapperUser2.getSlicesForUser(this.test.getLogger(), this.secondUserConfig.getUser().getUserUrn());
                for (GeniUrn sliceUrn : sliceUrns) {
                    if (!Objects.equals(sliceUrn.getEncodedResourceName(), sliceName)) continue;
                    res.urn = sliceUrn;
                    break;
                }
                if (res.urn == null) {
                    return null;
                }
                res.credentials = this.userAndSliceApiWrapperUser2.getSliceCredentials(this.test.getLogger(), res.urn);
            }
        }
        catch (Exception e) {
            LOG.info("Exception trying to reuse slice, will ignore", (Throwable)e);
            this.test.note("Exception trying to reuse slice, will ignore", e);
            return null;
        }
        this.test.assertNotNull(res.urn);
        res.urnString = res.urn.toString();
        this.test.assertNotNull(res.credentials);
        this.test.assertNotEmpty(res.credentials);
        this.allSliceInfo.add(res);
        return res;
    }

    public SliceInfo renewSlice(SliceInfo sliceInfo, Date newExpirationtime) throws JFedException {
        boolean callAsUser1;
        boolean bl = callAsUser1 = this.testCredentialType == TestCredentialType.REGULAR;
        assert (callAsUser1 != (this.testCredentialType == TestCredentialType.SPEAKSFOR || this.testCredentialType == TestCredentialType.DELEGATION));
        sliceInfo.credentials = callAsUser1 ? this.userAndSliceApiWrapperUser1.renewSlice(this.test.getLogger(), sliceInfo.credentials, newExpirationtime) : this.userAndSliceApiWrapperUser2.renewSlice(this.test.getLogger(), sliceInfo.credentials, newExpirationtime);
        this.test.assertNotNull(sliceInfo.credentials);
        this.test.assertNotEmpty(sliceInfo.credentials);
        return sliceInfo;
    }

    public static boolean sameNodesInRequestAndManifest(@Nonnull ApiTest test, @Nonnull String requestRspec, @Nonnull String manifestRspec) {
        List basicNodeInfoRequest = new BasicStringRspec(requestRspec).getBasicNodeInfo();
        List basicNodeInfoManifest = new BasicStringRspec(manifestRspec).getBasicNodeInfo();
        if (basicNodeInfoRequest == null || basicNodeInfoManifest == null) {
            return false;
        }
        if (basicNodeInfoManifest.size() < basicNodeInfoRequest.size()) {
            return false;
        }
        if (basicNodeInfoManifest.size() > basicNodeInfoRequest.size()) {
            test.warn("There are more nodes in manifest(" + basicNodeInfoManifest.size() + ") than in request(" + basicNodeInfoRequest.size() + ")!");
        }
        boolean res = true;
        Object clientIds = "";
        for (BasicStringRspec.BasicNodeInfo requestNode : basicNodeInfoRequest) {
            String clientId = requestNode.getClientId();
            clientIds = (String)clientIds + " \"" + clientId + "\"";
            if (clientId == null) continue;
            boolean found = false;
            for (BasicStringRspec.BasicNodeInfo manifestNode : basicNodeInfoManifest) {
                if (manifestNode.getClientId() == null || !Objects.equals(manifestNode.getClientId(), clientId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            test.errorNonFatal("Request RSpec had node with client_id \"" + clientId + "\" but the received manifest does not have this node.");
            res = false;
        }
        if (res) {
            test.note("Successfully found the following client_id's in both request and manifest:" + (String)clientIds);
        }
        return res;
    }

    public static void addCredentialOptions(List<String> res) {
        res.add("credentialType");
        res.addAll(SpeaksForConfig.getFixedOptionNames());
    }

    public void processCredentialOptions(TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder) {
        if (((LegacyApiTestConfig)this.test.getTestConfig()).get("credentialType") != null) {
            boolean dele;
            String credentialTypeParameter = (String)((LegacyApiTestConfig)this.test.getTestConfig()).get("credentialType");
            boolean known = false;
            boolean normal = credentialTypeParameter.trim().equalsIgnoreCase("normal") || credentialTypeParameter.trim().equalsIgnoreCase("regular");
            boolean sf = credentialTypeParameter.trim().equalsIgnoreCase("speaksFor");
            boolean bl = dele = credentialTypeParameter.trim().equalsIgnoreCase("delegation") || credentialTypeParameter.trim().equalsIgnoreCase("delegated") || credentialTypeParameter.trim().equalsIgnoreCase("delegate");
            if (normal) {
                this.test.note("All tests will test regular credentials");
                this.selectRegularTestCredentialType(this.test);
            }
            if (dele) {
                this.testCredentialType = TestCredentialType.DELEGATION;
                this.test.note("All tests will test delegated credentials");
                throw new RuntimeException("Delegated credentials are no longer supported. Support needs to be reimplemented.");
            }
            if (sf) {
                this.test.note("All tests will test speaks-for credentials");
                this.testCredentialType = TestCredentialType.SPEAKSFOR;
                this.speaksForConfig = new SpeaksForConfig();
                this.speaksForConfig.process(this.test, ((LegacyApiTestConfig)this.test.getTestConfig()).getProperties(), testbedInfoSource, authorityFinder);
                if (this.speaksForConfig.isSARequestMethodLogin()) {
                    this.secondUserConfig = this.speaksForConfig.getUser2Config();
                    assert (this.secondUserConfig != null);
                    assert (this.secondUserConfig.getUser() != null);
                    this.userAndSliceApiWrapperUser2 = this.test.getAutomaticUserAndSliceApiWrapperFactory().create(this.secondUserConfig.getUser());
                } else {
                    this.userAndSliceApiWrapperUser2 = null;
                    this.secondUserConfig = null;
                }
            }
            if (!(sf || dele || normal)) {
                throw new RuntimeException("credentialType parameter has unrecognized value \"" + credentialTypeParameter + "\". Possible values: regular speaksFor delegation");
            }
        } else {
            this.test.note("All tests will test regular credentials");
            this.selectRegularTestCredentialType(this.test);
        }
    }

    public Server getUserAuthorityServer() {
        return this.userAuthority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPingResult(Session conn, String result) {
        if (result != null && ((String)result).length() > 5) {
            Pattern patternTrans = Pattern.compile("([0-9]*) packets transmitted");
            Matcher matcherTrans = patternTrans.matcher((CharSequence)result);
            this.test.assertTrue(matcherTrans.find(), "Did not find \"[0-9]* packets transmitted\" in result");
            String sent = matcherTrans.group(1);
            Pattern patternRecv = Pattern.compile("([0-9]*) received");
            Matcher matcherRecv = patternRecv.matcher((CharSequence)result);
            this.test.assertTrue(matcherRecv.find(), "Did not find \"[0-9]* received\" in result");
            String recv = matcherRecv.group(1);
            if (!(conn == null || Objects.equals(sent, "5") && Objects.equals(recv, "5"))) {
                try {
                    String command = "echo; route - n; echo; echo; ifconfig -a";
                    Session.Command comm = conn.exec(command);
                    comm.join();
                    result = "";
                    Object err = "";
                    try {
                        BufferedReader sout = new BufferedReader(new InputStreamReader(comm.getInputStream()));
                        BufferedReader serr = new BufferedReader(new InputStreamReader(comm.getErrorStream()));
                        String line = sout.readLine();
                        while (line != null) {
                            result = (String)result + line + "\n";
                            line = sout.readLine();
                        }
                        line = serr.readLine();
                        while (line != null) {
                            err = (String)err + line + "\n";
                            line = serr.readLine();
                        }
                    }
                    finally {
                        comm.close();
                    }
                    this.test.note("Ping failed, gathering informational with: \"" + command + "\" command. result: \"" + ((String)result).trim() + "\". (stderr is: \"" + (String)err + "\")", true);
                }
                catch (Exception e) {
                    this.test.note("Ping failed, also failed to gathering additional info: " + e.getMessage());
                    LOG.error("Ping failed, also failed to gathering additional info", (Throwable)e);
                }
            }
            this.test.assertEquals("5", sent, "Packets sent count is not 5: sent=\"" + sent + "\"  (recv=\"" + recv + "\")");
            this.test.assertEquals("5", recv, "Packets received count is not 5: \"" + recv + "\"");
            Pattern patternTiming = Pattern.compile("min/avg/max/mdev = ([0-9.]*)/([0-9.]*)/([0-9.]*)/([0-9.]*) ms");
            Matcher matcherTiming = patternTiming.matcher((CharSequence)result);
            if (matcherTiming.find()) {
                try {
                    Double min = Double.parseDouble(matcherTiming.group(1));
                    Double avg = Double.parseDouble(matcherTiming.group(2));
                    Double max = Double.parseDouble(matcherTiming.group(3));
                    Double mdev = Double.parseDouble(matcherTiming.group(4));
                    String pingTiming = min + "," + avg + "," + max + "," + mdev;
                    this.logParsableInfo(min, "ping_rtt", "min");
                    this.logParsableInfo(max, "ping_rtt", "max");
                    this.logParsableInfo(avg, "ping_rtt", "avg");
                    this.logParsableInfo(mdev, "ping_rtt", "mdev");
                    this.test.note("Ping timing (min,avg,max,mdev in ms): " + pingTiming);
                }
                catch (NumberFormatException e) {
                    this.test.note("Failed to parse a ping timing info double. Probably non-compatible ping version: " + e.getMessage());
                    LOG.warn("Failed to parse a ping timing info double. Probably non-compatible ping version", (Throwable)e);
                }
            } else {
                this.test.note("Failed to parse ping timing info. Probably non-compatible ping version.");
            }
        } else {
            this.test.errorNonFatal("No usable ping output seen.");
        }
    }

    public void logParsableInfo(@Nonnull Object val, String ... nestedkey) {
        this.test.addExtraResultWithBC(val, nestedkey);
    }

    public SpeaksForConfig getSpeaksForConfig() {
        return this.speaksForConfig;
    }

    public User2LoginConfig getSecondUserConfig() {
        return this.secondUserConfig;
    }

    private static enum TestCredentialType {
        REGULAR,
        SPEAKSFOR,
        DELEGATION;

    }

    private static class FedmonTestInfo {
        public final Integer testInstanceId;
        public final Long taskId;

        public FedmonTestInfo(Integer testInstanceId, Long taskId) {
            this.testInstanceId = testInstanceId;
            this.taskId = taskId;
        }
    }

    public static class SpeaksForConfig
    extends TestConfig {
        private boolean automaticSpeaksForOptionNames = true;
        private final List<String> speaksForOptionNames = new ArrayList<String>();
        private User2LoginConfig user2Config;
        private CredentialSource credentialSource;
        private SARequestMethod saRequestMethod;
        private AnyCredential userProvidedCredential;
        private AnyCredential generatedCredential;
        private GeniUrn user2Urn;
        private GeniUser user2Login;

        public void setSpeaksForOptionNames(List<String> newSpeaksForOptionNames) {
            this.speaksForOptionNames.clear();
            this.speaksForOptionNames.addAll(newSpeaksForOptionNames);
            this.automaticSpeaksForOptionNames = false;
        }

        public boolean isAutomaticSpeaksForOptionNames() {
            return this.automaticSpeaksForOptionNames;
        }

        public List<String> getSpeaksForOptionNames() {
            return this.speaksForOptionNames;
        }

        public CredentialSource getCredentialSource() {
            return this.credentialSource;
        }

        public SARequestMethod getSaRequestMethod() {
            return this.saRequestMethod;
        }

        public boolean isSARequestMethodLogin() {
            return this.saRequestMethod == SARequestMethod.LOGIN;
        }

        public boolean isSARequestMethodSpeaksFor() {
            return this.saRequestMethod == SARequestMethod.SPEAKSFOR;
        }

        public AnyCredential getUserProvidedCredential() {
            return this.userProvidedCredential;
        }

        public List<AnyCredential> getSpeaksForCredentials() {
            if (this.credentialSource == CredentialSource.USER_PROVIDED) {
                return this.userProvidedCredential == null ? null : this.userProvidedCredential.toCredentialList();
            }
            assert (this.credentialSource == CredentialSource.JFED_GENERATED);
            return this.generatedCredential == null ? null : this.generatedCredential.toCredentialList();
        }

        public User2LoginConfig getUser2Config() {
            return this.user2Config;
        }

        public GeniUser getUser2Login() {
            return this.user2Login;
        }

        public GeniUrn getUser2Urn() {
            return this.user2Urn;
        }

        public static List<String> getFixedOptionNames() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("speaksForOptionNames");
            res.add("saRequestMethod");
            res.add("credentialSource");
            res.add("providedSpeaksForCredential");
            res.addAll(User2LoginConfig.getFixedOptionNames());
            return res;
        }

        @Override
        public List<String> getOptionNames() {
            return SpeaksForConfig.getFixedOptionNames();
        }

        @Override
        public void process(ApiTest test, Properties properties, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder) {
            if (properties.containsKey("speaksForOptionNames")) {
                String speaksForOptionNamesString = (String)properties.get("speaksForOptionNames");
                if (speaksForOptionNamesString.trim().equalsIgnoreCase("automatic")) {
                    test.note("SpeaksFor option names will be chosen automatically based on the API used.");
                    this.automaticSpeaksForOptionNames = true;
                } else if (speaksForOptionNamesString.trim().equalsIgnoreCase("none")) {
                    test.note("No speaksFor option will be used.");
                    this.automaticSpeaksForOptionNames = false;
                    this.speaksForOptionNames.clear();
                } else {
                    String[] speaksForOptionNamesArray = speaksForOptionNamesString.trim().split(",");
                    this.speaksForOptionNames.clear();
                    this.automaticSpeaksForOptionNames = false;
                    for (String speaksForOptionName : speaksForOptionNamesArray) {
                        speaksForOptionName = speaksForOptionName.trim();
                        this.speaksForOptionNames.add(speaksForOptionName);
                    }
                    test.note("Setting speaksFor option names to use: " + String.valueOf(this.speaksForOptionNames));
                }
            } else {
                this.automaticSpeaksForOptionNames = true;
                this.speaksForOptionNames.clear();
                test.note("speaksFor option names to use: defaulting to automatically choosing based on API.");
            }
            String saRequestMethodString = "login";
            if (properties.containsKey("saRequestMethod")) {
                saRequestMethodString = ((String)properties.get("saRequestMethod")).trim();
            }
            this.saRequestMethod = SARequestMethod.valueOf(saRequestMethodString.toUpperCase());
            if (this.saRequestMethod == null) {
                throw new RuntimeException("Invalid \"saRequestMethod\" option: \"" + saRequestMethodString + "\" (valid options are: " + Arrays.toString((Object[])SARequestMethod.values()) + ")");
            }
            String credentialSourceString = "login";
            if (properties.containsKey("credentialSource")) {
                credentialSourceString = ((String)properties.get("credentialSource")).trim();
            }
            this.credentialSource = CredentialSource.valueOf(credentialSourceString.toUpperCase());
            if (this.credentialSource == null) {
                throw new RuntimeException("Invalid \"credentialSource\" option: \"" + credentialSourceString + "\" (valid options are: " + Arrays.toString((Object[])CredentialSource.values()) + ")");
            }
            if (this.saRequestMethod == SARequestMethod.LOGIN || this.credentialSource == CredentialSource.JFED_GENERATED) {
                if (!properties.containsKey("pemKeyAndCertFilename2")) {
                    throw new RuntimeException("Missing \"pemKeyAndCertFilename2\" option: this option is required when option \"saRequestMethod\"=\"LOGIN\" or when option \"credentialSource\"=\"JFED_GENERATED\"");
                }
                this.user2Config = new User2LoginConfig();
                this.user2Config.process(test, properties, testbedInfoSource, authorityFinder);
                this.user2Login = this.user2Config.getUser();
                this.user2Urn = this.user2Login.getUserUrn();
                if (this.credentialSource == CredentialSource.JFED_GENERATED) {
                    GeniUser user1 = test.getUser();
                    GeniUser user2 = this.user2Login;
                    try {
                        this.generatedCredential = SfaCredential.createSpeaksFor((String)user2.getUserUrnString(), (String)user1.getUserUrnString(), (X509Certificate)((X509Certificate)user2.getClientCertificateChain().get(0)), (X509Certificate)((X509Certificate)user1.getClientCertificateChain().get(0)), (PrivateKey)user2.getPrivateKey(), (Date)new Date(System.currentTimeMillis() + 86400000L), (String)"*", (boolean)false);
                    }
                    catch (CredentialException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            } else if (properties.containsKey("userUrn2")) {
                String user2UrnString = ((String)properties.get("userUrn2")).trim();
                try {
                    this.user2Urn = new GeniUrn(user2UrnString);
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    throw new RuntimeException("Failed to parse \"userUrn2\" option into a geni URN: \"" + user2UrnString + "\"", e);
                }
            } else {
                assert (this.saRequestMethod != SARequestMethod.LOGIN);
                assert (this.credentialSource != CredentialSource.JFED_GENERATED);
                if (this.automaticSpeaksForOptionNames || !this.speaksForOptionNames.isEmpty()) {
                    throw new RuntimeException("Missing \"userUrn2\" option: this option is required unless saRequestMethod != LOGIN AND credentialSource != JFED_GENERATED AND speaksForOptionNames = none");
                }
            }
            if (this.credentialSource == CredentialSource.USER_PROVIDED) {
                if (!properties.containsKey("providedSpeaksForCredential")) {
                    throw new RuntimeException("Missing \"providedSpeaksForCredential\" option: this option is required when option \"credentialSource\"=\"USER_PROVIDED\"");
                }
                String credentialXml = null;
                String providedSpeaksForCredential = ((String)properties.get("providedSpeaksForCredential")).trim();
                if (providedSpeaksForCredential.startsWith("/") || providedSpeaksForCredential.startsWith("file:")) {
                    try {
                        credentialXml = IOUtils.fileToString((String)providedSpeaksForCredential);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to read speaksfor credential from file \"" + providedSpeaksForCredential + "\"", e);
                    }
                }
                if (providedSpeaksForCredential.startsWith("<")) {
                    credentialXml = providedSpeaksForCredential;
                }
                if (credentialXml == null) {
                    throw new RuntimeException("Invalid \"providedSpeaksForCredential\" option: this option must be either a filename or and XML credential");
                }
                try {
                    this.userProvidedCredential = AnyCredential.createAutoDetect((String)"SpeaksFor Credential from test config", (String)credentialXml);
                }
                catch (CredentialException e) {
                    throw new RuntimeException(e);
                }
                if (this.userProvidedCredential == null) {
                    throw new RuntimeException("Problem with \"providedSpeaksForCredential\" option: failed to process credential.");
                }
                test.note("User 1=" + test.getUser().getUserUrnString() + " speaks for another user (speaksFor credential has been provided)");
            }
            if (this.saRequestMethod == SARequestMethod.SPEAKSFOR) {
                if (this.credentialSource != CredentialSource.USER_PROVIDED) {
                    throw new RuntimeException("Bad speaksfor config: saRequestMethod=" + String.valueOf((Object)this.saRequestMethod) + " can only be combined with credentialSource=" + String.valueOf((Object)CredentialSource.USER_PROVIDED) + " (but " + String.valueOf((Object)this.credentialSource) + " is configured)");
                }
                if (this.userProvidedCredential == null) {
                    throw new RuntimeException("Bad speaksfor config: saRequestMethod=" + String.valueOf((Object)this.saRequestMethod) + " combined with credentialSource=" + String.valueOf((Object)this.credentialSource) + " requires a speaksfor credential to be found, but this went wrong.");
                }
            }
        }

        public static enum CredentialSource {
            JFED_GENERATED,
            USER_PROVIDED;

        }

        public static enum SARequestMethod {
            LOGIN,
            SPEAKSFOR;

        }
    }

    public static class User2LoginConfig
    extends TestConfig {
        private GeniUser user;

        public static List<String> getFixedOptionNames() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("passwordFilename2");
            res.add("userUrn2");
            res.add("pemKeyAndCertFilename2");
            res.add("userAuthorityUrn2");
            return res;
        }

        @Override
        public List<String> getOptionNames() {
            return User2LoginConfig.getFixedOptionNames();
        }

        @Override
        public void process(ApiTest test, Properties properties, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder) {
            test.note("Processing config options for 2nd user");
            try {
                this.user = new ContextFile(properties, testbedInfoSource, authorityFinder).getUser("2");
            }
            catch (ContextFile.ContextFileException e) {
                throw new RuntimeException("Exception extracting user 2 details from context file", e);
            }
            test.assertNotNull(this.user);
            test.assertNotNull(this.user.getUserAuthorityServerId());
        }

        public GeniUser getUser() {
            return this.user;
        }
    }

    public static class SliceInfo {
        public String name;
        public GeniUrn urn;
        public List<AnyCredential> credentials;
        public SfaCredential delegatedCredential;
        public String urnString;

        public SfaCredential getDelegatedCredential(GeniUser receiverUser, GeniUser granterUser) {
            if (this.delegatedCredential != null) {
                return this.delegatedCredential;
            }
            if (this.credentials == null || this.credentials.isEmpty()) {
                return null;
            }
            SfaCredential sfaCredential = null;
            for (AnyCredential credential : this.credentials) {
                if (!(credential instanceof SfaCredential)) continue;
                sfaCredential = (SfaCredential)credential;
            }
            if (sfaCredential == null) {
                return null;
            }
            try {
                this.delegatedCredential = sfaCredential.delegate(receiverUser.getUserUrnString(), (X509Certificate)receiverUser.getClientCertificateChain().get(0), granterUser.getPrivateKey(), new Date(System.currentTimeMillis() + 86400000L), "*", false);
            }
            catch (CredentialException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return this.delegatedCredential;
        }
    }
}

