/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.shared;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.GeniUserSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.stitching.VlanRange;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.shared.Proxy;
import be.iminds.ilabt.jfed.util.lib.SSHKeyHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProxyInfoGenerator {
    @Nullable
    public static JFedConnection.SshProxyInfo generate(@Nonnull ApiTest apiTest, @Nonnull Proxy proxyConfig, @Nonnull GeniUserProvider geniUserProvider, @Nonnull String sliceName, @Nonnull SSHKeyHelper nodeLoginKeys, @Nonnull String nodeLoginUsername) {
        GeniUser user = geniUserProvider.getLoggedInGeniUser();
        apiTest.assertNotNull(user);
        if (proxyConfig.getMode() == Proxy.ProxyMode.OFF) {
            return null;
        }
        if (proxyConfig.getMode() == Proxy.ProxyMode.USER_AUTHORITY) {
            Server userAuth = user.getUserAuthorityServer();
            if (userAuth == null || userAuth.getTestbed().getProxies().isEmpty()) {
                apiTest.warn("This logged in user's authority does not have a proxy that jFed can use.");
                return null;
            }
            be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy authProxyInfo = (be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy)userAuth.getTestbed().getProxies().get(0);
            VlanRange portRange = new VlanRange(authProxyInfo.getPortRange());
            Integer port = portRange.getFirst();
            GeniUserSshKeyInfo userSshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)user);
            return new JFedConnection.SshProxyInfo(authProxyInfo.getHostname(), port.intValue(), authProxyInfo.transformUsername(user.getUserUrn().getEncodedResourceName()), (SshKeyInfo)userSshKeyInfo, authProxyInfo.getHostKey());
        }
        if (proxyConfig.getMode() == Proxy.ProxyMode.MANUAL) {
            SshKeyInfo key = null;
            switch (proxyConfig.getKeySource()) {
                case NODE: {
                    key = nodeLoginKeys.toSshKeyInfo();
                    break;
                }
                case USER: {
                    key = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)user);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported proxy key source " + String.valueOf((Object)proxyConfig.getKeySource()));
                }
            }
            String sshProxyUsername = proxyConfig.getUsername();
            String loggedInUserName = user.getUserUrn().getEncodedResourceName();
            String username = sshProxyUsername;
            boolean limitName = username.contains("$USER") || username.contains("$NODE") || username.contains("$SLICE");
            username = username.replace("$USER", loggedInUserName);
            username = username.replace("$NODE", nodeLoginUsername);
            username = username.replace("$SLICE", sliceName);
            if (limitName) {
                username = be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy.limitUsername((String)username);
            }
            return new JFedConnection.SshProxyInfo(proxyConfig.getHostName(), proxyConfig.getHostPort(), username, key, proxyConfig.getHostKey());
        }
        throw new IllegalArgumentException("Unsupported proxy mode " + String.valueOf((Object)proxyConfig.getMode()));
    }
}

