/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec;

import be.iminds.ilabt.jfed.espec.model.AnsibleGalaxySpec;
import be.iminds.ilabt.jfed.espec.model.AnsibleHostSpec;
import be.iminds.ilabt.jfed.espec.model.AnsiblePlaybookSpec;
import be.iminds.ilabt.jfed.espec.model.DirSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ESpecLogic {
    private ESpecLogic() {
        throw new RuntimeException("static helper class");
    }

    public static boolean hasAnsibleNode(@Nonnull ExperimentSpecification espec) {
        return espec.getAnsible() != null && espec.getAnsible().getAnsibleHostSpec().getHostType() != AnsibleHostSpec.HostType.LOCAL;
    }

    public static boolean isAnsibleSubPart(@Nonnull UploadLikeSpec uploadLikeSpec, @Nonnull ExperimentSpecification espec) {
        if (espec.getAnsible() == null) {
            return false;
        }
        if (uploadLikeSpec instanceof AnsiblePlaybookSpec) {
            return true;
        }
        if (uploadLikeSpec instanceof AnsibleGalaxySpec) {
            return true;
        }
        if (uploadLikeSpec instanceof AnsiblePlaybookSpec.ExtraVarsJsonFileSpec) {
            return true;
        }
        ArrayList<UploadLikeSpec> ansibleUploads = new ArrayList<UploadLikeSpec>();
        ansibleUploads.addAll(espec.getAnsible().getAnsibleHostSpec().getUploadLists());
        ansibleUploads.addAll(espec.getAnsible().getAnsibleHostSpec().getExecuteLists());
        ansibleUploads.addAll(espec.getAnsible().getAnsibleGalaxySpecs());
        ansibleUploads.addAll(espec.getAnsible().getAnsiblePlaybookSpecs());
        for (UploadLikeSpec ansibleUploadLikeSpec : ansibleUploads) {
            if (ansibleUploadLikeSpec != uploadLikeSpec) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnsibleNode(@Nonnull String clientId, @Nonnull ExperimentSpecification espec) {
        if (espec.getAnsible() == null) {
            return false;
        }
        if (espec.getAnsible().getAnsibleHostSpec().getHostType() == AnsibleHostSpec.HostType.LOCAL) {
            return false;
        }
        String ansibleNodeName = espec.getAnsible().getAnsibleHostSpec().getNodeName() == null ? "ansible" : espec.getAnsible().getAnsibleHostSpec().getNodeName();
        return clientId.equals(ansibleNodeName);
    }

    @Nonnull
    public static String getAnsibleNodeName(@Nonnull ExperimentSpecification experimentSpecification) {
        if (experimentSpecification.getAnsible() == null) {
            throw new IllegalStateException("Ansible section in ExperimentSpecification was assumed but not found");
        }
        String ansibleNodeName = experimentSpecification.getAnsible().getAnsibleHostSpec().getNodeName();
        if (ansibleNodeName == null) {
            return "ansible";
        }
        return ansibleNodeName;
    }

    public static boolean mustRunOn(@Nonnull String clientId, @Nullable Collection<String> ansibleGroupNames, @Nonnull ExperimentSpecification espec, @Nonnull DirSpec dirSpec) {
        if (dirSpec.getNodes() == null) {
            if (dirSpec.isAnsibleContent()) {
                return ESpecLogic.isAnsibleNode(clientId, espec);
            }
            return espec.getConfig().isIncludeAnsibleNodeInAllNodes() || !ESpecLogic.isAnsibleNode(clientId, espec);
        }
        return ESpecLogic.mustRunOnBecauseOfNodes(dirSpec.getNodes(), clientId, ansibleGroupNames);
    }

    public static boolean mustRunOn(@Nonnull String clientId, @Nullable Collection<String> ansibleGroupNames, @Nonnull ExperimentSpecification espec, @Nonnull UploadLikeSpec aSpec) {
        if (ESpecLogic.isAnsibleSubPart(aSpec, espec)) {
            return ESpecLogic.isAnsibleNode(clientId, espec);
        }
        if (aSpec.getNodes() != null && !aSpec.getNodes().isEmpty()) {
            return ESpecLogic.mustRunOnBecauseOfNodes(aSpec.getNodes(), clientId, ansibleGroupNames);
        }
        if (ESpecLogic.isAnsibleNode(clientId, espec)) {
            return true;
        }
        return espec.getConfig().isIncludeAnsibleNodeInAllNodes();
    }

    static boolean mustRunOnBecauseOfNodes(@Nullable Collection<String> nodes, @Nonnull String clientId, @Nullable Collection<String> ansibleGroupNames) {
        if (nodes != null) {
            boolean mustRun = nodes.contains(clientId);
            if (ansibleGroupNames != null && !mustRun && !ansibleGroupNames.isEmpty()) {
                mustRun = nodes.stream().filter(s -> s.startsWith("ansible_group:")).map(s -> s.substring("ansible_group:".length())).anyMatch(ansibleGroupNames::contains);
            }
            return mustRun;
        }
        return false;
    }
}

