/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.model;

import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.UploadSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnsibleHostSpec {
    @Nonnull
    private final HostType hostType;
    @Nullable
    private final String nodeName;
    @Nonnull
    private final List<UploadSpec> uploadLists;
    @Nonnull
    private final List<ExecuteSpec> executeLists;
    @Nullable
    private final String galaxyCommand;
    @Nullable
    private final String galaxyInstallTemplate;
    @Nullable
    private final String playbookCommand;
    @Nullable
    private final String playbookRunTemplate;

    public AnsibleHostSpec(@Nonnull HostType hostType, @Nullable String nodeName, @Nullable List<UploadSpec> uploadLists, @Nullable List<ExecuteSpec> executeLists, @Nullable String galaxyCommand, @Nullable String galaxyInstallTemplate, @Nullable String playbookCommand, @Nullable String playbookRunTemplate) {
        this.hostType = hostType;
        this.nodeName = nodeName;
        this.uploadLists = uploadLists == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<UploadSpec>(uploadLists));
        this.executeLists = executeLists == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ExecuteSpec>(executeLists));
        this.galaxyCommand = galaxyCommand;
        this.galaxyInstallTemplate = galaxyInstallTemplate;
        this.playbookCommand = playbookCommand;
        this.playbookRunTemplate = playbookRunTemplate;
        switch (hostType.ordinal()) {
            case 0: 
            case 1: {
                if (nodeName != null) break;
                throw new IllegalArgumentException("nodeName is required for ansible host of type " + String.valueOf((Object)hostType));
            }
        }
    }

    @Nonnull
    public HostType getHostType() {
        return this.hostType;
    }

    @Nullable
    public String getNodeName() {
        return this.nodeName;
    }

    @Nonnull
    public List<UploadSpec> getUploadLists() {
        return this.uploadLists;
    }

    @Nonnull
    public List<ExecuteSpec> getExecuteLists() {
        return this.executeLists;
    }

    @Nullable
    public String getGalaxyCommand() {
        return this.galaxyCommand;
    }

    @Nullable
    public String getGalaxyInstallTemplate() {
        return this.galaxyInstallTemplate;
    }

    @Nullable
    public String getPlaybookCommand() {
        return this.playbookCommand;
    }

    @Nullable
    public String getPlaybookRunTemplate() {
        return this.playbookRunTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnsibleHostSpec)) {
            return false;
        }
        AnsibleHostSpec that = (AnsibleHostSpec)o;
        if (this.hostType != that.hostType) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (!this.uploadLists.equals(that.uploadLists)) {
            return false;
        }
        if (!this.executeLists.equals(that.executeLists)) {
            return false;
        }
        if (this.galaxyCommand != null ? !this.galaxyCommand.equals(that.galaxyCommand) : that.galaxyCommand != null) {
            return false;
        }
        if (this.galaxyInstallTemplate != null ? !this.galaxyInstallTemplate.equals(that.galaxyInstallTemplate) : that.galaxyInstallTemplate != null) {
            return false;
        }
        if (this.playbookRunTemplate != null ? !this.playbookRunTemplate.equals(that.playbookRunTemplate) : that.playbookRunTemplate != null) {
            return false;
        }
        return this.playbookCommand != null ? this.playbookCommand.equals(that.playbookCommand) : that.playbookCommand == null;
    }

    public int hashCode() {
        int result = this.hostType.hashCode();
        result = 31 * result + (this.nodeName != null ? this.nodeName.hashCode() : 0);
        result = 31 * result + this.uploadLists.hashCode();
        result = 31 * result + this.executeLists.hashCode();
        result = 31 * result + (this.galaxyCommand != null ? this.galaxyCommand.hashCode() : 0);
        result = 31 * result + (this.playbookCommand != null ? this.playbookCommand.hashCode() : 0);
        result = 31 * result + (this.galaxyInstallTemplate != null ? this.galaxyInstallTemplate.hashCode() : 0);
        result = 31 * result + (this.playbookRunTemplate != null ? this.playbookRunTemplate.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AnsibleHostSpec{hostType=" + String.valueOf((Object)this.hostType) + ", nodeName='" + this.nodeName + "', uploadLists=" + String.valueOf(this.uploadLists) + ", executeLists=" + String.valueOf(this.executeLists) + ", galaxyCommand='" + this.galaxyCommand + "', galaxyInstallTemplate='" + this.galaxyInstallTemplate + "', playbookCommand='" + this.playbookCommand + "', playbookRunTemplate='" + this.playbookRunTemplate + "'}";
    }

    public static enum HostType {
        ADD,
        EXISTING,
        LOCAL;

    }
}

