/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.model;

import be.iminds.ilabt.jfed.espec.model.FileSource;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.model.UploadLikeWithLogSpec;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnsiblePlaybookSpec
extends UploadLikeWithLogSpec {
    private final int debug;
    @Nullable
    private final String extraVarsString;
    @Nullable
    private final ExtraVarsJsonFileSpec extraVars;
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    public AnsiblePlaybookSpec(@Nullable FileSource source, @Nullable String path, @Nullable String permissions, @Nullable Integer debug, @Nullable String log, @Nullable ExtraVarsJsonFileSpec extraVars) {
        super(source, path, permissions == null ? "u=rwx" : permissions, Collections.singletonList("$ANSIBLE_NODE$"), log);
        this.debug = debug == null ? 0 : debug;
        this.extraVars = extraVars;
        this.extraVarsString = null;
    }

    public AnsiblePlaybookSpec(@Nullable FileSource source, @Nullable String path, @Nullable String permissions, @Nullable Integer debug, @Nullable String log, @Nullable String extraVars) {
        super(source, path, permissions == null ? "u=rwx" : permissions, Collections.singletonList("$ANSIBLE_NODE$"), log);
        this.debug = debug == null ? 0 : debug;
        this.extraVars = null;
        this.extraVarsString = extraVars;
    }

    public AnsiblePlaybookSpec(@Nullable FileSource source, @Nullable String path, @Nullable String permissions, @Nullable Integer debug, @Nullable String log, @Nonnull Map<String, Object> extraVars) {
        super(source, path, permissions == null ? "u=rwx" : permissions, Collections.singletonList("$ANSIBLE_NODE$"), log);
        this.debug = debug == null ? 0 : debug;
        try {
            this.extraVars = extraVars.isEmpty() ? null : new ExtraVarsJsonFileSpec(new FileSource(FileSource.SourceType.DIRECT, MAPPER.writeValueAsString(extraVars), "extra-vars.json"));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to convert extra vars into string", e);
        }
        this.extraVarsString = null;
    }

    public AnsiblePlaybookSpec(@Nullable FileSource source, @Nullable String path, @Nullable String permissions, @Nullable Integer debug, @Nullable String log) {
        this(source, path, permissions, debug, log, (String)null);
    }

    public boolean isDebug() {
        return this.debug > 0;
    }

    public int getDebug() {
        return this.debug;
    }

    public boolean hasExtraVars() {
        return this.extraVarsString != null || this.extraVars != null;
    }

    public boolean hasExtraVarsString() {
        return this.extraVarsString != null;
    }

    public boolean hasExtraVarsJsonFileSpec() {
        return this.extraVars != null;
    }

    @Nullable
    public String getExtraVarsString() {
        return this.extraVarsString;
    }

    @Nullable
    public ExtraVarsJsonFileSpec getExtraVarsJsonFileSpec() {
        return this.extraVars;
    }

    public static class ExtraVarsJsonFileSpec
    extends UploadLikeSpec {
        public ExtraVarsJsonFileSpec(@Nullable FileSource source, @Nullable String path, @Nullable String permissions, @Nullable List<String> nodes) {
            super(source, path, permissions == null ? "u=rwx" : permissions, nodes);
        }

        public ExtraVarsJsonFileSpec(@Nullable FileSource source) {
            this(source, null, null, null);
        }
    }
}

