/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.model;

import be.iminds.ilabt.jfed.espec.model.ESpecStep;
import be.iminds.ilabt.jfed.espec.parser.ESpecConstants;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DirSpec
implements ESpecStep {
    @Nonnull
    private final String path;
    @Nullable
    private final String content;
    @Nonnull
    private final String permissions;
    @Nullable
    private final List<String> nodes;

    public DirSpec(@Nonnull String path, @Nullable String content, @Nullable String permissions, @Nullable List<String> nodes) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Empty path is not valid");
        }
        if (!path.startsWith("~") && !path.startsWith("/")) {
            throw new IllegalArgumentException("path should start with either ~ or /");
        }
        if (content != null && content.isEmpty()) {
            throw new IllegalArgumentException("Empty content is not valid (but null content is)");
        }
        if (permissions != null && permissions.isEmpty()) {
            throw new IllegalArgumentException("Empty permissions is not valid (but null permissions is)");
        }
        this.path = path;
        this.content = content;
        this.permissions = permissions == null ? "u=rwx" : permissions;
        this.nodes = nodes;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getContent() {
        return this.content;
    }

    public boolean isUploadContent() {
        return ESpecConstants.isDirsSpecContentUpload(this.content);
    }

    public boolean isScriptContent() {
        return ESpecConstants.isDirsSpecContentScript(this.content);
    }

    public boolean isAnsibleContent() {
        return ESpecConstants.isDirsSpecContentAnsible(this.content);
    }

    @Nonnull
    public String getPermissions() {
        return this.permissions;
    }

    @Nullable
    public List<String> getNodes() {
        return this.nodes;
    }

    @Nullable
    public ESpecConstants.DirContent getDirContent() {
        if (this.isUploadContent()) {
            return ESpecConstants.DirContent.UPLOAD;
        }
        if (this.isScriptContent()) {
            return ESpecConstants.DirContent.SCRIPT;
        }
        if (this.isAnsibleContent()) {
            return ESpecConstants.DirContent.ANSIBLE;
        }
        return null;
    }

    public String toString() {
        return "DirSpec{path='" + this.path + "', content='" + this.content + "', permissions='" + this.permissions + "', nodes=" + String.valueOf(this.nodes) + "}";
    }
}

