/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.commandline;

import be.iminds.ilabt.jfed.util.common.ExceptionUtil;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncaughtCliExceptionLogger
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UncaughtCliExceptionLogger.class);
    private final PrintStream err;
    private static UncaughtCliExceptionLogger instance;

    private UncaughtCliExceptionLogger(PrintStream err) {
        this.err = err;
    }

    public static UncaughtCliExceptionLogger getInstance(PrintStream err) {
        if (instance == null) {
            instance = new UncaughtCliExceptionLogger(err);
        }
        return instance;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        LOG.error("UNCAUGHT ERROR IN THREAD {}", (Object)t.getName(), (Object)e);
        if (this.err != null) {
            this.err.println("UNCAUGHT ERROR IN THREAD " + t.getName());
            e.printStackTrace(this.err);
        }
        if (ExceptionUtil.isOutOfMemory((Throwable)e)) {
            LOG.warn("jFed ran out of memory and will exit.");
            this.err.println("jFed ran out of memory and will exit.");
            System.exit(-1);
        }
        if (ExceptionUtil.isOutOfDiskSpace((Throwable)e)) {
            LOG.warn("jFed ran out of disk space and will exit.");
            this.err.println("jFed ran out of disk space and will exit.");
            System.exit(-1);
        }
        LOG.info("Will now exit due to uncaught exception.");
        if (this.err != null) {
            this.err.println("Will now exit due to uncaught exception.");
        }
        System.exit(-1);
    }
}

